/*
 * Decompiled with CFR 0.152.
 */
package io.lacuna.bifurcan;

import io.lacuna.bifurcan.IForkable;
import io.lacuna.bifurcan.ILinearizable;
import io.lacuna.bifurcan.Ropes;
import io.lacuna.bifurcan.hash.PerlHash;
import io.lacuna.bifurcan.nodes.RopeNodes;
import io.lacuna.bifurcan.utils.CharSequences;
import io.lacuna.bifurcan.utils.IntIterators;
import io.lacuna.bifurcan.utils.Iterators;
import io.lacuna.bifurcan.utils.UnicodeChunk;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.PrimitiveIterator;
import java.util.stream.IntStream;

public class Rope
implements Comparable<Rope>,
ILinearizable<Rope>,
IForkable<Rope> {
    public static final Rope EMPTY = Rope.from("");
    private final Object editor;
    private RopeNodes.Node root;
    private int hash = -1;

    public static Rope from(CharSequence cs) {
        Object editor = new Object();
        RopeNodes.Node root = new RopeNodes.Node(editor, 5);
        if (cs.length() > 0) {
            Iterator<byte[]> it = Rope.chunks(cs);
            while (it.hasNext()) {
                root = root.pushLast(it.next(), editor);
            }
        }
        return new Rope(root, false);
    }

    Rope(RopeNodes.Node node, boolean linear) {
        this.editor = linear ? new Object() : null;
        this.root = node;
    }

    public Rope concat(Rope rope) {
        return new Rope(this.root.concat(rope.root, new Object()), this.isLinear());
    }

    public int nth(int idx) {
        if (idx < 0 || idx >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        return this.root.nthPoint(idx);
    }

    public int size() {
        return this.root.numCodePoints();
    }

    public Rope remove(int start, int end2) {
        Object editor;
        Object object = editor = this.isLinear() ? this.editor : new Object();
        if (end2 < start || start < 0 || end2 > this.size()) {
            throw new IllegalArgumentException("[" + start + ", " + end2 + ") is not a valid range");
        }
        if (end2 == start) {
            return this;
        }
        RopeNodes.Node newRoot = this.root.update(0, start, editor, (offset2, chunk) -> {
            int len = UnicodeChunk.numCodePoints(chunk);
            if (end2 < offset2 + len) {
                return UnicodeChunk.concat(UnicodeChunk.slice(chunk, 0, start - offset2), UnicodeChunk.slice(chunk, end2 - offset2, len));
            }
            return null;
        });
        if (newRoot == null) {
            newRoot = this.root.slice(0, start, editor).concat(this.root.slice(end2, this.size(), editor), editor);
        }
        if (this.isLinear()) {
            this.root = newRoot;
            return this;
        }
        return new Rope(newRoot, false);
    }

    private Rope insert(int index, Iterator<byte[]> chunks, int numCodeUnits) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        Object editor = this.isLinear() ? this.editor : new Object();
        RopeNodes.Node newRoot = null;
        if (numCodeUnits < 32) {
            newRoot = this.root.update(0, index, editor, (offset2, chunk) -> {
                if (numCodeUnits + UnicodeChunk.numCodeUnits(chunk) <= 32) {
                    byte[] newChunk = UnicodeChunk.slice(chunk, 0, index - offset2);
                    while (chunks.hasNext()) {
                        newChunk = UnicodeChunk.concat(newChunk, (byte[])chunks.next());
                    }
                    return UnicodeChunk.concat(newChunk, UnicodeChunk.slice(chunk, index - offset2, UnicodeChunk.numCodePoints(chunk)));
                }
                return null;
            });
        }
        if (newRoot == null) {
            newRoot = this.root.slice(0, index, editor);
            while (chunks.hasNext()) {
                newRoot = newRoot.pushLast(chunks.next(), editor);
            }
            newRoot = newRoot.concat(this.root.slice(index, this.size(), editor), editor);
        }
        if (this.isLinear()) {
            this.root = newRoot;
            return this;
        }
        return new Rope(newRoot, false);
    }

    public Rope insert(int index, Rope rope) {
        if (rope.size() == 0) {
            return this;
        }
        return this.insert(index, rope.chunks(), rope.root.numCodeUnits());
    }

    public Rope insert(int index, CharSequence cs) {
        if (cs.length() == 0) {
            return this;
        }
        return this.insert(index, Rope.chunks(cs), cs.length());
    }

    public Rope slice(int start, int end2) {
        if (end2 < start || start < 0 || end2 > this.size()) {
            throw new IllegalArgumentException("[" + start + ", " + end2 + ") is not a valid range");
        }
        return new Rope(this.root.slice(start, end2, new Object()), this.isLinear());
    }

    @Override
    public boolean isLinear() {
        return this.editor != null;
    }

    @Override
    public Rope forked() {
        return this.isLinear() ? new Rope(this.root, false) : this;
    }

    @Override
    public Rope linear() {
        return this.isLinear() ? this : new Rope(this.root, true);
    }

    public Iterator<ByteBuffer> bytes() {
        return Iterators.map(this.chunks(), ary -> ByteBuffer.wrap(ary, 2, ((byte[])ary).length - 2).slice());
    }

    public PrimitiveIterator.OfInt reverseChars() {
        return IntIterators.flatMap(this.reverseChunks(), UnicodeChunk::reverseCodeUnitIterator);
    }

    public PrimitiveIterator.OfInt chars() {
        return IntIterators.flatMap(this.chunks(), UnicodeChunk::codeUnitIterator);
    }

    public PrimitiveIterator.OfInt reverseCodePoints() {
        return IntIterators.flatMap(this.reverseChunks(), UnicodeChunk::reverseCodePointIterator);
    }

    public PrimitiveIterator.OfInt codePoints() {
        return IntIterators.flatMap(this.chunks(), UnicodeChunk::codePointIterator);
    }

    public String toString() {
        char[] cs = new char[this.root.numCodeUnits()];
        Iterator<byte[]> it = this.chunks();
        int offset2 = 0;
        while (it.hasNext()) {
            offset2 += UnicodeChunk.writeCodeUnits(cs, offset2, it.next());
        }
        return new String(cs);
    }

    public CharSequence toCharSequence() {
        return new CharSequence(){

            @Override
            public int length() {
                return Rope.this.root.numCodeUnits();
            }

            @Override
            public char charAt(int index) {
                return Rope.this.root.nthUnit(index);
            }

            @Override
            public CharSequence subSequence(int start, int end2) {
                return CharSequences.subSequence(this, start, end2);
            }

            @Override
            public IntStream chars() {
                return IntIterators.toStream(Rope.this.chars(), Rope.this.root.numCodeUnits());
            }

            @Override
            public IntStream codePoints() {
                return IntIterators.toStream(Rope.this.codePoints(), Rope.this.root.numCodePoints());
            }
        };
    }

    public int hashCode() {
        if (this.hash == -1) {
            this.hash = PerlHash.hash(0, this.bytes());
        }
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Rope) {
            return Ropes.equals(this, (Rope)obj);
        }
        return false;
    }

    @Override
    public int compareTo(Rope o) {
        if (this == o) {
            return 0;
        }
        if (this.size() != o.size()) {
            return this.size() - o.size();
        }
        if (this.size() == 0) {
            return 0;
        }
        return Ropes.compare(this.bytes(), o.bytes());
    }

    private Iterator<byte[]> reverseChunks() {
        return new Iterator<byte[]>(){
            int idx;
            {
                this.idx = Rope.this.size() - 1;
            }

            @Override
            public boolean hasNext() {
                return this.idx > 0;
            }

            @Override
            public byte[] next() {
                byte[] chunk = Rope.this.root.chunkFor(this.idx);
                this.idx -= UnicodeChunk.numCodePoints(chunk);
                return chunk;
            }
        };
    }

    private Iterator<byte[]> chunks() {
        return new Iterator<byte[]>(){
            int idx = 0;

            @Override
            public boolean hasNext() {
                return this.idx < Rope.this.size();
            }

            @Override
            public byte[] next() {
                byte[] chunk = Rope.this.root.chunkFor(this.idx);
                this.idx += UnicodeChunk.numCodePoints(chunk);
                return chunk;
            }
        };
    }

    private static Iterator<byte[]> chunks(final CharSequence cs) {
        return new Iterator<byte[]>(){
            int offset = 0;

            @Override
            public boolean hasNext() {
                return this.offset < cs.length();
            }

            @Override
            public byte[] next() {
                int start = this.offset;
                int end2 = Math.min(cs.length(), start + 32);
                if (end2 < cs.length() && Character.isHighSurrogate(cs.charAt(end2 - 1))) {
                    --end2;
                }
                this.offset = end2;
                return UnicodeChunk.from(cs, start, end2);
            }
        };
    }
}

