/*
 * Decompiled with CFR 0.152.
 */
package io.lacuna.bifurcan;

import io.lacuna.bifurcan.Graphs;
import io.lacuna.bifurcan.IEdge;
import io.lacuna.bifurcan.IForkable;
import io.lacuna.bifurcan.ILinearizable;
import io.lacuna.bifurcan.ISet;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.ToIntFunction;

public interface IGraph<V, E>
extends ILinearizable<IGraph<V, E>>,
IForkable<IGraph<V, E>> {
    public ISet<V> vertices();

    public Iterable<IEdge<V, E>> edges();

    public E edge(V var1, V var2);

    public ISet<V> in(V var1);

    public ISet<V> out(V var1);

    public IGraph<V, E> link(V var1, V var2, E var3, BinaryOperator<E> var4);

    public IGraph<V, E> unlink(V var1, V var2);

    public IGraph<V, E> add(V var1);

    public IGraph<V, E> remove(V var1);

    public <U> IGraph<V, U> mapEdges(Function<IEdge<V, E>, U> var1);

    default public long indexOf(V vertex) {
        return this.vertices().indexOf(vertex);
    }

    default public V nth(long index) {
        return this.vertices().nth(index);
    }

    default public IGraph<V, E> select(ISet<V> vertices) {
        IGraph g = (IGraph)this.clone().linear();
        this.vertices().difference(vertices).forEach(g::remove);
        return this.isLinear() ? g : (IGraph)g.forked();
    }

    default public IGraph<V, E> replace(V a2, V b) {
        return this.replace(a2, b, Graphs.MERGE_LAST_WRITE_WINS);
    }

    default public IGraph<V, E> replace(V a2, V b, BinaryOperator<E> merge) {
        if (this.vertexEquality().test(a2, b) || !this.vertices().contains(a2)) {
            return this;
        }
        IGraph<V, E> g = (IGraph<V, E>)this.linear();
        for (V v : this.out(a2)) {
            g = g.link(b, v, this.edge(a2, v));
        }
        for (V v : this.in(a2)) {
            g = g.link(v, b, this.edge(v, a2), merge);
        }
        g.remove(a2);
        return this.isLinear() ? this : (IGraph)g.forked();
    }

    @Override
    public boolean isLinear();

    public boolean isDirected();

    public ToIntFunction<V> vertexHash();

    public BiPredicate<V, V> vertexEquality();

    public IGraph<V, E> transpose();

    public IGraph<V, E> clone();

    default public IGraph<V, E> add(IEdge<V, E> edge) {
        return this.link(edge.from(), edge.to(), edge.value());
    }

    default public IGraph<V, E> remove(IEdge<V, E> edge) {
        return this.unlink(edge.from(), edge.to());
    }

    default public IGraph<V, E> link(V from, V to, E edge) {
        return this.link(from, to, edge, Graphs.MERGE_LAST_WRITE_WINS);
    }

    default public IGraph<V, E> link(V from, V to) {
        return this.link(from, to, null, Graphs.MERGE_LAST_WRITE_WINS);
    }

    default public IGraph<V, E> merge(IGraph<V, E> graph, BinaryOperator<E> merge) {
        return Graphs.merge(this, graph, merge);
    }

    default public IGraph<V, E> merge(IGraph<V, E> graph) {
        return this.merge(graph, Graphs.MERGE_LAST_WRITE_WINS);
    }
}

