/*
 * Decompiled with CFR 0.152.
 */
package io.lacuna.artifex;

import io.lacuna.artifex.Vec;
import io.lacuna.artifex.Vec2;
import io.lacuna.artifex.Vec3;
import io.lacuna.artifex.utils.Hashes;
import java.util.Comparator;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoublePredicate;
import java.util.function.DoubleUnaryOperator;

public class Vec4
implements Vec<Vec4> {
    public static final Vec4 ORIGIN = new Vec4(0.0, 0.0, 0.0, 0.0);
    public static final Vec4 X_AXIS = new Vec4(1.0, 0.0, 0.0, 0.0);
    public static final Vec4 Y_AXIS = new Vec4(0.0, 1.0, 0.0, 0.0);
    public static final Vec4 Z_AXIS = new Vec4(0.0, 0.0, 1.0, 0.0);
    public static final Vec4 W_AXIS = new Vec4(0.0, 0.0, 0.0, 1.0);
    public static final Comparator<Vec4> COMPARATOR = Comparator.comparingDouble(v -> v.x).thenComparingDouble(v -> v.y).thenComparingDouble(v -> v.z).thenComparingDouble(v -> v.w);
    public final double x;
    public final double y;
    public final double z;
    public final double w;

    public Vec4(double x, double y, double z, double w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    @Override
    public final Vec4 map(DoubleUnaryOperator f) {
        return new Vec4(f.applyAsDouble(this.x), f.applyAsDouble(this.y), f.applyAsDouble(this.z), f.applyAsDouble(this.w));
    }

    @Override
    public final double reduce(DoubleBinaryOperator f, double init) {
        return f.applyAsDouble(f.applyAsDouble(f.applyAsDouble(f.applyAsDouble(init, this.x), this.y), this.z), this.w);
    }

    @Override
    public double reduce(DoubleBinaryOperator f) {
        return f.applyAsDouble(f.applyAsDouble(f.applyAsDouble(this.x, this.y), this.z), this.w);
    }

    @Override
    public final Vec4 zip(Vec4 v, DoubleBinaryOperator f) {
        return new Vec4(f.applyAsDouble(this.x, v.x), f.applyAsDouble(this.y, v.y), f.applyAsDouble(this.z, v.z), f.applyAsDouble(this.w, v.w));
    }

    @Override
    public boolean every(DoublePredicate f) {
        return f.test(this.x) && f.test(this.y) && f.test(this.z) && f.test(this.w);
    }

    @Override
    public boolean any(DoublePredicate f) {
        return f.test(this.x) || f.test(this.y) || f.test(this.z) || f.test(this.w);
    }

    @Override
    public double nth(int idx) {
        switch (idx) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
            case 3: {
                return this.w;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int dim() {
        return 4;
    }

    @Override
    public double[] array() {
        return new double[]{this.x, this.y, this.z, this.w};
    }

    public Vec3 vec3() {
        return new Vec3(this.x, this.y, this.z);
    }

    public Vec2 vec2() {
        return new Vec2(this.x, this.y);
    }

    public int hashCode() {
        return Hashes.hash(this.x, this.y, this.z, this.w);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Vec4) {
            Vec4 v = (Vec4)obj;
            return v.x == this.x && v.y == this.y && v.z == this.z && v.w == this.w;
        }
        return false;
    }

    public String toString() {
        return "[x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", w=" + this.w + "]";
    }

    @Override
    public int compareTo(Vec4 o) {
        return COMPARATOR.compare(this, o);
    }
}

