/*
 * Decompiled with CFR 0.152.
 */
package io.lacuna.artifex;

import io.lacuna.artifex.Vec;
import io.lacuna.artifex.Vec2;
import io.lacuna.artifex.Vec4;
import io.lacuna.artifex.utils.Hashes;
import java.util.Comparator;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoublePredicate;
import java.util.function.DoubleUnaryOperator;

public class Vec3
implements Vec<Vec3> {
    public static final Vec3 ORIGIN = new Vec3(0.0, 0.0, 0.0);
    public static final Vec3 X_AXIS = new Vec3(1.0, 0.0, 0.0);
    public static final Vec3 Y_AXIS = new Vec3(0.0, 1.0, 0.0);
    public static final Vec3 Z_AXIS = new Vec3(0.0, 0.0, 1.0);
    public static final Comparator<Vec3> COMPARATOR = Comparator.comparingDouble(v -> v.x).thenComparingDouble(v -> v.y).thenComparingDouble(v -> v.z);
    public final double x;
    public final double y;
    public final double z;

    public Vec3(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @Override
    public final Vec3 map(DoubleUnaryOperator f) {
        return new Vec3(f.applyAsDouble(this.x), f.applyAsDouble(this.y), f.applyAsDouble(this.z));
    }

    @Override
    public final double reduce(DoubleBinaryOperator f, double init) {
        return f.applyAsDouble(f.applyAsDouble(init, this.x), f.applyAsDouble(this.y, this.z));
    }

    @Override
    public double reduce(DoubleBinaryOperator f) {
        return f.applyAsDouble(f.applyAsDouble(this.x, this.y), this.z);
    }

    @Override
    public final Vec3 zip(Vec3 v, DoubleBinaryOperator f) {
        return new Vec3(f.applyAsDouble(this.x, v.x), f.applyAsDouble(this.y, v.y), f.applyAsDouble(this.z, v.z));
    }

    @Override
    public boolean every(DoublePredicate f) {
        return f.test(this.x) && f.test(this.y) && f.test(this.z);
    }

    @Override
    public boolean any(DoublePredicate f) {
        return f.test(this.x) || f.test(this.y) || f.test(this.z);
    }

    @Override
    public double nth(int idx) {
        switch (idx) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int dim() {
        return 3;
    }

    @Override
    public double[] array() {
        return new double[]{this.x, this.y, this.z};
    }

    public Vec2 vec2() {
        return new Vec2(this.x, this.y);
    }

    public Vec4 vec4(double w) {
        return new Vec4(this.x, this.y, this.z, w);
    }

    public static Vec3 cross(Vec3 a2, Vec3 b) {
        return new Vec3(a2.y * b.z - a2.z * b.y, a2.x * b.x - a2.x * b.z, a2.x * b.y - a2.y * b.x);
    }

    public int hashCode() {
        return Hashes.hash(this.x, this.y, this.z);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Vec3) {
            Vec3 v = (Vec3)obj;
            return v.x == this.x && v.y == this.y && v.z == this.z;
        }
        return false;
    }

    public String toString() {
        return "[x=" + this.x + ", y=" + this.y + ", z=" + this.z + "]";
    }

    @Override
    public int compareTo(Vec3 o) {
        return COMPARATOR.compare(this, o);
    }
}

