/*
 * Decompiled with CFR 0.152.
 */
package io.lacuna.artifex;

import io.lacuna.artifex.Box;
import io.lacuna.artifex.Box3;
import io.lacuna.artifex.Curve2;
import io.lacuna.artifex.Line2;
import io.lacuna.artifex.Ring2;
import io.lacuna.artifex.Vec;
import io.lacuna.artifex.Vec2;
import java.util.ArrayList;

public class Box2
extends Box<Vec2, Box2> {
    public static final Box2 EMPTY = new Box2(Vec.vec(Double.NaN, Double.NaN), Vec.vec(Double.NaN, Double.NaN));
    public final double lx;
    public final double ly;
    public final double ux;
    public final double uy;

    Box2(double ax, double ay, double bx, double by) {
        if (ax < bx) {
            this.lx = ax;
            this.ux = bx;
        } else {
            this.ux = ax;
            this.lx = bx;
        }
        if (ay < by) {
            this.ly = ay;
            this.uy = by;
        } else {
            this.uy = ay;
            this.ly = by;
        }
    }

    public Box3 box3(double lz, double uz) {
        return new Box3(this.lx, this.ly, lz, this.ux, this.uy, uz);
    }

    public double width() {
        return this.ux - this.lx;
    }

    public double height() {
        return this.uy - this.ly;
    }

    public Box2(Vec2 a2, Vec2 b) {
        this(a2.x, a2.y, b.x, b.y);
    }

    @Override
    public Box2 scale(double k) {
        return (Box2)this.scale(Vec.vec(k, k));
    }

    public Box2 scale(double x, double y) {
        return (Box2)this.scale(Vec.vec(x, y));
    }

    public Box2 translate(double x, double y) {
        return (Box2)this.translate(Vec.vec(x, y));
    }

    public Vec2[] vertices() {
        return new Vec2[]{Vec.vec(this.lx, this.ly), Vec.vec(this.ux, this.ly), Vec.vec(this.ux, this.uy), Vec.vec(this.lx, this.uy)};
    }

    public Ring2 outline() {
        ArrayList<Curve2> cs = new ArrayList<Curve2>();
        Vec2[] vs = this.vertices();
        for (int i = 0; i < vs.length; ++i) {
            cs.add(Line2.line(vs[i], vs[(i + 1) % 4]));
        }
        return new Ring2(cs);
    }

    @Override
    public boolean intersects(Box2 b) {
        if (this.isEmpty() || b.isEmpty()) {
            return false;
        }
        return b.ux >= this.lx & this.ux >= b.lx & b.uy >= this.ly & this.uy >= b.ly;
    }

    @Override
    public Vec2 lower() {
        return new Vec2(this.lx, this.ly);
    }

    @Override
    public Vec2 upper() {
        return new Vec2(this.ux, this.uy);
    }

    @Override
    public boolean isEmpty() {
        return this == EMPTY;
    }

    @Override
    protected Box2 construct(Vec2 a2, Vec2 b) {
        return new Box2(a2.x, a2.y, b.x, b.y);
    }

    @Override
    protected Box2 empty() {
        return EMPTY;
    }
}

