/*
 * Decompiled with CFR 0.152.
 */
package glm_.quat;

import glm_.glm;
import glm_.mat3x3.Mat3;
import glm_.mat3x3.Mat3d;
import glm_.mat4x4.Mat4;
import glm_.mat4x4.Mat4d;
import glm_.quat.Quat;
import glm_.quat.QuatD;
import glm_.vec3.Vec3;
import glm_.vec3.Vec3d;
import glm_.vec4.Vec4bool;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0002\u001a\u00020\u00062\u0006\u0010\u0004\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\b\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007H\u0016J(\u0010\b\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006H\u0016J0\u0010\b\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u000fH\u0016J \u0010\b\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u0005H\u0016J(\u0010\b\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J0\u0010\b\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0005H\u0016J\u0010\u0010\t\u001a\u00020\u000f2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\t\u001a\u00020\u000f2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u000fH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u0007H\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005H\u0016J\u0018\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0016J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0007H\u0016J\u0018\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007H\u0016J\u0018\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005H\u0016J\u0018\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0007H\u0016J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005H\u0016J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0005H\u0016J\u0018\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u000fH\u0016J\u0010\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0007H\u0016J\u0018\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0018\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005H\u0016J \u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0015H\u0016J\u0018\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005H\u0016J \u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0015H\u0016J\u0010\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005H\u0016J\u0018\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0016J\u0010\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0007H\u0016J\u0018\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007H\u0016J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0015H\u0016J\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0015H\u0016J\u0010\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0004\u001a\u00020\u0007H\u0016J \u0010\u001d\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0003H\u0016J(\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0005H\u0016J \u0010\u001d\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u0006H\u0016J(\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0007H\u0016J\u0018\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005H\u0016J \u0010\u001f\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0015H\u0016J\u0018\u0010 \u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005H\u0016J \u0010 \u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0015H\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010!\u001a\u00020\"2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\"H\u0016J\u0018\u0010#\u001a\u00020\"2\u0006\u0010\u0004\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\"H\u0016J\u0010\u0010%\u001a\u00020&2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010%\u001a\u00020&2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020&H\u0016J\u0018\u0010'\u001a\u00020&2\u0006\u0010\u000b\u001a\u00020&2\u0006\u0010\u0004\u001a\u00020\u0007H\u0016J \u0010(\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0003H\u0016J(\u0010(\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0005H\u0016J \u0010(\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u0006H\u0016J(\u0010(\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0007H\u0016J\u0010\u0010)\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010)\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0016J\u0010\u0010)\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0007H\u0016J\u0018\u0010)\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007H\u0016J\u0018\u0010*\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005H\u0016J \u0010*\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0015H\u0016J\u0010\u0010+\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010+\u001a\u00020\u00062\u0006\u0010\u0004\u001a\u00020\u0007H\u0016J\u0010\u0010,\u001a\u00020\u00072\u0006\u0010$\u001a\u00020-H\u0016J\u0018\u0010,\u001a\u00020\u00072\u0006\u0010$\u001a\u00020-2\u0006\u0010\u000b\u001a\u00020\u0007H\u0016J\u0010\u0010,\u001a\u00020\u00072\u0006\u0010$\u001a\u00020.H\u0016J\u0018\u0010,\u001a\u00020\u00072\u0006\u0010$\u001a\u00020.2\u0006\u0010\u000b\u001a\u00020\u0007H\u0016JP\u0010,\u001a\u00020\u00072\u0006\u0010/\u001a\u00020\u00062\u0006\u00100\u001a\u00020\u00062\u0006\u00101\u001a\u00020\u00062\u0006\u00102\u001a\u00020\u00062\u0006\u00103\u001a\u00020\u00062\u0006\u00104\u001a\u00020\u00062\u0006\u00105\u001a\u00020\u00062\u0006\u00106\u001a\u00020\u00062\u0006\u00107\u001a\u00020\u0006H\u0016JX\u0010,\u001a\u00020\u00072\u0006\u0010/\u001a\u00020\u00062\u0006\u00100\u001a\u00020\u00062\u0006\u00101\u001a\u00020\u00062\u0006\u00102\u001a\u00020\u00062\u0006\u00103\u001a\u00020\u00062\u0006\u00104\u001a\u00020\u00062\u0006\u00105\u001a\u00020\u00062\u0006\u00106\u001a\u00020\u00062\u0006\u00107\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0007H\u0016J\u0010\u00108\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\"H\u0016J\u0018\u00108\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\"2\u0006\u0010\u000b\u001a\u00020\u0005H\u0016J\u0010\u00108\u001a\u00020\u00052\u0006\u0010$\u001a\u00020&H\u0016J\u0018\u00108\u001a\u00020\u00052\u0006\u0010$\u001a\u00020&2\u0006\u0010\u000b\u001a\u00020\u0005H\u0016JP\u00108\u001a\u00020\u00052\u0006\u0010/\u001a\u00020\u00032\u0006\u00100\u001a\u00020\u00032\u0006\u00101\u001a\u00020\u00032\u0006\u00102\u001a\u00020\u00032\u0006\u00103\u001a\u00020\u00032\u0006\u00104\u001a\u00020\u00032\u0006\u00105\u001a\u00020\u00032\u0006\u00106\u001a\u00020\u00032\u0006\u00107\u001a\u00020\u0003H\u0016JX\u00108\u001a\u00020\u00052\u0006\u0010/\u001a\u00020\u00032\u0006\u00100\u001a\u00020\u00032\u0006\u00101\u001a\u00020\u00032\u0006\u00102\u001a\u00020\u00032\u0006\u00103\u001a\u00020\u00032\u0006\u00104\u001a\u00020\u00032\u0006\u00105\u001a\u00020\u00032\u0006\u00106\u001a\u00020\u00032\u0006\u00107\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0005H\u0016J\u0010\u00109\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u00109\u001a\u00020\u00062\u0006\u0010\u0004\u001a\u00020\u0007H\u0016J \u0010:\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010;\u001a\u00020\u000fH\u0016J(\u0010:\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010;\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u0005H\u0016J0\u0010:\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010<\u001a\u00020\u00032\u0006\u0010=\u001a\u00020\u00032\u0006\u0010>\u001a\u00020\u0003H\u0016J8\u0010:\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010<\u001a\u00020\u00032\u0006\u0010=\u001a\u00020\u00032\u0006\u0010>\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0005H\u0016J \u0010:\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00062\u0006\u0010;\u001a\u00020\nH\u0016J(\u0010:\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00062\u0006\u0010;\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007H\u0016J0\u0010:\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00062\u0006\u0010<\u001a\u00020\u00062\u0006\u0010=\u001a\u00020\u00062\u0006\u0010>\u001a\u00020\u0006H\u0016J8\u0010:\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00062\u0006\u0010<\u001a\u00020\u00062\u0006\u0010=\u001a\u00020\u00062\u0006\u0010>\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0007H\u0016J \u0010?\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0003H\u0016J(\u0010?\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0005H\u0016J \u0010?\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u0006H\u0016J(\u0010?\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0007H\u0016J\u0010\u0010@\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010@\u001a\u00020\u00062\u0006\u0010\u0004\u001a\u00020\u0007H\u0016\u00a8\u0006A"}, d2={"Lglm_/quat/gtcQuaternion;", "", "angle", "", "q", "Lglm_/quat/Quat;", "", "Lglm_/quat/QuatD;", "angleAxis", "axis", "Lglm_/vec3/Vec3d;", "res", "axisX", "axisY", "axisZ", "Lglm_/vec3/Vec3;", "conjugate", "a", "dot", "b", "equal", "Lglm_/vec4/Vec4bool;", "eulerAngles", "greater", "greaterThan", "inverse", "isInf", "isNan", "length", "lerp", "interp", "lessThan", "lessThanEqual", "mat3_cast", "Lglm_/mat3x3/Mat3;", "mat3d_cast", "m", "mat4_cast", "Lglm_/mat4x4/Mat4;", "mat4d_cast", "mix", "normalize", "notEqual", "pitch", "quatD_cast", "Lglm_/mat3x3/Mat3d;", "Lglm_/mat4x4/Mat4d;", "m00", "m01", "m02", "m10", "m11", "m12", "m20", "m21", "m22", "quat_cast", "roll", "rotate", "v", "vX", "vY", "vZ", "slerp", "yaw", "glm"})
public interface gtcQuaternion {
    public float length(@NotNull Quat var1);

    public double length(@NotNull QuatD var1);

    @NotNull
    public Quat normalize(@NotNull Quat var1, @NotNull Quat var2);

    @NotNull
    public Quat normalize(@NotNull Quat var1);

    @NotNull
    public QuatD normalize(@NotNull QuatD var1, @NotNull QuatD var2);

    @NotNull
    public QuatD normalize(@NotNull QuatD var1);

    public float dot(@NotNull Quat var1, @NotNull Quat var2);

    public double dot(@NotNull QuatD var1, @NotNull QuatD var2);

    @NotNull
    public Quat mix(@NotNull Quat var1, @NotNull Quat var2, float var3, @NotNull Quat var4);

    @NotNull
    public Quat mix(@NotNull Quat var1, @NotNull Quat var2, float var3);

    @NotNull
    public QuatD mix(@NotNull QuatD var1, @NotNull QuatD var2, double var3, @NotNull QuatD var5);

    @NotNull
    public QuatD mix(@NotNull QuatD var1, @NotNull QuatD var2, double var3);

    @NotNull
    public Quat lerp(@NotNull Quat var1, @NotNull Quat var2, float var3, @NotNull Quat var4);

    @NotNull
    public Quat lerp(@NotNull Quat var1, @NotNull Quat var2, float var3);

    @NotNull
    public QuatD lerp(@NotNull QuatD var1, @NotNull QuatD var2, double var3, @NotNull QuatD var5);

    @NotNull
    public QuatD lerp(@NotNull QuatD var1, @NotNull QuatD var2, double var3);

    @NotNull
    public Quat slerp(@NotNull Quat var1, @NotNull Quat var2, float var3, @NotNull Quat var4);

    @NotNull
    public Quat slerp(@NotNull Quat var1, @NotNull Quat var2, float var3);

    @NotNull
    public QuatD slerp(@NotNull QuatD var1, @NotNull QuatD var2, double var3, @NotNull QuatD var5);

    @NotNull
    public QuatD slerp(@NotNull QuatD var1, @NotNull QuatD var2, double var3);

    @NotNull
    public Quat conjugate(@NotNull Quat var1, @NotNull Quat var2);

    @NotNull
    public Quat conjugate(@NotNull Quat var1);

    @NotNull
    public QuatD conjugate(@NotNull QuatD var1, @NotNull QuatD var2);

    @NotNull
    public QuatD conjugate(@NotNull QuatD var1);

    @NotNull
    public Quat inverse(@NotNull Quat var1, @NotNull Quat var2);

    @NotNull
    public Quat inverse(@NotNull Quat var1);

    @NotNull
    public QuatD inverse(@NotNull QuatD var1, @NotNull QuatD var2);

    @NotNull
    public QuatD inverse(@NotNull QuatD var1);

    @NotNull
    public Quat rotate(@NotNull Quat var1, float var2, float var3, float var4, float var5, @NotNull Quat var6);

    @NotNull
    public Quat rotate(@NotNull Quat var1, float var2, float var3, float var4, float var5);

    @NotNull
    public Quat rotate(@NotNull Quat var1, float var2, @NotNull Vec3 var3, @NotNull Quat var4);

    @NotNull
    public Quat rotate(@NotNull Quat var1, float var2, @NotNull Vec3 var3);

    @NotNull
    public QuatD rotate(@NotNull QuatD var1, double var2, double var4, double var6, double var8, @NotNull QuatD var10);

    @NotNull
    public QuatD rotate(@NotNull QuatD var1, double var2, double var4, double var6, double var8);

    @NotNull
    public QuatD rotate(@NotNull QuatD var1, double var2, @NotNull Vec3d var4, @NotNull QuatD var5);

    @NotNull
    public QuatD rotate(@NotNull QuatD var1, double var2, @NotNull Vec3d var4);

    @NotNull
    public Vec3 eulerAngles(@NotNull Quat var1, @NotNull Vec3 var2);

    @NotNull
    public Vec3 eulerAngles(@NotNull Quat var1);

    @NotNull
    public Vec3d eulerAngles(@NotNull QuatD var1, @NotNull Vec3d var2);

    @NotNull
    public Vec3d eulerAngles(@NotNull QuatD var1);

    public float roll(@NotNull Quat var1);

    public double roll(@NotNull QuatD var1);

    public float pitch(@NotNull Quat var1);

    public double pitch(@NotNull QuatD var1);

    public float yaw(@NotNull Quat var1);

    public double yaw(@NotNull QuatD var1);

    @NotNull
    public Mat3 mat3_cast(@NotNull Quat var1, @NotNull Mat3 var2);

    @NotNull
    public Mat3 mat3_cast(@NotNull Quat var1);

    @NotNull
    public Mat3 mat3d_cast(@NotNull QuatD var1, @NotNull Mat3 var2);

    @NotNull
    public Mat4 mat4_cast(@NotNull Quat var1, @NotNull Mat4 var2);

    @NotNull
    public Mat4 mat4_cast(@NotNull Quat var1);

    @NotNull
    public Mat4 mat4d_cast(@NotNull Mat4 var1, @NotNull QuatD var2);

    @NotNull
    public Quat quat_cast(@NotNull Mat3 var1, @NotNull Quat var2);

    @NotNull
    public QuatD quatD_cast(@NotNull Mat3d var1, @NotNull QuatD var2);

    @NotNull
    public Quat quat_cast(@NotNull Mat3 var1);

    @NotNull
    public QuatD quatD_cast(@NotNull Mat3d var1);

    @NotNull
    public Quat quat_cast(@NotNull Mat4 var1, @NotNull Quat var2);

    @NotNull
    public QuatD quatD_cast(@NotNull Mat4d var1, @NotNull QuatD var2);

    @NotNull
    public Quat quat_cast(@NotNull Mat4 var1);

    @NotNull
    public QuatD quatD_cast(@NotNull Mat4d var1);

    @NotNull
    public Quat quat_cast(float var1, float var2, float var3, float var4, float var5, float var6, float var7, float var8, float var9, @NotNull Quat var10);

    @NotNull
    public Quat quat_cast(float var1, float var2, float var3, float var4, float var5, float var6, float var7, float var8, float var9);

    @NotNull
    public QuatD quatD_cast(double var1, double var3, double var5, double var7, double var9, double var11, double var13, double var15, double var17, @NotNull QuatD var19);

    @NotNull
    public QuatD quatD_cast(double var1, double var3, double var5, double var7, double var9, double var11, double var13, double var15, double var17);

    public float angle(@NotNull Quat var1);

    public double angle(@NotNull QuatD var1);

    @NotNull
    public Vec3 axis(@NotNull Quat var1, @NotNull Vec3 var2);

    @NotNull
    public Vec3 axis(@NotNull Quat var1);

    @NotNull
    public Vec3d axis(@NotNull QuatD var1, @NotNull Vec3d var2);

    @NotNull
    public Vec3d axis(@NotNull QuatD var1);

    @NotNull
    public Quat angleAxis(float var1, float var2, float var3, float var4, @NotNull Quat var5);

    @NotNull
    public Quat angleAxis(float var1, float var2, float var3, float var4);

    @NotNull
    public Quat angleAxis(float var1, @NotNull Vec3 var2, @NotNull Quat var3);

    @NotNull
    public Quat angleAxis(float var1, @NotNull Vec3 var2);

    @NotNull
    public QuatD angleAxis(double var1, double var3, double var5, double var7, @NotNull QuatD var9);

    @NotNull
    public QuatD angleAxis(double var1, double var3, double var5, double var7);

    @NotNull
    public QuatD angleAxis(double var1, @NotNull Vec3d var3, @NotNull QuatD var4);

    @NotNull
    public QuatD angleAxis(double var1, @NotNull Vec3d var3);

    @NotNull
    public Vec4bool lessThan(@NotNull Quat var1, @NotNull Quat var2, @NotNull Vec4bool var3);

    @NotNull
    public Vec4bool lessThan(@NotNull Quat var1, @NotNull Quat var2);

    @NotNull
    public Vec4bool lessThanEqual(@NotNull Quat var1, @NotNull Quat var2, @NotNull Vec4bool var3);

    @NotNull
    public Vec4bool lessThanEqual(@NotNull Quat var1, @NotNull Quat var2);

    @NotNull
    public Vec4bool greater(@NotNull Quat var1, @NotNull Quat var2, @NotNull Vec4bool var3);

    @NotNull
    public Vec4bool greater(@NotNull Quat var1, @NotNull Quat var2);

    @NotNull
    public Vec4bool greaterThan(@NotNull Quat var1, @NotNull Quat var2, @NotNull Vec4bool var3);

    @NotNull
    public Vec4bool greaterThan(@NotNull Quat var1, @NotNull Quat var2);

    @NotNull
    public Vec4bool equal(@NotNull Quat var1, @NotNull Quat var2, @NotNull Vec4bool var3);

    @NotNull
    public Vec4bool equal(@NotNull Quat var1, @NotNull Quat var2);

    @NotNull
    public Vec4bool notEqual(@NotNull Quat var1, @NotNull Quat var2, @NotNull Vec4bool var3);

    @NotNull
    public Vec4bool notEqual(@NotNull Quat var1, @NotNull Quat var2);

    @NotNull
    public Vec4bool isNan(@NotNull Quat var1, @NotNull Vec4bool var2);

    @NotNull
    public Vec4bool isNan(@NotNull Quat var1);

    @NotNull
    public Vec4bool isInf(@NotNull Quat var1, @NotNull Vec4bool var2);

    @NotNull
    public Vec4bool isInf(@NotNull Quat var1);

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        public static float length(gtcQuaternion $this, @NotNull Quat q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return glm.INSTANCE.sqrt($this.dot(q, q));
        }

        public static double length(gtcQuaternion $this, @NotNull QuatD q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return glm.INSTANCE.sqrt($this.dot(q, q));
        }

        @NotNull
        public static Quat normalize(gtcQuaternion $this, @NotNull Quat q, @NotNull Quat res) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(res, "res");
            float len = $this.length(q);
            if (len <= 0.0f) {
                return res.put(1.0f, 0.0f, 0.0f, 0.0f);
            }
            float oneOverLen = 1.0f / len;
            return res.put(q.w.floatValue() * oneOverLen, q.x.floatValue() * oneOverLen, q.y.floatValue() * oneOverLen, q.z.floatValue() * oneOverLen);
        }

        @NotNull
        public static Quat normalize(gtcQuaternion $this, @NotNull Quat q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return $this.normalize(q, new Quat());
        }

        @NotNull
        public static QuatD normalize(gtcQuaternion $this, @NotNull QuatD q, @NotNull QuatD res) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(res, "res");
            double len = $this.length(q);
            if (len <= 0.0) {
                return res.put(1.0, 0.0, 0.0, 0.0);
            }
            double oneOverLen = 1.0 / len;
            return res.put(q.w.doubleValue() * oneOverLen, q.x.doubleValue() * oneOverLen, q.y.doubleValue() * oneOverLen, q.z.doubleValue() * oneOverLen);
        }

        @NotNull
        public static QuatD normalize(gtcQuaternion $this, @NotNull QuatD q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return $this.normalize(q, new QuatD());
        }

        public static float dot(gtcQuaternion $this, @NotNull Quat a2, @NotNull Quat b) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return a2.x.floatValue() * b.x.floatValue() + a2.y.floatValue() * b.y.floatValue() + a2.z.floatValue() * b.z.floatValue() + a2.w.floatValue() * b.w.floatValue();
        }

        public static double dot(gtcQuaternion $this, @NotNull QuatD a2, @NotNull QuatD b) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return a2.x.doubleValue() * b.x.doubleValue() + a2.y.doubleValue() * b.y.doubleValue() + a2.z.doubleValue() * b.z.doubleValue() + a2.w.doubleValue() * b.w.doubleValue();
        }

        @NotNull
        public static Quat mix(gtcQuaternion $this, @NotNull Quat a2, @NotNull Quat b, float interp, @NotNull Quat res) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            Intrinsics.checkParameterIsNotNull(res, "res");
            float cosTheta = $this.dot(a2, b);
            if (cosTheta > 1.0f - glm.epsilonF) {
                res.w = Float.valueOf(glm.INSTANCE.mix(a2.w.floatValue(), b.w.floatValue(), interp));
                res.x = Float.valueOf(glm.INSTANCE.mix(a2.x.floatValue(), b.x.floatValue(), interp));
                res.y = Float.valueOf(glm.INSTANCE.mix(a2.y.floatValue(), b.y.floatValue(), interp));
                res.z = Float.valueOf(glm.INSTANCE.mix(a2.z.floatValue(), b.z.floatValue(), interp));
                return res;
            }
            float angle = glm.INSTANCE.acos(cosTheta);
            float s0 = glm.INSTANCE.sin((1.0f - interp) * angle);
            float s1 = glm.INSTANCE.sin(interp * angle);
            float s2 = glm.INSTANCE.sin(angle);
            res.w = Float.valueOf((s0 * a2.w.floatValue() + s1 * b.w.floatValue()) / s2);
            res.x = Float.valueOf((s0 * a2.x.floatValue() + s1 * b.x.floatValue()) / s2);
            res.y = Float.valueOf((s0 * a2.y.floatValue() + s1 * b.y.floatValue()) / s2);
            res.z = Float.valueOf((s0 * a2.z.floatValue() + s1 * b.z.floatValue()) / s2);
            return res;
        }

        @NotNull
        public static Quat mix(gtcQuaternion $this, @NotNull Quat a2, @NotNull Quat b, float interp) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return $this.mix(a2, b, interp, new Quat());
        }

        @NotNull
        public static QuatD mix(gtcQuaternion $this, @NotNull QuatD a2, @NotNull QuatD b, double interp, @NotNull QuatD res) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            Intrinsics.checkParameterIsNotNull(res, "res");
            double cosTheta = $this.dot(a2, b);
            if (cosTheta > 1.0 - glm.epsilon) {
                res.w = glm.INSTANCE.mix(a2.w.doubleValue(), b.w.doubleValue(), interp);
                res.x = glm.INSTANCE.mix(a2.x.doubleValue(), b.x.doubleValue(), interp);
                res.y = glm.INSTANCE.mix(a2.y.doubleValue(), b.y.doubleValue(), interp);
                res.z = glm.INSTANCE.mix(a2.z.doubleValue(), b.z.doubleValue(), interp);
                return res;
            }
            double angle = glm.INSTANCE.acos(cosTheta);
            double s0 = glm.INSTANCE.sin((1.0 - interp) * angle);
            double s1 = glm.INSTANCE.sin(interp * angle);
            double s2 = glm.INSTANCE.sin(angle);
            res.w = (s0 * a2.w.doubleValue() + s1 * b.w.doubleValue()) / s2;
            res.x = (s0 * a2.x.doubleValue() + s1 * b.x.doubleValue()) / s2;
            res.y = (s0 * a2.y.doubleValue() + s1 * b.y.doubleValue()) / s2;
            res.z = (s0 * a2.z.doubleValue() + s1 * b.z.doubleValue()) / s2;
            return res;
        }

        @NotNull
        public static QuatD mix(gtcQuaternion $this, @NotNull QuatD a2, @NotNull QuatD b, double interp) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return $this.mix(a2, b, interp, new QuatD());
        }

        @NotNull
        public static Quat lerp(gtcQuaternion $this, @NotNull Quat a2, @NotNull Quat b, float interp, @NotNull Quat res) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            Intrinsics.checkParameterIsNotNull(res, "res");
            if (interp < 0.0f || interp > 1.0f) {
                throw (Throwable)new ArithmeticException("interp outside [0, 1]");
            }
            res.w = Float.valueOf(a2.w.floatValue() * (1.0f - interp) + b.w.floatValue() * interp);
            res.x = Float.valueOf(a2.x.floatValue() * (1.0f - interp) + b.x.floatValue() * interp);
            res.y = Float.valueOf(a2.y.floatValue() * (1.0f - interp) + b.y.floatValue() * interp);
            res.z = Float.valueOf(a2.z.floatValue() * (1.0f - interp) + b.z.floatValue() * interp);
            return res;
        }

        @NotNull
        public static Quat lerp(gtcQuaternion $this, @NotNull Quat a2, @NotNull Quat b, float interp) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return $this.lerp(a2, b, interp, new Quat());
        }

        @NotNull
        public static QuatD lerp(gtcQuaternion $this, @NotNull QuatD a2, @NotNull QuatD b, double interp, @NotNull QuatD res) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            Intrinsics.checkParameterIsNotNull(res, "res");
            if (interp < 0.0 || interp > 1.0) {
                throw (Throwable)new ArithmeticException("interp outside [0, 1]");
            }
            res.w = a2.w.doubleValue() * (1.0 - interp) + b.w.doubleValue() * interp;
            res.x = a2.x.doubleValue() * (1.0 - interp) + b.x.doubleValue() * interp;
            res.y = a2.y.doubleValue() * (1.0 - interp) + b.y.doubleValue() * interp;
            res.z = a2.z.doubleValue() * (1.0 - interp) + b.z.doubleValue() * interp;
            return res;
        }

        @NotNull
        public static QuatD lerp(gtcQuaternion $this, @NotNull QuatD a2, @NotNull QuatD b, double interp) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return $this.lerp(a2, b, interp, new QuatD());
        }

        @NotNull
        public static Quat slerp(gtcQuaternion $this, @NotNull Quat a2, @NotNull Quat b, float interp, @NotNull Quat res) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            Intrinsics.checkParameterIsNotNull(res, "res");
            float zW = b.w.floatValue();
            float zX = b.x.floatValue();
            float zY = b.y.floatValue();
            float zZ = b.z.floatValue();
            float cosTheta = $this.dot(a2, b);
            if (cosTheta < 0.0f) {
                zW = -b.w.floatValue();
                zX = -b.x.floatValue();
                zY = -b.y.floatValue();
                zZ = -b.z.floatValue();
                cosTheta = -cosTheta;
            }
            if (cosTheta > 1.0f - glm.epsilonF) {
                res.w = Float.valueOf(glm.INSTANCE.mix(a2.w.floatValue(), zW, interp));
                res.x = Float.valueOf(glm.INSTANCE.mix(a2.x.floatValue(), zX, interp));
                res.y = Float.valueOf(glm.INSTANCE.mix(a2.y.floatValue(), zY, interp));
                res.z = Float.valueOf(glm.INSTANCE.mix(a2.z.floatValue(), zZ, interp));
                return res;
            }
            float angle = glm.INSTANCE.acos(cosTheta);
            float s0 = glm.INSTANCE.sin((1.0f - interp) * angle);
            float s1 = glm.INSTANCE.sin(interp * angle);
            float s2 = glm.INSTANCE.sin(angle);
            res.w = Float.valueOf((s0 * a2.w.floatValue() + s1 * zW) / s2);
            res.x = Float.valueOf((s0 * a2.x.floatValue() + s1 * zX) / s2);
            res.y = Float.valueOf((s0 * a2.y.floatValue() + s1 * zY) / s2);
            res.z = Float.valueOf((s0 * a2.z.floatValue() + s1 * zZ) / s2);
            return res;
        }

        @NotNull
        public static Quat slerp(gtcQuaternion $this, @NotNull Quat a2, @NotNull Quat b, float interp) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return $this.slerp(a2, b, interp, new Quat());
        }

        @NotNull
        public static QuatD slerp(gtcQuaternion $this, @NotNull QuatD a2, @NotNull QuatD b, double interp, @NotNull QuatD res) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            Intrinsics.checkParameterIsNotNull(res, "res");
            double zW = b.w.doubleValue();
            double zX = b.x.doubleValue();
            double zY = b.y.doubleValue();
            double zZ = b.z.doubleValue();
            double cosTheta = $this.dot(a2, b);
            if (cosTheta < 0.0) {
                zW = -b.w.doubleValue();
                zX = -b.x.doubleValue();
                zY = -b.y.doubleValue();
                zZ = -b.z.doubleValue();
                cosTheta = -cosTheta;
            }
            if (cosTheta > 1.0 - glm.epsilon) {
                res.w = glm.INSTANCE.mix(a2.w.doubleValue(), zW, interp);
                res.x = glm.INSTANCE.mix(a2.x.doubleValue(), zX, interp);
                res.y = glm.INSTANCE.mix(a2.y.doubleValue(), zY, interp);
                res.z = glm.INSTANCE.mix(a2.z.doubleValue(), zZ, interp);
                return res;
            }
            double angle = glm.INSTANCE.acos(cosTheta);
            double s0 = glm.INSTANCE.sin((1.0 - interp) * angle);
            double s1 = glm.INSTANCE.sin(interp * angle);
            double s2 = glm.INSTANCE.sin(angle);
            res.w = (s0 * a2.w.doubleValue() + s1 * b.w.doubleValue()) / s2;
            res.x = (s0 * a2.x.doubleValue() + s1 * b.x.doubleValue()) / s2;
            res.y = (s0 * a2.y.doubleValue() + s1 * b.y.doubleValue()) / s2;
            res.z = (s0 * a2.z.doubleValue() + s1 * b.z.doubleValue()) / s2;
            return res;
        }

        @NotNull
        public static QuatD slerp(gtcQuaternion $this, @NotNull QuatD a2, @NotNull QuatD b, double interp) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return $this.slerp(a2, b, interp, new QuatD());
        }

        @NotNull
        public static Quat conjugate(gtcQuaternion $this, @NotNull Quat a2, @NotNull Quat res) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(res, "res");
            res.w = a2.w;
            res.x = Float.valueOf(-a2.x.floatValue());
            res.y = Float.valueOf(-a2.y.floatValue());
            res.z = Float.valueOf(-a2.z.floatValue());
            return res;
        }

        @NotNull
        public static Quat conjugate(gtcQuaternion $this, @NotNull Quat a2) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            return $this.conjugate(a2, new Quat());
        }

        @NotNull
        public static QuatD conjugate(gtcQuaternion $this, @NotNull QuatD a2, @NotNull QuatD res) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(res, "res");
            res.w = a2.w;
            res.x = -a2.x.doubleValue();
            res.y = -a2.y.doubleValue();
            res.z = -a2.z.doubleValue();
            return res;
        }

        @NotNull
        public static QuatD conjugate(gtcQuaternion $this, @NotNull QuatD a2) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            return $this.conjugate(a2, new QuatD());
        }

        @NotNull
        public static Quat inverse(gtcQuaternion $this, @NotNull Quat a2, @NotNull Quat res) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(res, "res");
            float dot = $this.dot(a2, a2);
            res.w = Float.valueOf(a2.w.floatValue() / dot);
            res.x = Float.valueOf(-a2.x.floatValue() / dot);
            res.y = Float.valueOf(-a2.y.floatValue() / dot);
            res.z = Float.valueOf(-a2.z.floatValue() / dot);
            return res;
        }

        @NotNull
        public static Quat inverse(gtcQuaternion $this, @NotNull Quat a2) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            return $this.inverse(a2, new Quat());
        }

        @NotNull
        public static QuatD inverse(gtcQuaternion $this, @NotNull QuatD a2, @NotNull QuatD res) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(res, "res");
            double dot = $this.dot(a2, a2);
            res.w = a2.w.doubleValue() / dot;
            res.x = -a2.x.doubleValue() / dot;
            res.y = -a2.y.doubleValue() / dot;
            res.z = -a2.z.doubleValue() / dot;
            return res;
        }

        @NotNull
        public static QuatD inverse(gtcQuaternion $this, @NotNull QuatD a2) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            return $this.inverse(a2, new QuatD());
        }

        @NotNull
        public static Quat rotate(gtcQuaternion $this, @NotNull Quat q, float angle, float vX, float vY, float vZ, @NotNull Quat res) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(res, "res");
            float tmpX = vX;
            float tmpY = vY;
            float tmpZ = vZ;
            float len = glm.INSTANCE.sqrt(vX * vX + vY * vY + vZ * vZ);
            if (glm.INSTANCE.abs(len - 1.0f) > 0.001f) {
                float oneOverLen = 1.0f / len;
                tmpX *= oneOverLen;
                tmpY *= oneOverLen;
                tmpZ *= oneOverLen;
            }
            float sin = glm.INSTANCE.sin(angle * 0.5f);
            float pW = glm.INSTANCE.cos(angle * 0.5f);
            float pX = tmpX * sin;
            float pY = tmpY * sin;
            float pZ = tmpZ * sin;
            float w = q.w.floatValue() * pW - q.x.floatValue() * pX - q.y.floatValue() * pY - q.z.floatValue() * pZ;
            float x = q.w.floatValue() * pX + q.x.floatValue() * pW + q.y.floatValue() * pZ - q.z.floatValue() * pY;
            float y = q.w.floatValue() * pY + q.y.floatValue() * pW + q.z.floatValue() * pX - q.x.floatValue() * pZ;
            float z = q.w.floatValue() * pZ + q.z.floatValue() * pW + q.x.floatValue() * pY - q.y.floatValue() * pX;
            res.w = Float.valueOf(w);
            res.x = Float.valueOf(x);
            res.y = Float.valueOf(y);
            res.z = Float.valueOf(z);
            return res;
        }

        @NotNull
        public static Quat rotate(gtcQuaternion $this, @NotNull Quat q, float angle, float vX, float vY, float vZ) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return $this.rotate(q, angle, vX, vY, vZ, new Quat());
        }

        @NotNull
        public static Quat rotate(gtcQuaternion $this, @NotNull Quat q, float angle, @NotNull Vec3 v, @NotNull Quat res) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(v, "v");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return $this.rotate(q, angle, v.getX().floatValue(), v.getY().floatValue(), v.getZ().floatValue(), res);
        }

        @NotNull
        public static Quat rotate(gtcQuaternion $this, @NotNull Quat q, float angle, @NotNull Vec3 v) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(v, "v");
            return $this.rotate(q, angle, v.getX().floatValue(), v.getY().floatValue(), v.getZ().floatValue(), new Quat());
        }

        @NotNull
        public static QuatD rotate(gtcQuaternion $this, @NotNull QuatD q, double angle, double vX, double vY, double vZ, @NotNull QuatD res) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(res, "res");
            double tmpX = vX;
            double tmpY = vY;
            double tmpZ = vZ;
            double len = glm.INSTANCE.sqrt(vX * vX + vY * vY + vZ * vZ);
            if (glm.INSTANCE.abs(len - (double)1.0f) > 0.001) {
                double oneOverLen = (double)1.0f / len;
                tmpX *= oneOverLen;
                tmpY *= oneOverLen;
                tmpZ *= oneOverLen;
            }
            double sin = glm.INSTANCE.sin(angle * (double)0.5f);
            double pW = glm.INSTANCE.cos(angle * (double)0.5f);
            double pX = tmpX * sin;
            double pY = tmpY * sin;
            double pZ = tmpZ * sin;
            double w = q.w.doubleValue() * pW - q.x.doubleValue() * pX - q.y.doubleValue() * pY - q.z.doubleValue() * pZ;
            double x = q.w.doubleValue() * pX + q.x.doubleValue() * pW + q.y.doubleValue() * pZ - q.z.doubleValue() * pY;
            double y = q.w.doubleValue() * pY + q.y.doubleValue() * pW + q.z.doubleValue() * pX - q.x.doubleValue() * pZ;
            double z = q.w.doubleValue() * pZ + q.z.doubleValue() * pW + q.x.doubleValue() * pY - q.y.doubleValue() * pX;
            res.w = w;
            res.x = x;
            res.y = y;
            res.z = z;
            return res;
        }

        @NotNull
        public static QuatD rotate(gtcQuaternion $this, @NotNull QuatD q, double angle, double vX, double vY, double vZ) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return $this.rotate(q, angle, vX, vY, vZ, new QuatD());
        }

        @NotNull
        public static QuatD rotate(gtcQuaternion $this, @NotNull QuatD q, double angle, @NotNull Vec3d v, @NotNull QuatD res) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(v, "v");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return $this.rotate(q, angle, v.getX(), v.getY(), v.getZ(), res);
        }

        @NotNull
        public static QuatD rotate(gtcQuaternion $this, @NotNull QuatD q, double angle, @NotNull Vec3d v) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(v, "v");
            return $this.rotate(q, angle, v.getX(), v.getY(), v.getZ(), new QuatD());
        }

        @NotNull
        public static Vec3 eulerAngles(gtcQuaternion $this, @NotNull Quat a2, @NotNull Vec3 res) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(res, "res");
            res.setX($this.pitch(a2));
            res.setY($this.yaw(a2));
            res.setZ($this.roll(a2));
            return res;
        }

        @NotNull
        public static Vec3 eulerAngles(gtcQuaternion $this, @NotNull Quat a2) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            return $this.eulerAngles(a2, new Vec3());
        }

        @NotNull
        public static Vec3d eulerAngles(gtcQuaternion $this, @NotNull QuatD a2, @NotNull Vec3d res) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(res, "res");
            res.setX($this.pitch(a2));
            res.setY($this.yaw(a2));
            res.setZ($this.roll(a2));
            return res;
        }

        @NotNull
        public static Vec3d eulerAngles(gtcQuaternion $this, @NotNull QuatD a2) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            return $this.eulerAngles(a2, new Vec3d());
        }

        public static float roll(gtcQuaternion $this, @NotNull Quat q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return glm.INSTANCE.atan(2.0f * (q.x.floatValue() * q.y.floatValue() + q.w.floatValue() * q.z.floatValue()), q.w.floatValue() * q.w.floatValue() + q.x.floatValue() * q.x.floatValue() - q.y.floatValue() * q.y.floatValue() - q.z.floatValue() * q.z.floatValue());
        }

        public static double roll(gtcQuaternion $this, @NotNull QuatD q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return glm.INSTANCE.atan(2.0 * (q.x.doubleValue() * q.y.doubleValue() + q.w.doubleValue() * q.z.doubleValue()), q.w.doubleValue() * q.w.doubleValue() + q.x.doubleValue() * q.x.doubleValue() - q.y.doubleValue() * q.y.doubleValue() - q.z.doubleValue() * q.z.doubleValue());
        }

        public static float pitch(gtcQuaternion $this, @NotNull Quat q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            float y = 2.0f * (q.y.floatValue() * q.z.floatValue() + q.w.floatValue() * q.x.floatValue());
            float x = q.w.floatValue() * q.w.floatValue() - q.x.floatValue() * q.x.floatValue() - q.y.floatValue() * q.y.floatValue() + q.z.floatValue() * q.z.floatValue();
            return y == 0.0f && x == 0.0f ? 2.0f * glm.INSTANCE.atan(q.x.floatValue(), q.w.floatValue()) : glm.INSTANCE.atan(y, x);
        }

        public static double pitch(gtcQuaternion $this, @NotNull QuatD q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return glm.INSTANCE.atan(2.0 * (q.y.doubleValue() * q.z.doubleValue() + q.w.doubleValue() * q.x.doubleValue()), q.w.doubleValue() * q.w.doubleValue() - q.x.doubleValue() * q.x.doubleValue() - q.y.doubleValue() * q.y.doubleValue() + q.z.doubleValue() * q.z.doubleValue());
        }

        public static float yaw(gtcQuaternion $this, @NotNull Quat q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return glm.INSTANCE.asin(glm.INSTANCE.clamp(-2.0f * (q.x.floatValue() * q.z.floatValue() - q.w.floatValue() * q.y.floatValue()), -1.0f, 1.0f));
        }

        public static double yaw(gtcQuaternion $this, @NotNull QuatD q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return glm.INSTANCE.asin(glm.INSTANCE.clamp(-2.0 * (q.x.doubleValue() * q.z.doubleValue() - q.w.doubleValue() * q.y.doubleValue()), -1.0, 1.0));
        }

        @NotNull
        public static Mat3 mat3_cast(gtcQuaternion $this, @NotNull Quat q, @NotNull Mat3 res) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(res, "res");
            float qxx = q.x.floatValue() * q.x.floatValue();
            float qyy = q.y.floatValue() * q.y.floatValue();
            float qzz = q.z.floatValue() * q.z.floatValue();
            float qxz = q.x.floatValue() * q.z.floatValue();
            float qxy = q.x.floatValue() * q.y.floatValue();
            float qyz = q.y.floatValue() * q.z.floatValue();
            float qwx = q.w.floatValue() * q.x.floatValue();
            float qwy = q.w.floatValue() * q.y.floatValue();
            float qwz = q.w.floatValue() * q.z.floatValue();
            res.set(0, 0, 1.0f - 2.0f * (qyy + qzz));
            res.set(0, 1, 2.0f * (qxy + qwz));
            res.set(0, 2, 2.0f * (qxz - qwy));
            res.set(1, 0, 2.0f * (qxy - qwz));
            res.set(1, 1, 1.0f - 2.0f * (qxx + qzz));
            res.set(1, 2, 2.0f * (qyz + qwx));
            res.set(2, 0, 2.0f * (qxz + qwy));
            res.set(2, 1, 2.0f * (qyz - qwx));
            res.set(2, 2, 1.0f - 2.0f * (qxx + qyy));
            return res;
        }

        @NotNull
        public static Mat3 mat3_cast(gtcQuaternion $this, @NotNull Quat q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return $this.mat3_cast(q, new Mat3());
        }

        @NotNull
        public static Mat3 mat3d_cast(gtcQuaternion $this, @NotNull QuatD q, @NotNull Mat3 m) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(m, "m");
            throw (Throwable)new NotImplementedError(null, 1, null);
        }

        @NotNull
        public static Mat4 mat4_cast(gtcQuaternion $this, @NotNull Quat q, @NotNull Mat4 res) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(res, "res");
            float qxx = q.x.floatValue() * q.x.floatValue();
            float qyy = q.y.floatValue() * q.y.floatValue();
            float qzz = q.z.floatValue() * q.z.floatValue();
            float qxz = q.x.floatValue() * q.z.floatValue();
            float qxy = q.x.floatValue() * q.y.floatValue();
            float qyz = q.y.floatValue() * q.z.floatValue();
            float qwx = q.w.floatValue() * q.x.floatValue();
            float qwy = q.w.floatValue() * q.y.floatValue();
            float qwz = q.w.floatValue() * q.z.floatValue();
            res.set(0, 0, 1.0f - 2.0f * (qyy + qzz));
            res.set(0, 1, 2.0f * (qxy + qwz));
            res.set(0, 2, 2.0f * (qxz - qwy));
            res.set(1, 0, 2.0f * (qxy - qwz));
            res.set(1, 1, 1.0f - 2.0f * (qxx + qzz));
            res.set(1, 2, 2.0f * (qyz + qwx));
            res.set(2, 0, 2.0f * (qxz + qwy));
            res.set(2, 1, 2.0f * (qyz - qwx));
            res.set(2, 2, 1.0f - 2.0f * (qxx + qyy));
            return res;
        }

        @NotNull
        public static Mat4 mat4_cast(gtcQuaternion $this, @NotNull Quat q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return $this.mat4_cast(q, new Mat4());
        }

        @NotNull
        public static Mat4 mat4d_cast(gtcQuaternion $this, @NotNull Mat4 res, @NotNull QuatD q) {
            Intrinsics.checkParameterIsNotNull(res, "res");
            Intrinsics.checkParameterIsNotNull(q, "q");
            throw (Throwable)new NotImplementedError(null, 1, null);
        }

        @NotNull
        public static Quat quat_cast(gtcQuaternion $this, @NotNull Mat3 m, @NotNull Quat res) {
            Intrinsics.checkParameterIsNotNull(m, "m");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return $this.quat_cast(m.get(0, 0).floatValue(), m.get(0, 1).floatValue(), m.get(0, 2).floatValue(), m.get(1, 0).floatValue(), m.get(1, 1).floatValue(), m.get(1, 2).floatValue(), m.get(2, 0).floatValue(), m.get(2, 1).floatValue(), m.get(2, 2).floatValue(), res);
        }

        @NotNull
        public static QuatD quatD_cast(gtcQuaternion $this, @NotNull Mat3d m, @NotNull QuatD res) {
            Intrinsics.checkParameterIsNotNull(m, "m");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return $this.quatD_cast(m.get(0, 0), m.get(0, 1), m.get(0, 2), m.get(1, 0), m.get(1, 1), m.get(1, 2), m.get(2, 0), m.get(2, 1), m.get(2, 2), res);
        }

        @NotNull
        public static Quat quat_cast(gtcQuaternion $this, @NotNull Mat3 m) {
            Intrinsics.checkParameterIsNotNull(m, "m");
            return $this.quat_cast(m, new Quat());
        }

        @NotNull
        public static QuatD quatD_cast(gtcQuaternion $this, @NotNull Mat3d m) {
            Intrinsics.checkParameterIsNotNull(m, "m");
            return $this.quatD_cast(m, new QuatD());
        }

        @NotNull
        public static Quat quat_cast(gtcQuaternion $this, @NotNull Mat4 m, @NotNull Quat res) {
            Intrinsics.checkParameterIsNotNull(m, "m");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return $this.quat_cast(m.get(0, 0).floatValue(), m.get(0, 1).floatValue(), m.get(0, 2).floatValue(), m.get(1, 0).floatValue(), m.get(1, 1).floatValue(), m.get(1, 2).floatValue(), m.get(2, 0).floatValue(), m.get(2, 1).floatValue(), m.get(2, 2).floatValue(), res);
        }

        @NotNull
        public static QuatD quatD_cast(gtcQuaternion $this, @NotNull Mat4d m, @NotNull QuatD res) {
            Intrinsics.checkParameterIsNotNull(m, "m");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return $this.quatD_cast(m.get(0, 0), m.get(0, 1), m.get(0, 2), m.get(1, 0), m.get(1, 1), m.get(1, 2), m.get(2, 0), m.get(2, 1), m.get(2, 2), res);
        }

        @NotNull
        public static Quat quat_cast(gtcQuaternion $this, @NotNull Mat4 m) {
            Intrinsics.checkParameterIsNotNull(m, "m");
            return $this.quat_cast(m, new Quat());
        }

        @NotNull
        public static QuatD quatD_cast(gtcQuaternion $this, @NotNull Mat4d m) {
            Intrinsics.checkParameterIsNotNull(m, "m");
            return $this.quatD_cast(m, new QuatD());
        }

        @NotNull
        public static Quat quat_cast(gtcQuaternion $this, float m00, float m01, float m02, float m10, float m11, float m12, float m20, float m21, float m22, @NotNull Quat res) {
            Quat quat;
            Intrinsics.checkParameterIsNotNull(res, "res");
            float fourXSquaredMinus1 = m00 - m11 - m22;
            float fourYSquaredMinus1 = m11 - m00 - m22;
            float fourZSquaredMinus1 = m22 - m00 - m11;
            float fourWSquaredMinus1 = m00 + m11 + m22;
            int biggestIndex = 0;
            float fourBiggestSquaredMinus1 = fourWSquaredMinus1;
            if (fourXSquaredMinus1 > fourBiggestSquaredMinus1) {
                fourBiggestSquaredMinus1 = fourXSquaredMinus1;
                biggestIndex = 1;
            }
            if (fourYSquaredMinus1 > fourBiggestSquaredMinus1) {
                fourBiggestSquaredMinus1 = fourYSquaredMinus1;
                biggestIndex = 2;
            }
            if (fourZSquaredMinus1 > fourBiggestSquaredMinus1) {
                fourBiggestSquaredMinus1 = fourZSquaredMinus1;
                biggestIndex = 3;
            }
            float biggestVal = glm.INSTANCE.sqrt(fourBiggestSquaredMinus1 + 1.0f) * 0.5f;
            float mult = 0.25f / biggestVal;
            switch (biggestIndex) {
                case 0: {
                    quat = res.put(biggestVal, (m12 - m21) * mult, (m20 - m02) * mult, (m01 - m10) * mult);
                    break;
                }
                case 1: {
                    quat = res.put((m12 - m21) * mult, biggestVal, (m01 + m10) * mult, (m20 + m02) * mult);
                    break;
                }
                case 2: {
                    quat = res.put((m20 - m02) * mult, (m01 + m10) * mult, biggestVal, (m12 + m21) * mult);
                    break;
                }
                case 3: {
                    quat = res.put((m01 - m10) * mult, (m20 + m02) * mult, (m12 + m21) * mult, biggestVal);
                    break;
                }
                default: {
                    boolean bl = false;
                    if (_Assertions.ENABLED) {
                        String string = "Assertion failed";
                        throw (Throwable)((Object)new AssertionError((Object)string));
                    }
                    quat = res.put(1.0f, 0.0f, 0.0f, 0.0f);
                }
            }
            return quat;
        }

        @NotNull
        public static Quat quat_cast(gtcQuaternion $this, float m00, float m01, float m02, float m10, float m11, float m12, float m20, float m21, float m22) {
            return $this.quat_cast(m00, m01, m02, m10, m11, m12, m20, m21, m22, new Quat());
        }

        @NotNull
        public static QuatD quatD_cast(gtcQuaternion $this, double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22, @NotNull QuatD res) {
            Intrinsics.checkParameterIsNotNull(res, "res");
            double fourXSquaredMinus1 = m00 - m11 - m22;
            double fourYSquaredMinus1 = m11 - m00 - m22;
            double fourZSquaredMinus1 = m22 - m00 - m11;
            double fourWSquaredMinus1 = m00 + m11 + m22;
            int biggestIndex = 0;
            double fourBiggestSquaredMinus1 = fourWSquaredMinus1;
            if (fourXSquaredMinus1 > fourBiggestSquaredMinus1) {
                fourBiggestSquaredMinus1 = fourXSquaredMinus1;
                biggestIndex = 1;
            }
            if (fourYSquaredMinus1 > fourBiggestSquaredMinus1) {
                fourBiggestSquaredMinus1 = fourYSquaredMinus1;
                biggestIndex = 2;
            }
            if (fourZSquaredMinus1 > fourBiggestSquaredMinus1) {
                fourBiggestSquaredMinus1 = fourZSquaredMinus1;
                biggestIndex = 3;
            }
            double biggestVal = glm.INSTANCE.sqrt(fourBiggestSquaredMinus1 + 1.0) * 0.5;
            double mult = 0.25 / biggestVal;
            switch (biggestIndex) {
                case 0: {
                    res.w = biggestVal;
                    res.x = (m12 - m21) * mult;
                    res.y = (m20 - m02) * mult;
                    res.z = (m01 - m10) * mult;
                    break;
                }
                case 1: {
                    res.w = (m12 - m21) * mult;
                    res.x = biggestVal;
                    res.y = (m01 + m10) * mult;
                    res.z = (m20 + m02) * mult;
                    break;
                }
                case 2: {
                    res.w = (m20 - m02) * mult;
                    res.x = (m01 + m10) * mult;
                    res.y = biggestVal;
                    res.z = (m12 + m21) * mult;
                    break;
                }
                case 3: {
                    res.w = (m01 - m10) * mult;
                    res.x = (m20 + m02) * mult;
                    res.y = (m12 + m21) * mult;
                    res.z = biggestVal;
                    break;
                }
                default: {
                    boolean bl = false;
                    if (!_Assertions.ENABLED) break;
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
            }
            return res;
        }

        @NotNull
        public static QuatD quatD_cast(gtcQuaternion $this, double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22) {
            return $this.quatD_cast(m00, m01, m02, m10, m11, m12, m20, m21, m22, new QuatD());
        }

        public static float angle(gtcQuaternion $this, @NotNull Quat q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return glm.INSTANCE.acos(q.w.floatValue()) * 2.0f;
        }

        public static double angle(gtcQuaternion $this, @NotNull QuatD q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return glm.INSTANCE.acos(q.w.doubleValue()) * 2.0;
        }

        @NotNull
        public static Vec3 axis(gtcQuaternion $this, @NotNull Quat q, @NotNull Vec3 res) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(res, "res");
            float tmp1 = 1.0f - q.w.floatValue() * q.w.floatValue();
            if (tmp1 <= 0.0f) {
                res.setX(0.0f);
                res.setY(0.0f);
                res.setZ(1.0f);
                return res;
            }
            float tmp2 = 1.0f / glm.INSTANCE.sqrt(tmp1);
            res.setX(q.x.floatValue() * tmp2);
            res.setY(q.y.floatValue() * tmp2);
            res.setZ(q.z.floatValue() * tmp2);
            return res;
        }

        @NotNull
        public static Vec3 axis(gtcQuaternion $this, @NotNull Quat q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return $this.axis(q, new Vec3());
        }

        @NotNull
        public static Vec3d axis(gtcQuaternion $this, @NotNull QuatD q, @NotNull Vec3d res) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(res, "res");
            double tmp1 = 1.0 - q.w.doubleValue() * q.w.doubleValue();
            if (tmp1 <= 0.0) {
                res.setX(0.0);
                res.setY(0.0);
                res.setZ(1.0);
                return res;
            }
            double tmp2 = 1.0 / glm.INSTANCE.sqrt(tmp1);
            res.setX(q.x.doubleValue() * tmp2);
            res.setY(q.y.doubleValue() * tmp2);
            res.setZ(q.z.doubleValue() * tmp2);
            return res;
        }

        @NotNull
        public static Vec3d axis(gtcQuaternion $this, @NotNull QuatD q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return $this.axis(q, new Vec3d());
        }

        @NotNull
        public static Quat angleAxis(gtcQuaternion $this, float angle, float axisX, float axisY, float axisZ, @NotNull Quat res) {
            Intrinsics.checkParameterIsNotNull(res, "res");
            float a2 = angle * 0.5f;
            float s2 = glm.INSTANCE.sin(a2);
            res.w = Float.valueOf(glm.INSTANCE.cos(a2));
            res.x = Float.valueOf(axisX * s2);
            res.y = Float.valueOf(axisY * s2);
            res.z = Float.valueOf(axisZ * s2);
            return res;
        }

        @NotNull
        public static Quat angleAxis(gtcQuaternion $this, float angle, float axisX, float axisY, float axisZ) {
            return $this.angleAxis(angle, axisX, axisY, axisZ, new Quat());
        }

        @NotNull
        public static Quat angleAxis(gtcQuaternion $this, float angle, @NotNull Vec3 axis, @NotNull Quat res) {
            Intrinsics.checkParameterIsNotNull(axis, "axis");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return $this.angleAxis(angle, axis.getX().floatValue(), axis.getY().floatValue(), axis.getZ().floatValue(), res);
        }

        @NotNull
        public static Quat angleAxis(gtcQuaternion $this, float angle, @NotNull Vec3 axis) {
            Intrinsics.checkParameterIsNotNull(axis, "axis");
            return $this.angleAxis(angle, axis.getX().floatValue(), axis.getY().floatValue(), axis.getZ().floatValue(), new Quat());
        }

        @NotNull
        public static QuatD angleAxis(gtcQuaternion $this, double angle, double axisX, double axisY, double axisZ, @NotNull QuatD res) {
            Intrinsics.checkParameterIsNotNull(res, "res");
            double a2 = angle * 0.5;
            double s2 = glm.INSTANCE.sin(a2);
            res.w = glm.INSTANCE.cos(a2);
            res.x = axisX * s2;
            res.y = axisY * s2;
            res.z = axisZ * s2;
            return res;
        }

        @NotNull
        public static QuatD angleAxis(gtcQuaternion $this, double angle, double axisX, double axisY, double axisZ) {
            return $this.angleAxis(angle, axisX, axisY, axisZ, new QuatD());
        }

        @NotNull
        public static QuatD angleAxis(gtcQuaternion $this, double angle, @NotNull Vec3d axis, @NotNull QuatD res) {
            Intrinsics.checkParameterIsNotNull(axis, "axis");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return $this.angleAxis(angle, axis.getX(), axis.getY(), axis.getZ(), res);
        }

        @NotNull
        public static QuatD angleAxis(gtcQuaternion $this, double angle, @NotNull Vec3d axis) {
            Intrinsics.checkParameterIsNotNull(axis, "axis");
            return $this.angleAxis(angle, axis.getX(), axis.getY(), axis.getZ(), new QuatD());
        }

        @NotNull
        public static Vec4bool lessThan(gtcQuaternion $this, @NotNull Quat a2, @NotNull Quat b, @NotNull Vec4bool res) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            Intrinsics.checkParameterIsNotNull(res, "res");
            res.setX(a2.x.floatValue() < b.x.floatValue());
            res.setY(a2.y.floatValue() < b.y.floatValue());
            res.setZ(a2.z.floatValue() < b.z.floatValue());
            res.setW(a2.w.floatValue() < b.w.floatValue());
            return res;
        }

        @NotNull
        public static Vec4bool lessThan(gtcQuaternion $this, @NotNull Quat a2, @NotNull Quat b) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return $this.lessThan(a2, b, new Vec4bool(false, false, false, false, 15, null));
        }

        @NotNull
        public static Vec4bool lessThanEqual(gtcQuaternion $this, @NotNull Quat a2, @NotNull Quat b, @NotNull Vec4bool res) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            Intrinsics.checkParameterIsNotNull(res, "res");
            res.setX(a2.x.floatValue() <= b.x.floatValue());
            res.setY(a2.y.floatValue() <= b.y.floatValue());
            res.setZ(a2.z.floatValue() <= b.z.floatValue());
            res.setW(a2.w.floatValue() <= b.w.floatValue());
            return res;
        }

        @NotNull
        public static Vec4bool lessThanEqual(gtcQuaternion $this, @NotNull Quat a2, @NotNull Quat b) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return $this.lessThanEqual(a2, b, new Vec4bool(false, false, false, false, 15, null));
        }

        @NotNull
        public static Vec4bool greater(gtcQuaternion $this, @NotNull Quat a2, @NotNull Quat b, @NotNull Vec4bool res) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            Intrinsics.checkParameterIsNotNull(res, "res");
            res.setX(a2.x.floatValue() > b.x.floatValue());
            res.setY(a2.y.floatValue() > b.y.floatValue());
            res.setZ(a2.z.floatValue() > b.z.floatValue());
            res.setW(a2.w.floatValue() > b.w.floatValue());
            return res;
        }

        @NotNull
        public static Vec4bool greater(gtcQuaternion $this, @NotNull Quat a2, @NotNull Quat b) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return $this.greater(a2, b, new Vec4bool(false, false, false, false, 15, null));
        }

        @NotNull
        public static Vec4bool greaterThan(gtcQuaternion $this, @NotNull Quat a2, @NotNull Quat b, @NotNull Vec4bool res) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            Intrinsics.checkParameterIsNotNull(res, "res");
            res.setX(a2.x.floatValue() >= b.x.floatValue());
            res.setY(a2.y.floatValue() >= b.y.floatValue());
            res.setZ(a2.z.floatValue() >= b.z.floatValue());
            res.setW(a2.w.floatValue() >= b.w.floatValue());
            return res;
        }

        @NotNull
        public static Vec4bool greaterThan(gtcQuaternion $this, @NotNull Quat a2, @NotNull Quat b) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return $this.greaterThan(a2, b, new Vec4bool(false, false, false, false, 15, null));
        }

        @NotNull
        public static Vec4bool equal(gtcQuaternion $this, @NotNull Quat a2, @NotNull Quat b, @NotNull Vec4bool res) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            Intrinsics.checkParameterIsNotNull(res, "res");
            res.setX(a2.x.floatValue() == b.x.floatValue());
            res.setY(a2.y.floatValue() == b.y.floatValue());
            res.setZ(a2.z.floatValue() == b.z.floatValue());
            res.setW(a2.w.floatValue() == b.w.floatValue());
            return res;
        }

        @NotNull
        public static Vec4bool equal(gtcQuaternion $this, @NotNull Quat a2, @NotNull Quat b) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return $this.equal(a2, b, new Vec4bool(false, false, false, false, 15, null));
        }

        @NotNull
        public static Vec4bool notEqual(gtcQuaternion $this, @NotNull Quat a2, @NotNull Quat b, @NotNull Vec4bool res) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            Intrinsics.checkParameterIsNotNull(res, "res");
            res.setX(a2.x.floatValue() != b.x.floatValue());
            res.setY(a2.y.floatValue() != b.y.floatValue());
            res.setZ(a2.z.floatValue() != b.z.floatValue());
            res.setW(a2.w.floatValue() != b.w.floatValue());
            return res;
        }

        @NotNull
        public static Vec4bool notEqual(gtcQuaternion $this, @NotNull Quat a2, @NotNull Quat b) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return $this.notEqual(a2, b, new Vec4bool(false, false, false, false, 15, null));
        }

        @NotNull
        public static Vec4bool isNan(gtcQuaternion $this, @NotNull Quat q, @NotNull Vec4bool res) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(res, "res");
            float f = q.x.floatValue();
            Vec4bool vec4bool = res;
            boolean bl = Float.isNaN(f);
            vec4bool.setX(bl);
            f = q.y.floatValue();
            vec4bool = res;
            bl = Float.isNaN(f);
            vec4bool.setY(bl);
            f = q.z.floatValue();
            vec4bool = res;
            bl = Float.isNaN(f);
            vec4bool.setZ(bl);
            f = q.w.floatValue();
            vec4bool = res;
            bl = Float.isNaN(f);
            vec4bool.setW(bl);
            return res;
        }

        @NotNull
        public static Vec4bool isNan(gtcQuaternion $this, @NotNull Quat q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return $this.isNan(q, new Vec4bool(false, false, false, false, 15, null));
        }

        @NotNull
        public static Vec4bool isInf(gtcQuaternion $this, @NotNull Quat q, @NotNull Vec4bool res) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(res, "res");
            float f = q.x.floatValue();
            Vec4bool vec4bool = res;
            boolean bl = Float.isInfinite(f);
            vec4bool.setX(bl);
            f = q.y.floatValue();
            vec4bool = res;
            bl = Float.isInfinite(f);
            vec4bool.setY(bl);
            f = q.z.floatValue();
            vec4bool = res;
            bl = Float.isInfinite(f);
            vec4bool.setZ(bl);
            f = q.w.floatValue();
            vec4bool = res;
            bl = Float.isInfinite(f);
            vec4bool.setW(bl);
            return res;
        }

        @NotNull
        public static Vec4bool isInf(gtcQuaternion $this, @NotNull Quat q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return $this.isInf(q, new Vec4bool(false, false, false, false, 15, null));
        }
    }
}

