/*
 * Decompiled with CFR 0.152.
 */
package glm_;

import glm_.glm;
import glm_.mat4x4.Mat4;
import glm_.vec3.Vec3;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0016J \u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0003H\u0016\u00a8\u0006\u0010"}, d2={"Lglm_/matrix_interpolation;", "", "axisAngle", "", "mat", "Lglm_/mat4x4/Mat4;", "axis", "Lglm_/vec3/Vec3;", "axisAngleMatrix", "angle", "extractMatrixRotation", "m", "interpolate", "m1", "m2", "delta", "glm"})
public interface matrix_interpolation {
    public float axisAngle(@NotNull Mat4 var1, @NotNull Vec3 var2);

    @NotNull
    public Mat4 axisAngleMatrix(@NotNull Vec3 var1, float var2);

    @NotNull
    public Mat4 extractMatrixRotation(@NotNull Mat4 var1);

    @NotNull
    public Mat4 interpolate(@NotNull Mat4 var1, @NotNull Mat4 var2, float var3);

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        public static float axisAngle(matrix_interpolation $this, @NotNull Mat4 mat, @NotNull Vec3 axis) {
            float angleCos;
            Intrinsics.checkParameterIsNotNull(mat, "mat");
            Intrinsics.checkParameterIsNotNull(axis, "axis");
            float angle = 0.0f;
            float epsilon2 = 0.01f;
            float epsilon22 = 0.1f;
            float f = mat.get(1, 0).floatValue() - mat.get(0, 1).floatValue();
            if (Math.abs(f) < epsilon2 && Math.abs(f = mat.get(2, 0).floatValue() - mat.get(0, 2).floatValue()) < epsilon2 && Math.abs(f = mat.get(2, 1).floatValue() - mat.get(1, 2).floatValue()) < epsilon2) {
                f = mat.get(1, 0).floatValue() + mat.get(0, 1).floatValue();
                if (Math.abs(f) < epsilon22 && Math.abs(f = mat.get(2, 0).floatValue() + mat.get(0, 2).floatValue()) < epsilon22 && Math.abs(f = mat.get(2, 1).floatValue() + mat.get(1, 2).floatValue()) < epsilon22 && Math.abs(f = mat.get(0, 0).floatValue() + mat.get(1, 1).floatValue() + mat.get(2, 2).floatValue() - 3.0f) < epsilon22) {
                    axis.setX(1.0f);
                    axis.setY(0.0f);
                    axis.setZ(0.0f);
                    return angle;
                }
                angle = glm.PIf;
                float xx = (mat.get(0, 0).floatValue() + 1.0f) * 0.5f;
                float yy = (mat.get(1, 1).floatValue() + 1.0f) * 0.5f;
                float zz = (mat.get(2, 2).floatValue() + 1.0f) * 0.5f;
                float xy = (mat.get(1, 0).floatValue() + mat.get(0, 1).floatValue()) * 0.25f;
                float xz = (mat.get(2, 0).floatValue() + mat.get(0, 2).floatValue()) * 0.25f;
                float yz = (mat.get(2, 1).floatValue() + mat.get(1, 2).floatValue()) * 0.25f;
                if (xx > yy && xx > zz) {
                    if (xx < epsilon2) {
                        axis.setX(0.0f);
                        axis.setY(0.7071f);
                        axis.setZ(0.7071f);
                    } else {
                        Vec3 vec3 = axis;
                        float f2 = (float)Math.sqrt(xx);
                        vec3.setX(f2);
                        axis.setY(xy / axis.getX().floatValue());
                        axis.setZ(xz / axis.getX().floatValue());
                    }
                } else if (yy > zz) {
                    if (yy < epsilon2) {
                        axis.setX(0.7071f);
                        axis.setY(0.0f);
                        axis.setZ(0.7071f);
                    } else {
                        Vec3 vec3 = axis;
                        float f3 = (float)Math.sqrt(yy);
                        vec3.setY(f3);
                        axis.setX(xy / axis.getY().floatValue());
                        axis.setZ(yz / axis.getY().floatValue());
                    }
                } else if (zz < epsilon2) {
                    axis.setX(0.7071f);
                    axis.setY(0.7071f);
                    axis.setZ(0.0f);
                } else {
                    Vec3 vec3 = axis;
                    float f4 = (float)Math.sqrt(zz);
                    vec3.setZ(f4);
                    axis.setX(xz / axis.getZ().floatValue());
                    axis.setY(yz / axis.getZ().floatValue());
                }
                return angle;
            }
            float yy = (mat.get(2, 1).floatValue() - mat.get(1, 2).floatValue()) * (mat.get(2, 1).floatValue() - mat.get(1, 2).floatValue()) + (mat.get(2, 0).floatValue() - mat.get(0, 2).floatValue()) * (mat.get(2, 0).floatValue() - mat.get(0, 2).floatValue()) + (mat.get(1, 0).floatValue() - mat.get(0, 1).floatValue()) * (mat.get(1, 0).floatValue() - mat.get(0, 1).floatValue());
            float s2 = (float)Math.sqrt(yy);
            if (Math.abs(s2) < 0.001f) {
                s2 = 1.0f;
            }
            angle = (angleCos = (mat.get(0, 0).floatValue() + mat.get(1, 1).floatValue() + mat.get(2, 2).floatValue() - 1.0f) * 0.5f) - 1.0f < epsilon2 ? glm.INSTANCE.get\u03c0f() * 0.25f : (float)Math.acos(angleCos);
            axis.setX((((Number)mat.get(1).get(2)).floatValue() - ((Number)mat.get(2).get(1)).floatValue()) / s2);
            axis.setY((((Number)mat.get(2).get(0)).floatValue() - ((Number)mat.get(0).get(2)).floatValue()) / s2);
            axis.setZ((((Number)mat.get(0).get(1)).floatValue() - ((Number)mat.get(1).get(0)).floatValue()) / s2);
            return angle;
        }

        @NotNull
        public static Mat4 axisAngleMatrix(matrix_interpolation $this, @NotNull Vec3 axis, float angle) {
            Intrinsics.checkParameterIsNotNull(axis, "axis");
            float c = (float)Math.cos(angle);
            float s2 = (float)Math.sin(angle);
            float t = 1.0f - c;
            Vec3 n = Vec3.normalize$default(axis, null, 1, null);
            return new Mat4(Float.valueOf(t * n.getX().floatValue() * n.getX().floatValue() + c), Float.valueOf(t * n.getX().floatValue() * n.getY().floatValue() + n.getZ().floatValue() * s2), Float.valueOf(t * n.getX().floatValue() * n.getZ().floatValue() - n.getY().floatValue() * s2), Float.valueOf(0.0f), Float.valueOf(t * n.getX().floatValue() * n.getY().floatValue() - n.getZ().floatValue() * s2), Float.valueOf(t * n.getY().floatValue() * n.getY().floatValue() + c), Float.valueOf(t * n.getY().floatValue() * n.getZ().floatValue() + n.getX().floatValue() * s2), Float.valueOf(0.0f), Float.valueOf(t * n.getX().floatValue() * n.getZ().floatValue() + n.getY().floatValue() * s2), Float.valueOf(t * n.getY().floatValue() * n.getZ().floatValue() - n.getX().floatValue() * s2), Float.valueOf(t * n.getZ().floatValue() * n.getZ().floatValue() + c), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f));
        }

        @NotNull
        public static Mat4 extractMatrixRotation(matrix_interpolation $this, @NotNull Mat4 m) {
            Intrinsics.checkParameterIsNotNull(m, "m");
            return new Mat4(m.get(0, 0), m.get(0, 1), m.get(0, 2), Float.valueOf(0.0f), m.get(1, 0), m.get(1, 1), m.get(1, 2), Float.valueOf(0.0f), m.get(2, 0), m.get(2, 1), m.get(2, 2), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f));
        }

        @NotNull
        public static Mat4 interpolate(matrix_interpolation $this, @NotNull Mat4 m1, @NotNull Mat4 m2, float delta) {
            Intrinsics.checkParameterIsNotNull(m1, "m1");
            Intrinsics.checkParameterIsNotNull(m2, "m2");
            Mat4 m1rot = $this.extractMatrixRotation(m1);
            Mat4 dltRotation = m2.times(Mat4.transpose$default(m1rot, null, 1, null));
            Vec3 dltAxis = new Vec3();
            float dltAngle = $this.axisAngle(dltRotation, dltAxis);
            Mat4 out = $this.axisAngleMatrix(dltAxis, dltAngle * delta).times(m1rot);
            out.set(3, 0, m1.get(3, 0).floatValue() + delta * (m2.get(3, 0).floatValue() - m1.get(3, 0).floatValue()));
            out.set(3, 1, m1.get(3, 1).floatValue() + delta * (m2.get(3, 1).floatValue() - m1.get(3, 1).floatValue()));
            out.set(3, 2, m1.get(3, 2).floatValue() + delta * (m2.get(3, 2).floatValue() - m1.get(3, 2).floatValue()));
            return out;
        }
    }
}

