/*
 * Decompiled with CFR 0.152.
 */
package gli_.tga;

import gli_.tga.ConstantsKt;
import gli_.tga.Header$WhenMappings;
import gli_.tga.ImageDescriptorBit;
import gli_.tga.ImageType;
import glm_.ExtensionsKt;
import glm_.vec2.Vec2i;
import javax.imageio.stream.ImageInputStream;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\bR\u0011\u0010\u0011\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\bR\u0011\u0010\u0013\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\bR\u0011\u0010\u0015\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\bR\u0011\u0010\u0017\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\bR\u001a\u0010\u001d\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u000e\"\u0004\b\u001f\u0010 R\u0011\u0010!\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\bR\u0011\u0010'\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\bR\u0011\u0010)\u001a\u00020*\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0011\u0010-\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b.\u0010\u001aR\u0011\u0010/\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010\u000eR\u0011\u00100\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010\u000eR\u0011\u00102\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010\bR\u0011\u00104\u001a\u000205\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107R\u0011\u00108\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010\bR\u0011\u0010:\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b;\u0010\bR\u0011\u0010<\u001a\u000205\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u00107\u00a8\u0006>"}, d2={"Lgli_/tga/Header;", "", "inputStream", "Ljavax/imageio/stream/ImageInputStream;", "(Ljavax/imageio/stream/ImageInputStream;)V", "bitsPerColorMapEntry", "", "getBitsPerColorMapEntry", "()I", "bitsPerPixel", "getBitsPerPixel", "bottomToTop", "", "getBottomToTop", "()Z", "colorMapDataOffset", "getColorMapDataOffset", "colorMapEntrySize", "getColorMapEntrySize", "colorMapLength", "getColorMapLength", "colorMapSize", "getColorMapSize", "debugString", "", "getDebugString", "()Ljava/lang/String;", "firstColorMapEntryIndex", "getFirstColorMapEntryIndex", "hasColorMap", "getHasColorMap", "setHasColorMap", "(Z)V", "id", "", "getId", "()[B", "idLength", "getIdLength", "imageDescriptor", "getImageDescriptor", "imageType", "Lgli_/tga/ImageType;", "getImageType", "()Lgli_/tga/ImageType;", "imageTypeString", "getImageTypeString", "isCompressed", "leftToRight", "getLeftToRight", "numberColorMapEntries", "getNumberColorMapEntries", "origin", "Lglm_/vec2/Vec2i;", "getOrigin", "()Lglm_/vec2/Vec2i;", "pixelDataOffset", "getPixelDataOffset", "samplesPerPixel", "getSamplesPerPixel", "size", "getSize", "build"})
public final class Header {
    private final int idLength;
    @NotNull
    private final byte[] id;
    private boolean hasColorMap;
    @NotNull
    private final ImageType imageType;
    private final boolean isCompressed;
    private final int firstColorMapEntryIndex;
    private final int numberColorMapEntries;
    private final int bitsPerColorMapEntry;
    @NotNull
    private final Vec2i origin;
    @NotNull
    private final Vec2i size;
    private final int bitsPerPixel;
    private final int imageDescriptor;
    private final int colorMapEntrySize;
    private final int colorMapSize;
    private final boolean leftToRight;
    private final boolean bottomToTop;
    private final int colorMapDataOffset;
    private final int pixelDataOffset;

    public final int getIdLength() {
        return this.idLength;
    }

    @NotNull
    public final byte[] getId() {
        return this.id;
    }

    public final boolean getHasColorMap() {
        return this.hasColorMap;
    }

    public final void setHasColorMap(boolean bl) {
        this.hasColorMap = bl;
    }

    @NotNull
    public final ImageType getImageType() {
        return this.imageType;
    }

    public final boolean isCompressed() {
        return this.isCompressed;
    }

    public final int getFirstColorMapEntryIndex() {
        return this.firstColorMapEntryIndex;
    }

    public final int getNumberColorMapEntries() {
        return this.numberColorMapEntries;
    }

    public final int getBitsPerColorMapEntry() {
        return this.bitsPerColorMapEntry;
    }

    @NotNull
    public final Vec2i getOrigin() {
        return this.origin;
    }

    @NotNull
    public final Vec2i getSize() {
        return this.size;
    }

    public final int getBitsPerPixel() {
        return this.bitsPerPixel;
    }

    public final int getImageDescriptor() {
        return this.imageDescriptor;
    }

    public final int getColorMapEntrySize() {
        return this.colorMapEntrySize;
    }

    public final int getColorMapSize() {
        return this.colorMapSize;
    }

    public final boolean getLeftToRight() {
        return this.leftToRight;
    }

    public final boolean getBottomToTop() {
        return this.bottomToTop;
    }

    public final int getColorMapDataOffset() {
        return this.colorMapDataOffset;
    }

    public final int getPixelDataOffset() {
        return this.pixelDataOffset;
    }

    public final int getColorMapLength() {
        return this.numberColorMapEntries;
    }

    @NotNull
    public final String getImageTypeString() {
        String string;
        switch (Header$WhenMappings.$EnumSwitchMapping$0[this.imageType.ordinal()]) {
            case 1: {
                string = "NO IMAGE";
                break;
            }
            case 2: {
                string = "COLOR MAP";
                break;
            }
            case 3: {
                string = "TRUE COLOR";
                break;
            }
            case 4: {
                string = "MONOCHROME";
                break;
            }
            case 5: {
                string = "RLE COMPRESSED COLOR MAP";
                break;
            }
            case 6: {
                string = "RLE COMPRESSED TRUE COLOR";
                break;
            }
            case 7: {
                string = "RLE COMPRESSED MONOCHROME";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    public final int getSamplesPerPixel() {
        return this.bitsPerPixel == 32 ? 4 : 3;
    }

    @NotNull
    public final String getDebugString() {
        return "TGAHeader[type=" + this.getImageTypeString() + ", " + (this.hasColorMap ? "firstColorMapEntryIndex=" + this.firstColorMapEntryIndex + ", numberColorMapEntries=" + this.numberColorMapEntries + ", " + "bitsPerColorMapEntry=" + this.bitsPerColorMapEntry + ", totalColorMapEntrySize=" + this.colorMapSize + ", " : "" + "isCompressed=" + this.isCompressed + ", origin=" + this.origin + ", size=" + this.size + ", bitsPerPixel=" + this.bitsPerPixel + ", samplesPerPixel=" + this.getSamplesPerPixel() + ']');
    }

    public Header(@NotNull ImageInputStream inputStream) {
        int n;
        Intrinsics.checkParameterIsNotNull(inputStream, "inputStream");
        this.idLength = inputStream.readUnsignedByte();
        byte[] byArray = new byte[this.idLength];
        Header header = this;
        byte[] it = byArray;
        inputStream.read(it);
        byte[] byArray2 = byArray;
        header.id = byArray2;
        this.hasColorMap = ExtensionsKt.getBool(inputStream.readUnsignedByte());
        this.imageType = ImageType.Companion.of(inputStream.readUnsignedByte());
        this.isCompressed = this.imageType == ImageType.RLE_COLOR_MAP || this.imageType == ImageType.RLE_TRUE_COLOR || this.imageType == ImageType.RLE_MONO;
        this.firstColorMapEntryIndex = inputStream.readUnsignedShort();
        this.numberColorMapEntries = inputStream.readUnsignedShort();
        this.bitsPerColorMapEntry = ExtensionsKt.getI(inputStream.readByte());
        this.origin = new Vec2i(inputStream.readUnsignedShort(), inputStream.readUnsignedShort());
        this.size = new Vec2i(inputStream.readUnsignedShort(), inputStream.readUnsignedShort());
        this.bitsPerPixel = ExtensionsKt.getI(inputStream.readByte());
        this.imageDescriptor = ExtensionsKt.getI(inputStream.readByte());
        switch (this.bitsPerColorMapEntry) {
            case 15: 
            case 16: {
                n = 2;
                break;
            }
            case 24: 
            case 32: {
                n = 3;
                break;
            }
            default: {
                n = 1;
            }
        }
        this.colorMapEntrySize = n;
        this.colorMapSize = this.colorMapEntrySize * this.numberColorMapEntries;
        this.leftToRight = ConstantsKt.hasnt(this.imageDescriptor, ImageDescriptorBit.LEFT_RIGHT_BIT);
        this.bottomToTop = ConstantsKt.hasnt(this.imageDescriptor, ImageDescriptorBit.BOTTOM_TOP_BIT);
        this.colorMapDataOffset = ExtensionsKt.getI(inputStream.getStreamPosition());
        this.pixelDataOffset = this.hasColorMap ? this.colorMapDataOffset + this.colorMapSize : ExtensionsKt.getI(inputStream.getStreamPosition());
    }
}

