; Seeing the light at the end of the tunnel
; New 256 byte intro by TomCat/Abaddon

; Rotating penrose triangle with backlight shadow
; Entry for the 1st Revision tiny intro compo

; nice use of new VBE 4.0 functions:
;  VBE4ClipArc()
;  VBE4RotateObject()
;  VBE4FillPolygon()
;  VBE4SetTransparency()
;  VBE4SetShadow()
; :)

; triangle parameters
SIZE EQU 1536
; tunnel parameters
STEPS EQU 8
PERSP EQU (2560+STEPS)
COLORS EQU 128

ORG 256
 DW     127             ; constant 127 -> amplitude for sinus table
 DW     3C00H           ; constant 1/128 -> calculating PI/128 for sinus table

 MOV    AL,13H          ; set video mode 320x200
@@:
 INT    10H             ; call VGA Bios
 IMUL   DX,BX,7FH
 IMUL   CX,BX,3FH
 IMUL   AX,BX,30H
 MOV    CL,AH           ; DH/CH/CL->R/G/B
 INC    BX              ; loop more than enough
 MOV    AX,1010H        ; set only one color by the VGA BIOS
 JNS    @B              ; CX = 7FFFH, BX = 8000H

@@:
 FLDPI                  ; PI
 FMUL   DWORD [SI]      ; PI/128
 FIMUL  WORD [DI]       ; counter*PI/128
 FSIN                   ; SIN(counter*PI/128)
 FIMUL  WORD [SI]       ; 127*SIN(counter*PI/128)
 FISTP  WORD [BX+SI]    ; -
 INC    BX
 DEC    BYTE [DI]       ; loop 256x
 JNZ    @B              ; BX = 8100H = sinus table

 MOV    BP,320          ; line length
 PUSH   0A000H          ; segment of video memory
 POP    ES
main:
 HLT                    ; wait for timing (cheaper than using 46CH BIOS var)
.2:
 CWD                    ; DX = 0
 MOV    AX,DI           ; DX:AX = pixel index
 DIV    BP              ; DX = sX = 0..319, AX = sY = 0..199
 SUB    AL,112          ; centering sX, AL = sY = -112..87
 ADD    DX,-159         ; 159 is the center (but -128 could save a byte)
 MOV    CL,STEPS-1
 PUSHA

 IMUL   DX,DX,80;79     ; the lower number the wider tunnel

 MOV    CH,AL           ; screen coord Y
 IMUL   AL              ; dY*dY
 XCHG   BP,AX

 AND    CL,BL           ; CL = tunnel color
 ADD    CL,COLORS-STEPS
 MOV    [SI],CX         ; pixel = max color, [SI+1] = dY

.3:
 DIV    CL

 PUSH   AX              ; clip floor
 SHR    AL,1            ; at half of radius
 CMP    AL,CH
 POP    AX
 JLE    .4

 MUL    AL              ; R*R
 XCHG   DI,AX

 MOV    AL,[BX]
 IMUL   CL              ; cX = radius * SIN(angle)
 ADD    AX,DX           ; dX = sX-cX
 SAR    AX,6
 IMUL   AX,AX
 SHR    AX,2
 ADD    AX,BP

 CMP    AX,DI
 JC     .5              ; dX*dX+dY*dY < R*R

.4:
 MOV    [SI],CL         ; pixel = tunnel color

.5:
 MOV    AX,PERSP
 SUB    CL,AL           ; STEPS
 CMP    CL,AH           ; PERSP/255
 JG     .3              ; was the smallest radius?
 POPA
 PUSHA
 CALL   penrose
.6:
 MOVSB                  ; PutPixel
 POPA
 INC    DI
 JNZ    .2              ; loop 65536x

 DEC    BL              ; BL = my own timer counter, BX = angle
 JNZ    @F
 MOV    SI,penrose.2+2-320
@@:
 CMP    [BP+SI],CL      ; SIZE*4/3/256-1
 JE     @F              ; if center position is reached then end of transition
 ADD    BYTE [BP+SI],5  ; move the bars in the direction of center
@@:

 IN     AL,60H          ; check for keypress
 DAS                    ; if not pressed
 JC     main            ; then go to next frame

;RETN                   ; exit to DOS

penrose:                ; BX:angle, DX:dX, [SI+1]:dY, CH:127, AH:0, AL:dY
 XOR    DH,DL           ; clever test for the middle of the screen
 JS     .6              ; skip pixels on the sides

 SUB    AL,45
 JNG    @F              ; if we are at 45 lines lower than the center
 IMUL   BP,AX,-640      ; then check the backbuffer for triangle
 IMUL   BYTE [BX]       ; shift the shadow in x direction
 SAR    AX,6            ; in opposite of the light
 SUB    BP,AX
 CMP    [ES:DI+BP],CH   ; if backbuffer pixel > 127
 JBE    @F              ; then backbuffer pixel = triangle
 SHR    BYTE [SI],1     ; and decrase the intensity of the floor
@@:

 MOV    DH,SIZE*3/256   ; DH = bar length
;MOV    CH,127          ; CH = triangle color
.1:
 PUSHA                  ; backup BX and CX, the angle and the color
 MOV    DI,-1*SIZE*13/6+97;64
.2:
 MOV    BP,066A0H       ; BP = offset from the center (start at offscreen)
 PUSH   BX
.3:
 MOV    AL,[BX]
 IMUL   BYTE [SI+1]     ; SIN(angle)*dY
 ADD    BP,AX
 SUB    BL,64
 MOV    AL,[BX]
 IMUL   DL              ; SIN(angle-PI/2)*dX
 ADD    AX,BP
 JNS    @F
 NEG    AX              ; c = ABS(COS*dX+SIN*dY+offset)
@@:
 CMP    AH,DH           ; if c > length then here is no bar and go ahead
 JAE    .4              ; else check the other two sides of bar
 ADD    BL,64+128+43    ; BL = rotation angle + PI/3 (deg 60)
 MOV    BP,DI           ; BP = other offset from the center
 CMP    DH,SIZE/2/256
 MOV    DH,SIZE/2/256   ; DH = other length aka width of bar
 JNE    .3              ; were the other 2 sides already then inside the bar

 CMP    [SI],BH         ; and check have previous bar found already?
 JNB   .4               ; if yes then skip
 ADD    [SI],CH         ; else add triangle color to background color
 STC                    ; make the triangle transparent
 RCR    BYTE [SI],1
.4:
 POP    BX              ; restore angle
 SUB    BL,42+128       ; angle = angle-PI/3
 MOV    DH,SIZE*2/256   ; length of the other bar
 XOR    DI,(-1*SIZE*7/6) XOR (-1*SIZE*13/6+97)
 JPE    .2              ; loop 2x, two bars with the same color

 POPA                   ; restore BX CX
 SUB    BL,85           ; angle = angle-2PI/3
 SUB    CH,42;63        ; decrasing colorindex of the bar
 JNC    .1              ; loop 4x;3x

.6:

RETN
