
org 100h

jmp init_vga
data:
    db 0b000_010_1
    db 0
    db 0
    db 0b000_010_1
    db 0b000_010_1
    db 0b000_010_1
    db 0 
    db 0b000_100_1
    db 0b000_100_1
    db 0b000_110_1
    db 0
    db 0b101_001_1
    db 0b101_001_1
    db 0 
    db 0b000_110_1
    db 0 
    db 0 
    db 0b000_100_0
    db 0b000_010_1
    db 0b000_010_0
    db 0b101_001_0
    db 0b000_100_1
    db 0b101_001_0
    db 0b000_100_0


%define vars (bx-128)
%define rice_color (vars+8)
%define frame_count (vars+12);
%define data_index (vars+14);

%define screen_width (320)
%define screen_coord(x,y) (x+y*screen_width)

%define offscreen_start (0x1000)
%define offscreen_width (512)
%define offscreen_height (64)
%define offscreen_coord(x,y) (x+y*offscreen_width)

init_vga:
    mov al,13h
    int 10h

clear_buffers:
    mov al,15
    mov di, offscreen_start
    mov cx, offscreen_width*offscreen_height
    rep stosb
    
    push 0a000h ; set up vram access
    pop es

    dec cx
    rep stosb
    
    push data
    pop bp

    
main:

    inc byte[frame_count]
    mov al,[frame_count]
    and al,63
    jnz animate

    mov al,[bp]
    test al,al
    jz inc_bp

    mov si, offscreen_start + offscreen_width*offscreen_height/2 + 320 + 32;


    mov cl,8
draw_loop:
    push cx
    mov al,0x1e;
    dec cl
    jz set_rice_color
    sub al,2
set_rice_color:
    mov [rice_color], al

    add si, offscreen_coord(0, -1);
    mov cx,1023;
spiral_loop:
    
    pusha
    
    ; load cx
    fild word [bx-20+12]        ; t 
    fld st0                     ; t t
    fmul dword [radius_rate]    ; rad t
    fxch st0, st1               ; t rad
    fmul dword [angle_rate]     ; ang rad
    fsincos                     ; sin cos rad
    fmul st2                    ; sin*rad cos rad

    ; store ax 
    fistp word [bx-20+14]       ; cos rad
    fmul                        ; cos*rad
    ; store dx 
    fistp word [bx-20+10]       ; *emtpy fpu stack*

    popa

    push si

    shl ax,9
    add ax,dx
    add si,ax

    mov dx,cx
    shr dx,2
    mov al,dl
    and al,2
    
    mov ah,[bp]
    shr ah,1
    jc type_2
    
    cmp dl, 110
    ja rice
    cmp dl, 90
    ja nori
    jmp content

type_2:
    cmp dl,190
    ja end_draw
    cmp dl,170
    ja nori
    cmp dl, 60
    ja rice
content:
    mov al,ah
    jmp end_color
rice:
    mov al,[rice_color]
    jmp end_color
nori:
    add al,0x12
end_color:
    mov [si], al
end_draw:
    pop si
    loop spiral_loop

    pop cx
    loop draw_loop

inc_bp:
    inc bp
animate:

vsync:
	mov dx, 03dah
	mov ah, 0x08
_vsync_poll:
	in al,dx
	test al,ah
	jz _vsync_poll

show_rows:
    mov cx, offscreen_height
    mov di, screen_coord(0,64);
    mov si, offscreen_start
_show_rows_loop:
    push cx
    mov cx,320
    rep movsb

    mov cx, 320+64
    add si,64
    mov al,15;
_shift_rows:
    dec si
    xchg al,[si]
    loop _shift_rows

    add si, offscreen_width
    pop cx
    loop _show_rows_loop
	
keyboard:
    in al,60h
    dec al
    jnz main

    ret

angle_rate: dd 0.2
radius_rate: dd 0.015
