#ifdef GL_ES
#define LOW lowp
#define MED mediump
#define HIGH highp
precision mediump float;
#else
#define MED
#define LOW
#define HIGH
#endif

attribute vec2 aPos;
attribute vec2 aTexCoords;
varying vec2 TexCoords;

// no arrays in gles2 so this will have
// to do...
varying vec4 blurTextureCoords1;
varying vec4 blurTextureCoords2;
varying vec4 blurTextureCoords3;
varying vec4 blurTextureCoords4;
varying vec4 blurTextureCoords5;
varying vec2 blurTextureCenterCoord;
uniform float targetHeight;
uniform int horizontal;

void main()
{
    gl_Position = vec4(aPos.x, aPos.y, 0.0, 1.0);
    vec2 centerTexCoords = aPos * 0.5 + 0.5;
    float pixelSize = 1.0 / targetHeight;
    TexCoords = aTexCoords;
    if (horizontal==1) {
        blurTextureCoords5.xy = centerTexCoords + vec2(pixelSize * -5.0, 0.0);
        blurTextureCoords4.xy = centerTexCoords + vec2(pixelSize * -4.0, 0.0);
        blurTextureCoords3.xy = centerTexCoords + vec2(pixelSize * -3.0, 0.0);
        blurTextureCoords2.xy = centerTexCoords + vec2(pixelSize * -2.0, 0.0);
        blurTextureCoords1.xy = centerTexCoords + vec2(pixelSize * -1.0, 0.0);
        blurTextureCenterCoord = centerTexCoords + vec2(pixelSize * 0.0, 0.0);
        blurTextureCoords1.zw = centerTexCoords + vec2(pixelSize * 1.0, 0.0);
        blurTextureCoords2.zw = centerTexCoords + vec2(pixelSize * 2.0, 0.0);
        blurTextureCoords3.zw = centerTexCoords + vec2(pixelSize * 3.0, 0.0);
        blurTextureCoords4.zw = centerTexCoords + vec2(pixelSize * 4.0, 0.0);
        blurTextureCoords5.zw = centerTexCoords + vec2(pixelSize * 5.0, 0.0);
    }
    else {
        blurTextureCoords5.xy = centerTexCoords + vec2(0.0, pixelSize * -5.0);
        blurTextureCoords4.xy = centerTexCoords + vec2(0.0, pixelSize * -4.0);
        blurTextureCoords3.xy = centerTexCoords + vec2(0.0, pixelSize * -3.0);
        blurTextureCoords2.xy = centerTexCoords + vec2(0.0, pixelSize * -2.0);
        blurTextureCoords1.xy = centerTexCoords + vec2(0.0, pixelSize * -1.0);
        blurTextureCenterCoord = centerTexCoords + vec2(0.0, pixelSize * 0.0);
        blurTextureCoords1.zw = centerTexCoords + vec2(0.0, pixelSize * 1.0);
        blurTextureCoords2.zw = centerTexCoords + vec2(0.0, pixelSize * 2.0);
        blurTextureCoords3.zw = centerTexCoords + vec2(0.0, pixelSize * 3.0);
        blurTextureCoords4.zw = centerTexCoords + vec2(0.0, pixelSize * 4.0);
        blurTextureCoords5.zw = centerTexCoords + vec2(0.0, pixelSize * 5.0);
    }
}

