#ifdef GL_ES
#define LOW lowp
#define MED mediump
#define HIGH highp
precision mediump float;
#else
#define MED
#define LOW
#define HIGH
#endif

uniform sampler2D screenTexture;
varying vec2 TexCoords;

void main()
{
    vec4 texcol = texture2D(screenTexture, TexCoords);

    float brightness = dot(texcol.rgb, vec3(0.2126, 0.7152, 0.0722));

    if(brightness > 0.7)
        gl_FragColor = vec4(texcol.rgb, 1.0);
    else
        gl_FragColor = vec4(0.0, 0.0, 0.0, 1.0);
    //gl_FragColor = vec4(1.0 - texcol.xyz, 1.0);
    //gl_FragColor = texcol;
}
