varying vec2 v_texCoords;
varying vec3 v_normal;
varying vec3 v_fragPos;

uniform sampler2D texture;

#define NUM_LIGHTS 3

struct DirectionalLight {
    vec3 direction;

    vec3 ambient;
    vec3 diffuse;
    vec3 specular;
    float shininess;
};

uniform DirectionalLight lights[NUM_LIGHTS];

// calculates the color when using a directional light.
vec3 CalcDirLight(DirectionalLight light, vec3 normal, vec3 viewDir)
{
    vec3 lightDir = normalize(-light.direction);
    // diffuse shading
    float diff = max(dot(normal, lightDir), 0.0);
    // specular shading
    vec3 reflectDir = reflect(-lightDir, normal);
    float spec = pow(max(dot(viewDir, reflectDir), 0.0), light.shininess);
    // combine results
    vec4 texcol = texture2D(texture, v_texCoords);

    vec3 ambient = light.ambient * vec3(texcol);
    vec3 diffuse = light.diffuse * diff * vec3(texcol);
    vec3 specular = light.specular * spec * vec3(texcol);
    return (ambient + diffuse + specular);
}


/*vec3 directionalLight(DirectionalLight light, vec3 camPos, vec3 normal) {
    vec3 lightDir = normalize(light.pos - v_fragPos);

    // calculate diffuse amount
    float diff = max(dot(normal, lightDir), 0.0);
    vec3 diffuse = diff * light.color;

    return vec3(0.0,0.0,0.0);
}*/


uniform float lightStrength;
uniform vec3 lightPos;
uniform vec3 lightColor;
uniform vec3 ambientColor;
uniform vec3 specColor;
uniform vec3 camPos;
uniform float specStrength;


void main() {
/*    vec4 texcol = texture2D(texture, v_texCoords);
    if(texcol.a < 0.1)
        discard;
    gl_FragColor = vec4(texcol);*/

/*    // calculate light position vector
    vec3 norm = normalize(v_normal);
    vec3 lightDir = normalize(lightPos - v_fragPos);

    // calculate diffuse amount
    float diff = max(dot(norm, lightDir), 0.0);
    vec3 diffuse = diff * lightColor;

    // calculate camera position vector and specular
    vec3 camDir = normalize(camPos - v_fragPos);
    vec3 reflectDir = reflect(-lightDir, norm);
    float spec = pow(max(dot(camDir, reflectDir), 0.0), 64.0);
    vec3 specCol =  specStrength * spec * specColor;*/

    // combine
    vec4 texcol = texture2D(texture, v_texCoords);
/*    if(texcol.a < 0.1)
        discard;
    vec3 result = (ambientColor + diffuse*lightStrength + specCol) * vec3(texcol); //+ specCol
    gl_FragColor = vec4(result, 1.0);*/


    gl_FragColor = vec4(texcol);
}
