attribute vec3 a_position;
attribute vec3 a_normal;
attribute vec2 a_texCoords;

uniform mat4 model;
uniform mat4 pv; // proj+view

varying vec3 v_fragPos;
varying vec2 v_texCoords;
varying vec3 v_normal;
uniform int preCalcNormals;


void main() {


    v_texCoords = a_texCoords;
    if (preCalcNormals == 1) {
        v_normal = a_normal;
    }
    else {
        v_normal = vec3(model * vec4(a_normal, 0.0));
    }
    vec4 m = model * vec4(a_position.x, a_position.y, a_position.z, 1.0);
    v_fragPos = vec3(m);
    gl_Position = pv * m;
    //gl_Position = pv * model * vec4(a_position.x, a_position.y, a_position.z, 1.0);
    //gl_Position = pv * vec4(a_position.x, a_position.y, a_position.z, 1.0);
}

