/*
 * Decompiled with CFR 0.152.
 */
package ktx.collections;

import com.badlogic.gdx.utils.Pool;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.jvm.internal.markers.KMutableIterator;
import ktx.collections.ListsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\n\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0010)\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0002OPB\u0019\u0012\u0012\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00050\u0004\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\fJ\u001b\u0010#\u001a\u00020!2\u000e\u0010$\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000%\u00a2\u0006\u0002\u0010&J\u0014\u0010#\u001a\u00020!2\f\u0010$\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002J)\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00000\u00052\u0006\u0010\"\u001a\u00028\u00002\f\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u0002\u00a2\u0006\u0002\u0010)J\u0006\u0010*\u001a\u00020!J\u0014\u0010+\u001a\u00020\u000e2\n\u0010,\u001a\u0006\u0012\u0002\b\u00030\u0000H\u0002J\u0016\u0010-\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010.J\u0013\u0010/\u001a\u00020\u000e2\b\u0010,\u001a\u0004\u0018\u000100H\u0096\u0002J-\u00101\u001a\u0012\u0012\u0004\u0012\u00028\u00000\u0000j\b\u0012\u0004\u0012\u00028\u0000`22\u0012\u00103\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u000e04H\u0086\bJ9\u00105\u001a\u0012\u0012\u0004\u0012\u0002H60\u0000j\b\u0012\u0004\u0012\u0002H6`2\"\u0004\b\u0001\u001062\u0018\u00107\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u0002H60\u000204H\u0086\bJ\u001d\u00108\u001a\u00020!2\u0012\u00109\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020!04H\u0086\bJ\b\u0010:\u001a\u00020\u001aH\u0016J\u0013\u0010;\u001a\u00020!2\u0006\u0010\"\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\fJ\u0013\u0010<\u001a\u00020!2\u0006\u0010\"\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\fJ3\u0010=\u001a\u00020!2\b\b\u0002\u0010>\u001a\u00020\u000e2\u001e\u00109\u001a\u001a\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0012\u0012\u0004\u0012\u00020!0?H\u0086\bJ\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000@H\u0096\u0002J3\u0010A\u001a\u0012\u0012\u0004\u0012\u0002H60\u0000j\b\u0012\u0004\u0012\u0002H6`2\"\u0004\b\u0001\u001062\u0012\u00107\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H604H\u0086\bJ\u0016\u0010B\u001a\b\u0012\u0004\u0012\u00028\u00000@2\b\b\u0002\u0010>\u001a\u00020\u000eJ\u001c\u0010C\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\"\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010DJ$\u0010C\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u000e\u0010$\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000%H\u0086\u0002\u00a2\u0006\u0002\u0010EJ\u001d\u0010C\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\f\u0010$\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002H\u0086\u0002J\u0006\u0010F\u001a\u00020!J\u0006\u0010G\u001a\u00020!J\u001b\u0010G\u001a\u00028\u00002\f\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u0002\u00a2\u0006\u0002\u0010HJ\u000b\u0010I\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\nJ\u000b\u0010J\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\nJ\f\u0010K\u001a\b\u0012\u0004\u0012\u00028\u00000@J\b\u0010L\u001a\u00020MH\u0016J\u0018\u0010N\u001a\u00020\u000e*\u0004\u0018\u0001002\b\u0010\"\u001a\u0004\u0018\u000100H\u0002R$\u0010\b\u001a\u00028\u00002\u0006\u0010\u0007\u001a\u00028\u00008F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000fR\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0007\u001a\u00028\u00008F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0014\u0010\n\"\u0004\b\u0015\u0010\fR\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R$\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020\u001a@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001f\u00a8\u0006Q"}, d2={"Lktx/collections/PooledList;", "T", "", "nodePool", "Lcom/badlogic/gdx/utils/Pool;", "Lktx/collections/PooledList$Node;", "(Lcom/badlogic/gdx/utils/Pool;)V", "value", "first", "getFirst", "()Ljava/lang/Object;", "setFirst", "(Ljava/lang/Object;)V", "isEmpty", "", "()Z", "isNotEmpty", "iterator", "Lktx/collections/PooledList$PooledListIterator;", "last", "getLast", "setLast", "main", "getNodePool", "()Lcom/badlogic/gdx/utils/Pool;", "<set-?>", "", "size", "getSize", "()I", "setSize", "(I)V", "add", "", "element", "addAll", "elements", "", "([Ljava/lang/Object;)V", "addBefore", "node", "(Ljava/lang/Object;Lktx/collections/PooledList$Node;)Lktx/collections/PooledList$Node;", "clear", "compareElements", "other", "contains", "(Ljava/lang/Object;)Z", "equals", "", "filter", "Lktx/collections/GdxList;", "predicate", "Lkotlin/Function1;", "flatMap", "R", "transform", "forEachReversed", "apply", "hashCode", "insertAfter", "insertBefore", "iterate", "reversed", "Lkotlin/Function2;", "", "map", "newIterator", "plus", "(Ljava/lang/Object;)Lktx/collections/PooledList;", "([Ljava/lang/Object;)Lktx/collections/PooledList;", "purge", "remove", "(Lktx/collections/PooledList$Node;)Ljava/lang/Object;", "removeFirst", "removeLast", "reversedIterator", "toString", "", "isEqualElementTo", "Node", "PooledListIterator", "ktx-collections"})
public final class PooledList<T>
implements Iterable<T>,
KMappedMarker {
    private int size;
    private final Node<T> main;
    private final PooledListIterator<T> iterator;
    @NotNull
    private final Pool<Node<T>> nodePool;

    public final int getSize() {
        return this.size;
    }

    private final void setSize(int n) {
        this.size = n;
    }

    public final boolean isEmpty() {
        return this.size == 0;
    }

    public final boolean isNotEmpty() {
        return this.size != 0;
    }

    public final T getFirst() {
        if (this.isEmpty()) {
            throw (Throwable)new NoSuchElementException();
        }
        T t = this.main.getNext().getElement();
        if (t == null) {
            Intrinsics.throwNpe();
        }
        return t;
    }

    public final void setFirst(T value) {
        this.addBefore(value, this.main.getNext());
    }

    public final T getLast() {
        if (this.isEmpty()) {
            throw (Throwable)new NoSuchElementException();
        }
        T t = this.main.getPrevious().getElement();
        if (t == null) {
            Intrinsics.throwNpe();
        }
        return t;
    }

    public final void setLast(T value) {
        this.addBefore(value, this.main);
    }

    public final void add(T element) {
        this.addBefore(element, this.main);
    }

    public final void addAll(@NotNull T[] elements) {
        Intrinsics.checkParameterIsNotNull(elements, "elements");
        T[] $receiver$iv = elements;
        int n = $receiver$iv.length;
        for (int i = 0; i < n; ++i) {
            T element$iv;
            T it = element$iv = $receiver$iv[i];
            this.add(it);
        }
    }

    public final void addAll(@NotNull Iterable<? extends T> elements) {
        Intrinsics.checkParameterIsNotNull(elements, "elements");
        Iterable<T> $receiver$iv = elements;
        Iterator<T> iterator2 = $receiver$iv.iterator();
        while (iterator2.hasNext()) {
            T element$iv;
            T it = element$iv = iterator2.next();
            this.add(it);
        }
    }

    @NotNull
    public final PooledList<T> plus(T element) {
        this.add(element);
        return this;
    }

    @NotNull
    public final PooledList<T> plus(@NotNull T[] elements) {
        Intrinsics.checkParameterIsNotNull(elements, "elements");
        this.addAll(elements);
        return this;
    }

    @NotNull
    public final PooledList<T> plus(@NotNull Iterable<? extends T> elements) {
        Intrinsics.checkParameterIsNotNull(elements, "elements");
        this.addAll(elements);
        return this;
    }

    public final T removeFirst() {
        return this.remove(this.main.getNext());
    }

    public final T removeLast() {
        return this.remove(this.main.getPrevious());
    }

    public final boolean contains(T element) {
        boolean bl;
        block3: {
            PooledList $receiver$iv = this;
            if ($receiver$iv instanceof Collection && ((Collection)((Object)$receiver$iv)).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    Object it = element$iv;
                    if (!Intrinsics.areEqual(it, element)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return PooledListIterator.reset$default(this.iterator, false, 1, null);
    }

    @NotNull
    public final Iterator<T> reversedIterator() {
        return this.iterator.reset(true);
    }

    @NotNull
    public final Iterator<T> newIterator(boolean reversed) {
        return new PooledListIterator(this).reset(reversed);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Iterator newIterator$default(PooledList pooledList, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return pooledList.newIterator(bl);
    }

    public final void forEachReversed(@NotNull Function1<? super T, Unit> apply2) {
        Iterator<T> iterator2;
        Intrinsics.checkParameterIsNotNull(apply2, "apply");
        Iterator<T> iterator3 = iterator2 = this.reversedIterator();
        while (iterator3.hasNext()) {
            T element = iterator3.next();
            apply2.invoke(element);
        }
    }

    public final void iterate(boolean reversed, @NotNull Function2<? super T, ? super PooledListIterator<T>, Unit> apply2) {
        Intrinsics.checkParameterIsNotNull(apply2, "apply");
        Iterator<T> iterator2 = reversed ? this.reversedIterator() : this.iterator();
        if (iterator2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type ktx.collections.PooledList.PooledListIterator<T>");
        }
        PooledListIterator iterator3 = (PooledListIterator)iterator2;
        while (iterator3.hasNext()) {
            apply2.invoke(iterator3.next(), iterator3);
        }
    }

    public static /* bridge */ /* synthetic */ void iterate$default(PooledList this_, boolean reversed, Function2 apply2, int n, Object object) {
        if ((n & 1) != 0) {
            reversed = false;
        }
        Intrinsics.checkParameterIsNotNull(apply2, "apply");
        Iterator iterator2 = reversed ? this_.reversedIterator() : this_.iterator();
        if (iterator2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type ktx.collections.PooledList.PooledListIterator<T>");
        }
        PooledListIterator iterator3 = (PooledListIterator)iterator2;
        while (iterator3.hasNext()) {
            apply2.invoke(iterator3.next(), iterator3);
        }
    }

    public final void remove() {
        this.iterator.remove();
    }

    public final void insertBefore(T element) {
        if (this.iterator.getCurrent$ktx_collections() == this.main) {
            throw (Throwable)new IllegalStateException();
        }
        this.addBefore(element, this.iterator.getCurrent$ktx_collections());
    }

    public final void insertAfter(T element) {
        if (this.iterator.getCurrent$ktx_collections() == this.main) {
            throw (Throwable)new IllegalStateException();
        }
        this.addBefore(element, this.iterator.getCurrent$ktx_collections().getNext());
    }

    public final void clear() {
        while (this.isNotEmpty()) {
            this.removeLast();
        }
    }

    public final void purge() {
        this.main.setNext(this.main);
        this.main.setPrevious(this.main);
        this.size = 0;
    }

    @NotNull
    public final <R> PooledList<R> map(@NotNull Function1<? super T, ? extends R> transform) {
        Intrinsics.checkParameterIsNotNull(transform, "transform");
        PooledList destination = ListsKt.gdxListOf$default(null, 1, null);
        for (T item : this) {
            destination.add(transform.invoke(item));
        }
        return destination;
    }

    @NotNull
    public final PooledList<T> filter(@NotNull Function1<? super T, Boolean> predicate) {
        Intrinsics.checkParameterIsNotNull(predicate, "predicate");
        PooledList destination = ListsKt.gdxListOf$default(null, 1, null);
        for (T item : this) {
            if (!predicate.invoke(item).booleanValue()) continue;
            destination.add(item);
        }
        return destination;
    }

    @NotNull
    public final <R> PooledList<R> flatMap(@NotNull Function1<? super T, ? extends Iterable<? extends R>> transform) {
        Intrinsics.checkParameterIsNotNull(transform, "transform");
        PooledList this_$iv = this;
        PooledList destination$iv = ListsKt.gdxListOf$default(null, 1, null);
        for (Object item$iv : this_$iv) {
            destination$iv.add(transform.invoke(item$iv));
        }
        PooledList $receiver$iv = destination$iv;
        destination$iv = ListsKt.gdxListOf$default(null, 1, null);
        for (Object item$iv : $receiver$iv) {
            destination$iv.addAll((Iterable<? extends T>)item$iv);
        }
        return destination$iv;
    }

    public int hashCode() {
        int hashCode = 1;
        Iterator<T> iterator2 = this.iterator();
        while (iterator2.hasNext()) {
            T element;
            T t = element = iterator2.next();
            hashCode = 31 * hashCode + (t != null ? t.hashCode() : 0);
        }
        return hashCode;
    }

    public boolean equals(@Nullable Object other) {
        return other == this ? true : (!(other instanceof PooledList) ? false : (((PooledList)other).size != this.size ? false : this.compareElements((PooledList)other)));
    }

    private final boolean compareElements(PooledList<?> other) {
        Iterator<T> iterator2 = this.iterator();
        Iterator<?> otherIterator = other.iterator();
        while (iterator2.hasNext()) {
            if (otherIterator.hasNext() && this.isEqualElementTo(iterator2.next(), otherIterator.next())) continue;
            return false;
        }
        return true;
    }

    private final boolean isEqualElementTo(@Nullable Object $receiver, Object element) {
        return $receiver == element || $receiver != null && Intrinsics.areEqual($receiver, element);
    }

    @NotNull
    public String toString() {
        Function1 function1 = null;
        CharSequence charSequence = null;
        int n = 0;
        CharSequence charSequence2 = "]";
        CharSequence charSequence3 = ", ";
        CharSequence charSequence4 = "[";
        return CollectionsKt.joinToString$default(this, charSequence3, charSequence4, charSequence2, n, charSequence, function1, 56, null);
    }

    private final Node<T> addBefore(T element, Node<T> node) {
        Node<T> newNode = this.nodePool.obtain();
        newNode.setElement(element);
        newNode.setNext(node);
        newNode.setPrevious(node.getPrevious());
        Node<T> node2 = newNode.getPrevious();
        Node<T> node3 = newNode;
        Intrinsics.checkExpressionValueIsNotNull(node3, "newNode");
        node2.setNext(node3);
        newNode.getNext().setPrevious(newNode);
        int n = this.size;
        this.size = n + 1;
        return newNode;
    }

    private final T remove(Node<T> node) {
        if (Intrinsics.areEqual(node, this.main)) {
            throw (Throwable)new IllegalStateException();
        }
        T element = node.getElement();
        node.getPrevious().setNext(node.getNext());
        node.getNext().setPrevious(node.getPrevious());
        node.reset();
        this.nodePool.free(node);
        int n = this.size;
        this.size = n + -1;
        T t = element;
        if (t == null) {
            Intrinsics.throwNpe();
        }
        return t;
    }

    @NotNull
    public final Pool<Node<T>> getNodePool() {
        return this.nodePool;
    }

    public PooledList(@NotNull Pool<Node<T>> nodePool) {
        Intrinsics.checkParameterIsNotNull(nodePool, "nodePool");
        this.nodePool = nodePool;
        this.main = new Node();
        this.iterator = new PooledListIterator(this);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0000\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0006\u0010\u0012\u001a\u00020\u0013R\u001e\u0010\u0004\u001a\u0004\u0018\u00018\u0001X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\t\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR \u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR \u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lktx/collections/PooledList$Node;", "T", "", "()V", "element", "getElement", "()Ljava/lang/Object;", "setElement", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "next", "getNext", "()Lktx/collections/PooledList$Node;", "setNext", "(Lktx/collections/PooledList$Node;)V", "previous", "getPrevious", "setPrevious", "reset", "", "ktx-collections"})
    public static final class Node<T> {
        @Nullable
        private T element;
        @NotNull
        private Node<T> previous = this;
        @NotNull
        private Node<T> next = this;

        @Nullable
        public final T getElement() {
            return this.element;
        }

        public final void setElement(@Nullable T t) {
            this.element = t;
        }

        @NotNull
        public final Node<T> getPrevious() {
            return this.previous;
        }

        public final void setPrevious(@NotNull Node<T> node) {
            Intrinsics.checkParameterIsNotNull(node, "<set-?>");
            this.previous = node;
        }

        @NotNull
        public final Node<T> getNext() {
            return this.next;
        }

        public final void setNext(@NotNull Node<T> node) {
            Intrinsics.checkParameterIsNotNull(node, "<set-?>");
            this.next = node;
        }

        public final void reset() {
            this.element = null;
            this.previous = this;
            this.next = this;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010)\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010(\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u0016\u001a\u00020\u0011H\u0096\u0002J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00010\u0018H\u0096\u0002J\u000e\u0010\u0019\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0002\u0010\u001aJ\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0002\u0010\u0010\u001a\u00020\u0011R \u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR \u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0006R\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001e"}, d2={"Lktx/collections/PooledList$PooledListIterator;", "T", "", "", "list", "Lktx/collections/PooledList;", "(Lktx/collections/PooledList;)V", "current", "Lktx/collections/PooledList$Node;", "getCurrent$ktx_collections", "()Lktx/collections/PooledList$Node;", "setCurrent$ktx_collections", "(Lktx/collections/PooledList$Node;)V", "getList", "()Lktx/collections/PooledList;", "setList", "reversed", "", "getReversed", "()Z", "setReversed", "(Z)V", "hasNext", "iterator", "", "next", "()Ljava/lang/Object;", "remove", "", "reset", "ktx-collections"})
    public static final class PooledListIterator<T>
    implements Iterator<T>,
    Iterable<T>,
    KMutableIterator,
    KMappedMarker {
        @NotNull
        private Node<T> current;
        private boolean reversed;
        @NotNull
        private PooledList<T> list;

        @NotNull
        public final Node<T> getCurrent$ktx_collections() {
            return this.current;
        }

        public final void setCurrent$ktx_collections(@NotNull Node<T> node) {
            Intrinsics.checkParameterIsNotNull(node, "<set-?>");
            this.current = node;
        }

        public final boolean getReversed() {
            return this.reversed;
        }

        public final void setReversed(boolean bl) {
            this.reversed = bl;
        }

        @Override
        public boolean hasNext() {
            return ((PooledList)this.list).main != (this.reversed ? this.current.getPrevious() : this.current.getNext());
        }

        @Override
        public T next() {
            this.current = this.reversed ? this.current.getPrevious() : this.current.getNext();
            T t = this.current.getElement();
            if (t == null) {
                Intrinsics.throwNpe();
            }
            return t;
        }

        @Override
        public void remove() {
            Node<T> node = this.current;
            this.current = this.reversed ? this.current.getNext() : this.current.getPrevious();
            ((PooledList)this.list).remove(node);
        }

        @NotNull
        public final PooledListIterator<T> reset(boolean reversed) {
            this.current = ((PooledList)this.list).main;
            this.reversed = reversed;
            return this;
        }

        @NotNull
        public static /* bridge */ /* synthetic */ PooledListIterator reset$default(PooledListIterator pooledListIterator, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bl = false;
            }
            return pooledListIterator.reset(bl);
        }

        @Override
        @NotNull
        public Iterator<T> iterator() {
            return this;
        }

        @NotNull
        public final PooledList<T> getList() {
            return this.list;
        }

        public final void setList(@NotNull PooledList<T> pooledList) {
            Intrinsics.checkParameterIsNotNull(pooledList, "<set-?>");
            this.list = pooledList;
        }

        public PooledListIterator(@NotNull PooledList<T> list) {
            Intrinsics.checkParameterIsNotNull(list, "list");
            this.list = list;
            this.current = ((PooledList)this.list).main;
        }
    }
}

