/*
 * Decompiled with CFR 0.152.
 */
package ktx.app;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Graphics;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.ObjectMap;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import ktx.app.GameKt;
import ktx.app.KtxApplicationAdapter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010\u0003\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0004\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u001b\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00018\u0000\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\"\u0010\u0014\u001a\u00020\u0015\"\n\b\u0001\u0010\u0016\u0018\u0001*\u00028\u00002\u0006\u0010\u0017\u001a\u0002H\u0016H\u0086\b\u00a2\u0006\u0002\u0010\fJ-\u0010\u0014\u001a\u00020\u0015\"\b\b\u0001\u0010\u0016*\u00028\u00002\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00160\u000f2\u0006\u0010\u0017\u001a\u0002H\u0016H\u0016\u00a2\u0006\u0002\u0010\u0019J\u0015\u0010\u001a\u001a\u00020\u0006\"\n\b\u0001\u0010\u0016\u0018\u0001*\u00028\u0000H\u0086\bJ \u0010\u001a\u001a\u00020\u0006\"\b\b\u0001\u0010\u0016*\u00028\u00002\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00160\u000fH\u0016J\b\u0010\u001b\u001a\u00020\u0015H\u0016J\b\u0010\u001c\u001a\u00020\u0015H\u0016J\u001a\u0010\u001d\u001a\u0002H\u0016\"\n\b\u0001\u0010\u0016\u0018\u0001*\u00028\u0000H\u0086\b\u00a2\u0006\u0002\u0010\nJ%\u0010\u001d\u001a\u0002H\u0016\"\b\b\u0001\u0010\u0016*\u00028\u00002\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00160\u000fH\u0016\u00a2\u0006\u0002\u0010\u001eJ\u001d\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00028\u00002\u0006\u0010 \u001a\u00020!H\u0014\u00a2\u0006\u0002\u0010\"J\b\u0010#\u001a\u00020\u0015H\u0016J\u001c\u0010$\u001a\u0004\u0018\u0001H\u0016\"\n\b\u0001\u0010\u0016\u0018\u0001*\u00028\u0000H\u0086\b\u00a2\u0006\u0002\u0010\nJ'\u0010$\u001a\u0004\u0018\u0001H\u0016\"\b\b\u0001\u0010\u0016*\u00028\u00002\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00160\u000fH\u0016\u00a2\u0006\u0002\u0010\u001eJ\b\u0010%\u001a\u00020\u0015H\u0016J\u0018\u0010&\u001a\u00020\u00152\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(H\u0016J\b\u0010*\u001a\u00020\u0015H\u0016J\u0015\u0010+\u001a\u00020\u0015\"\n\b\u0001\u0010\u0016\u0018\u0001*\u00028\u0000H\u0086\bJ \u0010+\u001a\u00020\u0015\"\b\b\u0001\u0010\u0016*\u00028\u00002\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00160\u000fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\u0002X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR(\u0010\r\u001a\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u000f\u0012\u0004\u0012\u00028\u00000\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00028\u00008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\n\u00a8\u0006,"}, d2={"Lktx/app/KtxGame;", "ScreenType", "Lcom/badlogic/gdx/Screen;", "Lktx/app/KtxApplicationAdapter;", "firstScreen", "clearScreen", "", "(Lcom/badlogic/gdx/Screen;Z)V", "currentScreen", "getCurrentScreen", "()Lcom/badlogic/gdx/Screen;", "setCurrentScreen", "(Lcom/badlogic/gdx/Screen;)V", "screens", "Lcom/badlogic/gdx/utils/ObjectMap;", "Ljava/lang/Class;", "getScreens", "()Lcom/badlogic/gdx/utils/ObjectMap;", "shownScreen", "getShownScreen", "addScreen", "", "Type", "screen", "type", "(Ljava/lang/Class;Lcom/badlogic/gdx/Screen;)V", "containsScreen", "create", "dispose", "getScreen", "(Ljava/lang/Class;)Lcom/badlogic/gdx/Screen;", "onScreenDisposalError", "exception", "", "(Lcom/badlogic/gdx/Screen;Ljava/lang/Throwable;)V", "pause", "removeScreen", "render", "resize", "width", "", "height", "resume", "setScreen", "ktx-app"})
public class KtxGame<ScreenType extends Screen>
implements KtxApplicationAdapter {
    @NotNull
    private final ObjectMap<Class<? extends ScreenType>, ScreenType> screens;
    @NotNull
    private Screen currentScreen;
    private final boolean clearScreen;

    @NotNull
    protected final ObjectMap<Class<? extends ScreenType>, ScreenType> getScreens() {
        return this.screens;
    }

    @NotNull
    protected final Screen getCurrentScreen() {
        return this.currentScreen;
    }

    protected final void setCurrentScreen(@NotNull Screen screen) {
        Intrinsics.checkParameterIsNotNull(screen, "<set-?>");
        this.currentScreen = screen;
    }

    @NotNull
    public ScreenType getShownScreen() {
        Screen screen = this.currentScreen;
        if (screen == null) {
            throw new TypeCastException("null cannot be cast to non-null type ScreenType");
        }
        return (ScreenType)screen;
    }

    @Override
    public void create() {
        Graphics graphics = Gdx.graphics;
        Intrinsics.checkExpressionValueIsNotNull(graphics, "Gdx.graphics");
        int n = graphics.getWidth();
        Graphics graphics2 = Gdx.graphics;
        Intrinsics.checkExpressionValueIsNotNull(graphics2, "Gdx.graphics");
        this.currentScreen.resize(n, graphics2.getHeight());
        this.currentScreen.show();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void render() {
        if (this.clearScreen) {
            void blue$iv;
            void green$iv;
            void red$iv;
            float f = 0.0f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            float alpha$iv = 1.0f;
            Gdx.gl.glClearColor((float)red$iv, (float)green$iv, (float)blue$iv, alpha$iv);
            Gdx.gl.glClear(16384);
        }
        Graphics graphics = Gdx.graphics;
        Intrinsics.checkExpressionValueIsNotNull(graphics, "Gdx.graphics");
        this.currentScreen.render(graphics.getDeltaTime());
    }

    @Override
    public void resize(int width, int height) {
        this.currentScreen.resize(width, height);
    }

    @Override
    public void pause() {
        this.currentScreen.pause();
    }

    @Override
    public void resume() {
        this.currentScreen.resume();
    }

    private final <Type extends ScreenType> void addScreen(Type screen) {
        Intrinsics.reifiedOperationMarker(4, "Type");
        this.addScreen(Screen.class, screen);
    }

    public <Type extends ScreenType> void addScreen(@NotNull Class<Type> type, @NotNull Type screen) {
        Intrinsics.checkParameterIsNotNull(type, "type");
        Intrinsics.checkParameterIsNotNull(screen, "screen");
        if (this.screens.containsKey(type)) {
            throw (Throwable)new GdxRuntimeException("Screen already registered to type: " + type + '.');
        }
        this.screens.put(type, screen);
    }

    private final <Type extends ScreenType> void setScreen() {
        Intrinsics.reifiedOperationMarker(4, "Type");
        this.setScreen(Screen.class);
    }

    public <Type extends ScreenType> void setScreen(@NotNull Class<Type> type) {
        Intrinsics.checkParameterIsNotNull(type, "type");
        this.currentScreen.hide();
        this.currentScreen = this.getScreen(type);
        Graphics graphics = Gdx.graphics;
        Intrinsics.checkExpressionValueIsNotNull(graphics, "Gdx.graphics");
        int n = graphics.getWidth();
        Graphics graphics2 = Gdx.graphics;
        Intrinsics.checkExpressionValueIsNotNull(graphics2, "Gdx.graphics");
        this.currentScreen.resize(n, graphics2.getHeight());
        this.currentScreen.show();
    }

    private final <Type extends ScreenType> Type getScreen() {
        Intrinsics.reifiedOperationMarker(4, "Type");
        return (Type)this.getScreen(Screen.class);
    }

    @NotNull
    public <Type extends ScreenType> Type getScreen(@NotNull Class<Type> type) {
        Intrinsics.checkParameterIsNotNull(type, "type");
        Screen screen = (Screen)this.screens.get(type);
        if (screen == null) {
            throw (Throwable)new GdxRuntimeException("Missing screen instance of type: " + type + '.');
        }
        return (Type)screen;
    }

    private final <Type extends ScreenType> Type removeScreen() {
        Intrinsics.reifiedOperationMarker(4, "Type");
        return (Type)this.removeScreen(Screen.class);
    }

    @Nullable
    public <Type extends ScreenType> Type removeScreen(@NotNull Class<Type> type) {
        Intrinsics.checkParameterIsNotNull(type, "type");
        return (Type)((Screen)this.screens.remove(type));
    }

    private final <Type extends ScreenType> boolean containsScreen() {
        Intrinsics.reifiedOperationMarker(4, "Type");
        return this.containsScreen(Screen.class);
    }

    public <Type extends ScreenType> boolean containsScreen(@NotNull Class<Type> type) {
        Intrinsics.checkParameterIsNotNull(type, "type");
        return this.screens.containsKey(type);
    }

    @Override
    public void dispose() {
        ObjectMap.Values<ScreenType> values2 = this.screens.values();
        Intrinsics.checkExpressionValueIsNotNull(values2, "screens.values()");
        Iterable $receiver$iv = values2;
        for (Object element$iv : $receiver$iv) {
            Screen it = (Screen)element$iv;
            try {
                it.dispose();
            }
            catch (Throwable exception) {
                Screen screen = it;
                Intrinsics.checkExpressionValueIsNotNull(screen, "it");
                this.onScreenDisposalError(screen, exception);
            }
        }
    }

    protected void onScreenDisposalError(@NotNull ScreenType screen, @NotNull Throwable exception) {
        Intrinsics.checkParameterIsNotNull(screen, "screen");
        Intrinsics.checkParameterIsNotNull(exception, "exception");
        Gdx.app.error("KTX", "Unable to dispose of " + screen.getClass() + " screen.", exception);
    }

    public KtxGame(@Nullable ScreenType firstScreen, boolean clearScreen) {
        this.clearScreen = clearScreen;
        this.screens = new ObjectMap();
        Object object = firstScreen;
        if (object == null) {
            object = GameKt.emptyScreen();
        }
        this.currentScreen = object;
    }

    public /* synthetic */ KtxGame(Screen screen, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            screen = null;
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        this(screen, bl);
    }

    public KtxGame() {
        this(null, false, 3, null);
    }
}

