/*
 * Decompiled with CFR 0.152.
 */
package glm.quat;

import glm.ExtensionsKt;
import glm.JavaBindsKt;
import glm.glm;
import glm.mat.QuatT;
import glm.mat3x3.Mat3;
import glm.mat3x3.Mat3d;
import glm.mat4x4.Mat4;
import glm.mat4x4.Mat4d;
import glm.quat.Quat;
import glm.quat.quatD_operators;
import glm.quat.quat_func;
import glm.vec3.Vec3;
import glm.vec3.Vec3d;
import glm.vec4.Vec4bool;
import glm.vec4.Vec4d;
import glm.vec4.Vec4t;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0004\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 G2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001GB\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0003B\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0017\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB\u0017\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\t\u0012\u0006\u0010\f\u001a\u00020\t\u00a2\u0006\u0002\u0010\rB\u000f\b\u0016\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010B\u000f\b\u0016\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013B\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u0014B'\b\u0016\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u0012\u0006\u0010\u0017\u001a\u00020\u0016\u0012\u0006\u0010\u0018\u001a\u00020\u0016\u0012\u0006\u0010\u0019\u001a\u00020\u0016\u00a2\u0006\u0002\u0010\u001aB\u0013\b\u0016\u0012\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u001b\u00a2\u0006\u0002\u0010\u001cB%\u0012\u0006\u0010\u0015\u001a\u00020\u0002\u0012\u0006\u0010\u0017\u001a\u00020\u0002\u0012\u0006\u0010\u0018\u001a\u00020\u0002\u0012\u0006\u0010\u0019\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u001dJ\u0006\u0010\u001e\u001a\u00020\u0002J\"\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u00022\u0006\u0010 \u001a\u00020\t2\b\b\u0002\u0010!\u001a\u00020\u0000H\u0007J\u0016\u0010\"\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u00022\u0006\u0010 \u001a\u00020\tJ\u0012\u0010#\u001a\u00020\u00002\b\b\u0002\u0010!\u001a\u00020\u0000H\u0007J\u0006\u0010$\u001a\u00020\u0000J\u0011\u0010%\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u0002H\u0086\u0006J\u0016\u0010%\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010!\u001a\u00020\u0000J\u0011\u0010&\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u0002H\u0086\u0004J\u0011\u0010'\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0000H\u0086\u0004J\u0013\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010+H\u0096\u0002J\u0012\u0010,\u001a\u00020\t2\b\b\u0002\u0010!\u001a\u00020\tH\u0007J\u0011\u0010-\u001a\u00020\u00022\u0006\u0010.\u001a\u00020/H\u0086\u0002J\u0012\u00100\u001a\u00020\u00002\b\b\u0002\u0010!\u001a\u00020\u0000H\u0007J\u0006\u00101\u001a\u00020\u0000J\u0006\u00102\u001a\u00020\u0002J\u0011\u00103\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u0000H\u0086\u0002J\u0016\u00103\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u0000J\u0011\u00104\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u0000H\u0086\u0004J\u0012\u00105\u001a\u00020\u00002\b\b\u0002\u0010!\u001a\u00020\u0000H\u0007J\u0006\u00106\u001a\u00020\u0000J\u0011\u00107\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u0000H\u0086\u0006J\u0016\u00107\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u0000J\u0011\u00108\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u0000H\u0086\u0004J\u0011\u00109\u001a\u00020\u00002\u0006\u0010:\u001a\u00020\u0000H\u0086\u0004J&\u00109\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u0002J\u0019\u0010;\u001a\u00020<2\u0006\u0010.\u001a\u00020/2\u0006\u0010\u0007\u001a\u00020\u0002H\u0086\u0002J\"\u0010=\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u00002\u0006\u0010>\u001a\u00020\u00022\b\b\u0002\u0010!\u001a\u00020\u0000H\u0007J\u0016\u0010?\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u00002\u0006\u0010>\u001a\u00020\u0002J\u0011\u0010@\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u0000H\u0086\u0006J\u0016\u0010@\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u0000J\u0011\u0010@\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\tH\u0086\u0006J\u0016\u0010@\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010!\u001a\u00020\tJ\u0011\u0010@\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u0012H\u0086\u0006J\u0016\u0010@\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u00122\u0006\u0010!\u001a\u00020\u0000J\u0011\u0010@\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u0002H\u0086\u0006J\u0016\u0010@\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010!\u001a\u00020\u0000J\u0011\u0010A\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u0000H\u0086\u0004J\u0011\u0010A\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\tH\u0086\u0004J\u0011\u0010A\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u0012H\u0086\u0004J\u0011\u0010A\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u0002H\u0086\u0004J\b\u0010B\u001a\u00020CH\u0016J\t\u0010D\u001a\u00020\u0000H\u0086\u0002J\t\u0010E\u001a\u00020\u0000H\u0086\u0002J\u0012\u0010F\u001a\u00020\u00122\b\b\u0002\u0010!\u001a\u00020\u0012H\u0007\u00a8\u0006H"}, d2={"Lglm/quat/QuatD;", "Lglm/mat/QuatT;", "", "()V", "q", "Lglm/quat/Quat;", "(Lglm/quat/Quat;)V", "s", "v", "Lglm/vec3/Vec3d;", "(DLglm/vec3/Vec3d;)V", "a", "b", "(Lglm/vec3/Vec3d;Lglm/vec3/Vec3d;)V", "eulerAngle", "Lglm/vec3/Vec3;", "(Lglm/vec3/Vec3;)V", "vec4", "Lglm/vec4/Vec4d;", "(Lglm/vec4/Vec4d;)V", "(Lglm/quat/QuatD;)V", "w", "", "x", "y", "z", "(Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;)V", "Lglm/vec4/Vec4t;", "(Lglm/vec4/Vec4t;)V", "(DDDD)V", "angle", "angleAxis", "axis", "res", "angleAxis_", "conjugate", "conjugate_", "div", "div_", "dot", "equals", "", "other", "", "eulerAngles", "get", "i", "", "inverse", "inverse_", "length", "minus", "minus_", "normalize", "normalize_", "plus", "plus_", "put", "quat", "set", "", "slerp", "interp", "slerp_", "times", "times_", "toString", "", "unaryMinus", "unaryPlus", "vectorize", "Companion", "build_main"})
public final class QuatD
extends QuatT<Double> {
    @JvmField
    public static final int size;
    public static final Companion Companion;

    @NotNull
    public final QuatD put(double w, double x, double y, double z) {
        this.w = w;
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    @NotNull
    public final QuatD put(@NotNull QuatD quat) {
        Intrinsics.checkParameterIsNotNull(quat, "quat");
        return this.put(quat.w.doubleValue(), quat.x.doubleValue(), quat.y.doubleValue(), quat.z.doubleValue());
    }

    public final double get(int i) {
        double d;
        switch (i) {
            case 0: {
                d = this.x.doubleValue();
                break;
            }
            case 1: {
                d = this.y.doubleValue();
                break;
            }
            case 2: {
                d = this.z.doubleValue();
                break;
            }
            case 3: {
                d = this.w.doubleValue();
                break;
            }
            default: {
                throw (Throwable)new ArrayIndexOutOfBoundsException();
            }
        }
        return d;
    }

    public final void set(int i, double s) {
        switch (i) {
            case 0: {
                this.x = s;
                break;
            }
            case 1: {
                this.y = s;
                break;
            }
            case 2: {
                this.z = s;
                break;
            }
            case 3: {
                this.w = s;
                break;
            }
            default: {
                throw (Throwable)new ArrayIndexOutOfBoundsException();
            }
        }
    }

    @NotNull
    public final QuatD unaryPlus() {
        return this;
    }

    @NotNull
    public final QuatD unaryMinus() {
        return new QuatD(-this.w.doubleValue(), -this.x.doubleValue(), -this.y.doubleValue(), -this.z.doubleValue());
    }

    @NotNull
    public final QuatD plus(@NotNull QuatD b) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        return Companion.plus(new QuatD(), this, b);
    }

    @NotNull
    public final QuatD plus(@NotNull QuatD b, @NotNull QuatD res) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        Intrinsics.checkParameterIsNotNull(res, "res");
        return Companion.plus(res, this, b);
    }

    @NotNull
    public final QuatD plus_(@NotNull QuatD b) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        return Companion.plus(this, this, b);
    }

    @NotNull
    public final QuatD minus(@NotNull QuatD b) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        return Companion.minus(new QuatD(), this, b);
    }

    @NotNull
    public final QuatD minus(@NotNull QuatD b, @NotNull QuatD res) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        Intrinsics.checkParameterIsNotNull(res, "res");
        return Companion.minus(res, this, b);
    }

    @NotNull
    public final QuatD minus_(@NotNull QuatD b) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        return Companion.minus(this, this, b);
    }

    @NotNull
    public final QuatD times(@NotNull QuatD b) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        return Companion.times(new QuatD(), this, b);
    }

    @NotNull
    public final QuatD times(double b) {
        return Companion.times(new QuatD(), this, b);
    }

    @NotNull
    public final Vec3d times(@NotNull Vec3d b) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        return Companion.times(new Vec3d(), this, b);
    }

    @NotNull
    public final QuatD times(@NotNull Vec4d b) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        return Companion.times(new QuatD(), this, b);
    }

    @NotNull
    public final QuatD times(@NotNull QuatD b, @NotNull QuatD res) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        Intrinsics.checkParameterIsNotNull(res, "res");
        return Companion.times(res, this, b);
    }

    @NotNull
    public final QuatD times(double b, @NotNull QuatD res) {
        Intrinsics.checkParameterIsNotNull(res, "res");
        return Companion.times(res, this, b);
    }

    @NotNull
    public final Vec3d times(@NotNull Vec3d b, @NotNull Vec3d res) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        Intrinsics.checkParameterIsNotNull(res, "res");
        return Companion.times(res, this, b);
    }

    @NotNull
    public final QuatD times(@NotNull Vec4d b, @NotNull QuatD res) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        Intrinsics.checkParameterIsNotNull(res, "res");
        return Companion.times(res, this, b);
    }

    @NotNull
    public final QuatD times_(@NotNull QuatD b) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        return Companion.times(this, this, b);
    }

    @NotNull
    public final QuatD times_(double b) {
        return Companion.times(this, this, b);
    }

    @NotNull
    public final Vec3d times_(@NotNull Vec3d b) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        return Companion.times(b, this, b);
    }

    @NotNull
    public final QuatD times_(@NotNull Vec4d b) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        return Companion.times(this, this, b);
    }

    @NotNull
    public final QuatD div(double b) {
        return Companion.div(new QuatD(), this, b);
    }

    @NotNull
    public final QuatD div(double b, @NotNull QuatD res) {
        Intrinsics.checkParameterIsNotNull(res, "res");
        return Companion.div(res, this, b);
    }

    @NotNull
    public final QuatD div_(double b) {
        return Companion.div(this, this, b);
    }

    public final double length() {
        return glm.INSTANCE.length(this);
    }

    @JvmOverloads
    @NotNull
    public final QuatD normalize(@NotNull QuatD res) {
        Intrinsics.checkParameterIsNotNull(res, "res");
        return glm.INSTANCE.normalize(this, res);
    }

    @JvmOverloads
    @NotNull
    public static /* bridge */ /* synthetic */ QuatD normalize$default(QuatD quatD, QuatD quatD2, int n, Object object) {
        if ((n & 1) != 0) {
            quatD2 = new QuatD();
        }
        return quatD.normalize(quatD2);
    }

    @JvmOverloads
    @NotNull
    public final QuatD normalize() {
        return QuatD.normalize$default(this, null, 1, null);
    }

    @NotNull
    public final QuatD normalize_() {
        return glm.INSTANCE.normalize(this, this);
    }

    public final double dot(@NotNull QuatD b) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        return glm.INSTANCE.dot(this, b);
    }

    @JvmOverloads
    @NotNull
    public final QuatD angleAxis(double angle, @NotNull Vec3d axis, @NotNull QuatD res) {
        Intrinsics.checkParameterIsNotNull(axis, "axis");
        Intrinsics.checkParameterIsNotNull(res, "res");
        return glm.INSTANCE.angleAxis(angle, axis, res);
    }

    @JvmOverloads
    @NotNull
    public static /* bridge */ /* synthetic */ QuatD angleAxis$default(QuatD quatD, double d, Vec3d vec3d, QuatD quatD2, int n, Object object) {
        if ((n & 4) != 0) {
            quatD2 = new QuatD();
        }
        return quatD.angleAxis(d, vec3d, quatD2);
    }

    @JvmOverloads
    @NotNull
    public final QuatD angleAxis(double angle, @NotNull Vec3d axis) {
        return QuatD.angleAxis$default(this, angle, axis, null, 4, null);
    }

    @NotNull
    public final QuatD angleAxis_(double angle, @NotNull Vec3d axis) {
        Intrinsics.checkParameterIsNotNull(axis, "axis");
        return glm.INSTANCE.angleAxis(angle, axis, this);
    }

    @JvmOverloads
    @NotNull
    public final QuatD conjugate(@NotNull QuatD res) {
        Intrinsics.checkParameterIsNotNull(res, "res");
        return glm.INSTANCE.conjugate(this, res);
    }

    @JvmOverloads
    @NotNull
    public static /* bridge */ /* synthetic */ QuatD conjugate$default(QuatD quatD, QuatD quatD2, int n, Object object) {
        if ((n & 1) != 0) {
            quatD2 = new QuatD();
        }
        return quatD.conjugate(quatD2);
    }

    @JvmOverloads
    @NotNull
    public final QuatD conjugate() {
        return QuatD.conjugate$default(this, null, 1, null);
    }

    @NotNull
    public final QuatD conjugate_() {
        return glm.INSTANCE.conjugate(this, this);
    }

    @JvmOverloads
    @NotNull
    public final QuatD inverse(@NotNull QuatD res) {
        Intrinsics.checkParameterIsNotNull(res, "res");
        return glm.INSTANCE.inverse(this, res);
    }

    @JvmOverloads
    @NotNull
    public static /* bridge */ /* synthetic */ QuatD inverse$default(QuatD quatD, QuatD quatD2, int n, Object object) {
        if ((n & 1) != 0) {
            quatD2 = new QuatD();
        }
        return quatD.inverse(quatD2);
    }

    @JvmOverloads
    @NotNull
    public final QuatD inverse() {
        return QuatD.inverse$default(this, null, 1, null);
    }

    @NotNull
    public final QuatD inverse_() {
        return glm.INSTANCE.inverse(this, this);
    }

    public final double angle() {
        return glm.INSTANCE.angle(this);
    }

    @JvmOverloads
    @NotNull
    public final Vec3d eulerAngles(@NotNull Vec3d res) {
        Intrinsics.checkParameterIsNotNull(res, "res");
        return glm.INSTANCE.eulerAngles(this, res);
    }

    @JvmOverloads
    @NotNull
    public static /* bridge */ /* synthetic */ Vec3d eulerAngles$default(QuatD quatD, Vec3d vec3d, int n, Object object) {
        if ((n & 1) != 0) {
            vec3d = new Vec3d();
        }
        return quatD.eulerAngles(vec3d);
    }

    @JvmOverloads
    @NotNull
    public final Vec3d eulerAngles() {
        return QuatD.eulerAngles$default(this, null, 1, null);
    }

    @JvmOverloads
    @NotNull
    public final QuatD slerp(@NotNull QuatD b, double interp, @NotNull QuatD res) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        Intrinsics.checkParameterIsNotNull(res, "res");
        return glm.INSTANCE.slerp(this, b, interp, res);
    }

    @JvmOverloads
    @NotNull
    public static /* bridge */ /* synthetic */ QuatD slerp$default(QuatD quatD, QuatD quatD2, double d, QuatD quatD3, int n, Object object) {
        if ((n & 4) != 0) {
            quatD3 = new QuatD();
        }
        return quatD.slerp(quatD2, d, quatD3);
    }

    @JvmOverloads
    @NotNull
    public final QuatD slerp(@NotNull QuatD b, double interp) {
        return QuatD.slerp$default(this, b, interp, null, 4, null);
    }

    @NotNull
    public final QuatD slerp_(@NotNull QuatD b, double interp) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        return glm.INSTANCE.slerp(this, b, interp, this);
    }

    @NotNull
    public String toString() {
        return "(" + this.x.doubleValue() + ", " + this.y.doubleValue() + ", " + this.z.doubleValue() + "), " + this.w.doubleValue();
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof QuatD ? this.get(0) == ((QuatD)other).get(0) && this.get(1) == ((QuatD)other).get(1) && this.get(2) == ((QuatD)other).get(2) && this.get(3) == ((QuatD)other).get(3) : false;
    }

    @JvmOverloads
    @NotNull
    public final Vec4d vectorize(@NotNull Vec4d res) {
        Intrinsics.checkParameterIsNotNull(res, "res");
        return res.put(this.x, this.y, this.z, this.w);
    }

    @JvmOverloads
    @NotNull
    public static /* bridge */ /* synthetic */ Vec4d vectorize$default(QuatD quatD, Vec4d vec4d, int n, Object object) {
        if ((n & 1) != 0) {
            vec4d = new Vec4d();
        }
        return quatD.vectorize(vec4d);
    }

    @JvmOverloads
    @NotNull
    public final Vec4d vectorize() {
        return QuatD.vectorize$default(this, null, 1, null);
    }

    public QuatD(double w, double x, double y, double z) {
        super(w, x, y, z);
    }

    public QuatD() {
        this(1.0, 0.0, 0.0, 0.0);
    }

    public QuatD(@NotNull Quat q) {
        Intrinsics.checkParameterIsNotNull(q, "q");
        this(q.w, q.x, q.y, q.z);
    }

    public QuatD(double s, @NotNull Vec3d v) {
        Intrinsics.checkParameterIsNotNull(v, "v");
        this(s, v.x.doubleValue(), v.y.doubleValue(), v.z.doubleValue());
    }

    public QuatD(@NotNull Vec3d a, @NotNull Vec3d b) {
        Intrinsics.checkParameterIsNotNull(a, "a");
        Intrinsics.checkParameterIsNotNull(b, "b");
        this();
        double cX = a.y.doubleValue() * b.z.doubleValue() - b.y.doubleValue() * a.z.doubleValue();
        double cY = a.z.doubleValue() * b.x.doubleValue() - b.z.doubleValue() * a.x.doubleValue();
        double cZ = a.x.doubleValue() * b.y.doubleValue() - b.x.doubleValue() * a.y.doubleValue();
        double dot = glm.INSTANCE.dot(a, b);
        this.put(1.0 + dot, cX, cY, cZ);
        Companion.normalize(this, this);
    }

    public QuatD(@NotNull Vec3 eulerAngle) {
        Intrinsics.checkParameterIsNotNull(eulerAngle, "eulerAngle");
        this();
        double eX = eulerAngle.x.doubleValue() * 0.5;
        double eY = eulerAngle.y.doubleValue() * 0.5;
        double eZ = eulerAngle.z.doubleValue() * 0.5;
        double cX = glm.INSTANCE.cos(eX);
        double cY = glm.INSTANCE.cos(eY);
        double cZ = glm.INSTANCE.cos(eZ);
        double sX = glm.INSTANCE.sin(eX);
        double sY = glm.INSTANCE.sin(eY);
        double sZ = glm.INSTANCE.sin(eZ);
        this.w = cX * cY * cZ + sX * sY * sZ;
        this.x = sX * cY * cZ - cX * sY * sZ;
        this.y = cX * sY * cZ + sX * cY * sZ;
        this.z = cX * cY * sZ - sX * sY * cZ;
    }

    public QuatD(@NotNull Vec4d vec4) {
        Intrinsics.checkParameterIsNotNull(vec4, "vec4");
        this(vec4.w.doubleValue(), vec4.x.doubleValue(), vec4.y.doubleValue(), vec4.z.doubleValue());
    }

    public QuatD(@NotNull QuatD q) {
        Intrinsics.checkParameterIsNotNull(q, "q");
        this(Float.valueOf(ExtensionsKt.getF(q.w)), Float.valueOf(ExtensionsKt.getF(q.x)), Float.valueOf(ExtensionsKt.getF(q.y)), Float.valueOf(ExtensionsKt.getF(q.z)));
    }

    public QuatD(@NotNull Number w, @NotNull Number x, @NotNull Number y, @NotNull Number z) {
        Intrinsics.checkParameterIsNotNull(w, "w");
        Intrinsics.checkParameterIsNotNull(x, "x");
        Intrinsics.checkParameterIsNotNull(y, "y");
        Intrinsics.checkParameterIsNotNull(z, "z");
        this(ExtensionsKt.getD(w), ExtensionsKt.getD(x), ExtensionsKt.getD(y), ExtensionsKt.getD(z));
    }

    public QuatD(@NotNull Vec4t<?> vec4) {
        Intrinsics.checkParameterIsNotNull(vec4, "vec4");
        this(ExtensionsKt.getD(vec4.w), ExtensionsKt.getD(vec4.x), ExtensionsKt.getD(vec4.y), ExtensionsKt.getD(vec4.z));
    }

    static {
        Companion = new Companion(null);
        size = 4 * JavaBindsKt.getBYTES(FloatCompanionObject.INSTANCE);
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lglm/quat/QuatD$Companion;", "Lglm/quat/quatD_operators;", "Lglm/quat/quat_func;", "()V", "size", "", "build_main"})
    public static final class Companion
    implements quatD_operators,
    quat_func {
        private Companion() {
        }

        @Override
        @NotNull
        public QuatD plus(@NotNull QuatD res, @NotNull QuatD a, @NotNull QuatD b) {
            Intrinsics.checkParameterIsNotNull(res, "res");
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return quatD_operators.DefaultImpls.plus(this, res, a, b);
        }

        @Override
        @NotNull
        public QuatD minus(@NotNull QuatD res, @NotNull QuatD a, @NotNull QuatD b) {
            Intrinsics.checkParameterIsNotNull(res, "res");
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return quatD_operators.DefaultImpls.minus(this, res, a, b);
        }

        @Override
        @NotNull
        public QuatD times(@NotNull QuatD res, @NotNull QuatD a, @NotNull QuatD b) {
            Intrinsics.checkParameterIsNotNull(res, "res");
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return quatD_operators.DefaultImpls.times((quatD_operators)this, res, a, b);
        }

        @Override
        @NotNull
        public QuatD times(@NotNull QuatD res, @NotNull QuatD a, double b) {
            Intrinsics.checkParameterIsNotNull(res, "res");
            Intrinsics.checkParameterIsNotNull(a, "a");
            return quatD_operators.DefaultImpls.times((quatD_operators)this, res, a, b);
        }

        @Override
        @NotNull
        public Vec3d times(@NotNull Vec3d res, @NotNull QuatD a, @NotNull Vec3d b) {
            Intrinsics.checkParameterIsNotNull(res, "res");
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return quatD_operators.DefaultImpls.times((quatD_operators)this, res, a, b);
        }

        @Override
        @NotNull
        public Vec3d times(@NotNull Vec3d res, @NotNull Vec3d a, @NotNull QuatD b) {
            Intrinsics.checkParameterIsNotNull(res, "res");
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return quatD_operators.DefaultImpls.times((quatD_operators)this, res, a, b);
        }

        @Override
        @NotNull
        public QuatD times(@NotNull QuatD res, @NotNull QuatD a, @NotNull Vec4d b) {
            Intrinsics.checkParameterIsNotNull(res, "res");
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return quatD_operators.DefaultImpls.times((quatD_operators)this, res, a, b);
        }

        @Override
        @NotNull
        public QuatD div(@NotNull QuatD res, @NotNull QuatD a, double b) {
            Intrinsics.checkParameterIsNotNull(res, "res");
            Intrinsics.checkParameterIsNotNull(a, "a");
            return quatD_operators.DefaultImpls.div(this, res, a, b);
        }

        @Override
        public float length(@NotNull Quat q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return quat_func.DefaultImpls.length((quat_func)this, q);
        }

        @Override
        public double length(@NotNull QuatD q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return quat_func.DefaultImpls.length((quat_func)this, q);
        }

        @Override
        @NotNull
        public Quat normalize(@NotNull Quat q, @NotNull Quat res) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return quat_func.DefaultImpls.normalize((quat_func)this, q, res);
        }

        @Override
        @NotNull
        public Quat normalize(@NotNull Quat q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return quat_func.DefaultImpls.normalize((quat_func)this, q);
        }

        @Override
        @NotNull
        public QuatD normalize(@NotNull QuatD q, @NotNull QuatD res) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return quat_func.DefaultImpls.normalize((quat_func)this, q, res);
        }

        @Override
        @NotNull
        public QuatD normalize(@NotNull QuatD q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return quat_func.DefaultImpls.normalize((quat_func)this, q);
        }

        @Override
        public float dot(@NotNull Quat a, @NotNull Quat b) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return quat_func.DefaultImpls.dot((quat_func)this, a, b);
        }

        @Override
        public double dot(@NotNull QuatD a, @NotNull QuatD b) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return quat_func.DefaultImpls.dot((quat_func)this, a, b);
        }

        @Override
        @NotNull
        public Quat mix(@NotNull Quat a, @NotNull Quat b, float interp, @NotNull Quat res) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return quat_func.DefaultImpls.mix((quat_func)this, a, b, interp, res);
        }

        @Override
        @NotNull
        public Quat mix(@NotNull Quat a, @NotNull Quat b, float interp) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return quat_func.DefaultImpls.mix((quat_func)this, a, b, interp);
        }

        @Override
        @NotNull
        public QuatD mix(@NotNull QuatD a, @NotNull QuatD b, double interp, @NotNull QuatD res) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return quat_func.DefaultImpls.mix((quat_func)this, a, b, interp, res);
        }

        @Override
        @NotNull
        public QuatD mix(@NotNull QuatD a, @NotNull QuatD b, double interp) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return quat_func.DefaultImpls.mix((quat_func)this, a, b, interp);
        }

        @Override
        @NotNull
        public Quat lerp(@NotNull Quat a, @NotNull Quat b, float interp, @NotNull Quat res) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return quat_func.DefaultImpls.lerp((quat_func)this, a, b, interp, res);
        }

        @Override
        @NotNull
        public Quat lerp(@NotNull Quat a, @NotNull Quat b, float interp) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return quat_func.DefaultImpls.lerp((quat_func)this, a, b, interp);
        }

        @Override
        @NotNull
        public QuatD lerp(@NotNull QuatD a, @NotNull QuatD b, double interp, @NotNull QuatD res) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return quat_func.DefaultImpls.lerp((quat_func)this, a, b, interp, res);
        }

        @Override
        @NotNull
        public QuatD lerp(@NotNull QuatD a, @NotNull QuatD b, double interp) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return quat_func.DefaultImpls.lerp((quat_func)this, a, b, interp);
        }

        @Override
        @NotNull
        public Quat slerp(@NotNull Quat a, @NotNull Quat b, float interp, @NotNull Quat res) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return quat_func.DefaultImpls.slerp((quat_func)this, a, b, interp, res);
        }

        @Override
        @NotNull
        public Quat slerp(@NotNull Quat a, @NotNull Quat b, float interp) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return quat_func.DefaultImpls.slerp((quat_func)this, a, b, interp);
        }

        @Override
        @NotNull
        public QuatD slerp(@NotNull QuatD a, @NotNull QuatD b, double interp, @NotNull QuatD res) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return quat_func.DefaultImpls.slerp((quat_func)this, a, b, interp, res);
        }

        @Override
        @NotNull
        public QuatD slerp(@NotNull QuatD a, @NotNull QuatD b, double interp) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return quat_func.DefaultImpls.slerp((quat_func)this, a, b, interp);
        }

        @Override
        @NotNull
        public Quat conjugate(@NotNull Quat a, @NotNull Quat res) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return quat_func.DefaultImpls.conjugate((quat_func)this, a, res);
        }

        @Override
        @NotNull
        public Quat conjugate(@NotNull Quat a) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            return quat_func.DefaultImpls.conjugate((quat_func)this, a);
        }

        @Override
        @NotNull
        public QuatD conjugate(@NotNull QuatD a, @NotNull QuatD res) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return quat_func.DefaultImpls.conjugate((quat_func)this, a, res);
        }

        @Override
        @NotNull
        public QuatD conjugate(@NotNull QuatD a) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            return quat_func.DefaultImpls.conjugate((quat_func)this, a);
        }

        @Override
        @NotNull
        public Quat inverse(@NotNull Quat a, @NotNull Quat res) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return quat_func.DefaultImpls.inverse((quat_func)this, a, res);
        }

        @Override
        @NotNull
        public Quat inverse(@NotNull Quat a) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            return quat_func.DefaultImpls.inverse((quat_func)this, a);
        }

        @Override
        @NotNull
        public QuatD inverse(@NotNull QuatD a, @NotNull QuatD res) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return quat_func.DefaultImpls.inverse((quat_func)this, a, res);
        }

        @Override
        @NotNull
        public QuatD inverse(@NotNull QuatD a) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            return quat_func.DefaultImpls.inverse((quat_func)this, a);
        }

        @Override
        @NotNull
        public Quat rotate(@NotNull Quat q, float angle, float vX, float vY, float vZ, @NotNull Quat res) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return quat_func.DefaultImpls.rotate((quat_func)this, q, angle, vX, vY, vZ, res);
        }

        @Override
        @NotNull
        public Quat rotate(@NotNull Quat q, float angle, float vX, float vY, float vZ) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return quat_func.DefaultImpls.rotate((quat_func)this, q, angle, vX, vY, vZ);
        }

        @Override
        @NotNull
        public Quat rotate(@NotNull Quat q, float angle, @NotNull Vec3 v, @NotNull Quat res) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(v, "v");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return quat_func.DefaultImpls.rotate((quat_func)this, q, angle, v, res);
        }

        @Override
        @NotNull
        public Quat rotate(@NotNull Quat q, float angle, @NotNull Vec3 v) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(v, "v");
            return quat_func.DefaultImpls.rotate((quat_func)this, q, angle, v);
        }

        @Override
        @NotNull
        public QuatD rotate(@NotNull QuatD q, double angle, double vX, double vY, double vZ, @NotNull QuatD res) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return quat_func.DefaultImpls.rotate((quat_func)this, q, angle, vX, vY, vZ, res);
        }

        @Override
        @NotNull
        public QuatD rotate(@NotNull QuatD q, double angle, double vX, double vY, double vZ) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return quat_func.DefaultImpls.rotate((quat_func)this, q, angle, vX, vY, vZ);
        }

        @Override
        @NotNull
        public QuatD rotate(@NotNull QuatD q, double angle, @NotNull Vec3d v, @NotNull QuatD res) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(v, "v");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return quat_func.DefaultImpls.rotate((quat_func)this, q, angle, v, res);
        }

        @Override
        @NotNull
        public QuatD rotate(@NotNull QuatD q, double angle, @NotNull Vec3d v) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(v, "v");
            return quat_func.DefaultImpls.rotate((quat_func)this, q, angle, v);
        }

        @Override
        @NotNull
        public Vec3 eulerAngles(@NotNull Quat a, @NotNull Vec3 res) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return quat_func.DefaultImpls.eulerAngles((quat_func)this, a, res);
        }

        @Override
        @NotNull
        public Vec3 eulerAngles(@NotNull Quat a) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            return quat_func.DefaultImpls.eulerAngles((quat_func)this, a);
        }

        @Override
        @NotNull
        public Vec3d eulerAngles(@NotNull QuatD a, @NotNull Vec3d res) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return quat_func.DefaultImpls.eulerAngles((quat_func)this, a, res);
        }

        @Override
        @NotNull
        public Vec3d eulerAngles(@NotNull QuatD a) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            return quat_func.DefaultImpls.eulerAngles((quat_func)this, a);
        }

        @Override
        public float roll(@NotNull Quat q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return quat_func.DefaultImpls.roll((quat_func)this, q);
        }

        @Override
        public double roll(@NotNull QuatD q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return quat_func.DefaultImpls.roll((quat_func)this, q);
        }

        @Override
        public float pitch(@NotNull Quat q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return quat_func.DefaultImpls.pitch((quat_func)this, q);
        }

        @Override
        public double pitch(@NotNull QuatD q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return quat_func.DefaultImpls.pitch((quat_func)this, q);
        }

        @Override
        public float yaw(@NotNull Quat q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return quat_func.DefaultImpls.yaw((quat_func)this, q);
        }

        @Override
        public double yaw(@NotNull QuatD q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return quat_func.DefaultImpls.yaw((quat_func)this, q);
        }

        @Override
        @NotNull
        public Mat3 mat3_cast(@NotNull Quat q, @NotNull Mat3 res) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return quat_func.DefaultImpls.mat3_cast(this, q, res);
        }

        @Override
        @NotNull
        public Mat3 mat3_cast(@NotNull Quat q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return quat_func.DefaultImpls.mat3_cast(this, q);
        }

        @Override
        @NotNull
        public Mat3 mat3d_cast(@NotNull QuatD q, @NotNull Mat3 m) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(m, "m");
            return quat_func.DefaultImpls.mat3d_cast(this, q, m);
        }

        @Override
        @NotNull
        public Mat4 mat4_cast(@NotNull Quat q, @NotNull Mat4 res) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return quat_func.DefaultImpls.mat4_cast(this, q, res);
        }

        @Override
        @NotNull
        public Mat4 mat4_cast(@NotNull Quat q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return quat_func.DefaultImpls.mat4_cast(this, q);
        }

        @Override
        @NotNull
        public Mat4 mat4d_cast(@NotNull Mat4 res, @NotNull QuatD q) {
            Intrinsics.checkParameterIsNotNull(res, "res");
            Intrinsics.checkParameterIsNotNull(q, "q");
            return quat_func.DefaultImpls.mat4d_cast(this, res, q);
        }

        @Override
        @NotNull
        public Quat quat_cast(@NotNull Mat3 m, @NotNull Quat res) {
            Intrinsics.checkParameterIsNotNull(m, "m");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return quat_func.DefaultImpls.quat_cast((quat_func)this, m, res);
        }

        @Override
        @NotNull
        public Quat quat_cast(@NotNull Mat3 m) {
            Intrinsics.checkParameterIsNotNull(m, "m");
            return quat_func.DefaultImpls.quat_cast((quat_func)this, m);
        }

        @Override
        @NotNull
        public Quat quat_cast(@NotNull Mat4 m, @NotNull Quat res) {
            Intrinsics.checkParameterIsNotNull(m, "m");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return quat_func.DefaultImpls.quat_cast((quat_func)this, m, res);
        }

        @Override
        @NotNull
        public Quat quat_cast(@NotNull Mat4 m) {
            Intrinsics.checkParameterIsNotNull(m, "m");
            return quat_func.DefaultImpls.quat_cast((quat_func)this, m);
        }

        @Override
        @NotNull
        public Quat quat_cast(float m00, float m01, float m02, float m10, float m11, float m12, float m20, float m21, float m22, @NotNull Quat res) {
            Intrinsics.checkParameterIsNotNull(res, "res");
            return quat_func.DefaultImpls.quat_cast(this, m00, m01, m02, m10, m11, m12, m20, m21, m22, res);
        }

        @Override
        @NotNull
        public Quat quat_cast(float m00, float m01, float m02, float m10, float m11, float m12, float m20, float m21, float m22) {
            return quat_func.DefaultImpls.quat_cast(this, m00, m01, m02, m10, m11, m12, m20, m21, m22);
        }

        @Override
        @NotNull
        public QuatD quatD_cast(@NotNull Mat3d m, @NotNull QuatD res) {
            Intrinsics.checkParameterIsNotNull(m, "m");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return quat_func.DefaultImpls.quatD_cast((quat_func)this, m, res);
        }

        @Override
        @NotNull
        public QuatD quatD_cast(@NotNull Mat3d m) {
            Intrinsics.checkParameterIsNotNull(m, "m");
            return quat_func.DefaultImpls.quatD_cast((quat_func)this, m);
        }

        @Override
        @NotNull
        public QuatD quatD_cast(@NotNull Mat4d m, @NotNull QuatD res) {
            Intrinsics.checkParameterIsNotNull(m, "m");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return quat_func.DefaultImpls.quatD_cast((quat_func)this, m, res);
        }

        @Override
        @NotNull
        public QuatD quatD_cast(@NotNull Mat4d m) {
            Intrinsics.checkParameterIsNotNull(m, "m");
            return quat_func.DefaultImpls.quatD_cast((quat_func)this, m);
        }

        @Override
        @NotNull
        public QuatD quatD_cast(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22, @NotNull QuatD res) {
            Intrinsics.checkParameterIsNotNull(res, "res");
            return quat_func.DefaultImpls.quatD_cast(this, m00, m01, m02, m10, m11, m12, m20, m21, m22, res);
        }

        @Override
        @NotNull
        public QuatD quatD_cast(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22) {
            return quat_func.DefaultImpls.quatD_cast(this, m00, m01, m02, m10, m11, m12, m20, m21, m22);
        }

        @Override
        public float angle(@NotNull Quat q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return quat_func.DefaultImpls.angle((quat_func)this, q);
        }

        @Override
        public double angle(@NotNull QuatD q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return quat_func.DefaultImpls.angle((quat_func)this, q);
        }

        @Override
        @NotNull
        public Vec3 axis(@NotNull Quat q, @NotNull Vec3 res) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return quat_func.DefaultImpls.axis((quat_func)this, q, res);
        }

        @Override
        @NotNull
        public Vec3 axis(@NotNull Quat q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return quat_func.DefaultImpls.axis((quat_func)this, q);
        }

        @Override
        @NotNull
        public Vec3d axis(@NotNull QuatD q, @NotNull Vec3d res) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return quat_func.DefaultImpls.axis((quat_func)this, q, res);
        }

        @Override
        @NotNull
        public Vec3d axis(@NotNull QuatD q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return quat_func.DefaultImpls.axis((quat_func)this, q);
        }

        @Override
        @NotNull
        public Quat angleAxis(float angle, float axisX, float axisY, float axisZ, @NotNull Quat res) {
            Intrinsics.checkParameterIsNotNull(res, "res");
            return quat_func.DefaultImpls.angleAxis((quat_func)this, angle, axisX, axisY, axisZ, res);
        }

        @Override
        @NotNull
        public Quat angleAxis(float angle, float axisX, float axisY, float axisZ) {
            return quat_func.DefaultImpls.angleAxis((quat_func)this, angle, axisX, axisY, axisZ);
        }

        @Override
        @NotNull
        public Quat angleAxis(float angle, @NotNull Vec3 axis, @NotNull Quat res) {
            Intrinsics.checkParameterIsNotNull(axis, "axis");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return quat_func.DefaultImpls.angleAxis((quat_func)this, angle, axis, res);
        }

        @Override
        @NotNull
        public Quat angleAxis(float angle, @NotNull Vec3 axis) {
            Intrinsics.checkParameterIsNotNull(axis, "axis");
            return quat_func.DefaultImpls.angleAxis((quat_func)this, angle, axis);
        }

        @Override
        @NotNull
        public QuatD angleAxis(double angle, double axisX, double axisY, double axisZ, @NotNull QuatD res) {
            Intrinsics.checkParameterIsNotNull(res, "res");
            return quat_func.DefaultImpls.angleAxis((quat_func)this, angle, axisX, axisY, axisZ, res);
        }

        @Override
        @NotNull
        public QuatD angleAxis(double angle, double axisX, double axisY, double axisZ) {
            return quat_func.DefaultImpls.angleAxis((quat_func)this, angle, axisX, axisY, axisZ);
        }

        @Override
        @NotNull
        public QuatD angleAxis(double angle, @NotNull Vec3d axis, @NotNull QuatD res) {
            Intrinsics.checkParameterIsNotNull(axis, "axis");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return quat_func.DefaultImpls.angleAxis((quat_func)this, angle, axis, res);
        }

        @Override
        @NotNull
        public QuatD angleAxis(double angle, @NotNull Vec3d axis) {
            Intrinsics.checkParameterIsNotNull(axis, "axis");
            return quat_func.DefaultImpls.angleAxis((quat_func)this, angle, axis);
        }

        @Override
        @NotNull
        public Vec4bool lessThan(@NotNull Quat a, @NotNull Quat b, @NotNull Vec4bool res) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return quat_func.DefaultImpls.lessThan(this, a, b, res);
        }

        @Override
        @NotNull
        public Vec4bool lessThan(@NotNull Quat a, @NotNull Quat b) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return quat_func.DefaultImpls.lessThan(this, a, b);
        }

        @Override
        @NotNull
        public Vec4bool lessThanEqual(@NotNull Quat a, @NotNull Quat b, @NotNull Vec4bool res) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return quat_func.DefaultImpls.lessThanEqual(this, a, b, res);
        }

        @Override
        @NotNull
        public Vec4bool lessThanEqual(@NotNull Quat a, @NotNull Quat b) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return quat_func.DefaultImpls.lessThanEqual(this, a, b);
        }

        @Override
        @NotNull
        public Vec4bool greater(@NotNull Quat a, @NotNull Quat b, @NotNull Vec4bool res) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return quat_func.DefaultImpls.greater(this, a, b, res);
        }

        @Override
        @NotNull
        public Vec4bool greater(@NotNull Quat a, @NotNull Quat b) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return quat_func.DefaultImpls.greater(this, a, b);
        }

        @Override
        @NotNull
        public Vec4bool greaterThan(@NotNull Quat a, @NotNull Quat b, @NotNull Vec4bool res) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return quat_func.DefaultImpls.greaterThan(this, a, b, res);
        }

        @Override
        @NotNull
        public Vec4bool greaterThan(@NotNull Quat a, @NotNull Quat b) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return quat_func.DefaultImpls.greaterThan(this, a, b);
        }

        @Override
        @NotNull
        public Vec4bool equal(@NotNull Quat a, @NotNull Quat b, @NotNull Vec4bool res) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return quat_func.DefaultImpls.equal(this, a, b, res);
        }

        @Override
        @NotNull
        public Vec4bool equal(@NotNull Quat a, @NotNull Quat b) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return quat_func.DefaultImpls.equal(this, a, b);
        }

        @Override
        @NotNull
        public Vec4bool notEqual(@NotNull Quat a, @NotNull Quat b, @NotNull Vec4bool res) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return quat_func.DefaultImpls.notEqual(this, a, b, res);
        }

        @Override
        @NotNull
        public Vec4bool notEqual(@NotNull Quat a, @NotNull Quat b) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return quat_func.DefaultImpls.notEqual(this, a, b);
        }

        @Override
        @NotNull
        public Vec4bool isNan(@NotNull Quat q, @NotNull Vec4bool res) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return quat_func.DefaultImpls.isNan(this, q, res);
        }

        @Override
        @NotNull
        public Vec4bool isNan(@NotNull Quat q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return quat_func.DefaultImpls.isNan(this, q);
        }

        @Override
        @NotNull
        public Vec4bool isInf(@NotNull Quat q, @NotNull Vec4bool res) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return quat_func.DefaultImpls.isInf(this, q, res);
        }

        @Override
        @NotNull
        public Vec4bool isInf(@NotNull Quat q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return quat_func.DefaultImpls.isInf(this, q);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

