/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.game.drawables;

import com.badlogic.gdx.math.CatmullRomSpline;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;
import com.mygdx.game.Camera;
import com.mygdx.game.Config;
import com.mygdx.game.DemoObject;
import com.mygdx.game.Drawable;
import com.mygdx.game.UtilsKt;
import glm.vec3.Vec3;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0018\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u00112\u0006\u00105\u001a\u00020\u0005H\u0016J\b\u00106\u001a\u000203H\u0016J\u0018\u00107\u001a\u0002032\u0006\u00104\u001a\u00020\u00112\u0006\u00105\u001a\u00020\u0005H\u0016R\u0014\u0010\f\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR$\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\nX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u001d\"\u0004\b \u0010!R\u001c\u0010\"\u001a\u0004\u0018\u00010#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R \u0010(\u001a\b\u0012\u0004\u0012\u00020*0)X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u001a\u0010/\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010\u001d\"\u0004\b1\u0010!\u00a8\u00068"}, d2={"Lcom/mygdx/game/drawables/CameraPath;", "Lcom/mygdx/game/Drawable;", "cfg", "Lcom/mygdx/game/Config;", "attachedCamera", "Lcom/mygdx/game/Camera;", "points", "Lcom/badlogic/gdx/utils/Array;", "Lglm/vec3/Vec3;", "looping", "", "(Lcom/mygdx/game/Config;Lcom/mygdx/game/Camera;Lcom/badlogic/gdx/utils/Array;Z)V", "MAX_VERTS", "", "getMAX_VERTS", "()I", "value", "", "at", "getAt", "()F", "setAt", "(F)V", "getAttachedCamera", "()Lcom/mygdx/game/Camera;", "setAttachedCamera", "(Lcom/mygdx/game/Camera;)V", "direction", "getDirection", "()Z", "lockView", "getLockView", "setLockView", "(Z)V", "lookatObject", "Lcom/mygdx/game/DemoObject;", "getLookatObject", "()Lcom/mygdx/game/DemoObject;", "setLookatObject", "(Lcom/mygdx/game/DemoObject;)V", "spline", "Lcom/badlogic/gdx/math/CatmullRomSpline;", "Lcom/badlogic/gdx/math/Vector3;", "getSpline", "()Lcom/badlogic/gdx/math/CatmullRomSpline;", "setSpline", "(Lcom/badlogic/gdx/math/CatmullRomSpline;)V", "wobblyCamera", "getWobblyCamera", "setWobblyCamera", "render", "", "delta", "cam", "reset", "update", "core"})
public final class CameraPath
extends Drawable {
    private final int MAX_VERTS = 0;
    private final boolean direction = false;
    private boolean lockView;
    @Nullable
    private DemoObject lookatObject;
    private boolean wobblyCamera;
    @NotNull
    private CatmullRomSpline<Vector3> spline;
    private float at;
    @Nullable
    private Camera attachedCamera;

    @Override
    public void render(float delta, @NotNull Camera cam) {
        Intrinsics.checkParameterIsNotNull(cam, "cam");
    }

    @Override
    public int getMAX_VERTS() {
        return this.MAX_VERTS;
    }

    @Override
    public void reset() {
        this.setAt(0.0f);
    }

    public final boolean getDirection() {
        return this.direction;
    }

    public final boolean getLockView() {
        return this.lockView;
    }

    public final void setLockView(boolean bl) {
        this.lockView = bl;
    }

    @Nullable
    public final DemoObject getLookatObject() {
        return this.lookatObject;
    }

    public final void setLookatObject(@Nullable DemoObject demoObject) {
        this.lookatObject = demoObject;
    }

    public final boolean getWobblyCamera() {
        return this.wobblyCamera;
    }

    public final void setWobblyCamera(boolean bl) {
        this.wobblyCamera = bl;
    }

    @NotNull
    public final CatmullRomSpline<Vector3> getSpline() {
        return this.spline;
    }

    public final void setSpline(@NotNull CatmullRomSpline<Vector3> catmullRomSpline) {
        Intrinsics.checkParameterIsNotNull(catmullRomSpline, "<set-?>");
        this.spline = catmullRomSpline;
    }

    public final float getAt() {
        return this.at;
    }

    public final void setAt(float value) {
        this.at = MathUtils.clamp(value, 0.0f, 1.0f);
    }

    @Override
    public void update(float delta, @NotNull Camera cam) {
        Intrinsics.checkParameterIsNotNull(cam, "cam");
        float camat = MathUtils.clamp(this.at, 0.0f, 1.0f);
        Vector3 vector3 = this.spline.valueAt((Vector3)((Vector)new Vector3()), camat);
        Intrinsics.checkExpressionValueIsNotNull(vector3, "spline.valueAt(Vector3(), camat)");
        Vec3 v = UtilsKt.vector3gdx2glm(vector3);
        Vector3 vector32 = this.spline.derivativeAt((Vector3)((Vector)new Vector3()), camat);
        Intrinsics.checkExpressionValueIsNotNull(vector32, "spline.derivativeAt(Vector3(), camat)");
        Vec3 t = Vec3.normalize$default(UtilsKt.vector3gdx2glm(vector32), null, 1, null);
        if (this.attachedCamera != null) {
            Camera camera = this.attachedCamera;
            if (camera == null) {
                Intrinsics.throwNpe();
            }
            camera.setPos(v);
            if (this.lockView) {
                Object object;
                Camera camera2 = this.attachedCamera;
                if (camera2 == null) {
                    Intrinsics.throwNpe();
                }
                if ((object = this.lookatObject) == null || (object = ((DemoObject)object).getPos()) == null) {
                    Camera camera3 = this.attachedCamera;
                    if (camera3 == null) {
                        Intrinsics.throwNpe();
                    }
                    object = camera3.getPos().plus(t);
                }
                camera2.setLookAt((Vec3)object);
                Camera camera4 = this.attachedCamera;
                if (camera4 == null) {
                    Intrinsics.throwNpe();
                }
                camera4.setUp(new Vec3((Number)0, (Number)1, (Number)0));
            }
        }
    }

    @Nullable
    public final Camera getAttachedCamera() {
        return this.attachedCamera;
    }

    public final void setAttachedCamera(@Nullable Camera camera) {
        this.attachedCamera = camera;
    }

    /*
     * WARNING - void declaration
     */
    public CameraPath(@NotNull Config cfg, @Nullable Camera attachedCamera, @NotNull Array<Vec3> points, boolean looping) {
        Intrinsics.checkParameterIsNotNull(cfg, "cfg");
        Intrinsics.checkParameterIsNotNull(points, "points");
        super(cfg);
        this.attachedCamera = attachedCamera;
        Array<Vector3> convertedPoints = new Array<Vector3>();
        int n = 0;
        int n2 = points.size - 1;
        if (n <= n2) {
            while (true) {
                void i;
                Vec3 vec3 = points.get((int)i);
                Intrinsics.checkExpressionValueIsNotNull(vec3, "points.get(i)");
                convertedPoints.add(UtilsKt.vector3glm2gdx(vec3));
                if (i == n2) break;
                ++i;
            }
        }
        this.spline = new CatmullRomSpline((Vector[])convertedPoints.toArray(Vector3.class), looping);
    }
}

