/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.game;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.mygdx.game.Drawable;
import com.mygdx.game.InitDemoException;
import com.mygdx.game.RuntimeDemoException;
import com.mygdx.game.VertexContainer;
import glm.vec3.Vec3;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0017\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001.B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J(\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00032\b\b\u0002\u0010\"\u001a\u00020\u0003J\u0016\u0010#\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\b2\u0006\u0010%\u001a\u00020&J&\u0010'\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\b2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)2\u0006\u0010+\u001a\u00020,J\u0016\u0010-\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003R6\u0010\u0006\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t`\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0011\"\u0004\b\u001a\u0010\u0013\u00a8\u0006/"}, d2={"Lcom/mygdx/game/LineVertexBlock;", "Lcom/mygdx/game/VertexContainer;", "maxVertices", "", "maxIndices", "(II)V", "areas", "Ljava/util/HashMap;", "Lcom/mygdx/game/Drawable;", "Lcom/mygdx/game/LineVertexBlock$IndexArea;", "Lkotlin/collections/HashMap;", "getAreas", "()Ljava/util/HashMap;", "setAreas", "(Ljava/util/HashMap;)V", "indexAreaPointer", "getIndexAreaPointer", "()I", "setIndexAreaPointer", "(I)V", "indices", "", "getIndices", "()[S", "vertexAreaPointer", "getVertexAreaPointer", "setVertexAreaPointer", "flush", "", "mesh", "Lcom/badlogic/gdx/graphics/Mesh;", "sp", "Lcom/badlogic/gdx/graphics/glutils/ShaderProgram;", "mode", "offset", "queueIndex", "d", "value", "", "queueVertex", "pos", "Lglm/vec3/Vec3;", "normal", "color", "Lcom/badlogic/gdx/graphics/Color;", "register", "IndexArea", "core"})
public final class LineVertexBlock
extends VertexContainer {
    private int vertexAreaPointer;
    private int indexAreaPointer;
    @NotNull
    private HashMap<Drawable, IndexArea> areas = new HashMap();
    @NotNull
    private final short[] indices;

    public final int getVertexAreaPointer() {
        return this.vertexAreaPointer;
    }

    public final void setVertexAreaPointer(int n) {
        this.vertexAreaPointer = n;
    }

    public final int getIndexAreaPointer() {
        return this.indexAreaPointer;
    }

    public final void setIndexAreaPointer(int n) {
        this.indexAreaPointer = n;
    }

    @NotNull
    public final HashMap<Drawable, IndexArea> getAreas() {
        return this.areas;
    }

    public final void setAreas(@NotNull HashMap<Drawable, IndexArea> hashMap) {
        Intrinsics.checkParameterIsNotNull(hashMap, "<set-?>");
        this.areas = hashMap;
    }

    @NotNull
    public final short[] getIndices() {
        return this.indices;
    }

    public final void queueVertex(@NotNull Drawable d, @NotNull Vec3 pos, @NotNull Vec3 normal, @NotNull Color color) {
        Intrinsics.checkParameterIsNotNull(d, "d");
        Intrinsics.checkParameterIsNotNull(pos, "pos");
        Intrinsics.checkParameterIsNotNull(normal, "normal");
        Intrinsics.checkParameterIsNotNull(color, "color");
        try {
            float[] fArray = this.getVertices();
            IndexArea indexArea = this.areas.get(d);
            if (indexArea == null) {
                Intrinsics.throwNpe();
            }
            fArray[indexArea.qv()] = pos.x.floatValue();
            float[] fArray2 = this.getVertices();
            IndexArea indexArea2 = this.areas.get(d);
            if (indexArea2 == null) {
                Intrinsics.throwNpe();
            }
            fArray2[indexArea2.qv()] = pos.y.floatValue();
            float[] fArray3 = this.getVertices();
            IndexArea indexArea3 = this.areas.get(d);
            if (indexArea3 == null) {
                Intrinsics.throwNpe();
            }
            fArray3[indexArea3.qv()] = pos.z.floatValue();
            float[] fArray4 = this.getVertices();
            IndexArea indexArea4 = this.areas.get(d);
            if (indexArea4 == null) {
                Intrinsics.throwNpe();
            }
            fArray4[indexArea4.qv()] = normal.x.floatValue();
            float[] fArray5 = this.getVertices();
            IndexArea indexArea5 = this.areas.get(d);
            if (indexArea5 == null) {
                Intrinsics.throwNpe();
            }
            fArray5[indexArea5.qv()] = normal.y.floatValue();
            float[] fArray6 = this.getVertices();
            IndexArea indexArea6 = this.areas.get(d);
            if (indexArea6 == null) {
                Intrinsics.throwNpe();
            }
            fArray6[indexArea6.qv()] = normal.z.floatValue();
            float[] fArray7 = this.getVertices();
            IndexArea indexArea7 = this.areas.get(d);
            if (indexArea7 == null) {
                Intrinsics.throwNpe();
            }
            fArray7[indexArea7.qv()] = color.r;
            float[] fArray8 = this.getVertices();
            IndexArea indexArea8 = this.areas.get(d);
            if (indexArea8 == null) {
                Intrinsics.throwNpe();
            }
            fArray8[indexArea8.qv()] = color.g;
            float[] fArray9 = this.getVertices();
            IndexArea indexArea9 = this.areas.get(d);
            if (indexArea9 == null) {
                Intrinsics.throwNpe();
            }
            fArray9[indexArea9.qv()] = color.b;
        }
        catch (NullPointerException e) {
            throw (Throwable)new RuntimeDemoException("Drawable is not registered.");
        }
        catch (IndexOutOfBoundsException e) {
            String tag$iv = "[DEBUG]";
            Application application = Gdx.app;
            Intrinsics.checkExpressionValueIsNotNull(application, "Gdx.app");
            if (application.getLogLevel() >= 3) {
                String string = tag$iv;
                Application application2 = Gdx.app;
                String string2 = "warning: line vertices out of bounds!";
                application2.debug(string, string2);
            }
            throw (Throwable)e;
        }
    }

    public final void queueIndex(@NotNull Drawable d, short value) {
        IndexArea d2;
        Intrinsics.checkParameterIsNotNull(d, "d");
        IndexArea indexArea = d2 = this.areas.get(d);
        if (indexArea == null) {
            Intrinsics.throwNpe();
        }
        int i = indexArea.qi();
        this.indices[i] = (short)(d2.startAsNumVerts() + value);
    }

    public final void register(@NotNull Drawable d, int maxVertices) {
        Intrinsics.checkParameterIsNotNull(d, "d");
        if (this.areas.containsKey(d)) {
            throw (Throwable)new RuntimeDemoException("cannot register same DrawableMesh twice!");
        }
        int maxInd = maxVertices / 3 / 3 / 3 * 6;
        int vstart = this.vertexAreaPointer;
        int vend = vstart + maxVertices;
        int istart = this.indexAreaPointer;
        int iend = istart + maxInd;
        this.areas.put(d, new IndexArea(vstart, vend, istart, iend));
        this.vertexAreaPointer += maxVertices;
        this.indexAreaPointer += maxInd;
        if (this.vertexAreaPointer > this.getMaxVertices()) {
            throw (Throwable)new InitDemoException("max VertexBlock capacity reached! " + this.vertexAreaPointer + " > " + this.getMaxVertices());
        }
    }

    public final void flush(@NotNull Mesh mesh, @NotNull ShaderProgram sp, int mode, int offset) {
        Intrinsics.checkParameterIsNotNull(mesh, "mesh");
        Intrinsics.checkParameterIsNotNull(sp, "sp");
        mesh.setVertices(this.getVertices());
        mesh.setIndices(this.indices);
        mesh.render(sp, mode, offset, this.vertexAreaPointer);
        Map map = this.areas;
        Iterator iterator2 = map.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator2.next();
            Drawable key = (Drawable)entry2.getKey();
            entry2 = entry;
            IndexArea value = (IndexArea)entry2.getValue();
            value.reset();
        }
    }

    public static /* synthetic */ void flush$default(LineVertexBlock lineVertexBlock, Mesh mesh, ShaderProgram shaderProgram, int n, int n2, int n3, Object object) {
        if ((n3 & 8) != 0) {
            n2 = 0;
        }
        lineVertexBlock.flush(mesh, shaderProgram, n, n2);
    }

    public LineVertexBlock(int maxVertices, int maxIndices) {
        super(maxVertices);
        this.indices = new short[maxIndices];
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0016\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00d6\u0001J\u0006\u0010\u001d\u001a\u00020\u0003J\u0006\u0010\u001e\u001a\u00020\u0003J\u0006\u0010\u001f\u001a\u00020 J\u0006\u0010!\u001a\u00020\u0003J\t\u0010\"\u001a\u00020#H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u001a\u0010\u000b\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\t\"\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\tR\u001a\u0010\u0011\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\t\"\u0004\b\u0013\u0010\u000e\u00a8\u0006$"}, d2={"Lcom/mygdx/game/LineVertexBlock$IndexArea;", "", "vStart", "", "vEnd", "iStart", "iEnd", "(IIII)V", "getIEnd", "()I", "getIStart", "indicesIndex", "getIndicesIndex", "setIndicesIndex", "(I)V", "getVEnd", "getVStart", "vertIndex", "getVertIndex", "setVertIndex", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "qi", "qv", "reset", "", "startAsNumVerts", "toString", "", "core"})
    public static final class IndexArea {
        private int vertIndex;
        private int indicesIndex;
        private final int vStart;
        private final int vEnd;
        private final int iStart;
        private final int iEnd;

        public final int getVertIndex() {
            return this.vertIndex;
        }

        public final void setVertIndex(int n) {
            this.vertIndex = n;
        }

        public final int getIndicesIndex() {
            return this.indicesIndex;
        }

        public final void setIndicesIndex(int n) {
            this.indicesIndex = n;
        }

        public final void reset() {
            this.vertIndex = this.vStart;
            this.indicesIndex = this.iStart;
        }

        public final int qv() {
            int s = this.vertIndex;
            int n = this.vertIndex;
            this.vertIndex = n + 1;
            return s;
        }

        public final int startAsNumVerts() {
            return this.vStart / 9;
        }

        public final int qi() {
            int i = this.indicesIndex;
            int n = this.indicesIndex;
            this.indicesIndex = n + 1;
            return i;
        }

        public final int getVStart() {
            return this.vStart;
        }

        public final int getVEnd() {
            return this.vEnd;
        }

        public final int getIStart() {
            return this.iStart;
        }

        public final int getIEnd() {
            return this.iEnd;
        }

        public IndexArea(int vStart, int vEnd, int iStart, int iEnd) {
            this.vStart = vStart;
            this.vEnd = vEnd;
            this.iStart = iStart;
            this.iEnd = iEnd;
            this.vertIndex = this.vStart;
            this.indicesIndex = this.iStart;
        }

        public final int component1() {
            return this.vStart;
        }

        public final int component2() {
            return this.vEnd;
        }

        public final int component3() {
            return this.iStart;
        }

        public final int component4() {
            return this.iEnd;
        }

        @NotNull
        public final IndexArea copy(int vStart, int vEnd, int iStart, int iEnd) {
            return new IndexArea(vStart, vEnd, iStart, iEnd);
        }

        @NotNull
        public static /* synthetic */ IndexArea copy$default(IndexArea indexArea, int n, int n2, int n3, int n4, int n5, Object object) {
            if ((n5 & 1) != 0) {
                n = indexArea.vStart;
            }
            if ((n5 & 2) != 0) {
                n2 = indexArea.vEnd;
            }
            if ((n5 & 4) != 0) {
                n3 = indexArea.iStart;
            }
            if ((n5 & 8) != 0) {
                n4 = indexArea.iEnd;
            }
            return indexArea.copy(n, n2, n3, n4);
        }

        @NotNull
        public String toString() {
            return "IndexArea(vStart=" + this.vStart + ", vEnd=" + this.vEnd + ", iStart=" + this.iStart + ", iEnd=" + this.iEnd + ")";
        }

        public int hashCode() {
            return ((this.vStart * 31 + this.vEnd) * 31 + this.iStart) * 31 + this.iEnd;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof IndexArea)) break block3;
                    IndexArea indexArea = (IndexArea)object;
                    if (!(this.vStart == indexArea.vStart) || !(this.vEnd == indexArea.vEnd) || !(this.iStart == indexArea.iStart) || !(this.iEnd == indexArea.iEnd)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

