/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.game;

import com.badlogic.gdx.graphics.Texture;
import com.mygdx.game.Camera;
import com.mygdx.game.Config;
import com.mygdx.game.CustomFramebuffer;
import com.mygdx.game.PostProcessingBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0019"}, d2={"Lcom/mygdx/game/FramebufferRenderer;", "", "cfg", "Lcom/mygdx/game/Config;", "framebuffer", "Lcom/mygdx/game/CustomFramebuffer;", "pb", "Lcom/mygdx/game/PostProcessingBuffer;", "(Lcom/mygdx/game/Config;Lcom/mygdx/game/CustomFramebuffer;Lcom/mygdx/game/PostProcessingBuffer;)V", "getCfg", "()Lcom/mygdx/game/Config;", "getFramebuffer", "()Lcom/mygdx/game/CustomFramebuffer;", "nullCamera", "Lcom/mygdx/game/Camera;", "getNullCamera", "()Lcom/mygdx/game/Camera;", "getPb", "()Lcom/mygdx/game/PostProcessingBuffer;", "getScreenTexture", "Lcom/badlogic/gdx/graphics/Texture;", "render", "", "delta", "", "core"})
public class FramebufferRenderer {
    @NotNull
    private final Camera nullCamera;
    @NotNull
    private final Config cfg;
    @NotNull
    private final CustomFramebuffer framebuffer;
    @NotNull
    private final PostProcessingBuffer pb;

    @NotNull
    public final Camera getNullCamera() {
        return this.nullCamera;
    }

    @NotNull
    public Texture getScreenTexture() {
        return this.framebuffer.getTexture();
    }

    public void render(float delta) {
        this.pb.render(delta, this.nullCamera);
    }

    @NotNull
    public final Config getCfg() {
        return this.cfg;
    }

    @NotNull
    public final CustomFramebuffer getFramebuffer() {
        return this.framebuffer;
    }

    @NotNull
    public final PostProcessingBuffer getPb() {
        return this.pb;
    }

    public FramebufferRenderer(@NotNull Config cfg, @NotNull CustomFramebuffer framebuffer, @NotNull PostProcessingBuffer pb) {
        Intrinsics.checkParameterIsNotNull(cfg, "cfg");
        Intrinsics.checkParameterIsNotNull(framebuffer, "framebuffer");
        Intrinsics.checkParameterIsNotNull(pb, "pb");
        this.cfg = cfg;
        this.framebuffer = framebuffer;
        this.pb = pb;
        this.nullCamera = new Camera(this.cfg, null, null, null, 14, null);
        PostProcessingBuffer.attachFBTexture$default(this.pb, this.getScreenTexture(), 0, 2, null);
    }
}

