/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.game;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.viewport.FitViewport;
import com.mygdx.game.BloomShader;
import com.mygdx.game.BlurShader;
import com.mygdx.game.Camera;
import com.mygdx.game.CombineBuffer;
import com.mygdx.game.Config;
import com.mygdx.game.CubeMap;
import com.mygdx.game.CustomFramebuffer;
import com.mygdx.game.Drawable;
import com.mygdx.game.FramebufferRenderer;
import com.mygdx.game.HDRShader;
import com.mygdx.game.ScreenTextureShader;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010;\u001a\u00020<H\u0016J2\u0010=\u001a\u00020<2\u0006\u0010>\u001a\u00020?2\f\u0010@\u001a\b\u0012\u0004\u0012\u00020B0A2\f\u0010C\u001a\b\u0012\u0004\u0012\u00020B0A2\u0006\u0010D\u001a\u00020EJ\u0016\u0010F\u001a\u00020<2\u0006\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020HJ$\u0010J\u001a\u00020<2\u0006\u0010>\u001a\u00020?2\f\u0010@\u001a\b\u0012\u0004\u0012\u00020B0A2\u0006\u0010D\u001a\u00020ER\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0012X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0014\"\u0004\b\u0019\u0010\u0016R\u001a\u0010\u001a\u001a\u00020\u0012X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0014\"\u0004\b\u001c\u0010\u0016R\u001a\u0010\u001d\u001a\u00020\u0012X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0014\"\u0004\b\u001f\u0010\u0016R\u001a\u0010 \u001a\u00020\u0012X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0014\"\u0004\b\"\u0010\u0016R\u0011\u0010#\u001a\u00020$\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u001a\u0010'\u001a\u00020(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u001a\u0010-\u001a\u00020(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010*\"\u0004\b/\u0010,R\u0011\u00100\u001a\u000201\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u001a\u00104\u001a\u00020\u0012X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u0010\u0014\"\u0004\b6\u0010\u0016R\u0011\u00107\u001a\u000208\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010:\u00a8\u0006K"}, d2={"Lcom/mygdx/game/DrawManager;", "Lcom/badlogic/gdx/utils/Disposable;", "cfg", "Lcom/mygdx/game/Config;", "(Lcom/mygdx/game/Config;)V", "getCfg", "()Lcom/mygdx/game/Config;", "combineBloom", "Lcom/mygdx/game/CombineBuffer;", "getCombineBloom", "()Lcom/mygdx/game/CombineBuffer;", "cubemap", "Lcom/mygdx/game/CubeMap;", "getCubemap", "()Lcom/mygdx/game/CubeMap;", "setCubemap", "(Lcom/mygdx/game/CubeMap;)V", "extractBright", "Lcom/mygdx/game/FramebufferRenderer;", "getExtractBright", "()Lcom/mygdx/game/FramebufferRenderer;", "setExtractBright", "(Lcom/mygdx/game/FramebufferRenderer;)V", "hdr", "getHdr", "setHdr", "horiBlur", "getHoriBlur", "setHoriBlur", "lastPass", "getLastPass", "setLastPass", "normalScene", "getNormalScene", "setNormalScene", "sb", "Lcom/badlogic/gdx/graphics/g2d/SpriteBatch;", "getSb", "()Lcom/badlogic/gdx/graphics/g2d/SpriteBatch;", "scene", "Lcom/mygdx/game/CustomFramebuffer;", "getScene", "()Lcom/mygdx/game/CustomFramebuffer;", "setScene", "(Lcom/mygdx/game/CustomFramebuffer;)V", "separate", "getSeparate", "setSeparate", "sr", "Lcom/badlogic/gdx/graphics/glutils/ShapeRenderer;", "getSr", "()Lcom/badlogic/gdx/graphics/glutils/ShapeRenderer;", "vertBlur", "getVertBlur", "setVertBlur", "viewport", "Lcom/badlogic/gdx/utils/viewport/FitViewport;", "getViewport", "()Lcom/badlogic/gdx/utils/viewport/FitViewport;", "dispose", "", "render", "delta", "", "drawables", "Lcom/badlogic/gdx/utils/Array;", "Lcom/mygdx/game/Drawable;", "drawablesBlendSkyBox", "cam", "Lcom/mygdx/game/Camera;", "resize", "width", "", "height", "update", "core"})
public final class DrawManager
implements Disposable {
    @NotNull
    public FramebufferRenderer normalScene;
    @NotNull
    public FramebufferRenderer hdr;
    @NotNull
    public FramebufferRenderer vertBlur;
    @NotNull
    public FramebufferRenderer horiBlur;
    @NotNull
    public FramebufferRenderer extractBright;
    @NotNull
    public FramebufferRenderer lastPass;
    @NotNull
    public CubeMap cubemap;
    @NotNull
    private CustomFramebuffer scene;
    @NotNull
    private CustomFramebuffer separate;
    @NotNull
    private final CombineBuffer combineBloom;
    @NotNull
    private final FitViewport viewport;
    @NotNull
    private final ShapeRenderer sr;
    @NotNull
    private final SpriteBatch sb;
    @NotNull
    private final Config cfg;

    @Override
    public void dispose() {
        this.sb.dispose();
        this.sr.dispose();
        this.scene.dispose();
        this.separate.dispose();
    }

    @NotNull
    public final FramebufferRenderer getNormalScene() {
        FramebufferRenderer framebufferRenderer = this.normalScene;
        if (framebufferRenderer == null) {
            Intrinsics.throwUninitializedPropertyAccessException("normalScene");
        }
        return framebufferRenderer;
    }

    public final void setNormalScene(@NotNull FramebufferRenderer framebufferRenderer) {
        Intrinsics.checkParameterIsNotNull(framebufferRenderer, "<set-?>");
        this.normalScene = framebufferRenderer;
    }

    @NotNull
    public final FramebufferRenderer getHdr() {
        FramebufferRenderer framebufferRenderer = this.hdr;
        if (framebufferRenderer == null) {
            Intrinsics.throwUninitializedPropertyAccessException("hdr");
        }
        return framebufferRenderer;
    }

    public final void setHdr(@NotNull FramebufferRenderer framebufferRenderer) {
        Intrinsics.checkParameterIsNotNull(framebufferRenderer, "<set-?>");
        this.hdr = framebufferRenderer;
    }

    @NotNull
    public final FramebufferRenderer getVertBlur() {
        FramebufferRenderer framebufferRenderer = this.vertBlur;
        if (framebufferRenderer == null) {
            Intrinsics.throwUninitializedPropertyAccessException("vertBlur");
        }
        return framebufferRenderer;
    }

    public final void setVertBlur(@NotNull FramebufferRenderer framebufferRenderer) {
        Intrinsics.checkParameterIsNotNull(framebufferRenderer, "<set-?>");
        this.vertBlur = framebufferRenderer;
    }

    @NotNull
    public final FramebufferRenderer getHoriBlur() {
        FramebufferRenderer framebufferRenderer = this.horiBlur;
        if (framebufferRenderer == null) {
            Intrinsics.throwUninitializedPropertyAccessException("horiBlur");
        }
        return framebufferRenderer;
    }

    public final void setHoriBlur(@NotNull FramebufferRenderer framebufferRenderer) {
        Intrinsics.checkParameterIsNotNull(framebufferRenderer, "<set-?>");
        this.horiBlur = framebufferRenderer;
    }

    @NotNull
    public final FramebufferRenderer getExtractBright() {
        FramebufferRenderer framebufferRenderer = this.extractBright;
        if (framebufferRenderer == null) {
            Intrinsics.throwUninitializedPropertyAccessException("extractBright");
        }
        return framebufferRenderer;
    }

    public final void setExtractBright(@NotNull FramebufferRenderer framebufferRenderer) {
        Intrinsics.checkParameterIsNotNull(framebufferRenderer, "<set-?>");
        this.extractBright = framebufferRenderer;
    }

    @NotNull
    public final FramebufferRenderer getLastPass() {
        FramebufferRenderer framebufferRenderer = this.lastPass;
        if (framebufferRenderer == null) {
            Intrinsics.throwUninitializedPropertyAccessException("lastPass");
        }
        return framebufferRenderer;
    }

    public final void setLastPass(@NotNull FramebufferRenderer framebufferRenderer) {
        Intrinsics.checkParameterIsNotNull(framebufferRenderer, "<set-?>");
        this.lastPass = framebufferRenderer;
    }

    @NotNull
    public final CubeMap getCubemap() {
        CubeMap cubeMap = this.cubemap;
        if (cubeMap == null) {
            Intrinsics.throwUninitializedPropertyAccessException("cubemap");
        }
        return cubeMap;
    }

    public final void setCubemap(@NotNull CubeMap cubeMap) {
        Intrinsics.checkParameterIsNotNull(cubeMap, "<set-?>");
        this.cubemap = cubeMap;
    }

    @NotNull
    public final CustomFramebuffer getScene() {
        return this.scene;
    }

    public final void setScene(@NotNull CustomFramebuffer customFramebuffer) {
        Intrinsics.checkParameterIsNotNull(customFramebuffer, "<set-?>");
        this.scene = customFramebuffer;
    }

    @NotNull
    public final CustomFramebuffer getSeparate() {
        return this.separate;
    }

    public final void setSeparate(@NotNull CustomFramebuffer customFramebuffer) {
        Intrinsics.checkParameterIsNotNull(customFramebuffer, "<set-?>");
        this.separate = customFramebuffer;
    }

    @NotNull
    public final CombineBuffer getCombineBloom() {
        return this.combineBloom;
    }

    @NotNull
    public final FitViewport getViewport() {
        return this.viewport;
    }

    @NotNull
    public final ShapeRenderer getSr() {
        return this.sr;
    }

    @NotNull
    public final SpriteBatch getSb() {
        return this.sb;
    }

    public final void update(float delta, @NotNull Array<Drawable> drawables, @NotNull Camera cam) {
        Intrinsics.checkParameterIsNotNull(drawables, "drawables");
        Intrinsics.checkParameterIsNotNull(cam, "cam");
        Iterable $receiver$iv = drawables;
        for (Object element$iv : $receiver$iv) {
            Drawable it = (Drawable)element$iv;
            it.update(delta, cam);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void render(float delta, @NotNull Array<Drawable> drawables, @NotNull Array<Drawable> drawablesBlendSkyBox, @NotNull Camera cam) {
        Drawable it;
        Intrinsics.checkParameterIsNotNull(drawables, "drawables");
        Intrinsics.checkParameterIsNotNull(drawablesBlendSkyBox, "drawablesBlendSkyBox");
        Intrinsics.checkParameterIsNotNull(cam, "cam");
        Gdx.gl20.glEnable(2929);
        Gdx.gl20.glDepthFunc(513);
        Gdx.gl20.glEnable(2960);
        Gdx.gl20.glStencilOp(7680, 7680, 7681);
        Gdx.gl20.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl20.glClear(16384);
        Gdx.gl20.glClear(256);
        FramebufferRenderer framebufferRenderer = this.normalScene;
        if (framebufferRenderer == null) {
            Intrinsics.throwUninitializedPropertyAccessException("normalScene");
        }
        FramebufferRenderer $receiver$iv = framebufferRenderer;
        $receiver$iv.getFramebuffer().begin();
        FramebufferRenderer it2 = $receiver$iv;
        FramebufferRenderer framebufferRenderer2 = this.normalScene;
        if (framebufferRenderer2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("normalScene");
        }
        framebufferRenderer2.getPb().setUniform("darkAmount", Float.valueOf(1.0f));
        Gdx.gl20.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        Gdx.gl20.glClear(16640);
        Gdx.gl20.glStencilMask(255);
        Gdx.gl20.glClear(1024);
        Gdx.gl20.glStencilMask(0);
        Iterable $receiver$iv2 = drawables;
        for (Object element$iv : $receiver$iv2) {
            it = (Drawable)element$iv;
            it.render(delta, cam);
        }
        Gdx.gl20.glStencilMask(255);
        Gdx.gl20.glClear(1024);
        if (this.cfg.getEnableSkybox()) {
            Gdx.gl20.glStencilFunc(519, 1, 255);
            Gdx.gl20.glStencilMask(255);
            Gdx.gl20.glDepthFunc(515);
            Gdx.gl20.glDepthMask(false);
            CubeMap cubeMap = this.cubemap;
            if (cubeMap == null) {
                Intrinsics.throwUninitializedPropertyAccessException("cubemap");
            }
            cubeMap.render(delta, cam);
            Gdx.gl20.glDepthMask(true);
            Gdx.gl20.glDepthFunc(513);
            Gdx.gl20.glStencilMask(0);
        }
        $receiver$iv2 = drawablesBlendSkyBox;
        for (Object element$iv : $receiver$iv2) {
            it = (Drawable)element$iv;
            it.render(delta, cam);
        }
        $receiver$iv.getFramebuffer().end();
        Gdx.gl20.glStencilMask(0);
        if (this.cfg.getEnableBloom()) {
            FramebufferRenderer framebufferRenderer3 = this.hdr;
            if (framebufferRenderer3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("hdr");
            }
            $receiver$iv = framebufferRenderer3;
            $receiver$iv.getFramebuffer().begin();
            it2 = $receiver$iv;
            Gdx.gl20.glClear(16640);
            Gdx.gl20.glStencilFunc(517, 1, 255);
            Gdx.gl20.glStencilMask(0);
            FramebufferRenderer framebufferRenderer4 = this.normalScene;
            if (framebufferRenderer4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("normalScene");
            }
            framebufferRenderer4.render(delta);
            Gdx.gl20.glStencilMask(255);
            Gdx.gl20.glClear(1024);
            Gdx.gl20.glStencilMask(0);
            $receiver$iv.getFramebuffer().end();
            FramebufferRenderer framebufferRenderer5 = this.extractBright;
            if (framebufferRenderer5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("extractBright");
            }
            $receiver$iv = framebufferRenderer5;
            $receiver$iv.getFramebuffer().begin();
            it2 = $receiver$iv;
            FramebufferRenderer framebufferRenderer6 = this.hdr;
            if (framebufferRenderer6 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("hdr");
            }
            framebufferRenderer6.render(delta);
            $receiver$iv.getFramebuffer().end();
            FramebufferRenderer framebufferRenderer7 = this.vertBlur;
            if (framebufferRenderer7 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("vertBlur");
            }
            $receiver$iv = framebufferRenderer7;
            $receiver$iv.getFramebuffer().begin();
            it2 = $receiver$iv;
            FramebufferRenderer framebufferRenderer8 = this.extractBright;
            if (framebufferRenderer8 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("extractBright");
            }
            framebufferRenderer8.render(delta);
            $receiver$iv.getFramebuffer().end();
            float div = MathUtils.clamp(this.cfg.getBloomDiv(), 4.0f, 20.0f);
            Float[] kernel = new Float[]{Float.valueOf(0.382925f), Float.valueOf(0.24173f), Float.valueOf(0.060598f), Float.valueOf(0.005977f), Float.valueOf(2.29E-4f)};
            int $i$a$4$renderOnThis = 0;
            int $i$f$renderOnThis = kernel.length;
            while ($i$a$4$renderOnThis < $i$f$renderOnThis) {
                void i;
                FramebufferRenderer framebufferRenderer9 = this.vertBlur;
                if (framebufferRenderer9 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("vertBlur");
                }
                framebufferRenderer9.getPb().setUniform("w" + String.valueOf((int)i), kernel[i]);
                ++i;
            }
            FramebufferRenderer framebufferRenderer10 = this.vertBlur;
            if (framebufferRenderer10 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("vertBlur");
            }
            framebufferRenderer10.getPb().setUniform("horizontal", 0);
            FramebufferRenderer framebufferRenderer11 = this.vertBlur;
            if (framebufferRenderer11 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("vertBlur");
            }
            framebufferRenderer11.getPb().setUniform("targetHeight", Float.valueOf(this.cfg.getVirtualHeight() / div));
            FramebufferRenderer framebufferRenderer12 = this.horiBlur;
            if (framebufferRenderer12 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("horiBlur");
            }
            FramebufferRenderer $receiver$iv222 = framebufferRenderer12;
            $receiver$iv222.getFramebuffer().begin();
            FramebufferRenderer it222 = $receiver$iv222;
            FramebufferRenderer framebufferRenderer13 = this.vertBlur;
            if (framebufferRenderer13 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("vertBlur");
            }
            framebufferRenderer13.render(delta);
            $receiver$iv222.getFramebuffer().end();
            int $receiver$iv222 = 0;
            int it222 = kernel.length;
            while ($receiver$iv222 < it222) {
                void i;
                FramebufferRenderer framebufferRenderer14 = this.horiBlur;
                if (framebufferRenderer14 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("horiBlur");
                }
                framebufferRenderer14.getPb().setUniform("w" + String.valueOf((int)i), kernel[i]);
                ++i;
            }
            FramebufferRenderer framebufferRenderer15 = this.horiBlur;
            if (framebufferRenderer15 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("horiBlur");
            }
            framebufferRenderer15.getPb().setUniform("horizontal", 1);
            FramebufferRenderer framebufferRenderer16 = this.horiBlur;
            if (framebufferRenderer16 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("horiBlur");
            }
            framebufferRenderer16.getPb().setUniform("targetHeight", Float.valueOf(this.cfg.getVirtualWidth() / div));
            FramebufferRenderer framebufferRenderer17 = this.horiBlur;
            if (framebufferRenderer17 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("horiBlur");
            }
            Object $receiver$iv3 = framebufferRenderer17;
            ((FramebufferRenderer)$receiver$iv3).getFramebuffer().begin();
            Object it3 = $receiver$iv3;
            FramebufferRenderer framebufferRenderer18 = this.horiBlur;
            if (framebufferRenderer18 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("horiBlur");
            }
            framebufferRenderer18.render(delta);
            ((FramebufferRenderer)$receiver$iv3).getFramebuffer().end();
            this.viewport.apply();
            $receiver$iv3 = this.combineBloom.getTexture();
            it3 = 0;
            FramebufferRenderer framebufferRenderer19 = this.normalScene;
            if (framebufferRenderer19 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("normalScene");
            }
            Texture texture = framebufferRenderer19.getPb().getTexture().get(0);
            if (texture == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull(texture, "normalScene.pb.texture[0]!!");
            Texture $i$a$6$renderOnThis = texture;
            $receiver$iv3.put(it3, $i$a$6$renderOnThis);
            $receiver$iv3 = this.combineBloom.getTexture();
            it3 = 1;
            FramebufferRenderer framebufferRenderer20 = this.lastPass;
            if (framebufferRenderer20 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("lastPass");
            }
            Texture texture2 = framebufferRenderer20.getPb().getTexture().get(0);
            if (texture2 == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull(texture2, "lastPass.pb.texture[0]!!");
            $i$a$6$renderOnThis = texture2;
            $receiver$iv3.put(it3, $i$a$6$renderOnThis);
            this.combineBloom.setUniform("bloomIntensity", Float.valueOf(this.cfg.getBloomIntensity()));
            if (this.cfg.getScreenFadeDarkAmount() < 1.0f) {
                FramebufferRenderer framebufferRenderer21 = this.lastPass;
                if (framebufferRenderer21 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("lastPass");
                }
                $receiver$iv3 = framebufferRenderer21;
                ((FramebufferRenderer)$receiver$iv3).getFramebuffer().begin();
                it3 = $receiver$iv3;
                FramebufferRenderer framebufferRenderer22 = this.lastPass;
                if (framebufferRenderer22 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("lastPass");
                }
                framebufferRenderer22.getPb().setUniform("darkAmount", Float.valueOf(this.cfg.getScreenFadeDarkAmount()));
                FramebufferRenderer framebufferRenderer23 = this.lastPass;
                if (framebufferRenderer23 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("lastPass");
                }
                framebufferRenderer23.getPb().setUniform("brightAmount", Float.valueOf(this.cfg.getScreenFadeBrightAmount()));
                this.combineBloom.render(delta, cam);
                ((FramebufferRenderer)$receiver$iv3).getFramebuffer().end();
                this.viewport.apply();
                FramebufferRenderer framebufferRenderer24 = this.lastPass;
                if (framebufferRenderer24 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("lastPass");
                }
                framebufferRenderer24.render(delta);
            } else {
                this.viewport.apply();
                this.combineBloom.render(delta, cam);
            }
        } else {
            FramebufferRenderer framebufferRenderer25 = this.lastPass;
            if (framebufferRenderer25 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("lastPass");
            }
            $receiver$iv = framebufferRenderer25;
            $receiver$iv.getFramebuffer().begin();
            it2 = $receiver$iv;
            FramebufferRenderer framebufferRenderer26 = this.lastPass;
            if (framebufferRenderer26 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("lastPass");
            }
            framebufferRenderer26.getPb().setUniform("darkAmount", Float.valueOf(this.cfg.getScreenFadeDarkAmount()));
            FramebufferRenderer framebufferRenderer27 = this.normalScene;
            if (framebufferRenderer27 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("normalScene");
            }
            framebufferRenderer27.render(delta);
            $receiver$iv.getFramebuffer().end();
            this.viewport.apply();
            FramebufferRenderer framebufferRenderer28 = this.lastPass;
            if (framebufferRenderer28 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("lastPass");
            }
            framebufferRenderer28.render(delta);
        }
        this.sb.setProjectionMatrix(this.viewport.getCamera().combined);
    }

    public final void resize(int width, int height) {
        this.viewport.update(width, height);
    }

    @NotNull
    public final Config getCfg() {
        return this.cfg;
    }

    public DrawManager(@NotNull Config cfg) {
        Intrinsics.checkParameterIsNotNull(cfg, "cfg");
        this.cfg = cfg;
        this.cubemap = new CubeMap(this.cfg);
        this.scene = new CustomFramebuffer(Pixmap.Format.RGBA4444, (int)this.cfg.getVirtualWidth(), (int)this.cfg.getVirtualHeight(), true, true, 0, 32, null);
        this.separate = new CustomFramebuffer(Pixmap.Format.RGBA4444, (int)this.cfg.getVirtualWidth(), (int)this.cfg.getVirtualHeight(), false, true, this.scene.getStencilbufferHandle());
        this.normalScene = new FramebufferRenderer(this.cfg, this.scene, new ScreenTextureShader(this.cfg));
        this.hdr = new FramebufferRenderer(this.cfg, this.separate, new HDRShader(this.cfg));
        this.extractBright = new FramebufferRenderer(this.cfg, this.separate, new BloomShader(this.cfg));
        this.vertBlur = new FramebufferRenderer(this.cfg, this.separate, new BlurShader(this.cfg));
        this.horiBlur = new FramebufferRenderer(this.cfg, this.separate, new BlurShader(this.cfg));
        this.lastPass = new FramebufferRenderer(this.cfg, this.separate, new ScreenTextureShader(this.cfg));
        this.combineBloom = new CombineBuffer(this.cfg, "combine");
        this.viewport = new FitViewport(this.cfg.getVirtualWidth(), this.cfg.getVirtualHeight(), new OrthographicCamera());
        this.sr = new ShapeRenderer();
        this.sb = new SpriteBatch();
    }
}

