/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.game;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Cubemap;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.TextureData;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.mygdx.game.Camera;
import com.mygdx.game.Config;
import com.mygdx.game.DrawableMesh;
import com.mygdx.game.UtilsKt;
import com.mygdx.game.VertexBlock;
import glm.mat3x3.Mat3;
import glm.mat4x4.Mat4;
import glm.vec2.Vec2;
import glm.vec3.Vec3;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020'H\u0016J\u0018\u0010(\u001a\u00020$2\u0006\u0010%\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020'H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0019\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0013\u001a\u00020\u0014X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u001eX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"\u00a8\u0006)"}, d2={"Lcom/mygdx/game/CubeMap;", "Lcom/mygdx/game/DrawableMesh;", "cfg", "Lcom/mygdx/game/Config;", "(Lcom/mygdx/game/Config;)V", "MAX_VERTS", "", "getMAX_VERTS", "()I", "cubemap", "Lcom/badlogic/gdx/graphics/Cubemap;", "getCubemap", "()Lcom/badlogic/gdx/graphics/Cubemap;", "cubeverts", "", "", "getCubeverts", "()[Ljava/lang/Float;", "[Ljava/lang/Float;", "mesh", "Lcom/badlogic/gdx/graphics/Mesh;", "getMesh", "()Lcom/badlogic/gdx/graphics/Mesh;", "setMesh", "(Lcom/badlogic/gdx/graphics/Mesh;)V", "sp", "Lcom/badlogic/gdx/graphics/glutils/ShaderProgram;", "getSp", "()Lcom/badlogic/gdx/graphics/glutils/ShaderProgram;", "vertices", "Lcom/mygdx/game/VertexBlock;", "getVertices", "()Lcom/mygdx/game/VertexBlock;", "setVertices", "(Lcom/mygdx/game/VertexBlock;)V", "render", "", "delta", "cam", "Lcom/mygdx/game/Camera;", "update", "core"})
public final class CubeMap
extends DrawableMesh {
    private final int MAX_VERTS;
    @NotNull
    private Mesh mesh;
    @NotNull
    private VertexBlock vertices;
    @NotNull
    private final ShaderProgram sp;
    @NotNull
    private final Cubemap cubemap;
    @NotNull
    private final Float[] cubeverts;

    @Override
    public int getMAX_VERTS() {
        return this.MAX_VERTS;
    }

    @Override
    @NotNull
    public Mesh getMesh() {
        return this.mesh;
    }

    @Override
    public void setMesh(@NotNull Mesh mesh) {
        Intrinsics.checkParameterIsNotNull(mesh, "<set-?>");
        this.mesh = mesh;
    }

    @Override
    @NotNull
    public VertexBlock getVertices() {
        return this.vertices;
    }

    @Override
    public void setVertices(@NotNull VertexBlock vertexBlock) {
        Intrinsics.checkParameterIsNotNull(vertexBlock, "<set-?>");
        this.vertices = vertexBlock;
    }

    @NotNull
    public final ShaderProgram getSp() {
        return this.sp;
    }

    @NotNull
    public final Cubemap getCubemap() {
        return this.cubemap;
    }

    @NotNull
    public final Float[] getCubeverts() {
        return this.cubeverts;
    }

    @Override
    public void update(float delta, @NotNull Camera cam) {
        Intrinsics.checkParameterIsNotNull(cam, "cam");
    }

    @Override
    public void render(float delta, @NotNull Camera cam) {
        Intrinsics.checkParameterIsNotNull(cam, "cam");
        ShaderProgram $receiver$iv = this.sp;
        $receiver$iv.begin();
        ShaderProgram it = $receiver$iv;
        Gdx.gl20.glActiveTexture(33984);
        this.cubemap.bind();
        this.sp.setUniformi("texture", 0);
        UtilsKt.setUniformMatrix(this.sp, cam.projection(), "proj");
        UtilsKt.setUniformMatrix(this.sp, new Mat4(new Mat3(cam.view())), "view");
        VertexBlock.flush$default(this.getVertices(), this.getMesh(), this.sp, 4, 0, false, 0, 48, null);
        Gdx.gl20.glActiveTexture(33984);
        $receiver$iv.end();
    }

    /*
     * WARNING - void declaration
     */
    public CubeMap(@NotNull Config cfg) {
        Intrinsics.checkParameterIsNotNull(cfg, "cfg");
        super(cfg);
        this.MAX_VERTS = 256 * this.getPOSITION_COMPONENTS() * this.getNORMAL_COMPONENTS() * this.getTEXTURE_COMPONENTS();
        this.mesh = new Mesh(true, this.getMAX_VERTS(), 0, new VertexAttribute(1, this.getPOSITION_COMPONENTS(), "a_position"), new VertexAttribute(16, this.getTEXTURE_COMPONENTS(), "a_texCoords"));
        this.vertices = new VertexBlock(this.getMesh().getMaxVertices());
        this.sp = cfg.getShader("cubemap");
        Object t = cfg.getAssetManager().get("right.png");
        Intrinsics.checkExpressionValueIsNotNull(t, "cfg.assetManager.get<Texture>(\"right.png\")");
        TextureData textureData = ((Texture)t).getTextureData();
        Object t2 = cfg.getAssetManager().get("left.png");
        Intrinsics.checkExpressionValueIsNotNull(t2, "cfg.assetManager.get<Texture>(\"left.png\")");
        TextureData textureData2 = ((Texture)t2).getTextureData();
        Object t3 = cfg.getAssetManager().get("top.png");
        Intrinsics.checkExpressionValueIsNotNull(t3, "cfg.assetManager.get<Texture>(\"top.png\")");
        TextureData textureData3 = ((Texture)t3).getTextureData();
        Object t4 = cfg.getAssetManager().get("bottom.png");
        Intrinsics.checkExpressionValueIsNotNull(t4, "cfg.assetManager.get<Texture>(\"bottom.png\")");
        TextureData textureData4 = ((Texture)t4).getTextureData();
        Object t5 = cfg.getAssetManager().get("front.png");
        Intrinsics.checkExpressionValueIsNotNull(t5, "cfg.assetManager.get<Texture>(\"front.png\")");
        TextureData textureData5 = ((Texture)t5).getTextureData();
        Object t6 = cfg.getAssetManager().get("back.png");
        Intrinsics.checkExpressionValueIsNotNull(t6, "cfg.assetManager.get<Texture>(\"back.png\")");
        this.cubemap = new Cubemap(textureData, textureData2, textureData3, textureData4, textureData5, ((Texture)t6).getTextureData());
        this.cubeverts = new Float[]{Float.valueOf(-1.0f), Float.valueOf(1.0f), Float.valueOf(-1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(-1.0f), Float.valueOf(-1.0f), Float.valueOf(-1.0f), Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(-1.0f), Float.valueOf(-1.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(-1.0f), Float.valueOf(-1.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(-1.0f), Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(-1.0f), Float.valueOf(1.0f), Float.valueOf(-1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(-1.0f), Float.valueOf(-1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(-1.0f), Float.valueOf(-1.0f), Float.valueOf(-1.0f), Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(-1.0f), Float.valueOf(1.0f), Float.valueOf(-1.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(-1.0f), Float.valueOf(1.0f), Float.valueOf(-1.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(-1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(-1.0f), Float.valueOf(-1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(-1.0f), Float.valueOf(-1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(-1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(-1.0f), Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(-1.0f), Float.valueOf(-1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(-1.0f), Float.valueOf(-1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(-1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(-1.0f), Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(-1.0f), Float.valueOf(-1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(-1.0f), Float.valueOf(1.0f), Float.valueOf(-1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(-1.0f), Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(-1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(-1.0f), Float.valueOf(1.0f), Float.valueOf(-1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(-1.0f), Float.valueOf(-1.0f), Float.valueOf(-1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(-1.0f), Float.valueOf(-1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(-1.0f), Float.valueOf(-1.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(-1.0f), Float.valueOf(-1.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(-1.0f), Float.valueOf(-1.0f), Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(-1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f)};
        int n = 0;
        IntProgression intProgression = RangesKt.step(new IntRange(n, this.cubeverts.length - 1), 5);
        int n2 = intProgression.getFirst();
        int n3 = intProgression.getLast();
        int n4 = intProgression.getStep();
        int n5 = n2;
        int n6 = n3;
        if (n4 > 0 ? n5 <= n6 : n5 >= n6) {
            while (true) {
                void i;
                this.getVertices().queueVertex(new Vec3(this.cubeverts[i].floatValue(), this.cubeverts[i + true].floatValue(), this.cubeverts[i + 2].floatValue()), new Vec2(this.cubeverts[i + 3].floatValue(), this.cubeverts[i + 4].floatValue()));
                if (i == n3) break;
                n2 = i + n4;
            }
        }
        this.getMesh().setVertices(this.getVertices().getVertices());
    }
}

