/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.game;

import com.badlogic.gdx.math.MathUtils;
import com.mygdx.game.Camera;
import com.mygdx.game.Config;
import com.mygdx.game.ControllableCamera$WhenMappings;
import glm.func.func_geometric;
import glm.glm;
import glm.mat4x4.Mat4;
import glm.vec3.Vec3;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\f\u0018\u00002\u00020\u0001:\u00011B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bJ\b\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\u000e\u0010(\u001a\u00020$2\u0006\u0010)\u001a\u00020\u0019J\u000e\u0010*\u001a\u00020$2\u0006\u0010)\u001a\u00020\u0019J\u000e\u0010+\u001a\u00020$2\u0006\u0010)\u001a\u00020\u0019J\u000e\u0010,\u001a\u00020$2\u0006\u0010)\u001a\u00020\u0019J\u0018\u0010-\u001a\u00020$2\u0006\u0010.\u001a\u00020\u00192\u0006\u0010/\u001a\u00020\u0001H\u0016J\b\u00100\u001a\u00020$H\u0002R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR\u001a\u0010\u0012\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\f\"\u0004\b\u0014\u0010\u000eR\u001a\u0010\u0015\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\f\"\u0004\b\u0017\u0010\u000eR\u001a\u0010\u0018\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u001b\"\u0004\b \u0010\u001d\u00a8\u00062"}, d2={"Lcom/mygdx/game/ControllableCamera;", "Lcom/mygdx/game/Camera;", "cfg", "Lcom/mygdx/game/Config;", "pos", "Lglm/vec3/Vec3;", "lookAt", "up", "(Lcom/mygdx/game/Config;Lglm/vec3/Vec3;Lglm/vec3/Vec3;Lglm/vec3/Vec3;)V", "camDirX", "Lcom/mygdx/game/ControllableCamera$CamDir;", "getCamDirX", "()Lcom/mygdx/game/ControllableCamera$CamDir;", "setCamDirX", "(Lcom/mygdx/game/ControllableCamera$CamDir;)V", "camDirY", "getCamDirY", "setCamDirY", "camLookX", "getCamLookX", "setCamLookX", "camLookY", "getCamLookY", "setCamLookY", "pitch", "", "getPitch", "()F", "setPitch", "(F)V", "yaw", "getYaw", "setYaw", "calculateView", "Lglm/mat4x4/Mat4;", "keyDown", "", "keycode", "", "keyUp", "moveBack", "speed", "moveForward", "moveLeft", "moveRight", "update", "delta", "cam", "updateMoves", "CamDir", "core"})
public final class ControllableCamera
extends Camera {
    @NotNull
    private CamDir camDirX;
    @NotNull
    private CamDir camDirY;
    @NotNull
    private CamDir camLookY;
    @NotNull
    private CamDir camLookX;
    private float pitch;
    private float yaw;

    @NotNull
    public final CamDir getCamDirX() {
        return this.camDirX;
    }

    public final void setCamDirX(@NotNull CamDir camDir) {
        Intrinsics.checkParameterIsNotNull((Object)camDir, "<set-?>");
        this.camDirX = camDir;
    }

    @NotNull
    public final CamDir getCamDirY() {
        return this.camDirY;
    }

    public final void setCamDirY(@NotNull CamDir camDir) {
        Intrinsics.checkParameterIsNotNull((Object)camDir, "<set-?>");
        this.camDirY = camDir;
    }

    @NotNull
    public final CamDir getCamLookY() {
        return this.camLookY;
    }

    public final void setCamLookY(@NotNull CamDir camDir) {
        Intrinsics.checkParameterIsNotNull((Object)camDir, "<set-?>");
        this.camLookY = camDir;
    }

    @NotNull
    public final CamDir getCamLookX() {
        return this.camLookX;
    }

    public final void setCamLookX(@NotNull CamDir camDir) {
        Intrinsics.checkParameterIsNotNull((Object)camDir, "<set-?>");
        this.camLookX = camDir;
    }

    public final float getPitch() {
        return this.pitch;
    }

    public final void setPitch(float f) {
        this.pitch = f;
    }

    public final float getYaw() {
        return this.yaw;
    }

    public final void setYaw(float f) {
        this.yaw = f;
    }

    @Override
    @NotNull
    public Mat4 calculateView() {
        this.getLookAt().x = Float.valueOf(MathUtils.cos((float)Math.PI / 180 * this.pitch) * MathUtils.cos((float)Math.PI / 180 * this.yaw));
        this.getLookAt().y = Float.valueOf(MathUtils.sin((float)Math.PI / 180 * this.pitch));
        this.getLookAt().z = Float.valueOf(MathUtils.cos((float)Math.PI / 180 * this.pitch) * MathUtils.sin((float)Math.PI / 180 * this.yaw));
        return glm.INSTANCE.lookAt(this.getPos(), this.getPos().plus(this.getLookAt()), this.getUp());
    }

    @Override
    public void update(float delta, @NotNull Camera cam) {
        Intrinsics.checkParameterIsNotNull(cam, "cam");
        this.updateMoves();
        this.setView(this.calculateView());
    }

    private final void updateMoves() {
        switch (ControllableCamera$WhenMappings.$EnumSwitchMapping$0[this.camDirX.ordinal()]) {
            case 1: {
                this.moveLeft(0.03f);
                break;
            }
            case 2: {
                this.moveRight(0.03f);
            }
        }
        switch (ControllableCamera$WhenMappings.$EnumSwitchMapping$1[this.camDirY.ordinal()]) {
            case 1: {
                this.moveForward(0.03f);
                break;
            }
            case 2: {
                this.moveBack(0.03f);
            }
        }
        float turnSpeed = 0.5f;
        switch (ControllableCamera$WhenMappings.$EnumSwitchMapping$2[this.camLookY.ordinal()]) {
            case 1: {
                this.yaw -= turnSpeed;
                break;
            }
            case 2: {
                this.yaw += turnSpeed;
            }
        }
        switch (ControllableCamera$WhenMappings.$EnumSwitchMapping$3[this.camLookX.ordinal()]) {
            case 1: {
                this.pitch -= turnSpeed;
                break;
            }
            case 2: {
                this.pitch += turnSpeed;
            }
        }
    }

    @Override
    public void keyUp(int keycode) {
        switch (keycode) {
            case 29: {
                this.camDirX = CamDir.NONE;
                break;
            }
            case 32: {
                this.camDirX = CamDir.NONE;
                break;
            }
            case 51: {
                this.camDirY = CamDir.NONE;
                break;
            }
            case 47: {
                this.camDirY = CamDir.NONE;
                break;
            }
            case 21: {
                this.camLookY = CamDir.NONE;
                break;
            }
            case 22: {
                this.camLookY = CamDir.NONE;
                break;
            }
            case 33: {
                this.camLookX = CamDir.NONE;
                break;
            }
            case 45: {
                this.camLookX = CamDir.NONE;
            }
        }
    }

    @Override
    public void keyDown(int keycode) {
        switch (keycode) {
            case 29: {
                this.camDirX = CamDir.LEFT;
                break;
            }
            case 32: {
                this.camDirX = CamDir.RIGHT;
                break;
            }
            case 51: {
                this.camDirY = CamDir.FORWARD;
                break;
            }
            case 47: {
                this.camDirY = CamDir.BACK;
                break;
            }
            case 21: {
                this.camLookY = CamDir.LEFT;
                break;
            }
            case 22: {
                this.camLookY = CamDir.RIGHT;
                break;
            }
            case 33: {
                this.camLookX = CamDir.DOWN;
                break;
            }
            case 45: {
                this.camLookX = CamDir.UP;
            }
        }
    }

    public final void moveLeft(float speed) {
        ControllableCamera controllableCamera = this;
        controllableCamera.setPos(controllableCamera.getPos().minus(func_geometric.DefaultImpls.normalize$default((func_geometric)glm.INSTANCE, func_geometric.DefaultImpls.cross$default((func_geometric)glm.INSTANCE, this.getLookAt(), this.getUp(), null, 4, null), null, 2, null).times(speed)));
    }

    public final void moveRight(float speed) {
        ControllableCamera controllableCamera = this;
        controllableCamera.setPos(controllableCamera.getPos().minus(func_geometric.DefaultImpls.normalize$default((func_geometric)glm.INSTANCE, func_geometric.DefaultImpls.cross$default((func_geometric)glm.INSTANCE, this.getUp(), this.getLookAt(), null, 4, null), null, 2, null).times(speed)));
    }

    public final void moveForward(float speed) {
        ControllableCamera controllableCamera = this;
        controllableCamera.setPos(controllableCamera.getPos().plus(this.getLookAt().times(speed)));
    }

    public final void moveBack(float speed) {
        ControllableCamera controllableCamera = this;
        controllableCamera.setPos(controllableCamera.getPos().minus(this.getLookAt().times(speed)));
    }

    public ControllableCamera(@NotNull Config cfg, @NotNull Vec3 pos, @NotNull Vec3 lookAt, @NotNull Vec3 up) {
        Intrinsics.checkParameterIsNotNull(cfg, "cfg");
        Intrinsics.checkParameterIsNotNull(pos, "pos");
        Intrinsics.checkParameterIsNotNull(lookAt, "lookAt");
        Intrinsics.checkParameterIsNotNull(up, "up");
        super(cfg, pos, lookAt, up);
        this.camDirX = CamDir.NONE;
        this.camDirY = CamDir.NONE;
        this.camLookY = CamDir.NONE;
        this.camLookX = CamDir.NONE;
        this.yaw = 90.0f;
    }

    public /* synthetic */ ControllableCamera(Config config, Vec3 vec3, Vec3 vec32, Vec3 vec33, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            vec33 = new Vec3((Number)0, (Number)1, (Number)0);
        }
        this(config, vec3, vec32, vec33);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\t\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lcom/mygdx/game/ControllableCamera$CamDir;", "", "(Ljava/lang/String;I)V", "LEFT", "RIGHT", "UP", "DOWN", "FORWARD", "BACK", "NONE", "core"})
    public static final class CamDir
    extends Enum<CamDir> {
        public static final /* enum */ CamDir LEFT;
        public static final /* enum */ CamDir RIGHT;
        public static final /* enum */ CamDir UP;
        public static final /* enum */ CamDir DOWN;
        public static final /* enum */ CamDir FORWARD;
        public static final /* enum */ CamDir BACK;
        public static final /* enum */ CamDir NONE;
        private static final /* synthetic */ CamDir[] $VALUES;

        static {
            CamDir[] camDirArray = new CamDir[7];
            CamDir[] camDirArray2 = camDirArray;
            camDirArray[0] = LEFT = new CamDir();
            camDirArray[1] = RIGHT = new CamDir();
            camDirArray[2] = UP = new CamDir();
            camDirArray[3] = DOWN = new CamDir();
            camDirArray[4] = FORWARD = new CamDir();
            camDirArray[5] = BACK = new CamDir();
            camDirArray[6] = NONE = new CamDir();
            $VALUES = camDirArray;
        }

        public static CamDir[] values() {
            return (CamDir[])$VALUES.clone();
        }

        public static CamDir valueOf(String string) {
            return Enum.valueOf(CamDir.class, string);
        }
    }
}

