/*
 * Decompiled with CFR 0.152.
 */
package processing.data;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Random;
import processing.core.PApplet;
import processing.data.IntDict;
import processing.data.JSONObject;
import processing.data.Sort;

public class StringList
implements Iterable<String> {
    int count;
    String[] data;

    public StringList() {
        this(10);
    }

    public StringList(int length) {
        this.data = new String[length];
    }

    public StringList(String[] list) {
        this.count = list.length;
        this.data = new String[this.count];
        System.arraycopy(list, 0, this.data, 0, this.count);
    }

    public StringList(Object ... items) {
        this.count = items.length;
        this.data = new String[this.count];
        int index = 0;
        Object[] objectArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o != null) {
                this.data[index] = o.toString();
            }
            ++index;
            ++n2;
        }
    }

    public StringList(Iterable<String> iter) {
        this(10);
        for (String s : iter) {
            this.append(s);
        }
    }

    private void crop() {
        if (this.count != this.data.length) {
            this.data = PApplet.subset(this.data, 0, this.count);
        }
    }

    public int size() {
        return this.count;
    }

    public void resize(int length) {
        if (length > this.data.length) {
            String[] temp = new String[length];
            System.arraycopy(this.data, 0, temp, 0, this.count);
            this.data = temp;
        } else if (length > this.count) {
            Arrays.fill(this.data, this.count, length, (Object)0);
        }
        this.count = length;
    }

    public void clear() {
        this.count = 0;
    }

    public String get(int index) {
        if (index >= this.count) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.data[index];
    }

    public void set(int index, String what) {
        if (index >= this.count) {
            this.data = PApplet.expand(this.data, index + 1);
            int i = this.count;
            while (i < index) {
                this.data[i] = null;
                ++i;
            }
            this.count = index + 1;
        }
        this.data[index] = what;
    }

    public void push(String value) {
        this.append(value);
    }

    public String pop() {
        if (this.count == 0) {
            throw new RuntimeException("Can't call pop() on an empty list");
        }
        String value = this.get(this.count - 1);
        this.data[--this.count] = null;
        return value;
    }

    public String remove(int index) {
        if (index < 0 || index >= this.count) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        String entry = this.data[index];
        int i = index;
        while (i < this.count - 1) {
            this.data[i] = this.data[i + 1];
            ++i;
        }
        --this.count;
        return entry;
    }

    public int removeValue(String value) {
        if (value == null) {
            int i = 0;
            while (i < this.count) {
                if (this.data[i] == null) {
                    this.remove(i);
                    return i;
                }
                ++i;
            }
        } else {
            int index = this.index(value);
            if (index != -1) {
                this.remove(index);
                return index;
            }
        }
        return -1;
    }

    public int removeValues(String value) {
        int i;
        int ii = 0;
        if (value == null) {
            i = 0;
            while (i < this.count) {
                if (this.data[i] != null) {
                    this.data[ii++] = this.data[i];
                }
                ++i;
            }
        } else {
            i = 0;
            while (i < this.count) {
                if (!value.equals(this.data[i])) {
                    this.data[ii++] = this.data[i];
                }
                ++i;
            }
        }
        int removed = this.count - ii;
        this.count = ii;
        return removed;
    }

    public int replaceValue(String value, String newValue) {
        if (value == null) {
            int i = 0;
            while (i < this.count) {
                if (this.data[i] == null) {
                    this.data[i] = newValue;
                    return i;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.count) {
                if (value.equals(this.data[i])) {
                    this.data[i] = newValue;
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public int replaceValues(String value, String newValue) {
        int changed = 0;
        if (value == null) {
            int i = 0;
            while (i < this.count) {
                if (this.data[i] == null) {
                    this.data[i] = newValue;
                    ++changed;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.count) {
                if (value.equals(this.data[i])) {
                    this.data[i] = newValue;
                    ++changed;
                }
                ++i;
            }
        }
        return changed;
    }

    public void append(String value) {
        if (this.count == this.data.length) {
            this.data = PApplet.expand(this.data);
        }
        this.data[this.count++] = value;
    }

    public void append(String[] values2) {
        String[] stringArray = values2;
        int n = values2.length;
        int n2 = 0;
        while (n2 < n) {
            String v = stringArray[n2];
            this.append(v);
            ++n2;
        }
    }

    public void append(StringList list) {
        String[] stringArray = list.values();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String v = stringArray[n2];
            this.append(v);
            ++n2;
        }
    }

    public void appendUnique(String value) {
        if (!this.hasValue(value)) {
            this.append(value);
        }
    }

    public void insert(int index, String value) {
        this.insert(index, new String[]{value});
    }

    public void insert(int index, String[] values2) {
        if (index < 0) {
            throw new IllegalArgumentException("insert() index cannot be negative: it was " + index);
        }
        if (index >= this.data.length) {
            throw new IllegalArgumentException("insert() index " + index + " is past the end of this list");
        }
        String[] temp = new String[this.count + values2.length];
        System.arraycopy(this.data, 0, temp, 0, Math.min(this.count, index));
        System.arraycopy(values2, 0, temp, index, values2.length);
        System.arraycopy(this.data, index, temp, index + values2.length, this.count - index);
        this.count += values2.length;
        this.data = temp;
    }

    public void insert(int index, StringList list) {
        this.insert(index, list.values());
    }

    public int index(String what) {
        if (what == null) {
            int i = 0;
            while (i < this.count) {
                if (this.data[i] == null) {
                    return i;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.count) {
                if (what.equals(this.data[i])) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public boolean hasValue(String value) {
        if (value == null) {
            int i = 0;
            while (i < this.count) {
                if (this.data[i] == null) {
                    return true;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.count) {
                if (value.equals(this.data[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public void sort() {
        this.sortImpl(false);
    }

    public void sortReverse() {
        this.sortImpl(true);
    }

    private void sortImpl(final boolean reverse) {
        new Sort(){

            @Override
            public int size() {
                return StringList.this.count;
            }

            @Override
            public float compare(int a, int b) {
                float diff = StringList.this.data[a].compareToIgnoreCase(StringList.this.data[b]);
                return reverse ? -diff : diff;
            }

            @Override
            public void swap(int a, int b) {
                String temp = StringList.this.data[a];
                StringList.this.data[a] = StringList.this.data[b];
                StringList.this.data[b] = temp;
            }
        }.run();
    }

    public void reverse() {
        int ii = this.count - 1;
        int i = 0;
        while (i < this.count / 2) {
            String t = this.data[i];
            this.data[i] = this.data[ii];
            this.data[ii] = t;
            --ii;
            ++i;
        }
    }

    public void shuffle() {
        Random r = new Random();
        int num = this.count;
        while (num > 1) {
            int value = r.nextInt(num);
            String temp = this.data[--num];
            this.data[num] = this.data[value];
            this.data[value] = temp;
        }
    }

    public void shuffle(PApplet sketch) {
        int num = this.count;
        while (num > 1) {
            int value = (int)sketch.random(num);
            String temp = this.data[--num];
            this.data[num] = this.data[value];
            this.data[value] = temp;
        }
    }

    public void lower() {
        int i = 0;
        while (i < this.count) {
            if (this.data[i] != null) {
                this.data[i] = this.data[i].toLowerCase();
            }
            ++i;
        }
    }

    public void upper() {
        int i = 0;
        while (i < this.count) {
            if (this.data[i] != null) {
                this.data[i] = this.data[i].toUpperCase();
            }
            ++i;
        }
    }

    public StringList copy() {
        StringList outgoing = new StringList(this.data);
        outgoing.count = this.count;
        return outgoing;
    }

    public String[] values() {
        this.crop();
        return this.data;
    }

    @Override
    public Iterator<String> iterator() {
        return new Iterator<String>(){
            int index = -1;

            @Override
            public void remove() {
                StringList.this.remove(this.index);
                --this.index;
            }

            @Override
            public String next() {
                return StringList.this.data[++this.index];
            }

            @Override
            public boolean hasNext() {
                return this.index + 1 < StringList.this.count;
            }
        };
    }

    public String[] array() {
        return this.array(null);
    }

    public String[] array(String[] array) {
        if (array == null || array.length != this.count) {
            array = new String[this.count];
        }
        System.arraycopy(this.data, 0, array, 0, this.count);
        return array;
    }

    public StringList getSubset(int start) {
        return this.getSubset(start, this.count - start);
    }

    public StringList getSubset(int start, int num) {
        String[] subset = new String[num];
        System.arraycopy(this.data, start, subset, 0, num);
        return new StringList(subset);
    }

    public String[] getUnique() {
        return this.getTally().keyArray();
    }

    public IntDict getTally() {
        IntDict outgoing = new IntDict();
        int i = 0;
        while (i < this.count) {
            outgoing.increment(this.data[i]);
            ++i;
        }
        return outgoing;
    }

    public IntDict getOrder() {
        IntDict outgoing = new IntDict();
        int i = 0;
        while (i < this.count) {
            outgoing.set(this.data[i], i);
            ++i;
        }
        return outgoing;
    }

    public String join(String separator) {
        if (this.count == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.data[0]);
        int i = 1;
        while (i < this.count) {
            sb.append(separator);
            sb.append(this.data[i]);
            ++i;
        }
        return sb.toString();
    }

    public void print() {
        int i = 0;
        while (i < this.count) {
            System.out.format("[%d] %s%n", i, this.data[i]);
            ++i;
        }
    }

    public String toJSON() {
        StringList temp = new StringList();
        for (String item : this) {
            temp.append(JSONObject.quote(item));
        }
        return "[ " + temp.join(", ") + " ]";
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " size=" + this.size() + " " + this.toJSON();
    }
}

