/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt.driver.linux;

import com.jogamp.common.util.InterruptSource;
import com.jogamp.newt.Screen;
import com.jogamp.newt.Window;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.event.WindowUpdateEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import jogamp.newt.WindowImpl;
import jogamp.newt.driver.MouseTracker;

public class LinuxMouseTracker
implements WindowListener,
MouseTracker {
    private static final LinuxMouseTracker lmt = new LinuxMouseTracker();
    private volatile boolean stop = false;
    private int x = 0;
    private int y = 0;
    private short buttonDown = 0;
    private int old_x = 0;
    private int old_y = 0;
    private volatile int lastFocusedX = 0;
    private volatile int lastFocusedY = 0;
    private short old_buttonDown = 0;
    private WindowImpl focusedWindow = null;
    private final MouseDevicePoller mouseDevicePoller = new MouseDevicePoller();

    public static LinuxMouseTracker getSingleton() {
        return lmt;
    }

    @Override
    public final int getLastX() {
        return this.lastFocusedX;
    }

    @Override
    public final int getLastY() {
        return this.lastFocusedY;
    }

    @Override
    public void windowResized(WindowEvent windowEvent) {
    }

    @Override
    public void windowMoved(WindowEvent windowEvent) {
    }

    @Override
    public void windowDestroyNotify(WindowEvent windowEvent) {
        Object object = windowEvent.getSource();
        if (this.focusedWindow == object) {
            this.focusedWindow = null;
        }
    }

    @Override
    public void windowDestroyed(WindowEvent windowEvent) {
    }

    @Override
    public void windowGainedFocus(WindowEvent windowEvent) {
        Object object = windowEvent.getSource();
        if (object instanceof WindowImpl) {
            this.focusedWindow = (WindowImpl)object;
        }
    }

    @Override
    public void windowLostFocus(WindowEvent windowEvent) {
        Object object = windowEvent.getSource();
        if (this.focusedWindow == object) {
            this.focusedWindow = null;
        }
    }

    @Override
    public void windowRepaint(WindowUpdateEvent windowUpdateEvent) {
    }

    static {
        InterruptSource.Thread thread2 = new InterruptSource.Thread(null, LinuxMouseTracker.lmt.mouseDevicePoller, "NEWT-LinuxMouseTracker");
        thread2.setDaemon(true);
        thread2.start();
    }

    class MouseDevicePoller
    implements Runnable {
        MouseDevicePoller() {
        }

        @Override
        public void run() {
            FileInputStream fileInputStream;
            byte[] byArray = new byte[3];
            File file = new File("/dev/input/mice");
            file.setReadOnly();
            try {
                fileInputStream = new FileInputStream(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
                return;
            }
            byte by = 0;
            byte by2 = 0;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            boolean bl7 = false;
            while (!LinuxMouseTracker.this.stop) {
                int n = 3;
                while (n > 0) {
                    int n2 = 0;
                    try {
                        n2 = ((InputStream)fileInputStream).read(byArray, 0, n);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    if (n2 < 0) {
                        LinuxMouseTracker.this.stop = true;
                        continue;
                    }
                    n -= n2;
                }
                bl3 = (byArray[0] & 1) > 0;
                bl5 = (byArray[0] & 2) > 0;
                bl4 = (byArray[0] & 4) > 0;
                bl6 = (byArray[0] & 0x10) > 0;
                bl7 = (byArray[0] & 0x20) > 0;
                bl = (byArray[0] & 0x40) > 0;
                bl2 = (byArray[0] & 0x80) > 0;
                by = byArray[1];
                by2 = byArray[2];
                LinuxMouseTracker.this.x = LinuxMouseTracker.this.x + by;
                LinuxMouseTracker.this.y = LinuxMouseTracker.this.y - by2;
                if (LinuxMouseTracker.this.x < 0) {
                    LinuxMouseTracker.this.x = 0;
                }
                if (LinuxMouseTracker.this.y < 0) {
                    LinuxMouseTracker.this.y = 0;
                }
                LinuxMouseTracker.this.buttonDown = (short)0;
                if (bl3) {
                    LinuxMouseTracker.this.buttonDown = (short)1;
                }
                if (bl4) {
                    LinuxMouseTracker.this.buttonDown = (short)2;
                }
                if (bl5) {
                    LinuxMouseTracker.this.buttonDown = (short)3;
                }
                if (null != LinuxMouseTracker.this.focusedWindow) {
                    Object object = LinuxMouseTracker.this.focusedWindow.getScreen();
                    int n3 = ((Screen)object).getWidth();
                    int n4 = ((Screen)object).getHeight();
                    if (LinuxMouseTracker.this.x >= n3) {
                        LinuxMouseTracker.this.x = n3 - 1;
                    }
                    if (LinuxMouseTracker.this.y >= n4) {
                        LinuxMouseTracker.this.y = n4 - 1;
                    }
                    object = LinuxMouseTracker.this.focusedWindow.convertToPixelUnits(new int[]{LinuxMouseTracker.this.focusedWindow.getX(), LinuxMouseTracker.this.focusedWindow.getY()});
                    n3 = LinuxMouseTracker.this.x - object[0];
                    n4 = LinuxMouseTracker.this.y - object[1];
                    if (LinuxMouseTracker.this.old_x != LinuxMouseTracker.this.x || LinuxMouseTracker.this.old_y != LinuxMouseTracker.this.y) {
                        LinuxMouseTracker.this.lastFocusedX = n3;
                        LinuxMouseTracker.this.lastFocusedY = n4;
                        LinuxMouseTracker.this.focusedWindow.sendMouseEvent((short)205, 0, n3, n4, (short)0, 0.0f);
                    }
                    if (LinuxMouseTracker.this.old_buttonDown != LinuxMouseTracker.this.buttonDown) {
                        if (0 != LinuxMouseTracker.this.buttonDown) {
                            LinuxMouseTracker.this.focusedWindow.sendMouseEvent((short)203, 0, n3, n4, LinuxMouseTracker.this.buttonDown, 0.0f);
                        } else {
                            LinuxMouseTracker.this.focusedWindow.sendMouseEvent((short)204, 0, n3, n4, LinuxMouseTracker.this.old_buttonDown, 0.0f);
                        }
                    }
                } else if (Window.DEBUG_MOUSE_EVENT) {
                    System.out.println(LinuxMouseTracker.this.x + "/" + LinuxMouseTracker.this.y + ", hs=" + bl6 + ",vs=" + bl7 + ",lb=" + bl3 + ",rb=" + bl5 + ",mb=" + bl4 + ",xo=" + bl + ",yo=" + bl2 + "xd=" + by + ",yd=" + by2);
                }
                LinuxMouseTracker.this.old_x = LinuxMouseTracker.this.x;
                LinuxMouseTracker.this.old_y = LinuxMouseTracker.this.y;
                LinuxMouseTracker.this.old_buttonDown = LinuxMouseTracker.this.buttonDown;
            }
            if (null != fileInputStream) {
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }
}

