
; musiken går i tempo 0b07
; 11+7 /2 * 16

; övre sprites kommer rätt
; Nyheter kommer fel



; 8 sprites
; 192 pixels Wide
; 21 pixels high
; expand in y = 42 pixels high
; expand in x

;release    equ 0

;3 bytes irq in zp to make sure ghost byte $ffff is #$00
irq_zp = $02
irq_zp_lsb = irq_zp + 1
irq_zp_msb = irq_zp + 2

tmp2 = $05
tmp_poi = $06
tmp_poi2 = $08
koala_poi = $0a
text_row = $0c
text_column = $0d
which_paper = $0e
tmp_char = $0f
text_colour = $20
frame_no_lsb = $21
frame_no_msb = $22

; Keyboard scan routine zp registers:
ScanResult       = $10  ;8 bytes
BufferNew        = $18  ;3 bytes
KeyQuantity      = $1b  ;1 byte
NonAlphaFlagX    = $1c  ;1 byte
NonAlphaFlagY    = $1d  ;1 byte
TempZP           = $1e  ;1 byte
SimultaneousKeys = $1f  ;1 byte

; Music uses $fc and $fd zp registers
music = $0c00
music_play = $0c03
music_init = $0c00

; EasyFlash3 registers:
USB_ID   = $de08
USB_STATUS = $de09
USB_DATA   = $de0a

MOUSETYPE_1351_ACC = 0
MOUSETYPE_1351_NOACC = 1
MOUSETYPE_JOYSTICK   = 2
MOUSETYPE_NONE   = 3
MOUSETYPE_MAX  = 4


;There are basically three types of cartridges for the C64:
;8K Cartridge, $8000-$9FFF (ROML).
;GAME = 1, EXROM = 0
;ROML is read only. Basic ROM and Kernal ROM are available.
;
;16K Cartridge, $8000-$9FFF / $A000-$BFFF (ROML / ROMH).
;GAME = 0, EXROM = 0
;ROML/ROMH are read only, Basic ROM is overwritten by ROMH.
;
;16K Cartridge, $8000-$9FFF / $E000-$FFFF (ROML / ROMH). Ultimax mode.
;GAME = 0, EXROM = 1
;Ultimax mode is an emulation of the Japanese CBM machine called “MAX”. It is a predecessor of the C64 with less RAM. In Ultimax mode ROMH replaces the kernal at $E000. You do not need ROML for a cartridge to function and can be left out.


;$0800-$0900 bootloader
code_start = $0400
;$0900-$0bff first code to be run
;Music $0c00-$1fff
charset0L = $2000
charset0R = $2800
screen0 = $3028
mouse_sprites0 = $3400
code_segment_34c0 = $34c0
;$34c0-$3ffe free
;$3fff ghost byte
code_segment_4000 = $4000
charset1L = $6000
charset1R = $6800
screen1 = $7028
mouse_sprites1 = $7400
code_segment_74c0 = $34c0
;$74c0-$7ffe free
;$7fff ghost byte
;$8000-$9fff ultimax cart
logo_sprites = $8000
topaz = $9000
;-$9400
charset2L = $a000
charset2R = $a800
screen2 = $b028
mouse_sprites2 = $b400
;$b4c0-$bffe free
;$bfff ghost byte
;$c000-$cb3f free
mouse_sprites3 = $cb40
;$cc00-$cfff koala screen
koala_screen = $cc00
;$e000-$ffff ultimax cart
;$e000-$ff3f koala image or nyheter_start/credits-image
koala_image_bitmap = $e000

  org code_start
  sei
  cld
  lda #$7f
  sta $dc0d  ;disable timer interrupts which can be generated by the two CIA chips
  sta $dd0d  ;the kernal uses such an interrupt to flash the cursor and scan the keyboard, so we better
  ;stop it.
  lda $dc0d  ;by reading this two registers we negate any pending CIA irqs.
  lda $dd0d  ;if we don't do this, a pending CIA irq might occur after we finish setting up our irq.
syncite3:
  lda $d011
  bpl syncite3
syncite2:
  lda $d011
  bmi syncite2

  lda #$35
  sta $01
  ldx #$ff
  txs
  lda #$1
  sta $d020
  lda #$1
  sta $d021
  lda #0
  sta $dd00
  lda #$03
  sta $dd02
  lda #$c8  ;screen at $3400, charset at $2000
  sta $d018
  ;lda #$ca  ;screen at $3400, charset at $2800
  ;sta $d018

;  ldx #0
;invert_more:
;  lda logo_sprites,x
;  eor #$ff
;  sta logo_sprites,x
;  lda logo_sprites+$100,x
;  eor #$ff
;  sta logo_sprites+$100,x
;  inx
;  bne invert_more


;  jsr show_nyheter_start
  lda #0
  sta screen_mode+1
  ldx #0
clrstart:
  lda #$1
  sta $d800,x
  sta $d900,x
  sta $da00,x
  sta $db00,x
;screen at $cc00
  lda #$11
  sta $cc00,x
  sta $cd00,x
  sta $ce00,x
  sta $cef8,x
  inx
  bne clrstart
  lda #1
  sta koala_bgcol+1
  sta koala_bordercol+1

  lda #(empty_sprites / $40) & $ff
  sta which_sprites_at_top + 1
  sta which_sprites_at_bottom + 1

  lda #0
  sta upper_sprcol+1
  sta lower_sprcol+1

; There are two leftover bytes from the bootloader:
wait_usb_rx_ok813:
  bit USB_STATUS
  bpl wait_usb_rx_ok813
  lda USB_DATA
wait_usb_rx_ok823:
  bit USB_STATUS
  bpl wait_usb_rx_ok823
  lda USB_DATA

  jsr music_init
margin = 6
  lda #$fa
  sta frame_no_lsb
  lda #$ff
  sta frame_no_msb
; Wade through the seven intro pictures:
  lda #0
  sta sync_tick+1

  lda #$7f
  sta $dc0d  ;disable timer interrupts which can be generated by the two CIA chips
  sta $dd0d  ;the kernal uses such an interrupt to flash the cursor and scan the keyboard, so we better
  ;stop it.
  lda $dc0d  ;by reading this two registers we negate any pending CIA irqs.
  lda $dd0d  ;if we don't do this, a pending CIA irq might occur after we finish setting up our irq.
  ;we don't want that to happen.
OP_JMP = $4c
  lda #OP_JMP
  sta irq_zp
  lda #<irq1
  sta irq_zp_lsb
  lda #>irq1
  sta irq_zp_msb
  lda #<irq_zp
  sta $fffe
  lda #>irq_zp
  sta $ffff
  lda #uppermost_irq - 3
  sta $d012
  lda #$3b
  sta $d011

  lda #0
  sta text_colour

  ldx #0
  jsr mouse_init

  ldx #1
  stx $d01a   ; enable raster interrupt
  lda $dc0d   ; acknowledge CIA interrupts
  lsr $d019   ; and video interrupts
  cli



;;D018  53272   VIC Memory Control Register
;;    7-4 Video Matrix Base Address (inside VIC)
;;    3-1 Character Dot-Data Base Address (inside VIC)
;;    0 Select upper/lower Character Set
;;screen at $cc00
;;bitmap at $e000
;  lda #$38
;  sta $d018
;;multicol, 40 chars wide
;  lda #$d8
;  sta $d016
;;data direction for bank selecting
;  lda #$03
;  sta $dd02
;;bank $c000-$ffff
;  lda #$00
;  sta $dd00
;;bitmap
;  lda #$3b
;  sta $d011

;  lda #$05
;  sta $e000
;  sta $e001
;  sta $e002
;  sta $e003
;  lda #$af
;  sta $e004
;  sta $e005
;  sta $e006
;  sta $e007
;  lda #$71
;  sta $cc00
;  lda #$5
;  sta $d800

one_bar = 143
one_note = 35

wait_until_0 = one_bar
  lda #<wait_until_0
  ldx #>wait_until_0
  jsr wait_until_frame_no
  lda #(intro_du_tittar_sprite / $40) & $ff
  sta which_sprites_at_top + 1

wait_until_1 = one_bar + one_note
  lda #<wait_until_1
  ldx #>wait_until_1
  jsr wait_until_frame_no
; Show HIRES image already in memory "Nyheter"
  lda #0
  sta screen_mode+1
  ldy #$0
whitt_more:
  lda #$1
  sta $d800,y
  sta $d900,y
  sta $da00,y
  sta $db00,y
;screen at $cc00
  lda #$10
  sta $cc00,y
  sta $cd00,y
  sta $ce00,y
  sta $cef8,y
  iny
  bne whitt_more
  lda #1
  sta koala_bgcol+1
  sta koala_bordercol+1

wait_until_2 = one_bar + one_note*2
  lda #<wait_until_2
  ldx #>wait_until_2
  jsr wait_until_frame_no
  lda #(intro_pa_c64_sprite / $40) & $ff
  sta which_sprites_at_bottom + 1

wait_until_3 = one_bar*2
  lda #<wait_until_3
  ldx #>wait_until_3
  jsr wait_until_frame_no
  lda #(empty_sprites / $40) & $ff
  sta which_sprites_at_top + 1

wait_until_4 = one_bar*2 + one_note
  lda #<wait_until_4
  ldx #>wait_until_4
  jsr wait_until_frame_no
  jsr clear_hires

wait_until_5 = one_bar*2 + one_note*2
  lda #<wait_until_5
  ldx #>wait_until_5
  jsr wait_until_frame_no
  lda #(empty_sprites / $40) & $ff
  sta which_sprites_at_bottom + 1

  lda #1
  sta upper_sprcol+1
  sta lower_sprcol+1

; MOUSE intro image
wait_until_1a = one_bar*3 - margin
  lda #<wait_until_1a
  ldx #>wait_until_1a
  jsr wait_until_frame_no
  lda #(intro_01_sprite / $40) & $ff
  sta which_sprites_at_top + 1
  jsr grab_an_intro_image

wait_until_1c = one_bar*3 + one_note*2
  lda #<wait_until_1c
  ldx #>wait_until_1c
  jsr wait_until_frame_no
  lda #(intro_koppla_sprite / $40) & $ff
  sta which_sprites_at_bottom + 1

; USB->PS2 intro image
wait_until_2a = one_bar*4 - margin
  lda #<wait_until_2a
  ldx #>wait_until_2a
  jsr wait_until_frame_no
  lda #(intro_02_sprite / $40) & $ff
  sta which_sprites_at_top + 1
  lda #(empty_sprites / $40) & $ff
  sta which_sprites_at_bottom + 1
  jsr grab_an_intro_image

wait_until_2c = one_bar*4 + one_note*2
  lda #<wait_until_2c
  ldx #>wait_until_2c
  jsr wait_until_frame_no
  lda #(intro_som_kopplas_sprite / $40) & $ff
  sta which_sprites_at_bottom + 1

; PS2->DSUB9 intro image
wait_until_3a = one_bar*5 - margin
  lda #<wait_until_3a
  ldx #>wait_until_3a
  jsr wait_until_frame_no
  lda #(intro_03_sprite / $40) & $ff
  sta which_sprites_at_top + 1
  lda #(empty_sprites / $40) & $ff
  sta which_sprites_at_bottom + 1
  jsr grab_an_intro_image

wait_until_3c = one_bar*5 + one_note*2
  lda #<wait_until_3c
  ldx #>wait_until_3c
  jsr wait_until_frame_no
  lda #(intro_som_kopplas_sprite / $40) & $ff
  sta which_sprites_at_bottom + 1

; Din Commodore64 intro image
wait_until_4a = one_bar*6 - margin
  lda #<wait_until_4a
  ldx #>wait_until_4a
  jsr wait_until_frame_no
  lda #(intro_04_sprite / $40) & $ff
  sta which_sprites_at_top + 1
  lda #(empty_sprites / $40) & $ff
  sta which_sprites_at_bottom + 1
  jsr grab_an_intro_image

wait_until_4c = one_bar*6 + one_note*2
  lda #<wait_until_4c
  ldx #>wait_until_4c
  jsr wait_until_frame_no
  lda #(intro_som_kopplas_sprite / $40) & $ff
  sta which_sprites_at_bottom + 1

; Din EasyFlash3 intro image
wait_until_5a = one_bar*7 - margin
  lda #<wait_until_5a
  ldx #>wait_until_5a
  jsr wait_until_frame_no
  lda #(intro_05_sprite / $40) & $ff
  sta which_sprites_at_top + 1
  lda #(empty_sprites / $40) & $ff
  sta which_sprites_at_bottom + 1
  jsr grab_an_intro_image

wait_until_5c = one_bar*7 + one_note*2
  lda #<wait_until_5c
  ldx #>wait_until_5c
  jsr wait_until_frame_no
  lda #(intro_som_kopplas_sprite / $40) & $ff
  sta which_sprites_at_bottom + 1

; Usb igen intro image
wait_until_6a = one_bar*8 - margin
  lda #<wait_until_6a
  ldx #>wait_until_6a
  jsr wait_until_frame_no
  lda #(intro_06_sprite / $40) & $ff
  sta which_sprites_at_top + 1
  lda #(empty_sprites / $40) & $ff
  sta which_sprites_at_bottom + 1
  jsr grab_an_intro_image

wait_until_6c = one_bar*8 + one_note*2
  lda #<wait_until_6c
  ldx #>wait_until_6c
  jsr wait_until_frame_no
  lda #(intro_som_kopplas_sprite / $40) & $ff
  sta which_sprites_at_bottom + 1

; Usb/Wifi intro image
wait_until_7a = one_bar*9 - margin
  lda #<wait_until_7a
  ldx #>wait_until_7a
  jsr wait_until_frame_no
  lda #(intro_07_sprite / $40) & $ff
  sta which_sprites_at_top + 1
  lda #(empty_sprites / $40) & $ff
  sta which_sprites_at_bottom + 1
  jsr grab_an_intro_image

wait_until_7c = one_bar*9 + one_note*2
  lda #<wait_until_7c
  ldx #>wait_until_7c
  jsr wait_until_frame_no
  lda #(intro_som_kopplas_sprite / $40) & $ff
  sta which_sprites_at_bottom + 1


; Start nyheter image:
wait_until_8a = one_bar*10 - margin
  lda #<wait_until_8a
  ldx #>wait_until_8a
  jsr wait_until_frame_no
  lda #(empty_sprites / $40) & $ff
  sta which_sprites_at_top + 1
  sta which_sprites_at_bottom + 1
  jsr grab_an_intro_image
  lda #1
  sta intro_done+1
  lda #$7
  sta upper_d015+1
  lda #0
  sta upper_sprcol+1
  sta lower_sprcol+1

ever:
sync:
  lda #0
  beq sync
  lda #0
  sta sync+1

  lda screen_mode+1
  beq do_logos
  cmp #1
  beq do_bounce
  cmp #2
  beq do_bounce
;do koala:
  lda MouseEvent_buttons
  cmp #$ff
  beq no_mouse_event_koala
  lda #$ff
  sta MouseEvent_buttons
  jsr next_page
  jmp ever
no_mouse_event_koala
  jmp ever
do_logos:
;Do logos:
  lda MouseEvent_buttons
  cmp #$ff
  beq no_mouse_event_logo
  lda #$ff
  sta MouseEvent_buttons

;Find out which paper was clicked on:
  lda MouseEvent_ypos
  ;divide by 50:
  ldx #3  ;aftenposten
  cmp #150
  bcs paper_decided
  ldx #2  ;vg
  cmp #100
  bcs paper_decided
  ldx #1  ;svd
  cmp #50
  bcs paper_decided
  ldx #0  ;aftonbladet
paper_decided:
  stx which_paper
  txa
  asl
  asl
  asl
; These sprites are at $8000, so no need to add anything:
;  clc
;  adc #(logo_sprites / $40) & $ff
  sta which_sprites_at_top+1

;Send a request for headlines
;check if ready to send a byte:
wait_usb_tx_0:
  bit USB_STATUS
  bvc wait_usb_tx_0
  lda which_paper
  adc #$41
  sta USB_DATA             ; send the byte A, B, C or D

  jsr receive_anything
no_mouse_event_logo:
  jmp ever

do_bounce:
text_xpos:
  ldx #0
text_dir:
  lda #0
  bne go_left
go_right:
  inx
  stx text_xpos+1
  cpx #$7f
  bne no_bounce
  lda #1
  sta text_dir+1
  jmp no_bounce
go_left:
  dex
  stx text_xpos+1
  bne no_bounce
  lda #0
  sta text_dir+1
no_bounce:
  lda text_xpos+1
  lsr
  lsr
  lsr
  lsr
  sta chars_x_msb+1

  lda text_xpos+1
  lsr
  and #$07
  ora #$c8
  sta the_d016+1

;set charset:
  lda text_xpos+1
  and #1
  asl
  ora #$c8
  sta the_d018+1
  jsr print_chars

  lda MouseEvent_buttons
  cmp #$ff
  beq no_mouse_event_text
  lda #$ff
  sta MouseEvent_buttons
  jsr next_page
  jmp ever
no_mouse_event_text:
  jmp ever

next_page:
;Send a request for next page, disguised as a "on which row is the mouse"-char:
wait_usb_tx_10:
  bit USB_STATUS
  bvc wait_usb_tx_10
  lda MouseEvent_ypos
  sec
  sbc #8
  lsr
  lsr
  lsr
  clc
  adc #$61
  sta USB_DATA             ; send the byte a, b, c, d, e, f...
  jmp receive_anything


wait_until_frame_no:
sync_tick:
  ldy #0
  beq sync_tick
  dey
  sty sync_tick+1
  ldy MouseEvent_buttons
  cpy #$ff
  bne skip_this
  cmp frame_no_lsb
  bne wait_until_frame_no
  cpx frame_no_msb
  bne wait_until_frame_no
  rts
skip_this:
  lda #$ff
  sta MouseEvent_buttons
  rts


clear_hires:
  lda #$11
;  lda koala_bordercol+1
;  lsr
;  lsr
;  lsr
;  lsr
;  ora koala_bordercol+1
  ldx #0
clrrcols:
  sta $d800,x
  sta $d900,x
  sta $da00,x
  sta $db00,x
;screen at $cc00
  sta $cc00,x
  sta $cd00,x
  sta $ce00,x
  sta $cef8,x
  inx
  bne clrrcols
  rts


grab_an_intro_image:
;Send a request for koala image:
;check if ready to send a byte:
wait_usb_tx_aa:
  bit USB_STATUS
  bvc wait_usb_tx_aa
  lda #$61
  sta USB_DATA             ; send the byte a
  jmp receive_anything




receive_koala:
;Clear the previous koala:
  lda #1
  sta koala_bgcol+1
  sta koala_bordercol+1
  ldx #0
  lda #$11
clrcol_1:
  sta koala_screen,x
  sta koala_screen+$100,x
  sta koala_screen+$200,x
  sta koala_screen+$2e8,x
  sta $d800,x
  sta $d800+$100,x
  sta $d800+$200,x
  sta $d800+$2e8,x
  inx 
  bne clrcol_1

  lda #3
  sta screen_mode+1
; 8000 bytes bitmap
; 1000 bytes chars
; 1000 bytes $d800
; 1 byte $d021
  lda #<koala_image_bitmap
  sta koala_poi
  lda #>koala_image_bitmap
  sta koala_poi+1
  ldy #0
wait_usb_rx_ok8:
  bit USB_STATUS
  bpl wait_usb_rx_ok8
  lda USB_DATA
  sta (koala_poi),y
  iny
  bne wait_usb_rx_ok8
  inc koala_poi+1
  lda koala_poi+1
  cmp #$ff
  bne wait_usb_rx_ok8
wait_usb_rx_ok9:
  bit USB_STATUS
  bpl wait_usb_rx_ok9
  lda USB_DATA
  sta (koala_poi),y
  iny
  cpy #$40
  bne wait_usb_rx_ok9
  lda #<koala_screen
  sta koala_poi
  lda #>koala_screen
  sta koala_poi+1
  ldy #0
wait_usb_rx_ok10:
  bit USB_STATUS
  bpl wait_usb_rx_ok10
  lda USB_DATA
  sta (koala_poi),y
  iny
  bne wait_usb_rx_ok10
  inc koala_poi+1
  lda koala_poi+1
  cmp #>(koala_screen+$300)
  bne wait_usb_rx_ok10
wait_usb_rx_ok11:
  bit USB_STATUS
  bpl wait_usb_rx_ok11
  lda USB_DATA
  sta (koala_poi),y
  iny
  cpy #$e8
  bne wait_usb_rx_ok11

  lda #$00
  sta koala_poi
  lda #$d8
  sta koala_poi+1
  ldy #0
wait_usb_rx_ok12:
  bit USB_STATUS
  bpl wait_usb_rx_ok12
  lda USB_DATA
  sta (koala_poi),y
  iny
  bne wait_usb_rx_ok12
  inc koala_poi+1
  lda koala_poi+1
  cmp #$db
  bne wait_usb_rx_ok12
wait_usb_rx_ok13:
  bit USB_STATUS
  bpl wait_usb_rx_ok13
  lda USB_DATA
  sta (koala_poi),y
  iny
  cpy #$e8
  bne wait_usb_rx_ok13

wait_usb_rx_ok14:
  bit USB_STATUS
  bpl wait_usb_rx_ok14
  lda USB_DATA
  sta koala_bgcol + 1
  sta koala_bordercol + 1

wait_usb_rx_ok141:
  bit USB_STATUS
  bpl wait_usb_rx_ok141
  lda USB_DATA

  rts


;handle_mouse_event:
;  ldx #$ff
;longercol:
;  lda MouseEvent_buttonsc
;  cmp #1
;  bne no_left_button
;  lda #$a
;  sta $d020
;  jsr receive_koala
;  jmp done_with_mouse_event
;no_left_button:
;  cmp #2
;  bne no_right_button
;  lda #$2
;  sta $d020
;no_right_button:
;done_with_mouse_event:
;  lda #$ff
;  sta MouseEvent_buttons
;  rts

org music
  incbin "music/nyheter2x.bin"

uppermost_irq = $32

org mouse_sprites0
  incbin "sprites/amiga_pointer.map"

  ORG code_segment_34c0
irq0:
  sta savea0+1
  stx savex0+1
  sty savey0+1

; This is where the screen "starts", somewhere around rasterline $32
  nop
  nop
  nop
  nop
  nop
  nop
  nop
  nop
  nop
  nop
  nop
  nop
  nop

screen_mode:
;0 = logos/credits
;1 = fullscreen hires, interlaced
;2 = text, interlaced
;3 = koala
  lda #2
  bne no_logos
;Yes, we shall show the logos image now:

;D018  53272   VIC Memory Control Register
;    7-4 Video Matrix Base Address (inside VIC)
;    3-1 Character Dot-Data Base Address (inside VIC)
;    0 Select upper/lower Character Set
;screen at $cc00
;bitmap at $e000
  lda #$38
  sta $d018
;singlecol, 40 chars wide
  lda #$c8
  sta $d016
;data direction for bank selecting
  lda #$03
  sta $dd02
;bank $c000-$ffff
  lda #$00
  sta $dd00
  lda #<irq_open_border
  sta irq_zp_lsb
  lda #>irq_open_border
  sta irq_zp_msb
  lda #irq_open_border_rasterline
  sta $d012

  lda upper_d015+1
  sta $d015
  lda #0
  sta $d017
  sta $d01d
  lda #0
  sta $d027
  lda #2
  sta $d028
  lda #1
  sta $d029



  lda mouse_y+1
  clc
  adc #uppermost_irq
  sta $d001
  sta $d003
  sta $d005
  ldx mouse_x_lsb+1
  stx $d000
  stx $d002
  stx $d004
  lda mouse_x_msb+1
  lsr
  lda #0
  bcc dod0102
  lda #$7
dod0102:
  sta $d010


  ldx #12
wejt:
  dex
  bne wejt
;bitmap
  lda #$3b
  sta $d011

  jmp setup_mouse2
no_logos:
  cmp #3
  bne no_koala
;Yes, we shall show the koala image now:

;D018  53272   VIC Memory Control Register
;    7-4 Video Matrix Base Address (inside VIC)
;    3-1 Character Dot-Data Base Address (inside VIC)
;    0 Select upper/lower Character Set
;screen at $cc00
;bitmap at $e000
  lda #$38
  sta $d018
;multicol, 40 chars wide
  lda #$d8
  sta $d016
;data direction for bank selecting
  lda #$03
  sta $dd02
;bank $c000-$ffff
  lda #$00
  sta $dd00
;bitmap
  lda #<irq_open_border
  sta irq_zp_lsb
  lda #>irq_open_border
  sta irq_zp_msb
  lda #irq_open_border_rasterline
  sta $d012
  lda #$3b
  sta $d011
  jmp setup_mouse
no_koala:

;ToDo: check #0, logos
  lda #$1b
  sta $d011
  lda #uppermost_irq + 64 + 8
  sta $d012
  lda #3
  sta $dd00
the_d016:
  lda #$c8
  sta $d016
the_d018:
  lda #$c8
  sta $d018
  lda #<irq1
  sta irq_zp_lsb
  lda #>irq1
  sta irq_zp_msb

setup_mouse:
upper_d015:
  lda #$00
  sta $d015
  lda #0
  sta $d017
  sta $d01d
  lda #0
  sta $d027
  lda #2
  sta $d028
  lda #1
  sta $d029

mouse_y:
  lda #$50
  clc
  adc #uppermost_irq
  sta $d001
  sta $d003
  sta $d005
mouse_x_lsb:
  ldx #$80
  stx $d000
  stx $d002
  stx $d004
mouse_x_msb:
  lda #0
  lsr
  lda #0
  bcc dod010
  lda #$7
dod010:
  sta $d010

setup_mouse2:

  ldx #((mouse_sprites0 / $40) & $ff)
  stx screen0 + $3f8 - $28
  stx screen1 + $3f8 - $28
  stx screen2 + $3f8 - $28
  inx
  stx screen0 + $3f9 - $28
  stx screen1 + $3f9 - $28
  stx screen2 + $3f9 - $28
  inx
  stx screen0 + $3fa - $28
  stx screen1 + $3fa - $28
  stx screen2 + $3fa - $28

  ldx #((mouse_sprites3 / $40) & $ff)
  stx koala_screen + $3f8
  inx
  stx koala_screen + $3f9
  inx
  stx koala_screen + $3fa

  jsr mouse_irq
  jsr music_play

;  jsr do_keyboard
;  bcs NoValidInput
;  stx maybe_key_x + 1
;  sty maybe_key_y + 1
;  cmp #$ff
;  beq NoNewAphanumericKey
;  ; Check A for Alphanumeric keys
;  sta keyboard_a
;NoNewAphanumericKey:
;  ; Check X & Y for Non-Alphanumeric Keys
;maybe_key_x:
;  ldx #0
;maybe_key_y:
;  ldy #0
;  stx keyboard_x
;  sty keyboard_y
;NoValidInput:  ; This may be substituted for an errorhandler if needed.
;
;
;  lda keyboard_x
;  cmp #$80
;  bne no_keyb_updown
;  lda keyboard_y
;  and #$60
;  beq do_keyb_down
;;do_keyb_up:
;  lda actualxpos+0
;  sec
;  sbc #1
;  sta actualxpos+0
;  lda actualxpos+1
;  sbc #0
;  sta actualxpos+1
;  jmp no_keyb_updown
;do_keyb_down:
;  lda actualxpos+0
;  clc
;  adc #1
;  sta actualxpos+0
;  lda actualxpos+1
;  adc #0
;  sta actualxpos+1
;no_keyb_updown:

end_irq0:
  inc $d019
savea0:
  lda #0
savey0:
  ldy #0
savex0:
  ldx #0
  rti

keyboard_a: dc.b $ff
keyboard_x: dc.b $00
keyboard_y: dc.b $00

irq1:
  sta savea1+1
  stx savex1+1
  sty savey1+1

  lda #$1b
  sta $d011
  lda #uppermost_irq + 64 + 64 + 8
  sta $d012

  nop
  nop
  nop
  nop
  nop
  nop
  nop
  nop
;  nop
;  nop
  bit $ea

  lda #2
  sta $dd00
  lda #<irq2
  sta irq_zp_lsb
  lda #>irq2
  sta irq_zp_msb

  inc $d019
savea1:
  lda #0
savey1:
  ldy #0
savex1:
  ldx #0
  rti


irq2:
  sta savea2+1
  stx savex2+1
  sty savey2+1

  lda #$1b
  sta $d011
  lda #irq_open_border_rasterline
  sta $d012

  nop
  nop
  nop
  nop
  nop
  nop
  nop
  nop
;  nop
;  nop
  bit $ea

  lda #1
  sta $dd00
  lda #<irq_open_border
  sta irq_zp_lsb
  lda #>irq_open_border
  sta irq_zp_msb

  inc $d019
savea2:
  lda #0
savey2:
  ldy #0
savex2:
  ldx #0
  rti

irq_open_border_rasterline = $fa
irq_open_border:
  sta saveaob2+1
  stx savexob2+1
  sty saveyob2+1
  lda #$0
  sta $d012
  lda #<irq_vblank
  sta irq_zp_lsb
  lda #>irq_vblank
  sta irq_zp_msb
  lda $d011
  and #$f7
  sta $d011
;  lda #$c
;  sta $d020
;  lda #$5
;  sta $d021

  lda #$13
;  and #$d7
  sta $d011

intro_done:
  lda #0
  beq do_lower_border_sprites
  jmp no_lower_border_sprites
do_lower_border_sprites:
  lda #$ff
  sta $d015
  lda #$03
  sta $d001
  sta $d003
  sta $d005
  sta $d007
  sta $d009
  sta $d00b
  sta $d00d
  sta $d00f

;screen at $b000
  lda #$c8
  sta $d018
;logo_sprites are in bank $8000-$bfff
  lda #1
  sta $dd00

  lda #spr_logo_x
  sta $d000
  clc
  adc #$18
  sta $d000
  clc
  adc #$18
  sta $d002
  clc
  adc #$18
  sta $d004
  clc
  adc #$18
  sta $d006
  clc
  adc #$18
  sta $d008
  clc
  adc #$18
  sta $d00a
  clc
  adc #$18
  sta $d00c
  clc
  adc #$18
  sta $d00e
  lda #$00
  sta $d010
upper_sprcol:
  lda #$0
  ldx koala_bgcol + 1
  bne black_is_ok2
; Need to make paper sprites non-black, since the koala bgcol is black already.
  lda #$b
black_is_ok2:
  sta $d027
  sta $d028
  sta $d029
  sta $d02a
  sta $d02b
  sta $d02c
  sta $d02d
  sta $d02e
  lda #0
  sta $d01b
  sta $d017
  sta $d01c
  sta $d01d

which_sprites_at_bottom:
  ldx #((logo_sprites / $40) & $ff)
  stx screen2 + $3f8 - $28
  inx
  stx screen2 + $3f9 - $28
  inx
  stx screen2 + $3fa - $28
  inx
  stx screen2 + $3fb - $28
  inx
  stx screen2 + $3fc - $28
  inx
  stx screen2 + $3fd - $28
  inx
  stx screen2 + $3fe - $28
  inx
  stx screen2 + $3ff - $28



no_lower_border_sprites:

  jsr mouse_irq
  jsr music_play

; Signal to ever that main thread can start things syncronized to vblank
  inc sync+1

  inc $d019
saveaob2:
  lda #0
saveyob2:
  ldy #0
savexob2:
  ldx #0
  rti

irq_vblank:
  sta savea4+1
  stx savex4+1
  sty savey4+1

  lda #uppermost_irq - 3
  sta $d012
  lda #$f
  sta $d020
  lda #$f
  sta $d021
  lda #$ff
  sta $d015

koala_bgcol:
  lda #$e
  sta $d021
koala_bordercol:
  lda #$1
  sta $d020

;D018  53272   VIC Memory Control Register
;    7-4 Video Matrix Base Address (inside VIC)
;    3-1 Character Dot-Data Base Address (inside VIC)
;    0 Select upper/lower Character Set
;screen at $b000
  lda #$c8
  sta $d018
;bitmap
  lda #$1b
  sta $d011
;logo_sprites are in bank $8000-$bfff
  lda #1
  sta $dd00

spr_logo_x = $38
  lda #spr_logo_x
  sta $d000
  clc
  adc #$18
  sta $d000
  clc
  adc #$18
  sta $d002
  clc
  adc #$18
  sta $d004
  clc
  adc #$18
  sta $d006
  clc
  adc #$18
  sta $d008
  clc
  adc #$18
  sta $d00a
  clc
  adc #$18
  sta $d00c
  clc
  adc #$18
  sta $d00e
  lda #$00
  sta $d010
  lda #25
  sta $d001
  sta $d003
  sta $d005
  sta $d007
  sta $d009
  sta $d00b
  sta $d00d
  sta $d00f
lower_sprcol:
  lda #$0
  ldx koala_bgcol + 1
  bne black_is_ok
; Need to make paper sprites non-black, since the koala bgcol is black already.
  lda #$b
black_is_ok:
  sta $d027
  sta $d028
  sta $d029
  sta $d02a
  sta $d02b
  sta $d02c
  sta $d02d
  sta $d02e
  lda #0
  sta $d01b
  sta $d017
  sta $d01c
  sta $d01d

which_sprites_at_top:
  ldx #((logo_sprites / $40) & $ff)
  stx screen2 + $3f8 - $28
  inx
  stx screen2 + $3f9 - $28
  inx
  stx screen2 + $3fa - $28
  inx
  stx screen2 + $3fb - $28
  inx
  stx screen2 + $3fc - $28
  inx
  stx screen2 + $3fd - $28
  inx
  stx screen2 + $3fe - $28
  inx
  stx screen2 + $3ff - $28

  lda #<irq0
  sta irq_zp_lsb
  lda #>irq0
  sta irq_zp_msb

  jsr placeSprite
  inc sync_tick+1
  inc frame_no_lsb
  bne no_frwrap
  inc frame_no_msb
no_frwrap:


  inc $d019
savea4:
  lda #0
savey4:
  ldy #0
savex4:
  ldx #0
  rti

  ORG $3fff
  .byte 0

  ORG code_segment_4000

mouseType:  ds.b 1
stateVars:
xpos:   ds.b 2
ypos:   ds.b 2
actualxpos:   ds.b 2
actualypos:   ds.b 2
currentxpos:  ds.b 2
currentypos:  ds.b 2
dx:     ds.b 2
dy:     ds.b 2
oldPotX:  ds.b 1
oldPotY:  ds.b 1
tmp:    ds.b 1
buttons:  ds.b 1
acceleration:   ds.b 1
mouseConnected: ds.b 1
stateVars_end:

MouseEvent_buttons: ds.b 1
MouseEvent_xpos:    ds.b 2
MouseEvent_ypos:    ds.b 1

pointerEnabled: ds.b 1

xmin = $18
xmax = $18 + 317
ymin = 0
ymax = 230

mouse_init:
  stx mouseType

; Mouse in PORT1:
;  LDA #$40 ; '@'
; Mouse in PORT2:
  LDA #$80 ; '@'
  STA $DC00
  LDA #$C0 ; 'À'
  STA $DC02

  lda #1
  sta pointerEnabled

  lda #0
  ldx #stateVars_end-stateVars-1
nullstate:
  sta stateVars,x
  dex
  bpl nullstate
;  jsrf updatePointerSprite

  lda #<((xmin+xmax)/2)
  sta xpos+0
  sta currentxpos+0
  sta actualxpos+0
  lda #>((xmin+xmax)/2)
  sta xpos+1
  sta currentxpos+1
  sta actualxpos+1
  lda #<((ymin+ymax)/2)
  sta ypos+0
  sta currentypos+0
  sta actualypos+0
  lda #>((ymin+ymax)/2)
  sta ypos+1
  sta currentypos+1
  sta actualypos+1

  lda #$ff
  sta MouseEvent_buttons
  lda #0
  sta MouseEvent_xpos
  sta MouseEvent_xpos+1
  sta MouseEvent_ypos
  sta dx+0
  sta dx+1
  sta dy+0
  sta dy+1
  sta buttons
  lda #1
  sta acceleration

  lda $d419
  sta oldPotX
  lda $d41a
  sta oldPotY

  jmp placeSprite


deltaX: ds.b 1
deltaY: ds.b 1

placeSprite:
  lda acceleration
  beq no_accx
    clc
    lda dx+0
    adc #64
    tax

    clc
    lda xpos+0
    adc accelerationTable_lo,x
    tay
    lda xpos+1
    adc accelerationTable_hi,x
    tax
    jmp accx_done
no_accx:
    clc
    lda xpos+0
    adc dx+0
    tay
    lda xpos+1
    adc dx+1
    tax
accx_done:
  jsr limitX

  lda acceleration
  beq no_accy
    clc
    lda dy+0
    adc #64
    tax

    sec
    lda ypos+0
    sbc accelerationTable_lo,x
    tay
    lda ypos+1
    sbc accelerationTable_hi,x
    tax
    jmp accy_done
no_accy:
    sec
    lda ypos+0
    sbc dy+0
    tay
    lda ypos+1
    sbc dy+1
    tax
accy_done:
  jsr limitY

  ; Filter xpos
  sec
  lda xpos+0
  sbc currentxpos+0
  cmp #<-1
  bmi filx
  cmp #2
  bpl filx
  jmp filx_done
filx:
    lda xpos+0
    sta currentxpos+0
    lda xpos+1
    sta currentxpos+1
filx_done:

  ; Filter ypos
  sec
  lda ypos+0
  sbc currentypos+0
  cmp #<-1
  bmi fily
  cmp #2
  bpl fily
  jmp fily_done
fily:
    lda ypos+0
    sta currentypos+0
    lda ypos+1
    sta currentypos+1
fily_done:

  ; Move actual towards current
  clc
  lda currentxpos+0
  adc actualxpos+0
  sta actualxpos+0
  lda currentxpos+1
  adc actualxpos+1
  ror
  sta actualxpos+1
  ror actualxpos+0
  clc
  lda currentypos+0
  adc actualypos+0
  sta actualypos+0
  lda currentypos+1
  adc actualypos+1
  ror
  sta actualypos+1
  ror actualypos+0

  ; Reset delta
  lda #0
  sta dx+0
  sta dx+1
  sta dy+0
  sta dy+1

  ; Place sprite
  lda actualxpos+0
  sta mouse_x_lsb+1
  lda actualxpos+1
  and #1
  sta mouse_x_msb+1
  lda actualypos+0
  sta mouse_y+1
  rts

accelerationTable_lo:
  .incbin "mouse_acc.bin"
accelerationTable_hi = accelerationTable_lo+128

limitX:
  ; Limit the X coordinate to the bounding box
    cpy #<xmin
  sbc #>xmin
    bpl no_xmin
      ldy #<xmin
      ldx #>xmin
      jmp x_done
no_xmin:
  txa
    cpy #<xmax
    sbc #>xmax
    bmi no_xmax
      ldy #<xmax
    ldx #>xmax
no_xmax:
x_done:
  sty xpos+0
    stx xpos+1
    rts

limitY:
  ; Limit the Y coordinate to the bounding box
  cpy #<ymin
  sbc #>ymin
  bpl no_ymin
  ldy #<ymin
  ldx #>ymin
  jmp y_done
no_ymin:
  txa
  cpy #<ymax
  sbc #>ymax
  bmi no_ymax
  ldy #<ymax
  ldx #>ymax
no_ymax:
y_done:
  sty ypos+0
  stx ypos+1
  rts

INDJMPOP:
  jmp $1234
INDJMP = INDJMPOP + 1

mouse_irq:
  ; Always do joystick, PORT1
  jsr mouse_joy
  ; And do mouse as well:
  jsr mouse_1351

  lda MouseEvent_buttons
  cmp #$ff
  beq no_pending_event
  ; Unprocessed event, abort
  rts
no_pending_event:

  lda $dc01
  and #$10
  bne no_butdown
;Yes, joystick button is pressed
  lda #1
  jmp any_button
no_butdown:
  jsr buttons_1351
  bne any_button
  ; No mouse button pressed, abort
  sta buttons
  rts
any_button:
  cmp buttons
  bne new_button
  ; Still the same mouse button, abort
  rts
new_button:
  ; Generate event (but only for 0->1 transitions)
  sta tmp
  lda buttons
  eor #3
  and tmp
  bne still_interested
    ; No 0->1 transition
    lda tmp
    sta buttons
    rts
still_interested:
  sta MouseEvent_buttons
  lda tmp
  sta buttons

  lda xpos+0
  sta MouseEvent_xpos+0
  lda xpos+1
  sta MouseEvent_xpos+1
  lda ypos
  sta MouseEvent_ypos
  rts

mouse_1351:
  lda #0
  sta mouseConnected

  lda $d419
  ldy oldPotX
  jsr moveCheck
  bcc no_xmove
  sty oldPotX
  clc
  adc dx+0
  sta dx+0
  txa
  adc dx+1
  sta dx+1
  inc mouseConnected
no_xmove:

  ; Calculate the Y movement vector
  lda $d41a
  ldy oldPotY
  jsr moveCheck         ; Calculate movement
  bcc no_ymove
  sty oldPotY
  clc
  adc dy+0
  sta dy+0
  txa
  adc dy+1
  sta dy+1
  inc mouseConnected
no_ymove:
  rts

; Returns delta in x,a (-64..63) (new pot value in y)
moveCheck:
  and #$fe
  sty tmp
  cmp #$fe
  beq disconnected
  tay

  sec
  sbc tmp

  ldx #0
  and #$7f
  lsr

  cmp #$20
  bcs check_20
  sec
  rts
check_20:
  ora #$c0
  dex
  rts

disconnected:
  clc
  rts

buttons_1351:
  ; Bit 0: Right mouse button
  ; Bit 4: Left mouse button
  lda $dc00
  eor #$ff
  pha
  and #1
  asl
  sta tmp
  pla
  lsr
  lsr
  lsr
  lsr
  and #1
  ora tmp
  rts

mouse_joy:
  lda #1
  sta mouseConnected
  lda $dc01
  sta tmp

  lda #0
  sta dx+0
  sta dy+0
  sta dx+1
  sta dy+1

  lsr tmp
  bcs no_up
    ;up
    lda #<1
    sta dy+0
    lda #>1
    sta dy+1
no_up:

  lsr tmp
  bcs no_down
    ;down
    lda #<-1
    sta dy+0
    lda #>-1
    sta dy+1
no_down:

  lsr tmp
  bcs no_right
    ;right
    lda #<-2
    sta dx+0
    lda #>-2
    sta dx+1
no_right:

  lsr tmp
  bcs no_left
    ;left
    lda #<2
    sta dx+0
    lda #>2
    sta dx+1
no_left:
  rts

;buttons_joy:
;  lda $dc01
;  and #$10
;  bne no_butdown
;  lda tmp
;  ora #1
;  sta tmp
;no_butdown:
;;  lda $d419 ;c0=released, ff=pressed
;;  cmp #$ff
;;  bne no_but2down
;;    lda tmp
;;    ora #2
;;    sta tmp
;;no_but2down:
;;  lda tmp
;  rts




;https://codebase64.org/doku.php?id=base:scanning_the_keyboard_the_correct_and_non_kernal_way
;/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
;    Keyboard IO Routine
;    ~~~~~~~~~~~~~~~~~~~
;        By: TWW/CTR
;
;
;    Preparatory Settings
;    ~~~~~~~~~~~~~~~~~~~~
;        None
;
;
;    Destroys
;    ~~~~~~~~
;        Accumulator
;        X-Register
;        Y-Register
;        Carry / Zero / Negative
;        $dc00
;        $dc01
;        $50-$5f
;
;
;    Footprint
;    ~~~~~~~~~
;        #$206 Bytes
;
;
;    Information
;    ~~~~~~~~~~~
;        The routine uses "2 Key rollower" or up to 3 if the key-combination doesen't induce shadowing.
;        If 2 or 3 keys are pressed simultaneously (within 1 scan) a "No Activity" state has to occur before new valid keys are returned.
;        RESTORE is not detectable and must be handled by NMI IRQ.
;        SHIFT LOCK is not detected due to unreliability.
;
;
;    Usage
;    ~~~~~
;      Example Code:
;
;            jsr Keyboard
;            bcs NoValidInput
;                stx TempX
;                sty TempY
;                cmp #$ff
;                beq NoNewAphanumericKey
;                ; Check A for Alphanumeric keys
;                    sta $0400
;            NoNewAphanumericKey:
;        ; Check X & Y for Non-Alphanumeric Keys
;            ldx TempX
;            ldy TempY
;            stx $0401
;            sty $0402
;       NoValidInput:  // This may be substituted for an errorhandler if needed.
;
;
;    Returned
;    ~~~~~~~~
;
;        +=================================================+
;        |             Returned in Accumulator             |
;        +===========+===========+=============+===========+
;        |  $00 - @  |  $10 - p  |  $20 - SPC  |  $30 - 0  |
;        |  $01 - a  |  $11 - q  |  $21 -      |  $31 - 1  |
;        |  $02 - b  |  $12 - r  |  $22 -      |  $32 - 2  |
;        |  $03 - c  |  $13 - s  |  $23 -      |  $33 - 3  |
;        |  $04 - d  |  $14 - t  |  $24 -      |  $34 - 4  |
;        |  $05 - e  |  $15 - u  |  $25 -      |  $35 - 5  |
;        |  $06 - f  |  $16 - v  |  $26 -      |  $36 - 6  |
;        |  $07 - g  |  $17 - w  |  $27 -      |  $37 - 7  |
;        |  $08 - h  |  $18 - x  |  $28 -      |  $38 - 8  |
;        |  $09 - i  |  $19 - y  |  $29 -      |  $39 - 9  |
;        |  $0a - j  |  $1a - z  |  $2a - *    |  $3a - :  |
;        |  $0b - k  |  $1b -    |  $2b - +    |  $3b - ;  |
;        |  $0c - l  |  $1c - £  |  $2c - ,    |  $3c -    |
;        |  $0d - m  |  $1d -    |  $2d - -    |  $3d - =  |
;        |  $0e - n  |  $1e - ^  |  $2e - .    |  $3e -    |
;        |  $0f - o  |  $1f - <- |  $2f - /    |  $3f -    |
;        +-----------+-----------+-------------+-----------+
;
;        +================================================================================
;        |                             Return in X-Register                              |
;        +=========+=========+=========+=========+=========+=========+=========+=========+
;        |  Bit 7  |  Bit 6  |  Bit 5  |  Bit 4  |  Bit 3  |  Bit 2  |  Bit 1  |  Bit 0  |
;        +---------+---------+---------+---------+---------+---------+---------+---------+
;        | CRSR UD |   F5    |   F3    |   F1    |   F7    | CRSR RL | RETURN  |INST/DEL |
;        +---------+---------+---------+---------+---------+---------+---------+---------+
;
;        +================================================================================
;        |                             Return in Y-Register                              |
;        +=========+=========+=========+=========+=========+=========+=========+=========+
;        |  Bit 7  |  Bit 6  |  Bit 5  |  Bit 4  |  Bit 3  |  Bit 2  |  Bit 1  |  Bit 0  |
;        +---------+---------+---------+---------+---------+---------+---------+---------+
;        |RUN STOP | L-SHIFT |   C=    | R-SHIFT |CLR/HOME |  CTRL   |         |         |
;        +---------+---------+---------+---------+---------+---------+---------+---------+
;
;        CARRY:
;          - Set = Error Condition (Check A for code):
;              A = #$01 => No keyboard activity is detected.
;              A = #$02 => Control Port #1 Activity is detected.
;              A = #$03 => Key Shadowing / Ghosting is detected.
;              A = #$04 => 2 or 3 new keys is detected within one scan
;              A = #$05 => Awaiting "No Activity" state
;          - Clear = Valid input
;              A =  #$ff => No new Alphanumeric Keys detected (some key(s) being held down AND/OR some Non-Alphanumeric key is causing valid return).
;              A <> #$ff => New Alphanumeric Key returned. Non-Alphanumeric keys may also be returned in X or Y Register
;
;    Issues/ToDo:
;    ~~~~~~~~~~~~
;        - None
;
;
;    Improvements:
;    ~~~~~~~~~~~~~
;        - Replace the subroutine with a pseudocommand and account for speedcode parameter (Memory vs. Cycles).
;        - Shorten the routine / Optimize if possible.
;
;
;    History:
;    ~~~~~~~~
;    V2.5 - New test tool.
;           Added return of error codes.
;           Fixed a bug causing Buffer Overflow.
;           Fixed a bug in Non Alphanumerical Flags from 2.0.
;    V2.1 - Shortened the source by adding .for loops & Updated the header and some comments.
;           Added "simultaneous keypress" check.
;    V2.0 - Added return of non-Alphanumeric keys into X & Y-Registers.
;           Small optimizations here and there.
;    V1.1 - Unrolled code to make it faster and optimized other parts of it.
;           Removed SHIFT LOCK scanning.
;    V1.0 - First Working Version along with test tool.
;
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

;Operational Variables
MaxKeyRollover = 3

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
; Routine for Scanning a Matrix Row

KeyInRow:
  asl
  bcs *+5
  jsr KeyFound
  inx
  asl
  bcs *+5
  jsr KeyFound
  inx
  asl
  bcs *+5
  jsr KeyFound
  inx
  asl
  bcs *+5
  jsr KeyFound
  inx
  asl
  bcs *+5
  jsr KeyFound
  inx
  asl
  bcs *+5
  jsr KeyFound
  inx
  asl
  bcs *+5
  jsr KeyFound
  inx
  asl
  bcs *+5
  jsr KeyFound
  rts


;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
; Routine for handling: Key Found

KeyFound:
  stx TempZP
  dec KeyQuantity
  bmi OverFlow
  ldy KeyTable,x
  ldx KeyQuantity
  sty BufferNew,x
  ldx TempZP
  rts

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
; Routine for handling: Overflow

OverFlow:
  pla  ; Dirty hack to handle 2 layers of JSR
  pla
  pla
  pla
; Don't manipulate last legal buffer as the routine will fix itself once it gets valid input again.
  lda #$03
  sec
  rts


;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
; Exit Routine for: No Activity

NoActivityDetected:
; Exit With A = #$01, Carry Set & Reset BufferOld.
  lda #$00
  sta SimultaneousAlphanumericKeysFlag  ; Clear the too many keys flag once a "no activity" state is detected.
  stx BufferOld
  stx BufferOld+1
  stx BufferOld+2
  sec
  lda #$01
  rts


;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
; Exit Routine for Control Port Activity

ControlPort:
; Exit with A = #$02, Carry Set. Keep BufferOld to verify input after Control Port activity ceases
  sec
  lda #$02
  rts


;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
; Configure Data Direction Registers
do_keyboard:
  ldx #$ff
  stx $dc02   ; Port A - Output
  ldy #$00
  sty $dc03   ; Port B - Input


;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
; Check for Port Activity

  sty $dc00   ; Connect all Keyboard Rows
  cpx $dc01
  beq NoActivityDetected
  lda SimultaneousAlphanumericKeysFlag
  beq check_ctrl_port1
  ; Waiting for all keys to be released before accepting new input.
  lda #$05
  sec
  rts

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
; Check for Control Port #1 Activity
check_ctrl_port1:
    stx $dc00   ; Disconnect all Keyboard Rows
    cpx $dc01   ; Only Control Port activity will be detected
    bne ControlPort

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
; Scan Keyboard Matrix

  lda #%11111110
  sta $dc00
  ldy $dc01
  sty ScanResult+7
  sec
;    .for (var i = 6 ; i > -1 ; i--) {
;        rol
;        sta $dc00
;        ldy $dc01
;        sty ScanResult+i
;    }
  rol
  sta $dc00
  ldy $dc01
  sty ScanResult+6
  rol
  sta $dc00
  ldy $dc01
  sty ScanResult+5
  rol
  sta $dc00
  ldy $dc01
  sty ScanResult+4
  rol
  sta $dc00
  ldy $dc01
  sty ScanResult+3
  rol
  sta $dc00
  ldy $dc01
  sty ScanResult+2
  rol
  sta $dc00
  ldy $dc01
  sty ScanResult+1
  rol
  sta $dc00
  ldy $dc01
  sty ScanResult+0


;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
; Check for Control Port #1 Activity (again)

  stx $dc00   ; Disconnect all Keyboard Rows
  cpx $dc01   ; Only Control Port activity will be detected
  bne ControlPort


;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
; Initialize Buffer, Flags and Max Keys

; Reset current read buffer
  stx BufferNew
  stx BufferNew+1
  stx BufferNew+2

; Reset Non-AlphaNumeric Flag
  inx
  stx NonAlphaFlagY

; Set max keys allowed before ignoring result
  lda #MaxKeyRollover
  sta KeyQuantity

; Counter to check for simultaneous alphanumeric key-presses
  lda #$fe
  sta SimultaneousKeys


;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
; Check and flag Non Alphanumeric Keys

  lda ScanResult+6
  eor #$ff
  and #%10000000 ; Left Shift
  lsr
  sta NonAlphaFlagY
  lda ScanResult+0
  eor #$ff
  and #%10100100 ; RUN STOP - C= - CTRL
  ora NonAlphaFlagY
  sta NonAlphaFlagY
  lda ScanResult+1
  eor #$ff
  and #%00011000 ; Right SHIFT - CLR HOME
  ora NonAlphaFlagY
  sta NonAlphaFlagY

  lda ScanResult+7  ; The rest
  eor #$ff
  sta NonAlphaFlagX


;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
; Check for pressed key(s)

  lda ScanResult+7
  cmp #$ff
  beq *+5
  jsr KeyInRow
;  .for (var i = 6 ; i > -1 ; i--) {
;      ldx #[7-i]*8
;      lda ScanResult+i
;      beq *+5
;          jsr KeyInRow
;  }
  ldx #[7-6]*8
  lda ScanResult+6
  beq *+5
  jsr KeyInRow
  ldx #[7-5]*8
  lda ScanResult+5
  beq *+5
  jsr KeyInRow
  ldx #[7-4]*8
  lda ScanResult+4
  beq *+5
  jsr KeyInRow
  ldx #[7-3]*8
  lda ScanResult+3
  beq *+5
  jsr KeyInRow
  ldx #[7-2]*8
  lda ScanResult+2
  beq *+5
  jsr KeyInRow
  ldx #[7-1]*8
  lda ScanResult+1
  beq *+5
  jsr KeyInRow
  ldx #[7-0]*8
  lda ScanResult
  beq *+5
  jsr KeyInRow


;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
; Key Scan Completed

; Put any new key (not in old scan) into buffer
  ldx #MaxKeyRollover-1
keyb_more:
  lda BufferNew,x
  cmp #$ff
  beq Exist    ; Handle 'null' values
  cmp BufferOld
  beq Exist
  cmp BufferOld+1
  beq Exist
  cmp BufferOld+2
  beq Exist
; New Key Detected
  inc BufferQuantity
  ldy BufferQuantity
  sta Buffer,y
; Keep track of how many new Alphanumeric keys are detected
  inc SimultaneousKeys
  beq TooManyNewKeys
Exist:
  dex
  bpl keyb_more

; Anything in Buffer?
  ldy BufferQuantity
  bmi BufferEmpty
; Yes: Then return it and tidy up the buffer
  dec BufferQuantity
  lda Buffer
  ldx Buffer+1
  stx Buffer
  ldx Buffer+2
  stx Buffer+1
  jmp Return

BufferEmpty:  ; No new Alphanumeric keys to handle.
  lda #$ff

Return:  ; A is preset
  clc
; Copy BufferNew to BufferOld
  ldx BufferNew
  stx BufferOld
  ldx BufferNew+1
  stx BufferOld+1
  ldx BufferNew+2
  stx BufferOld+2
; Handle Non Alphanumeric Keys
  ldx NonAlphaFlagX
  ldy NonAlphaFlagY
  rts

TooManyNewKeys:
  sec
  lda #$ff
  sta BufferQuantity
  sta SimultaneousAlphanumericKeysFlag
  lda #$04
  rts

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
KeyTable:
  .byte $ff, $ff, $ff, $ff, $ff, $ff, $ff, $ff  ; CRSR DOWN, F5, F3, F1, F7, CRSR RIGHT, RETURN, INST DEL
  .byte $ff, $05, $13, $1a, $34, $01, $17, $33  ; LEFT SHIFT, "E", "S", "Z", "4", "A", "W", "3"
  .byte $18, $14, $06, $03, $36, $04, $12, $35  ; "X", "T", "F", "C", "6", "D", "R", "5"
  .byte $16, $15, $08, $02, $38, $07, $19, $37  ; "V", "U", "H", "B", "8", "G", "Y", "7"
  .byte $0e, $0f, $0b, $0d, $30, $0a, $09, $39  ; "N", "O" (Oscar), "K", "M", "0" (Zero), "J", "I", "9"
  .byte $2c, $00, $3a, $2e, $2d, $0c, $10, $2b  ; ",", "@", ":", ".", "-", "L", "P", "+"
  .byte $2f, $1e, $3d, $ff, $ff, $3b, $2a, $1c  ; "/", "^", "=", RIGHT SHIFT, HOME, ";", "*", "£"
  .byte $ff, $11, $ff, $20, $32, $ff, $1f, $31  ; RUN STOP, "Q", "C=" (CMD), " " (SPC), "2", "CTRL", "<-", "1"

BufferOld:
  .byte $ff, $ff, $ff

Buffer:
  .byte $ff, $ff, $ff, $ff

BufferQuantity:
  .byte $ff

SimultaneousAlphanumericKeysFlag:
  .byte $00


receive_anything:
; We don't know what we are going to get:
; It might be
; headlines
; an article page
; a koala image
; a hires image "credits"
; a hires image "headlines"

; While we're waiting for the first byte from USB telling us what we're getting,
; We could slowly "erase" the current screen in one way or another in a "slow" way.
; And, when we've gotten what type of data we're getting, make a fast erase and
; setup the new screen.

; For now, don't erase anything. Just wait.

;get_the_first_2_chars "size"
wait_usb_rx_ok83:
  bit USB_STATUS
  bpl wait_usb_rx_ok83
  lda USB_DATA
wait_usb_rx_ok84:
  bit USB_STATUS
  bpl wait_usb_rx_ok84
  lda USB_DATA

;get the TYPE_xxx
;const int TYPE_HEADLINES = 6;
;const int TYPE_TEXT = 1;
;const int TYPE_KOALA = 2;
;const int TYPE_HIRES = 3;
;const int TYPE_HIRES_SELECT_PAPER = 4;
;const int TYPE_INTERLACE_IMAGE = 5;
wait_usb_rx_ok85:
  bit USB_STATUS
  bpl wait_usb_rx_ok85
  lda USB_DATA
  cmp #1
  beq receive_text
  cmp #6
  beq receive_text
  cmp #2
  bne no_koala_this_time
  jmp receive_koala
no_koala_this_time:
  cmp #3
  bne no_hires_this_time
  jmp receive_hires
no_hires_this_time:
  cmp #4
  bne no_hires_select_paper_this_time
  jmp receive_hires_select_paper
no_hires_select_paper_this_time:
  cmp #5
  bne no_interlace_image_this_time
  jmp receive_interlace_image
no_interlace_image_this_time:

receive_text:
  ldx #0
  cmp #$6
  bne no_headlines
  ldx #6
no_headlines:
  stx text_colour
  lda #2
  sta screen_mode+1
  lda #1
  sta koala_bgcol+1
  sta koala_bordercol+1

  lda #0
  sta text_row
  lda #0
  sta text_column

  lda #0
  sta text_xpos+1
  sta chars_x_msb+1
  sta text_dir+1
  lda text_xpos+1
  lsr
  and #$07
  ora #$c8
  sta the_d016+1
  lda text_xpos+1
  and #1
  asl
  ora #$c8
  sta the_d018+1
  jsr print_chars

  ldx #0
  lda #1
white_more:
  sta $d800,x
  sta $d900,x
  sta $da00,x
  sta $dae8,x
  inx
  bne white_more

grab_another_char:
wait_usb_rx_ok80:
  bit USB_STATUS
  bpl wait_usb_rx_ok80
  lda USB_DATA
  cmp #$ff
  beq printing_done
  jsr plot_a_char
  jmp grab_another_char
printing_done:

; Get the leftover bytes:
  rts

receive_hires:
receive_hires_select_paper:
  sta saved_type+1
  sta screen_mode+1
;Clear the previous image:
  lda #1
  sta koala_bgcol+1
  sta koala_bordercol+1

  lda #0
  sta text_row
  lda #0
  sta text_column

  lda #0
  sta text_xpos+1
  sta chars_x_msb+1
  sta text_dir+1
  lda text_xpos+1
  lsr
  and #$07
  ora #$c8
  sta the_d016+1
  lda text_xpos+1
  and #1
  asl
  ora #$c8
  sta the_d018+1
  jsr print_chars

  ldx #0
  lda #$11
clrcol_1p:
  sta koala_screen,x
  sta koala_screen+$100,x
  sta koala_screen+$200,x
  sta koala_screen+$2e8,x
  sta $d800,x
  sta $d800+$100,x
  sta $d800+$200,x
  sta $d800+$2e8,x
  inx 
  bne clrcol_1p

  lda #0
  sta screen_mode+1
; 8000 bytes bitmap
  lda #<koala_image_bitmap
  sta koala_poi
  lda #>koala_image_bitmap
  sta koala_poi+1
  ldy #0
wait_usb_rx_ok8p:
  bit USB_STATUS
  bpl wait_usb_rx_ok8p
  lda USB_DATA
  sta (koala_poi),y
  iny
  bne wait_usb_rx_ok8p
  inc koala_poi+1
  lda koala_poi+1
  cmp #$ff
  bne wait_usb_rx_ok8p
wait_usb_rx_ok9p:
  bit USB_STATUS
  bpl wait_usb_rx_ok9p
  lda USB_DATA
  sta (koala_poi),y
  iny
  cpy #$40
  bne wait_usb_rx_ok9p

saved_type:
  lda #0
  cmp #4
  bne no_paper_start
;If paper_start:
  jmp show_nyheter_start
no_paper_start:
;if any other hires image:
;Set colour of screen:
  ldx #0
hires_col:
  lda #$16
setcol_1p:
  sta koala_screen,x
  sta koala_screen+$100,x
  sta koala_screen+$200,x
  sta koala_screen+$2e8,x
  sta $d800,x
  sta $d800+$100,x
  sta $d800+$200,x
  sta $d800+$2e8,x
  inx 
  bne setcol_1p
  lda #(empty_sprites / $40) & $ff
  sta which_sprites_at_top + 1
  rts




receive_interlace_image:
;Clear the previous image:
  sta screen_mode+1
  lda #1
  sta koala_bgcol+1
  sta koala_bordercol+1
  lda #0
  sta text_colour
  ldx #0
  lda #$11
clrcol_1q:
  sta $d800,x
  sta $d800+$100,x
  sta $d800+$200,x
  sta $d800+$2e8,x
  inx 
  bne clrcol_1q

  lda #1
  sta screen_mode+1
;$1000 bytes into $2000-$2fff
  lda #<charset0L
  sta koala_poi
  lda #>charset0L
  sta koala_poi+1
  ldy #0
wait_usb_rx_ok8q:
  bit USB_STATUS
  bpl wait_usb_rx_ok8q
  lda USB_DATA
  sta (koala_poi),y
  iny
  bne wait_usb_rx_ok8q
  inc koala_poi+1
  lda koala_poi+1
  cmp #$30
  bne wait_usb_rx_ok8q
;$1000 bytes into $6000-$6fff
  lda #<charset1L
  sta koala_poi
  lda #>charset1L
  sta koala_poi+1
  ldy #0
wait_usb_rx_ok8qq:
  bit USB_STATUS
  bpl wait_usb_rx_ok8qq
  lda USB_DATA
  sta (koala_poi),y
  iny
  bne wait_usb_rx_ok8qq
  inc koala_poi+1
  lda koala_poi+1
  cmp #$70
  bne wait_usb_rx_ok8qq
;$1000 bytes into $a000-$afff
  lda #<charset2L
  sta koala_poi
  lda #>charset2L
  sta koala_poi+1
  ldy #0
wait_usb_rx_ok8qqq:
  bit USB_STATUS
  bpl wait_usb_rx_ok8qqq
  lda USB_DATA
  sta (koala_poi),y
  iny
  bne wait_usb_rx_ok8qqq
  inc koala_poi+1
  lda koala_poi+1
  cmp #$b0
  bne wait_usb_rx_ok8qqq

;Set colour of screen:
  ldx #$1f
interl_col:
  lda #$10
setcol_22p:
  sta $d800+ 1*40,x
  sta $d800+ 2*40,x
  sta $d800+ 3*40,x
  sta $d800+ 4*40,x
  sta $d800+ 5*40,x
  sta $d800+ 6*40,x
  sta $d800+ 7*40,x
  sta $d800+ 8*40,x
  sta $d800+ 9*40,x
  sta $d800+10*40,x
  sta $d800+11*40,x
  sta $d800+12*40,x
  sta $d800+13*40,x
  sta $d800+14*40,x
  sta $d800+15*40,x
  sta $d800+16*40,x
  sta $d800+17*40,x
  sta $d800+18*40,x
  sta $d800+19*40,x
  sta $d800+20*40,x
  sta $d800+21*40,x
  sta $d800+22*40,x
  sta $d800+23*40,x
  sta $d800+24*40,x
  dex
  bpl setcol_22p
  rts


;No clue what this data is. Error.
error:
  sta $d021
  inc $d020
  jmp error



print_chars:
chars_x_msb:
  ldx #0
  lda #1
  sta $d7ff+$28,x
  sta $d7ff+8*40+$28,x
  sta $d7ff+16*40+$28,x
  lda text_colour
  sta $d800+$28,x
  sta $d800+8*40+$28,x
  sta $d800+16*40+$28,x
  ldy #0
  tya
  sta screen0+ 0*40+ 0,x
  sta screen1+ 8*40+ 0,x
  sta screen2+16*40+ 0,x
  iny
  tya
  sta screen0+ 0*40+ 1,x
  sta screen1+ 8*40+ 1,x
  sta screen2+16*40+ 1,x
  iny
  tya
  sta screen0+ 0*40+ 2,x
  sta screen1+ 8*40+ 2,x
  sta screen2+16*40+ 2,x
  iny
  tya
  sta screen0+ 0*40+ 3,x
  sta screen1+ 8*40+ 3,x
  sta screen2+16*40+ 3,x
  iny
  tya
  sta screen0+ 0*40+ 4,x
  sta screen1+ 8*40+ 4,x
  sta screen2+16*40+ 4,x
  iny
  tya
  sta screen0+ 0*40+ 5,x
  sta screen1+ 8*40+ 5,x
  sta screen2+16*40+ 5,x
  iny
  tya
  sta screen0+ 0*40+ 6,x
  sta screen1+ 8*40+ 6,x
  sta screen2+16*40+ 6,x
  iny
  tya
  sta screen0+ 0*40+ 7,x
  sta screen1+ 8*40+ 7,x
  sta screen2+16*40+ 7,x
  iny
  tya
  sta screen0+ 0*40+ 8,x
  sta screen1+ 8*40+ 8,x
  sta screen2+16*40+ 8,x
  iny
  tya
  sta screen0+ 0*40+ 9,x
  sta screen1+ 8*40+ 9,x
  sta screen2+16*40+ 9,x
  iny
  tya
  sta screen0+ 0*40+10,x
  sta screen1+ 8*40+10,x
  sta screen2+16*40+10,x
  iny
  tya
  sta screen0+ 0*40+11,x
  sta screen1+ 8*40+11,x
  sta screen2+16*40+11,x
  iny
  tya
  sta screen0+ 0*40+12,x
  sta screen1+ 8*40+12,x
  sta screen2+16*40+12,x
  iny
  tya
  sta screen0+ 0*40+13,x
  sta screen1+ 8*40+13,x
  sta screen2+16*40+13,x
  iny
  tya
  sta screen0+ 0*40+14,x
  sta screen1+ 8*40+14,x
  sta screen2+16*40+14,x
  iny
  tya
  sta screen0+ 0*40+15,x
  sta screen1+ 8*40+15,x
  sta screen2+16*40+15,x
  iny
  tya
  sta screen0+ 0*40+16,x
  sta screen1+ 8*40+16,x
  sta screen2+16*40+16,x
  iny
  tya
  sta screen0+ 0*40+17,x
  sta screen1+ 8*40+17,x
  sta screen2+16*40+17,x
  iny
  tya
  sta screen0+ 0*40+18,x
  sta screen1+ 8*40+18,x
  sta screen2+16*40+18,x
  iny
  tya
  sta screen0+ 0*40+19,x
  sta screen1+ 8*40+19,x
  sta screen2+16*40+19,x
  iny
  tya
  sta screen0+ 0*40+20,x
  sta screen1+ 8*40+20,x
  sta screen2+16*40+20,x
  iny
  tya
  sta screen0+ 0*40+21,x
  sta screen1+ 8*40+21,x
  sta screen2+16*40+21,x
  iny
  tya
  sta screen0+ 0*40+22,x
  sta screen1+ 8*40+22,x
  sta screen2+16*40+22,x
  iny
  tya
  sta screen0+ 0*40+23,x
  sta screen1+ 8*40+23,x
  sta screen2+16*40+23,x
  iny
  tya
  sta screen0+ 0*40+24,x
  sta screen1+ 8*40+24,x
  sta screen2+16*40+24,x
  iny
  tya
  sta screen0+ 0*40+25,x
  sta screen1+ 8*40+25,x
  sta screen2+16*40+25,x
  iny
  tya
  sta screen0+ 0*40+26,x
  sta screen1+ 8*40+26,x
  sta screen2+16*40+26,x
  iny
  tya
  sta screen0+ 0*40+27,x
  sta screen1+ 8*40+27,x
  sta screen2+16*40+27,x
  iny
  tya
  sta screen0+ 0*40+28,x
  sta screen1+ 8*40+28,x
  sta screen2+16*40+28,x
  iny
  tya
  sta screen0+ 0*40+29,x
  sta screen1+ 8*40+29,x
  sta screen2+16*40+29,x
  iny
  tya
  sta screen0+ 0*40+30,x
  sta screen1+ 8*40+30,x
  sta screen2+16*40+30,x
  iny
  tya
  sta screen0+ 0*40+31,x
  sta screen1+ 8*40+31,x
  sta screen2+16*40+31,x
  lda text_colour
  sta $d81f+$28,x
  sta $d81f+8*40+$28,x
  sta $d81f+16*40+$28,x
  lda #1
  sta $d820+$28,x
  sta $d820+8*40+$28,x
  sta $d820+16*40+$28,x





  lda #1
  sta $d7ff+1*40+$28,x
  sta $d7ff+9*40+$28,x
  sta $d7ff+17*40+$28,x
  lda text_colour
  sta $d800+1*40+$28,x
  sta $d800+9*40+$28,x
  sta $d800+17*40+$28,x
  iny
  tya
  sta screen0+ 1*40+ 0,x
  sta screen1+ 9*40+ 0,x
  sta screen2+17*40+ 0,x
  iny
  tya
  sta screen0+ 1*40+ 1,x
  sta screen1+ 9*40+ 1,x
  sta screen2+17*40+ 1,x
  iny
  tya
  sta screen0+ 1*40+ 2,x
  sta screen1+ 9*40+ 2,x
  sta screen2+17*40+ 2,x
  iny
  tya
  sta screen0+ 1*40+ 3,x
  sta screen1+ 9*40+ 3,x
  sta screen2+17*40+ 3,x
  iny
  tya
  sta screen0+ 1*40+ 4,x
  sta screen1+ 9*40+ 4,x
  sta screen2+17*40+ 4,x
  iny
  tya
  sta screen0+ 1*40+ 5,x
  sta screen1+ 9*40+ 5,x
  sta screen2+17*40+ 5,x
  iny
  tya
  sta screen0+ 1*40+ 6,x
  sta screen1+ 9*40+ 6,x
  sta screen2+17*40+ 6,x
  iny
  tya
  sta screen0+ 1*40+ 7,x
  sta screen1+ 9*40+ 7,x
  sta screen2+17*40+ 7,x
  iny
  tya
  sta screen0+ 1*40+ 8,x
  sta screen1+ 9*40+ 8,x
  sta screen2+17*40+ 8,x
  iny
  tya
  sta screen0+ 1*40+ 9,x
  sta screen1+ 9*40+ 9,x
  sta screen2+17*40+ 9,x
  iny
  tya
  sta screen0+ 1*40+10,x
  sta screen1+ 9*40+10,x
  sta screen2+17*40+10,x
  iny
  tya
  sta screen0+ 1*40+11,x
  sta screen1+ 9*40+11,x
  sta screen2+17*40+11,x
  iny
  tya
  sta screen0+ 1*40+12,x
  sta screen1+ 9*40+12,x
  sta screen2+17*40+12,x
  iny
  tya
  sta screen0+ 1*40+13,x
  sta screen1+ 9*40+13,x
  sta screen2+17*40+13,x
  iny
  tya
  sta screen0+ 1*40+14,x
  sta screen1+ 9*40+14,x
  sta screen2+17*40+14,x
  iny
  tya
  sta screen0+ 1*40+15,x
  sta screen1+ 9*40+15,x
  sta screen2+17*40+15,x
  iny
  tya
  sta screen0+ 1*40+16,x
  sta screen1+ 9*40+16,x
  sta screen2+17*40+16,x
  iny
  tya
  sta screen0+ 1*40+17,x
  sta screen1+ 9*40+17,x
  sta screen2+17*40+17,x
  iny
  tya
  sta screen0+ 1*40+18,x
  sta screen1+ 9*40+18,x
  sta screen2+17*40+18,x
  iny
  tya
  sta screen0+ 1*40+19,x
  sta screen1+ 9*40+19,x
  sta screen2+17*40+19,x
  iny
  tya
  sta screen0+ 1*40+20,x
  sta screen1+ 9*40+20,x
  sta screen2+17*40+20,x
  iny
  tya
  sta screen0+ 1*40+21,x
  sta screen1+ 9*40+21,x
  sta screen2+17*40+21,x
  iny
  tya
  sta screen0+ 1*40+22,x
  sta screen1+ 9*40+22,x
  sta screen2+17*40+22,x
  iny
  tya
  sta screen0+ 1*40+23,x
  sta screen1+ 9*40+23,x
  sta screen2+17*40+23,x
  iny
  tya
  sta screen0+ 1*40+24,x
  sta screen1+ 9*40+24,x
  sta screen2+17*40+24,x
  iny
  tya
  sta screen0+ 1*40+25,x
  sta screen1+ 9*40+25,x
  sta screen2+17*40+25,x
  iny
  tya
  sta screen0+ 1*40+26,x
  sta screen1+ 9*40+26,x
  sta screen2+17*40+26,x
  iny
  tya
  sta screen0+ 1*40+27,x
  sta screen1+ 9*40+27,x
  sta screen2+17*40+27,x
  iny
  tya
  sta screen0+ 1*40+28,x
  sta screen1+ 9*40+28,x
  sta screen2+17*40+28,x
  iny
  tya
  sta screen0+ 1*40+29,x
  sta screen1+ 9*40+29,x
  sta screen2+17*40+29,x
  iny
  tya
  sta screen0+ 1*40+30,x
  sta screen1+ 9*40+30,x
  sta screen2+17*40+30,x
  iny
  tya
  sta screen0+ 1*40+31,x
  sta screen1+ 9*40+31,x
  sta screen2+17*40+31,x
  lda text_colour
  sta $d81f+1*40+$28,x
  sta $d81f+9*40+$28,x
  sta $d81f+17*40+$28,x
  lda #1
  sta $d820+1*40+$28,x
  sta $d820+9*40+$28,x
  sta $d820+17*40+$28,x




  lda #1
  sta $d7ff+2*40+$28,x
  sta $d7ff+10*40+$28,x
  sta $d7ff+18*40+$28,x
  lda text_colour
  sta $d800+2*40+$28,x
  sta $d800+10*40+$28,x
  sta $d800+18*40+$28,x
  iny
  tya
  sta screen0+ 2*40+ 0,x
  sta screen1+10*40+ 0,x
  sta screen2+18*40+ 0,x
  iny
  tya
  sta screen0+ 2*40+ 1,x
  sta screen1+10*40+ 1,x
  sta screen2+18*40+ 1,x
  iny
  tya
  sta screen0+ 2*40+ 2,x
  sta screen1+10*40+ 2,x
  sta screen2+18*40+ 2,x
  iny
  tya
  sta screen0+ 2*40+ 3,x
  sta screen1+10*40+ 3,x
  sta screen2+18*40+ 3,x
  iny
  tya
  sta screen0+ 2*40+ 4,x
  sta screen1+10*40+ 4,x
  sta screen2+18*40+ 4,x
  iny
  tya
  sta screen0+ 2*40+ 5,x
  sta screen1+10*40+ 5,x
  sta screen2+18*40+ 5,x
  iny
  tya
  sta screen0+ 2*40+ 6,x
  sta screen1+10*40+ 6,x
  sta screen2+18*40+ 6,x
  iny
  tya
  sta screen0+ 2*40+ 7,x
  sta screen1+10*40+ 7,x
  sta screen2+18*40+ 7,x
  iny
  tya
  sta screen0+ 2*40+ 8,x
  sta screen1+10*40+ 8,x
  sta screen2+18*40+ 8,x
  iny
  tya
  sta screen0+ 2*40+ 9,x
  sta screen1+10*40+ 9,x
  sta screen2+18*40+ 9,x
  iny
  tya
  sta screen0+ 2*40+10,x
  sta screen1+10*40+10,x
  sta screen2+18*40+10,x
  iny
  tya
  sta screen0+ 2*40+11,x
  sta screen1+10*40+11,x
  sta screen2+18*40+11,x
  iny
  tya
  sta screen0+ 2*40+12,x
  sta screen1+10*40+12,x
  sta screen2+18*40+12,x
  iny
  tya
  sta screen0+ 2*40+13,x
  sta screen1+10*40+13,x
  sta screen2+18*40+13,x
  iny
  tya
  sta screen0+ 2*40+14,x
  sta screen1+10*40+14,x
  sta screen2+18*40+14,x
  iny
  tya
  sta screen0+ 2*40+15,x
  sta screen1+10*40+15,x
  sta screen2+18*40+15,x
  iny
  tya
  sta screen0+ 2*40+16,x
  sta screen1+10*40+16,x
  sta screen2+18*40+16,x
  iny
  tya
  sta screen0+ 2*40+17,x
  sta screen1+10*40+17,x
  sta screen2+18*40+17,x
  iny
  tya
  sta screen0+ 2*40+18,x
  sta screen1+10*40+18,x
  sta screen2+18*40+18,x
  iny
  tya
  sta screen0+ 2*40+19,x
  sta screen1+10*40+19,x
  sta screen2+18*40+19,x
  iny
  tya
  sta screen0+ 2*40+20,x
  sta screen1+10*40+20,x
  sta screen2+18*40+20,x
  iny
  tya
  sta screen0+ 2*40+21,x
  sta screen1+10*40+21,x
  sta screen2+18*40+21,x
  iny
  tya
  sta screen0+ 2*40+22,x
  sta screen1+10*40+22,x
  sta screen2+18*40+22,x
  iny
  tya
  sta screen0+ 2*40+23,x
  sta screen1+10*40+23,x
  sta screen2+18*40+23,x
  iny
  tya
  sta screen0+ 2*40+24,x
  sta screen1+10*40+24,x
  sta screen2+18*40+24,x
  iny
  tya
  sta screen0+ 2*40+25,x
  sta screen1+10*40+25,x
  sta screen2+18*40+25,x
  iny
  tya
  sta screen0+ 2*40+26,x
  sta screen1+10*40+26,x
  sta screen2+18*40+26,x
  iny
  tya
  sta screen0+ 2*40+27,x
  sta screen1+10*40+27,x
  sta screen2+18*40+27,x
  iny
  tya
  sta screen0+ 2*40+28,x
  sta screen1+10*40+28,x
  sta screen2+18*40+28,x
  iny
  tya
  sta screen0+ 2*40+29,x
  sta screen1+10*40+29,x
  sta screen2+18*40+29,x
  iny
  tya
  sta screen0+ 2*40+30,x
  sta screen1+10*40+30,x
  sta screen2+18*40+30,x
  iny
  tya
  sta screen0+ 2*40+31,x
  sta screen1+10*40+31,x
  sta screen2+18*40+31,x
  lda text_colour
  sta $d81f+2*40+$28,x
  sta $d81f+10*40+$28,x
  sta $d81f+18*40+$28,x
  lda #1
  sta $d820+2*40+$28,x
  sta $d820+10*40+$28,x
  sta $d820+18*40+$28,x







  lda #1
  sta $d7ff+3*40+$28,x
  sta $d7ff+11*40+$28,x
  sta $d7ff+19*40+$28,x
  lda text_colour
  sta $d800+3*40+$28,x
  sta $d800+11*40+$28,x
  sta $d800+19*40+$28,x
  iny
  tya
  sta screen0+ 3*40+ 0,x
  sta screen1+11*40+ 0,x
  sta screen2+19*40+ 0,x
  iny
  tya
  sta screen0+ 3*40+ 1,x
  sta screen1+11*40+ 1,x
  sta screen2+19*40+ 1,x
  iny
  tya
  sta screen0+ 3*40+ 2,x
  sta screen1+11*40+ 2,x
  sta screen2+19*40+ 2,x
  iny
  tya
  sta screen0+ 3*40+ 3,x
  sta screen1+11*40+ 3,x
  sta screen2+19*40+ 3,x
  iny
  tya
  sta screen0+ 3*40+ 4,x
  sta screen1+11*40+ 4,x
  sta screen2+19*40+ 4,x
  iny
  tya
  sta screen0+ 3*40+ 5,x
  sta screen1+11*40+ 5,x
  sta screen2+19*40+ 5,x
  iny
  tya
  sta screen0+ 3*40+ 6,x
  sta screen1+11*40+ 6,x
  sta screen2+19*40+ 6,x
  iny
  tya
  sta screen0+ 3*40+ 7,x
  sta screen1+11*40+ 7,x
  sta screen2+19*40+ 7,x
  iny
  tya
  sta screen0+ 3*40+ 8,x
  sta screen1+11*40+ 8,x
  sta screen2+19*40+ 8,x
  iny
  tya
  sta screen0+ 3*40+ 9,x
  sta screen1+11*40+ 9,x
  sta screen2+19*40+ 9,x
  iny
  tya
  sta screen0+ 3*40+10,x
  sta screen1+11*40+10,x
  sta screen2+19*40+10,x
  iny
  tya
  sta screen0+ 3*40+11,x
  sta screen1+11*40+11,x
  sta screen2+19*40+11,x
  iny
  tya
  sta screen0+ 3*40+12,x
  sta screen1+11*40+12,x
  sta screen2+19*40+12,x
  iny
  tya
  sta screen0+ 3*40+13,x
  sta screen1+11*40+13,x
  sta screen2+19*40+13,x
  iny
  tya
  sta screen0+ 3*40+14,x
  sta screen1+11*40+14,x
  sta screen2+19*40+14,x
  iny
  tya
  sta screen0+ 3*40+15,x
  sta screen1+11*40+15,x
  sta screen2+19*40+15,x
  iny
  tya
  sta screen0+ 3*40+16,x
  sta screen1+11*40+16,x
  sta screen2+19*40+16,x
  iny
  tya
  sta screen0+ 3*40+17,x
  sta screen1+11*40+17,x
  sta screen2+19*40+17,x
  iny
  tya
  sta screen0+ 3*40+18,x
  sta screen1+11*40+18,x
  sta screen2+19*40+18,x
  iny
  tya
  sta screen0+ 3*40+19,x
  sta screen1+11*40+19,x
  sta screen2+19*40+19,x
  iny
  tya
  sta screen0+ 3*40+20,x
  sta screen1+11*40+20,x
  sta screen2+19*40+20,x
  iny
  tya
  sta screen0+ 3*40+21,x
  sta screen1+11*40+21,x
  sta screen2+19*40+21,x
  iny
  tya
  sta screen0+ 3*40+22,x
  sta screen1+11*40+22,x
  sta screen2+19*40+22,x
  iny
  tya
  sta screen0+ 3*40+23,x
  sta screen1+11*40+23,x
  sta screen2+19*40+23,x
  iny
  tya
  sta screen0+ 3*40+24,x
  sta screen1+11*40+24,x
  sta screen2+19*40+24,x
  iny
  tya
  sta screen0+ 3*40+25,x
  sta screen1+11*40+25,x
  sta screen2+19*40+25,x
  iny
  tya
  sta screen0+ 3*40+26,x
  sta screen1+11*40+26,x
  sta screen2+19*40+26,x
  iny
  tya
  sta screen0+ 3*40+27,x
  sta screen1+11*40+27,x
  sta screen2+19*40+27,x
  iny
  tya
  sta screen0+ 3*40+28,x
  sta screen1+11*40+28,x
  sta screen2+19*40+28,x
  iny
  tya
  sta screen0+ 3*40+29,x
  sta screen1+11*40+29,x
  sta screen2+19*40+29,x
  iny
  tya
  sta screen0+ 3*40+30,x
  sta screen1+11*40+30,x
  sta screen2+19*40+30,x
  iny
  tya
  sta screen0+ 3*40+31,x
  sta screen1+11*40+31,x
  sta screen2+19*40+31,x
  lda text_colour
  sta $d81f+3*40+$28,x
  sta $d81f+11*40+$28,x
  sta $d81f+19*40+$28,x
  lda #1
  sta $d820+3*40+$28,x
  sta $d820+11*40+$28,x
  sta $d820+19*40+$28,x





  lda #1
  sta $d7ff+4*40+$28,x
  sta $d7ff+12*40+$28,x
  sta $d7ff+20*40+$28,x
  lda text_colour
  sta $d800+4*40+$28,x
  sta $d800+12*40+$28,x
  sta $d800+20*40+$28,x
  iny
  tya
  sta screen0+ 4*40+ 0,x
  sta screen1+12*40+ 0,x
  sta screen2+20*40+ 0,x
  iny
  tya
  sta screen0+ 4*40+ 1,x
  sta screen1+12*40+ 1,x
  sta screen2+20*40+ 1,x
  iny
  tya
  sta screen0+ 4*40+ 2,x
  sta screen1+12*40+ 2,x
  sta screen2+20*40+ 2,x
  iny
  tya
  sta screen0+ 4*40+ 3,x
  sta screen1+12*40+ 3,x
  sta screen2+20*40+ 3,x
  iny
  tya
  sta screen0+ 4*40+ 4,x
  sta screen1+12*40+ 4,x
  sta screen2+20*40+ 4,x
  iny
  tya
  sta screen0+ 4*40+ 5,x
  sta screen1+12*40+ 5,x
  sta screen2+20*40+ 5,x
  iny
  tya
  sta screen0+ 4*40+ 6,x
  sta screen1+12*40+ 6,x
  sta screen2+20*40+ 6,x
  iny
  tya
  sta screen0+ 4*40+ 7,x
  sta screen1+12*40+ 7,x
  sta screen2+20*40+ 7,x
  iny
  tya
  sta screen0+ 4*40+ 8,x
  sta screen1+12*40+ 8,x
  sta screen2+20*40+ 8,x
  iny
  tya
  sta screen0+ 4*40+ 9,x
  sta screen1+12*40+ 9,x
  sta screen2+20*40+ 9,x
  iny
  tya
  sta screen0+ 4*40+10,x
  sta screen1+12*40+10,x
  sta screen2+20*40+10,x
  iny
  tya
  sta screen0+ 4*40+11,x
  sta screen1+12*40+11,x
  sta screen2+20*40+11,x
  iny
  tya
  sta screen0+ 4*40+12,x
  sta screen1+12*40+12,x
  sta screen2+20*40+12,x
  iny
  tya
  sta screen0+ 4*40+13,x
  sta screen1+12*40+13,x
  sta screen2+20*40+13,x
  iny
  tya
  sta screen0+ 4*40+14,x
  sta screen1+12*40+14,x
  sta screen2+20*40+14,x
  iny
  tya
  sta screen0+ 4*40+15,x
  sta screen1+12*40+15,x
  sta screen2+20*40+15,x
  iny
  tya
  sta screen0+ 4*40+16,x
  sta screen1+12*40+16,x
  sta screen2+20*40+16,x
  iny
  tya
  sta screen0+ 4*40+17,x
  sta screen1+12*40+17,x
  sta screen2+20*40+17,x
  iny
  tya
  sta screen0+ 4*40+18,x
  sta screen1+12*40+18,x
  sta screen2+20*40+18,x
  iny
  tya
  sta screen0+ 4*40+19,x
  sta screen1+12*40+19,x
  sta screen2+20*40+19,x
  iny
  tya
  sta screen0+ 4*40+20,x
  sta screen1+12*40+20,x
  sta screen2+20*40+20,x
  iny
  tya
  sta screen0+ 4*40+21,x
  sta screen1+12*40+21,x
  sta screen2+20*40+21,x
  iny
  tya
  sta screen0+ 4*40+22,x
  sta screen1+12*40+22,x
  sta screen2+20*40+22,x
  iny
  tya
  sta screen0+ 4*40+23,x
  sta screen1+12*40+23,x
  sta screen2+20*40+23,x
  iny
  tya
  sta screen0+ 4*40+24,x
  sta screen1+12*40+24,x
  sta screen2+20*40+24,x
  iny
  tya
  sta screen0+ 4*40+25,x
  sta screen1+12*40+25,x
  sta screen2+20*40+25,x
  iny
  tya
  sta screen0+ 4*40+26,x
  sta screen1+12*40+26,x
  sta screen2+20*40+26,x
  iny
  tya
  sta screen0+ 4*40+27,x
  sta screen1+12*40+27,x
  sta screen2+20*40+27,x
  iny
  tya
  sta screen0+ 4*40+28,x
  sta screen1+12*40+28,x
  sta screen2+20*40+28,x
  iny
  tya
  sta screen0+ 4*40+29,x
  sta screen1+12*40+29,x
  sta screen2+20*40+29,x
  iny
  tya
  sta screen0+ 4*40+30,x
  sta screen1+12*40+30,x
  sta screen2+20*40+30,x
  iny
  tya
  sta screen0+ 4*40+31,x
  sta screen1+12*40+31,x
  sta screen2+20*40+31,x
  lda text_colour
  sta $d81f+4*40+$28,x
  sta $d81f+12*40+$28,x
  sta $d81f+20*40+$28,x
  lda #1
  sta $d820+4*40+$28,x
  sta $d820+12*40+$28,x
  sta $d820+20*40+$28,x





  lda #1
  sta $d7ff+5*40+$28,x
  sta $d7ff+13*40+$28,x
  sta $d7ff+21*40+$28,x
  lda text_colour
  sta $d800+5*40+$28,x
  sta $d800+13*40+$28,x
  sta $d800+21*40+$28,x
  iny
  tya
  sta screen0+ 5*40+ 0,x
  sta screen1+13*40+ 0,x
  sta screen2+21*40+ 0,x
  iny
  tya
  sta screen0+ 5*40+ 1,x
  sta screen1+13*40+ 1,x
  sta screen2+21*40+ 1,x
  iny
  tya
  sta screen0+ 5*40+ 2,x
  sta screen1+13*40+ 2,x
  sta screen2+21*40+ 2,x
  iny
  tya
  sta screen0+ 5*40+ 3,x
  sta screen1+13*40+ 3,x
  sta screen2+21*40+ 3,x
  iny
  tya
  sta screen0+ 5*40+ 4,x
  sta screen1+13*40+ 4,x
  sta screen2+21*40+ 4,x
  iny
  tya
  sta screen0+ 5*40+ 5,x
  sta screen1+13*40+ 5,x
  sta screen2+21*40+ 5,x
  iny
  tya
  sta screen0+ 5*40+ 6,x
  sta screen1+13*40+ 6,x
  sta screen2+21*40+ 6,x
  iny
  tya
  sta screen0+ 5*40+ 7,x
  sta screen1+13*40+ 7,x
  sta screen2+21*40+ 7,x
  iny
  tya
  sta screen0+ 5*40+ 8,x
  sta screen1+13*40+ 8,x
  sta screen2+21*40+ 8,x
  iny
  tya
  sta screen0+ 5*40+ 9,x
  sta screen1+13*40+ 9,x
  sta screen2+21*40+ 9,x
  iny
  tya
  sta screen0+ 5*40+10,x
  sta screen1+13*40+10,x
  sta screen2+21*40+10,x
  iny
  tya
  sta screen0+ 5*40+11,x
  sta screen1+13*40+11,x
  sta screen2+21*40+11,x
  iny
  tya
  sta screen0+ 5*40+12,x
  sta screen1+13*40+12,x
  sta screen2+21*40+12,x
  iny
  tya
  sta screen0+ 5*40+13,x
  sta screen1+13*40+13,x
  sta screen2+21*40+13,x
  iny
  tya
  sta screen0+ 5*40+14,x
  sta screen1+13*40+14,x
  sta screen2+21*40+14,x
  iny
  tya
  sta screen0+ 5*40+15,x
  sta screen1+13*40+15,x
  sta screen2+21*40+15,x
  iny
  tya
  sta screen0+ 5*40+16,x
  sta screen1+13*40+16,x
  sta screen2+21*40+16,x
  iny
  tya
  sta screen0+ 5*40+17,x
  sta screen1+13*40+17,x
  sta screen2+21*40+17,x
  iny
  tya
  sta screen0+ 5*40+18,x
  sta screen1+13*40+18,x
  sta screen2+21*40+18,x
  iny
  tya
  sta screen0+ 5*40+19,x
  sta screen1+13*40+19,x
  sta screen2+21*40+19,x
  iny
  tya
  sta screen0+ 5*40+20,x
  sta screen1+13*40+20,x
  sta screen2+21*40+20,x
  iny
  tya
  sta screen0+ 5*40+21,x
  sta screen1+13*40+21,x
  sta screen2+21*40+21,x
  iny
  tya
  sta screen0+ 5*40+22,x
  sta screen1+13*40+22,x
  sta screen2+21*40+22,x
  iny
  tya
  sta screen0+ 5*40+23,x
  sta screen1+13*40+23,x
  sta screen2+21*40+23,x
  iny
  tya
  sta screen0+ 5*40+24,x
  sta screen1+13*40+24,x
  sta screen2+21*40+24,x
  iny
  tya
  sta screen0+ 5*40+25,x
  sta screen1+13*40+25,x
  sta screen2+21*40+25,x
  iny
  tya
  sta screen0+ 5*40+26,x
  sta screen1+13*40+26,x
  sta screen2+21*40+26,x
  iny
  tya
  sta screen0+ 5*40+27,x
  sta screen1+13*40+27,x
  sta screen2+21*40+27,x
  iny
  tya
  sta screen0+ 5*40+28,x
  sta screen1+13*40+28,x
  sta screen2+21*40+28,x
  iny
  tya
  sta screen0+ 5*40+29,x
  sta screen1+13*40+29,x
  sta screen2+21*40+29,x
  iny
  tya
  sta screen0+ 5*40+30,x
  sta screen1+13*40+30,x
  sta screen2+21*40+30,x
  iny
  tya
  sta screen0+ 5*40+31,x
  sta screen1+13*40+31,x
  sta screen2+21*40+31,x
  lda text_colour
  sta $d81f+5*40+$28,x
  sta $d81f+13*40+$28,x
  sta $d81f+21*40+$28,x
  lda #1
  sta $d820+5*40+$28,x
  sta $d820+13*40+$28,x
  sta $d820+21*40+$28,x




  lda #1
  sta $d7ff+6*40+$28,x
  sta $d7ff+14*40+$28,x
  sta $d7ff+22*40+$28,x
  lda text_colour
  sta $d800+6*40+$28,x
  sta $d800+14*40+$28,x
  sta $d800+22*40+$28,x
  iny
  tya
  sta screen0+ 6*40+ 0,x
  sta screen1+14*40+ 0,x
  sta screen2+22*40+ 0,x
  iny
  tya
  sta screen0+ 6*40+ 1,x
  sta screen1+14*40+ 1,x
  sta screen2+22*40+ 1,x
  iny
  tya
  sta screen0+ 6*40+ 2,x
  sta screen1+14*40+ 2,x
  sta screen2+22*40+ 2,x
  iny
  tya
  sta screen0+ 6*40+ 3,x
  sta screen1+14*40+ 3,x
  sta screen2+22*40+ 3,x
  iny
  tya
  sta screen0+ 6*40+ 4,x
  sta screen1+14*40+ 4,x
  sta screen2+22*40+ 4,x
  iny
  tya
  sta screen0+ 6*40+ 5,x
  sta screen1+14*40+ 5,x
  sta screen2+22*40+ 5,x
  iny
  tya
  sta screen0+ 6*40+ 6,x
  sta screen1+14*40+ 6,x
  sta screen2+22*40+ 6,x
  iny
  tya
  sta screen0+ 6*40+ 7,x
  sta screen1+14*40+ 7,x
  sta screen2+22*40+ 7,x
  iny
  tya
  sta screen0+ 6*40+ 8,x
  sta screen1+14*40+ 8,x
  sta screen2+22*40+ 8,x
  iny
  tya
  sta screen0+ 6*40+ 9,x
  sta screen1+14*40+ 9,x
  sta screen2+22*40+ 9,x
  iny
  tya
  sta screen0+ 6*40+10,x
  sta screen1+14*40+10,x
  sta screen2+22*40+10,x
  iny
  tya
  sta screen0+ 6*40+11,x
  sta screen1+14*40+11,x
  sta screen2+22*40+11,x
  iny
  tya
  sta screen0+ 6*40+12,x
  sta screen1+14*40+12,x
  sta screen2+22*40+12,x
  iny
  tya
  sta screen0+ 6*40+13,x
  sta screen1+14*40+13,x
  sta screen2+22*40+13,x
  iny
  tya
  sta screen0+ 6*40+14,x
  sta screen1+14*40+14,x
  sta screen2+22*40+14,x
  iny
  tya
  sta screen0+ 6*40+15,x
  sta screen1+14*40+15,x
  sta screen2+22*40+15,x
  iny
  tya
  sta screen0+ 6*40+16,x
  sta screen1+14*40+16,x
  sta screen2+22*40+16,x
  iny
  tya
  sta screen0+ 6*40+17,x
  sta screen1+14*40+17,x
  sta screen2+22*40+17,x
  iny
  tya
  sta screen0+ 6*40+18,x
  sta screen1+14*40+18,x
  sta screen2+22*40+18,x
  iny
  tya
  sta screen0+ 6*40+19,x
  sta screen1+14*40+19,x
  sta screen2+22*40+19,x
  iny
  tya
  sta screen0+ 6*40+20,x
  sta screen1+14*40+20,x
  sta screen2+22*40+20,x
  iny
  tya
  sta screen0+ 6*40+21,x
  sta screen1+14*40+21,x
  sta screen2+22*40+21,x
  iny
  tya
  sta screen0+ 6*40+22,x
  sta screen1+14*40+22,x
  sta screen2+22*40+22,x
  iny
  tya
  sta screen0+ 6*40+23,x
  sta screen1+14*40+23,x
  sta screen2+22*40+23,x
  iny
  tya
  sta screen0+ 6*40+24,x
  sta screen1+14*40+24,x
  sta screen2+22*40+24,x
  iny
  tya
  sta screen0+ 6*40+25,x
  sta screen1+14*40+25,x
  sta screen2+22*40+25,x
  iny
  tya
  sta screen0+ 6*40+26,x
  sta screen1+14*40+26,x
  sta screen2+22*40+26,x
  iny
  tya
  sta screen0+ 6*40+27,x
  sta screen1+14*40+27,x
  sta screen2+22*40+27,x
  iny
  tya
  sta screen0+ 6*40+28,x
  sta screen1+14*40+28,x
  sta screen2+22*40+28,x
  iny
  tya
  sta screen0+ 6*40+29,x
  sta screen1+14*40+29,x
  sta screen2+22*40+29,x
  iny
  tya
  sta screen0+ 6*40+30,x
  sta screen1+14*40+30,x
  sta screen2+22*40+30,x
  iny
  tya
  sta screen0+ 6*40+31,x
  sta screen1+14*40+31,x
  sta screen2+22*40+31,x
  lda text_colour
  sta $d81f+6*40+$28,x
  sta $d81f+14*40+$28,x
  sta $d81f+22*40+$28,x
  lda #1
  sta $d820+6*40+$28,x
  sta $d820+14*40+$28,x
  sta $d820+22*40+$28,x





  lda #1
  sta $d7ff+7*40+$28,x
  sta $d7ff+15*40+$28,x
  sta $d7ff+23*40+$28,x
  lda text_colour
  sta $d800+7*40+$28,x
  sta $d800+15*40+$28,x
  sta $d800+23*40+$28,x
  iny
  tya
  sta screen0+ 7*40+ 0,x
  sta screen1+15*40+ 0,x
  sta screen2+23*40+ 0,x
  iny
  tya
  sta screen0+ 7*40+ 1,x
  sta screen1+15*40+ 1,x
  sta screen2+23*40+ 1,x
  iny
  tya
  sta screen0+ 7*40+ 2,x
  sta screen1+15*40+ 2,x
  sta screen2+23*40+ 2,x
  iny
  tya
  sta screen0+ 7*40+ 3,x
  sta screen1+15*40+ 3,x
  sta screen2+23*40+ 3,x
  iny
  tya
  sta screen0+ 7*40+ 4,x
  sta screen1+15*40+ 4,x
  sta screen2+23*40+ 4,x
  iny
  tya
  sta screen0+ 7*40+ 5,x
  sta screen1+15*40+ 5,x
  sta screen2+23*40+ 5,x
  iny
  tya
  sta screen0+ 7*40+ 6,x
  sta screen1+15*40+ 6,x
  sta screen2+23*40+ 6,x
  iny
  tya
  sta screen0+ 7*40+ 7,x
  sta screen1+15*40+ 7,x
  sta screen2+23*40+ 7,x
  iny
  tya
  sta screen0+ 7*40+ 8,x
  sta screen1+15*40+ 8,x
  sta screen2+23*40+ 8,x
  iny
  tya
  sta screen0+ 7*40+ 9,x
  sta screen1+15*40+ 9,x
  sta screen2+23*40+ 9,x
  iny
  tya
  sta screen0+ 7*40+10,x
  sta screen1+15*40+10,x
  sta screen2+23*40+10,x
  iny
  tya
  sta screen0+ 7*40+11,x
  sta screen1+15*40+11,x
  sta screen2+23*40+11,x
  iny
  tya
  sta screen0+ 7*40+12,x
  sta screen1+15*40+12,x
  sta screen2+23*40+12,x
  iny
  tya
  sta screen0+ 7*40+13,x
  sta screen1+15*40+13,x
  sta screen2+23*40+13,x
  iny
  tya
  sta screen0+ 7*40+14,x
  sta screen1+15*40+14,x
  sta screen2+23*40+14,x
  iny
  tya
  sta screen0+ 7*40+15,x
  sta screen1+15*40+15,x
  sta screen2+23*40+15,x
  iny
  tya
  sta screen0+ 7*40+16,x
  sta screen1+15*40+16,x
  sta screen2+23*40+16,x
  iny
  tya
  sta screen0+ 7*40+17,x
  sta screen1+15*40+17,x
  sta screen2+23*40+17,x
  iny
  tya
  sta screen0+ 7*40+18,x
  sta screen1+15*40+18,x
  sta screen2+23*40+18,x
  iny
  tya
  sta screen0+ 7*40+19,x
  sta screen1+15*40+19,x
  sta screen2+23*40+19,x
  iny
  tya
  sta screen0+ 7*40+20,x
  sta screen1+15*40+20,x
  sta screen2+23*40+20,x
  iny
  tya
  sta screen0+ 7*40+21,x
  sta screen1+15*40+21,x
  sta screen2+23*40+21,x
  iny
  tya
  sta screen0+ 7*40+22,x
  sta screen1+15*40+22,x
  sta screen2+23*40+22,x
  iny
  tya
  sta screen0+ 7*40+23,x
  sta screen1+15*40+23,x
  sta screen2+23*40+23,x
  iny
  tya
  sta screen0+ 7*40+24,x
  sta screen1+15*40+24,x
  sta screen2+23*40+24,x
  iny
  tya
  sta screen0+ 7*40+25,x
  sta screen1+15*40+25,x
  sta screen2+23*40+25,x
  iny
  tya
  sta screen0+ 7*40+26,x
  sta screen1+15*40+26,x
  sta screen2+23*40+26,x
  iny
  tya
  sta screen0+ 7*40+27,x
  sta screen1+15*40+27,x
  sta screen2+23*40+27,x
  iny
  tya
  sta screen0+ 7*40+28,x
  sta screen1+15*40+28,x
  sta screen2+23*40+28,x
  iny
  tya
  sta screen0+ 7*40+29,x
  sta screen1+15*40+29,x
  sta screen2+23*40+29,x
  iny
  tya
  sta screen0+ 7*40+30,x
  sta screen1+15*40+30,x
  sta screen2+23*40+30,x
  iny
  tya
  sta screen0+ 7*40+31,x
  sta screen1+15*40+31,x
  sta screen2+23*40+31,x
  lda text_colour
  sta $d81f+7*40+$28,x
  sta $d81f+15*40+$28,x
  sta $d81f+23*40+$28,x
  lda #1
  sta $d820+7*40+$28,x
  sta $d820+15*40+$28,x
  sta $d820+23*40+$28,x
  rts






col_this_row_msb:
  dc.b >($d800 +  1*40)
  dc.b >($d800 +  2*40)
  dc.b >($d800 +  3*40)
  dc.b >($d800 +  4*40)
  dc.b >($d800 +  5*40)
  dc.b >($d800 +  6*40)
  dc.b >($d800 +  7*40)
  dc.b >($d800 +  8*40)
  dc.b >($d800 +  9*40)
  dc.b >($d800 + 10*40)
  dc.b >($d800 + 11*40)
  dc.b >($d800 + 12*40)
  dc.b >($d800 + 13*40)
  dc.b >($d800 + 14*40)
  dc.b >($d800 + 15*40)
  dc.b >($d800 + 16*40)
  dc.b >($d800 + 17*40)
  dc.b >($d800 + 18*40)
  dc.b >($d800 + 19*40)
  dc.b >($d800 + 20*40)
  dc.b >($d800 + 21*40)
  dc.b >($d800 + 22*40)
  dc.b >($d800 + 23*40)
  dc.b >($d800 + 24*40)

col_this_row_lsb:
  dc.b <($d800 +  1*40)
  dc.b <($d800 +  2*40)
  dc.b <($d800 +  3*40)
  dc.b <($d800 +  4*40)
  dc.b <($d800 +  5*40)
  dc.b <($d800 +  6*40)
  dc.b <($d800 +  7*40)
  dc.b <($d800 +  8*40)
  dc.b <($d800 +  9*40)
  dc.b <($d800 + 10*40)
  dc.b <($d800 + 11*40)
  dc.b <($d800 + 12*40)
  dc.b <($d800 + 13*40)
  dc.b <($d800 + 14*40)
  dc.b <($d800 + 15*40)
  dc.b <($d800 + 16*40)
  dc.b <($d800 + 17*40)
  dc.b <($d800 + 18*40)
  dc.b <($d800 + 19*40)
  dc.b <($d800 + 20*40)
  dc.b <($d800 + 21*40)
  dc.b <($d800 + 22*40)
  dc.b <($d800 + 23*40)
  dc.b <($d800 + 24*40)


where_is_this_row:
  dc.b >charset0L + 0
  dc.b >charset0L + 1
  dc.b >charset0L + 2
  dc.b >charset0L + 3
  dc.b >charset0L + 4
  dc.b >charset0L + 5
  dc.b >charset0L + 6
  dc.b >charset0L + 7
  dc.b >charset1L + 0
  dc.b >charset1L + 1
  dc.b >charset1L + 2
  dc.b >charset1L + 3
  dc.b >charset1L + 4
  dc.b >charset1L + 5
  dc.b >charset1L + 6
  dc.b >charset1L + 7
  dc.b >charset2L + 0
  dc.b >charset2L + 1
  dc.b >charset2L + 2
  dc.b >charset2L + 3
  dc.b >charset2L + 4
  dc.b >charset2L + 5
  dc.b >charset2L + 6
  dc.b >charset2L + 7

plot_a_char:
  sta letter+1
  sta letterR+1
  ldx text_row
  lda col_this_row_lsb,x
  sta black_poi+1
  lda col_this_row_msb,x
  sta black_poi+2
  lda text_column
  lsr
  tay

  lda text_colour
black_poi:
  sta $d800,y

  lda where_is_this_row,x
  sta tmp_poi+1
  ora #8
  sta tmp_poi2+1
  lda text_column
  asl
  asl
  and #$f8
  sta tmp_poi
  sta tmp_poi2
  lda text_column
  and #1
  bne do_the_right_char
; Do the left char:
  lda #0
  sta tmp_char
letter:
  lda #0
  asl
  asl
  rol tmp_char
  asl
  rol tmp_char
  adc #<topaz
  sta letter_poi+1
  lda #>topaz
  adc tmp_char
  sta letter_poi+2

  ldy #0
copy_more_charset:
letter_poi:
  lda topaz,y
  sta again+1
  asl
  asl
  asl
  asl
  sta (tmp_poi),y
again:
  lda #$00
  and #$f0
  sta (tmp_poi2),y
  iny
  cpy #8
  bne copy_more_charset
  inc text_column
  rts
do_the_right_char:
; Do the right char:
  lda #0
  sta tmp_char
letterR:
  lda #0
  asl
  asl
  rol tmp_char
  asl
  rol tmp_char
  adc #<topaz
  sta letter_poiR+1
  lda #>topaz
  adc tmp_char
  sta letter_poiR+2
  ldy #0
copy_right_char:
letter_poiR:
  lda topaz,y
  sta againR+1
  and #$0f
  ora (tmp_poi),y
  sta (tmp_poi),y
againR:
  lda #$00
  lsr
  lsr
  lsr
  lsr
  ora (tmp_poi2),y
  sta (tmp_poi2),y
  iny
  cpy #8
  bne copy_right_char
  ldx text_column
  inx
  cpx #$40
  bne no_new_row
  ldx #0
  ldy text_row
  iny
  cpy #24
  bne nowraprows
  ldy #0
nowraprows:
  sty text_row
no_new_row:
  stx text_column
  rts


show_nyheter_start:
  lda #0
  sta screen_mode+1
  ldx #0
setcols:
  lda #$4
  sta $d800,x
  sta $d900,x
  sta $da00,x
  sta $db00,x
;screen at $cc00
  lda #$01
  sta $cc00,x
  sta $cd00,x
  sta $ce00,x
  sta $cef8,x
  inx
  bne setcols
  lda #1
  sta koala_bgcol+1
  sta koala_bordercol+1

  ldx #6
  lda #$21
setvg:
  sta $cc00 + 11*40,x
  sta $cc00 + 12*40,x
  sta $cc00 + 13*40,x
  sta $cc00 + 14*40,x
  sta $cc00 + 15*40,x
  sta $cc00 + 16*40,x
  sta $cc00 + 17*40,x
  inx
  cpx #$28
  bne setvg

  ldx #0
  lda #$61
setsvd:
  sta $cc00 + 7*40,x
  sta $cc00 + 8*40,x
  sta $cc00 + 9*40,x
  sta $cc00 + 10*40,x
  inx
  cpx #$28
  bne setsvd

  ldx #6
  lda #$b1
setaf:
  sta $cc00 + 18*40,x
  sta $cc00 + 19*40,x
  sta $cc00 + 20*40,x
  sta $cc00 + 21*40,x
  sta $cc00 + 22*40,x
  sta $cc00 + 23*40,x
  sta $cc00 + 24*40,x
  inx
  cpx #$28
  bne setaf

  lda #(empty_sprites / $40) & $ff
  sta which_sprites_at_top + 1
  rts






org mouse_sprites1
  incbin "sprites/amiga_pointer.map"

  ORG $7fff
.byte 0

  ORG logo_sprites
  incbin "sprites/aftonbladet_logo_v04.map"
  incbin "sprites/svd_logo_v03.map"
  incbin "sprites/vg_logo_v03.map"
  incbin "sprites/aftenposten_logo_v03.map"
empty_sprites:
  ds.b $200,0

intro_01_sprite:
;$8a00
  incbin "../intro_gfx/intro_01_sprite2.map"
intro_02_sprite:
;$8c00
  incbin "../intro_gfx/intro_02_sprite2.map"
intro_03_sprite:
;$8e00
  incbin "../intro_gfx/intro_03_sprite2.map"
;$9000:
  ORG topaz
  incbin "topaz_both.bin"
;-$9400


  org $a000
intro_04_sprite:
;$9000
  incbin "../intro_gfx/intro_04_sprite2.map"
intro_05_sprite:
;$9200
  incbin "../intro_gfx/intro_05_sprite2.map"
intro_06_sprite:
;$9400
  incbin "../intro_gfx/intro_06_sprite2.map"
intro_07_sprite:
;$9600
  incbin "../intro_gfx/intro_07_sprite2.map"
intro_koppla_sprite:
;$9800
  incbin "../intro_gfx/intro_koppla_sprite2.map"
intro_som_kopplas_sprite:
;$9a00
  incbin "../intro_gfx/intro_som_kopplas_sprite2.map"
intro_du_tittar_sprite:
;$9c00
  incbin "../intro_gfx/intro_du_tittar_sprite2.map"
intro_pa_c64_sprite:
;$9e00
  incbin "../intro_gfx/intro_c64_sprite2.map"


org mouse_sprites2
  incbin "sprites/amiga_pointer.map"


;$b4c0-$bffe free


  ORG $bfff
.byte 0

org mouse_sprites3
  incbin "sprites/amiga_pointer.map"

org $e000
  incbin "intro_nyheter.map"
