
import imageio

# Python program to transform the input image to the font data.
# Font data is located at
#$2000-$27ff  row 0-7   Left
#$2800-$2fff            Right
#$6000-$27ff  row 8-15  Left
#$6800-$2fff            Right
#$a000-$27ff  row 16-23 Left
#$a800-$2fff            Right

# Row0 starts at $2000
# Row1 starts at $2100
# Row2 starts at $2200
# Row3 starts at $2300
# Row4 starts at $2400
# Row5 starts at $2500
# Row6 starts at $2600
# Row7 starts at $2700

offset = 0

def output_char(bank_no,row_no,char_no,odd,im,outp):
  global offset
  x = char_no*16 + (1-odd)
  y = (bank_no * 8 + row_no) * 8 * 2

  for y2 in range(0,8):
    yy = y + y2*2
    char_tmp = 0
    for x2 in range(0,8):
      xx = x + x2*2
      pixel = im[yy][xx][0]
      pixout = 1
      if (pixel > 128):
        pixout = 0
      char_tmp = char_tmp << 1 | pixout
    #of.write(bytes(char_tmp))
    outp[offset] = char_tmp
    offset += 1
  #print("char_no=%d, odd=%d, row_no=%d, bank_no=%d\n" % (char_no,odd,row_no,bank_no))

def make_bin(filename, output_filename):
  global offset
  # import image with size
  #192 pixels high
  #640 pixels wide
  #In photoshop, make this
  #640*384 pixels black & white image.

  im = imageio.imread("../gfx/%s" % filename)
  print(im.shape)

  nof_written_chars = 0
  offset = 0
  outp = bytearray(1536*8)

  for bank_no in range(0,3):
    for odd in range(0,2):
      for row_no in range(0,8):
        print("odd=%d, row_no=%d, bank_no=%d" % (odd,row_no,bank_no))
        for char_no in range(0,32):
          output_char(bank_no,row_no,char_no,odd,im,outp)
          nof_written_chars += 1
  print("Nof written chars = %d" % nof_written_chars)

  with open(output_filename, "wb") as of:
    of.write(outp)


make_bin("aftenposten_introbild_v01.png", "introbild_af.bin")
make_bin("aftonbladet_introbild_v01_bw.png", "introbild_ab.bin")
make_bin("svd_introbild_v01_bw.png", "introbild_svd.bin")
make_bin("vg_introbild_v02.png", "introbild_vg.bin")
