
# Python program to transform the Topaz font into a useable C64 font for horizontal interlace.

filename = "Topaz_a500_v1.0.raw"

with open(filename, mode='rb') as file: # b is important -> binary
    font = file.read()


font = []
bytes_read = open(filename, "rb").read()
for b in bytes_read:
    font.append(b)


# Draw åäö ÅÄÖ

char_no=0
font[char_no * 16 +  0] = 0b00011000
font[char_no * 16 +  2] = 0b00000000
font[char_no * 16 +  4] = 0b00111100
font[char_no * 16 +  6] = 0b00000110
font[char_no * 16 +  8] = 0b00011110
font[char_no * 16 + 10] = 0b01100110
font[char_no * 16 + 12] = 0b00111011
font[char_no * 16 + 14] = 0b00000000

char_no=1
font[char_no * 16 +  0] = 0b00110110
font[char_no * 16 +  2] = 0b00000000
font[char_no * 16 +  4] = 0b00111100
font[char_no * 16 +  6] = 0b00000110
font[char_no * 16 +  8] = 0b00011110
font[char_no * 16 + 10] = 0b01100110
font[char_no * 16 + 12] = 0b00111011
font[char_no * 16 + 14] = 0b00000000

char_no=2
font[char_no * 16 +  0] = 0b00110110
font[char_no * 16 +  2] = 0b00000000
font[char_no * 16 +  4] = 0b00111100
font[char_no * 16 +  6] = 0b01100110
font[char_no * 16 +  8] = 0b01100110
font[char_no * 16 + 10] = 0b01100110
font[char_no * 16 + 12] = 0b00111100
font[char_no * 16 + 14] = 0b00000000

char_no=3
font[char_no * 16 +  0] = 0b00011000
font[char_no * 16 +  2] = 0b00000000
font[char_no * 16 +  4] = 0b00111100
font[char_no * 16 +  6] = 0b01100110
font[char_no * 16 +  8] = 0b01111110
font[char_no * 16 + 10] = 0b11000011
font[char_no * 16 + 12] = 0b11000011
font[char_no * 16 + 14] = 0b00000000

char_no=4
font[char_no * 16 +  0] = 0b11011011
font[char_no * 16 +  2] = 0b00111100
font[char_no * 16 +  4] = 0b00111100
font[char_no * 16 +  6] = 0b01100110
font[char_no * 16 +  8] = 0b01111110
font[char_no * 16 + 10] = 0b11000011
font[char_no * 16 + 12] = 0b11000011
font[char_no * 16 + 14] = 0b00000000

char_no=5
font[char_no * 16 +  0] = 0b11000110
font[char_no * 16 +  2] = 0b00111000
font[char_no * 16 +  4] = 0b01101100
font[char_no * 16 +  6] = 0b11000110
font[char_no * 16 +  8] = 0b11000110
font[char_no * 16 + 10] = 0b01101100
font[char_no * 16 + 12] = 0b00111000
font[char_no * 16 + 14] = 0b00000000

char_no=6 #æ
font[char_no * 16 +  0] = 0b00000000
font[char_no * 16 +  2] = 0b00000000
font[char_no * 16 +  4] = 0b11101110
font[char_no * 16 +  6] = 0b00111011
font[char_no * 16 +  8] = 0b01111111
font[char_no * 16 + 10] = 0b11011000
font[char_no * 16 + 12] = 0b01110111
font[char_no * 16 + 14] = 0b00000000

char_no=7 #Æ
font[char_no * 16 +  0] = 0b00011111
font[char_no * 16 +  2] = 0b00111100
font[char_no * 16 +  4] = 0b00111100
font[char_no * 16 +  6] = 0b01101100
font[char_no * 16 +  8] = 0b01111111
font[char_no * 16 + 10] = 0b11001100
font[char_no * 16 + 12] = 0b11001111
font[char_no * 16 + 14] = 0b00000000

char_no=8 #ø
font[char_no * 16 +  0] = 0b00000000
font[char_no * 16 +  2] = 0b00000000
font[char_no * 16 +  4] = 0b00111011
font[char_no * 16 +  6] = 0b01101110
font[char_no * 16 +  8] = 0b01111110
font[char_no * 16 + 10] = 0b01110110
font[char_no * 16 + 12] = 0b11011100
font[char_no * 16 + 14] = 0b00000000

char_no=9 #Ø
font[char_no * 16 +  0] = 0b00000011
font[char_no * 16 +  2] = 0b00111110
font[char_no * 16 +  4] = 0b01101100
font[char_no * 16 +  6] = 0b11011110
font[char_no * 16 +  8] = 0b11110110
font[char_no * 16 + 10] = 0b01101100
font[char_no * 16 + 12] = 0b01111000
font[char_no * 16 + 14] = 0b11000000

char_no=0x0a #é
font[char_no * 16 +  0] = 0b00000110
font[char_no * 16 +  2] = 0b00001100
font[char_no * 16 +  4] = 0b00111100
font[char_no * 16 +  6] = 0b01100110
font[char_no * 16 +  8] = 0b01111110
font[char_no * 16 + 10] = 0b01100000
font[char_no * 16 + 12] = 0b00111100
font[char_no * 16 + 14] = 0b00000000












byte_no = 0
output = []
output_even = []
output_odd = []
output_both = []

def output_char(char_no):
  for pixel_row in range(8):
    row = font[char_no * 16 + pixel_row * 2]
    print (format(row, '08b'))
    output.append(row)
    even = ((row & 0x80)>>4) + ((row & 0x20)>>3) + ((row & 0x08)>>2) + ((row & 0x02)>>1)
    odd = ((row & 0x40)>>3) + ((row & 0x10)>>2) + ((row & 0x04)>>1) + ((row & 0x01))
    both = odd | (even<<4)
    output_even.append(even)
    output_odd.append(odd)
    output_both.append(both)

for char_no in range(0x00,0x20):
  output_char(char_no)

for char_no in range(0x20,0x40):
  output_char(char_no)

for char_no in range(0x40,0x60):
  output_char(char_no)

for char_no in range(0x60,0x80):
  output_char(char_no)


# Save the output into a binary file:
output_bytearray = bytearray(output)
with open("topaz.bin", "wb") as newfile:
  newfile.write(output_bytearray)

output_both_bytearray = bytearray(output_both)
with open("topaz_both.bin", "wb") as newfile:
  newfile.write(output_both_bytearray)
