//======================================================== FX_HEADER
EFF_INI		JP	EFF_INI_
EFF_RUN		JP	EFF_RUN_
//======================================================== FX_CONST
BUFF_Y		EQU	48
;---
BUFFSZ		EQU	32 * BUFF_Y	;1280
BUFF1A		EQU	#BE00 - BUFFSZ
BUFF1B		EQU	BUFF1A - BUFFSZ
BUFF2A		EQU	BUFF1B - BUFFSZ
BUFF2B		EQU	BUFF2A - BUFFSZ
;---

MOVET_ADR	EQU	#DB00
MOVET_ATTR	EQU	#5800
MOVET_SZ	EQU	4*16*BUFF_Y + 4
	IF MACHINE_TYPE = MT_PENTAGON
MOV_TOP_SZ	EQU	36
	ELSE
MOV_TOP_SZ	EQU	27
	ENDIF
MOV_BOTT_SZ	EQU	BUFF_Y - MOV_TOP_SZ

MDXSTEP	EQU	1
MDYSTEP EQU	0-2

MDX0	EQU	0
MDY0	EQU	0

MAPG1	EQU	#10
MAPG2	EQU	#18
MAP7FFD	EQU	#7FFD

//======================================================== FX_INIT
EFF_INI_
	LD	A,#17
	CALL	PAGER
	CALL	SWAPBUFF
	JP	SWP
//======================================================== FX_MAINLOOP
EFF_RUN_

;378+378+378=1134
;1536-1134=402

	EI
	HALT
	CALL	MOVE_TOP
	CALL	MAPPING
	CALL	SWP
	CALL	MOVE_BOTTOM

	EI
	HALT
	CALL	MOVE_TOP
	CALL	MAPPING
	CALL	SWP
	CALL	MOVE_BOTTOM

	EI
	HALT
	CALL	MOVE_TOP
	CALL	MAPPING
	CALL	SWP
	CALL	MOVE_BOTTOM
	
	EI
	HALT
	CALL	MOVE_TOP
	CALL	MAPPING
	CALL	SYNC
	CALL	DEFORM
	CALL	SWAPBUFF
	CALL	SWP
	CALL	MOVE_BOTTOM
	RET
//======================================================== FX_PROCEDURES
SWP	LD	A,0
SWP0	EQU	$-1
	XOR	#FF
	LD	(SWP0),A
	LD	HL,0
SWP_BUFFA EQU $-2
	LD	DE,0
SWP_BUFFA_BOTT EQU $-2
	JP	Z,SWP1
	LD	HL,0
SWP_BUFFB EQU $-2
	LD	DE,0
SWP_BUFFB_BOTT EQU $-2
SWP1	LD	(MOVE_TOP_SP),HL
	LD	(MOVE_BOTTOM_SP),DE
	RET
;--------------------------
SWAPBUFF
	LD	A,(MDX)
MDXA	ADD	A,MDXSTEP
	AND	31
	LD	(MDX),A
	;---------------
	LD	A,(MDY)
MDYA	ADD	A,MDYSTEP
	AND	31
	LD	(MDY),A
	;---------------
	LD	HL,MAPLNTBL
	LD	(MAP_MAPTBL),HL
	LD	A,0
SWAPBUFFA EQU $-1
	XOR	#FF
	LD	(SWAPBUFFA),A
	JR	Z,SWAPBUFF1
	;---
	LD	HL,BUFF2A + BUFFSZ - 1
	LD	(MAP_BUFFA),HL
	LD	HL,BUFF2B + BUFFSZ - 1
	LD	(MAP_BUFFB),HL
	;-
	LD	HL,BUFF1A + 32*(BUFF_Y - MOV_TOP_SZ)
	LD	(SWP_BUFFA),HL
	LD	HL,BUFF1B + 32*(BUFF_Y - MOV_TOP_SZ)
	LD	(SWP_BUFFB),HL
	LD	HL,BUFF1A
	LD	(SWP_BUFFA_BOTT),HL
	LD	HL,BUFF1B
	LD	(SWP_BUFFB_BOTT),HL
	RET
SWAPBUFF1 ;---
	LD	HL,BUFF1A + BUFFSZ - 1
	LD	(MAP_BUFFA),HL
	LD	HL,BUFF1B + BUFFSZ - 1
	LD	(MAP_BUFFB),HL
	;-
	LD	HL,BUFF2A + 32*(BUFF_Y - MOV_TOP_SZ)
	LD	(SWP_BUFFA),HL
	LD	HL,BUFF2B + 32*(BUFF_Y - MOV_TOP_SZ)
	LD	(SWP_BUFFB),HL
	LD	HL,BUFF2A
	LD	(SWP_BUFFA_BOTT),HL
	LD	HL,BUFF2B
	LD	(SWP_BUFFB_BOTT),HL
	RET
;--------------------------	
FX_BLINK
	LD	HL,#5B00
	CALL	FXBL0
	LD	HL,#DB00
FXBL0	LD	(FXBLSP),SP
	LD	SP,HL
	LD	HL,256*(7*8+7) + 7*8+7
	LD	B,192
FXBL1	PUSH	HL
	PUSH	HL
	DJNZ	FXBL1
	LD	SP,#3131
FXBLSP	EQU	$-2
	LD	BC,#7FFD
	RET
;--------------------------
MOVE_TOP
	IF MACHINE_TYPE = MT_ZX128 OR MACHINE_TYPE = MT_ZX2A
	  ADD HL,HL:ADD HL,HL:ADD HL,HL:ADD HL,HL:ADD HL,HL
	ENDIF
	LD	BC,#7FFD
	LD	A,#17
	OUT	(C),A
	;--
	LD	A,7
BORDER	EQU	$-1
	OUT	(#FE),A
	CP	7
	JR	Z,FX_BLINK
	;--
	LD	(SOHRSP1),SP
	LD	SP,#3131
MOVE_TOP_SP	EQU $-2
	LD	DE,MOVE_TOP1
	JP	MOVET_ADR + MOV_BOTT_SZ * 16*4  + 2
MOVE_TOP1
	LD	SP,#3131
SOHRSP1	EQU	$-2
	RET
;--------------------------
MOVE_BOTTOM
	LD	A,(BORDER)
	CP	7
	RET	Z
	;---
	LD	BC,#7FFD
	LD	A,#17+#08
	OUT	(C),A
	;---
	LD	(SOHRSP2),SP
	LD	SP,#3131
MOVE_BOTTOM_SP	EQU $-2
	LD	DE,MOVE_BOTTOM1
	JP	MOVET_ADR
MOVE_BOTTOM1
	;---
	LD	HL,#0000	;10
	LD	SP,#DB00	;10
	DUP	16
	PUSH	HL		;176t
	EDUP
	;---
	LD	SP,#3131
SOHRSP2	EQU	$-2
	RET
;--------------------------
MAPPING	
	LD	A,12
	DEC	A
	JP	NZ,$-1
	;---
	LD	DE,BUFF1A + BUFFSZ - 1
MAP_BUFFA EQU $-2
	LD	BC,BUFF1B + BUFFSZ - 1
MAP_BUFFB EQU $-2
	LD	H,PALETTE / 256
PALADR	EQU $-1
	EXX
	;-----
	LD	(SOHRSP_MAP),SP
	LD	BC,MAP7FFD
	LD	A,MAPG2
	OUT	(C),A
	LD	IY,MAPLNTBL
MAP_MAPTBL EQU $-2
	LD	SP,IY
	POP	HL
	LD	SP,HL
	LD	LX,12
	LD	DE,0	;mapping scroll, rotate
MDX	EQU	$-2
MDY	EQU	$-1
MAPLP	;------------------
	DUP	8
	;---
	POP	HL	;10
	ADD	HL,DE	;11
	LD	A,(HL)	;7
	POP	HL	;10
	ADD	HL,DE	;11
	OR	(HL)	;7 /56
	;-
	EXX		;4
	LD	L,A	;4
	LD	A,(HL)	;7
	LD	(BC),A	;7
	INC	H	;4
	LDD		;16
	DEC	H	;4
	EXX		;4 /50 /=> 106*8=848
	;---
	EDUP
	;---w14
	NOP:NOP:DEC HL
	;---
	LD	A,MAPG1	;7
	IF MACHINE_TYPE = MT_ZX128 OR MACHINE_TYPE = MT_ZX2A
	  NOP:NOP:NOP:NOP
	ENDIF
	OUT	(C),A	;12 /19 //867 =>29free
	;------------------
	DUP	8
	;---
	POP	HL	;10
	ADD	HL,DE	;11
	LD	A,(HL)	;7
	POP	HL	;10
	ADD	HL,DE	;11
	OR	(HL)	;7 /56
	;-
	EXX		;4
	LD	L,A	;4
	LD	A,(HL)	;7
	LD	(BC),A	;7
	INC	H	;4
	LDD		;16
	DEC	H	;4
	EXX		;4 /50 /=> 106*8=848
	;---
	EDUP
	;---
	INC IY:INC IY
	LD A,R	;w9
	;---
	LD	A,MAPG2	;7
	IF MACHINE_TYPE = MT_ZX128 OR MACHINE_TYPE = MT_ZX2A
	  NOP:NOP:NOP:NOP
	ENDIF
	OUT	(C),A	;12 /19 //867 =>29free
	;------------------
	DUP	8
	;---
	POP	HL	;10
	ADD	HL,DE	;11
	LD	A,(HL)	;7
	POP	HL	;10
	ADD	HL,DE	;11
	OR	(HL)	;7 /56
	;-
	EXX		;4
	LD	L,A	;4
	LD	A,(HL)	;7
	LD	(BC),A	;7
	INC	H	;4
	LDD		;16
	DEC	H	;4
	EXX		;4 /50 /=> 106*8=848
	;---
	EDUP
	;---w29
	ADD HL,HL:ADD HL,HL:LD A,0
	;---
	LD	A,MAPG1	;7
	IF MACHINE_TYPE = MT_ZX128 OR MACHINE_TYPE = MT_ZX2A
	  NOP:NOP:NOP:NOP
	ENDIF
	OUT	(C),A	;12 /19 //867 =>29free
	;------------------
	DUP	8
	;---
	POP	HL	;10
	ADD	HL,DE	;11
	LD	A,(HL)	;7
	POP	HL	;10
	ADD	HL,DE	;11
	OR	(HL)	;7 /56
	;-
	EXX		;4
	LD	L,A	;4
	LD	A,(HL)	;7
	LD	(BC),A	;7
	INC	H	;4
	LDD		;16
	DEC	H	;4
	EXX		;4 /50 /=> 106*8=848
	;---
	EDUP
	;---
		LD	SP,IY	;10
		POP	HL	;10
		LD	SP,HL	;6 /26t -15
	;---
	LD	A,MAPG2	;7
	IF MACHINE_TYPE = MT_ZX128 OR MACHINE_TYPE = MT_ZX2A
	  NOP:NOP:NOP:NOP
	ENDIF
	OUT	(C),A	;12 /19
	;---
	DEC	LX	;8
	JP	NZ,MAPLP ;10 /18 //881 11ree
	;--------------------
	EXX
	LD	(MAP_BUFFA),DE
	LD	(MAP_BUFFB),BC
	LD	(MAP_MAPTBL),IY
	;--------------------
	LD	SP,#3131
SOHRSP_MAP	EQU	$-2
	RET
//======================================================== FX_INCLUDE_DATA
SYNC
	XOR	A
	LD	(BORDER),A
	;---
	LD	HL,SYNC_TBL
SYNC_ADR EQU $-2
	LD	C,(HL)
	INC	HL
	LD	B,(HL)
	INC	HL
	EX	DE,HL
	LD	HL,(MUSPOS)
	AND	A
	SBC	HL,BC
	RET	C
	;---
	EX	DE,HL
	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	INC	HL
	EX	DE,HL
	JP	(HL)
	;---
SYNC_DEFORM
	EX	DE,HL
	LD	A,(HL)
	INC	HL
	LD	(DEFORM_A),A
	;-
	LD	A,(MDX)
	ADD	A,(HL)
	AND	31
	LD	(MDX),A
	INC	HL
	;-
	LD	A,(MDY)
	ADD	A,(HL)
	AND	31
	LD	(MDY),A
	INC	HL	
	;-
	LD	(SYNC_ADR),HL
	RET
SYNC_BLNK
	LD	A,#FF
	LD	(DEFORM_A),A
	LD	A,(DE)
	INC	DE
	LD	(MDXA+1),A
	LD	A,(DE)
	INC	DE
	LD	(MDYA+1),A
	LD	(SYNC_ADR),DE
	LD	A,7
	LD	(BORDER),A
	RET
SYNC_TBL
	;DW	3492-4-1 + 4*0	;3491
	;DW	SYNC_DEFORM
	;DB	%10101010
	;DW	3492-4-1 + 4*1
	;DW	SYNC_DEFORM
	;DB	%10010010
	;DW	3492-4-1 + 4*2
	;DW	SYNC_DEFORM
	;DB	%11111111


	DW	3492-1-4 + 4*0
	DW	SYNC_DEFORM
	DB	%11111111
	DB	1,0-17
	DW	3492-1-4 + 4*1
	DW	SYNC_DEFORM
	DB	%11111111
	DB	1,0-17
	DW	3492-1-4 + 4*2
	DW	SYNC_DEFORM
	DB	%11111111
	DB	1,0-17


	DW	3492-4-1 + 4*4	;3510
	DW	SYNC_DEFORM
	DB	%10010010
	DB	0,0
	DW	3492-4-1 + 4*5
	DW	SYNC_DEFORM
	DB	%10101010
	DB	0,0
	DW	3492-4-1 + 4*6
	DW	SYNC_DEFORM
	DB	%11111111
	DB	0,0

	DW	3492-4-1 + 4*7	;3523	
	DW	SYNC_DEFORM
	DB	%10010010
	DB	0,0
	DW	3492-4-1 + 4*8
	DW	SYNC_DEFORM
	DB	%10101010
	DB	0,0
	DW	3492-4-1 + 4*9
	DW	SYNC_DEFORM
	DB	%11111111
	DB	0,0

	DW	3536-1
	DW	SYNC_BLNK
	DB	0-1
	DB	2

	DW	#FFFF
;---------------------------------
DEFORM	LD	(SOHRSP_DEFORM),SP
	LD	A,%11111111
DEFORM_A EQU $-1
	;-
	LD	SP,MAPLNTBL + 24*2
	LD	HL,MAPTBL + 24*128
	LD	DE,0-128
	LD	B,24
DEFORM1	;--
	RRCA	
	JR	NC,DEFORM2
	ADD	HL,DE
DEFORM2	PUSH	HL
	DJNZ	DEFORM1
	;---
	EX	DE,HL
	LD	HL,2*MAPTBL + 48*128
	AND	A
	SBC	HL,DE
	LD	DE,0-128
	LD	SP,MAPLNTBL + 48*2
	LD	B,24
DEFORM3	;--
	RRCA	
	JR	NC,DEFORM4
	ADD	HL,DE
DEFORM4	PUSH	HL
	DJNZ	DEFORM3
	LD	SP,0
SOHRSP_DEFORM EQU $-2
	RET
//======================================================== FX_TABLES
MAPTBL	INCLUDE "bin/map_intor.asm"
MAPTBL_END
;------------------
	ALIGN	256
PALETTE	INCBIN "bin/palette_intor.bin"
;------------------
MAPLNTBL
TMP1=MAPTBL
	DUP	48
	DW	TMP1
TMP1=TMP1+128
	EDUP
;------------------

	DISPLAY "MOVE_ADR: ", /A, MOVET_ADR
	DISPLAY "MOVE_SZ: ", /A, MOVET_SZ
	DISPLAY "MOVE_END: ", /A, MOVET_ADR + MOVET_SZ
	DISPLAY "MAPTBL: ", /A, MAPTBL
	DISPLAY "MAPTBL_SZ: ", /A, MAPTBL_END - MAPTBL
	DISPLAY "MAPTBL_END: ", /A, MAPTBL_END
	
	DISPLAY	"BUFFSZ ", /A, BUFFSZ
	DISPLAY	"BUFF1A ", /A, BUFF1A
	DISPLAY	"BUFF1B ", /A, BUFF1B
	DISPLAY	"BUFF2A ", /A, BUFF2A
	DISPLAY	"BUFF2B ", /A, BUFF2B
