//-----------------------------------------------------------------------------
// CONSTANTS
//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
// 03. NOISE BEGIN
//-----------------------------------------------------------------------------

	;init_fx
	DB	T_FX_INI

	;pause after init
	;DB	T_FX_NOP
	;DW	0		; pause while fx-local frame counter <= this value
	
	; start music after first effect init
	DB	2 ;COMM_ASM
	EI
	HALT
	CALL	MUSIC_ON
	LD	IY,$+5
	RET

	;run_fx
	DB	T_FX_RUN
	DW	1456 - 26


//-----------------------------------------------------------------------------
// 04. STARFIELD
//-----------------------------------------------------------------------------
	DB	2 ;COMM_ASM
	
	CALL	CLEAR_RGB
	
	LD	A,STAR_PG7_PG
	CALL	PAGER
	LD	HL,STAR_PG7
	LD	DE,#8000
	LD	BC,STAR_PG7_END-STAR_PG7
	LDIR
	LD	A,#17
	CALL	PAGER
	LD	HL,#8000
	LD	DE,#C000
	CALL	DEPACK_PL5
	;---------
	LD	A,STAR_EXE_PG
	CALL	PAGER
	LD	HL,STAR_EXE
	LD	DE,#8000
	CALL	DEPACK_PL5
	
	LD	IY,$+5
	RET

	DB	T_FX_INI
	DB	T_FX_NOP
	DW	1456
	
	
	DB	T_BLINK_ON
	DB	T_BLINK_ON
	DB	T_BLINK_OFF
	
	DB	T_FX_RUN
	DW	1872 - 26
	
//-----------------------------------------------------------------------------
// 05. FX_3D_ADD_LIGHT
//-----------------------------------------------------------------------------
	DB	2 ;COMM_ASM
	
	CALL	CLEAR_RGB
	
	LD	A,ADDLIGHT_PG0_PG
	CALL	PAGER
	LD	HL,ADDLIGHT_PG0
	LD	DE,#8000
	LD	BC,ADDLIGHT_PG0_END-ADDLIGHT_PG0
	LDIR
	LD	A,#10
	CALL	PAGER
	LD	HL,#8000
	LD	DE,#C000
	CALL	DEPACK_PL5
	;---------
	LD	A,ADDLIGHT_EXE_PG
	CALL	PAGER
	LD	HL,ADDLIGHT_EXE
	LD	DE,#8000
	CALL	DEPACK_PL5
	
	LD	IY,$+5
	RET
	
	DB	T_FX_INI
	DB	T_FX_NOP
	DW	1872
	
	DB	T_BLINK_ON
	DB	T_BLINK_ON
	DB	T_BLINK_OFF
	
	DB	T_FX_RUN
	DW	2704 - 26
	
//-----------------------------------------------------------------------------
// 06. FX_3D_BLACK_CIRCLES
//-----------------------------------------------------------------------------
	DB	2 ;COMM_ASM
	
	CALL	CLEAR_RGB
	
	LD	A,BLACKCIRC_PG0_PG
	CALL	PAGER
	LD	HL,BLACKCIRC_PG0
	LD	DE,#8000
	LD	BC,BLACKCIRC_PG0_END-BLACKCIRC_PG0
	LDIR
	LD	A,#10
	CALL	PAGER
	LD	HL,#8000
	LD	DE,#C000
	CALL	DEPACK_PL5
	;---------
	LD	A,BLACKCIRC_EXE_PG
	CALL	PAGER
	LD	HL,BLACKCIRC_EXE
	LD	DE,#8000
	CALL	DEPACK_PL5
	
	LD	IY,$+5
	RET
	
	DB	T_FX_INI
	DB	T_FX_NOP
	DW	2704
	
	
	DB	T_BLINK_ON
	DB	T_BLINK_ON
	DB	T_BLINK_OFF
	
	DB	T_FX_RUN
	DW	3536-26
	
//-----------------------------------------------------------------------------
// 02. FX_DUO_TUNNEL
//-----------------------------------------------------------------------------
	DB	2 ;COMM_ASM
	
	CALL	CLEAR_RGB
	
	LD	A,DUOTUNNEL_PG0_PG
	CALL	PAGER
	LD	HL,DUOTUNNEL_PG0
	LD	DE,#8000
	LD	BC,DUOTUNNEL_PG0_END - DUOTUNNEL_PG0
	LDIR
	LD	A,#10
	CALL	PAGER
	LD	HL,#8000
	LD	DE,#C000
	CALL	DEPACK_PL5
	;---------
	LD	A,DUOTUNNEL_PG7_PG
	CALL	PAGER
	LD	HL,DUOTUNNEL_PG7
	LD	DE,#8000
	LD	BC,DUOTUNNEL_PG7_END - DUOTUNNEL_PG7
	LDIR
	LD	A,#17
	CALL	PAGER
	LD	HL,#8000
	LD	DE,#E000
	CALL	DEPACK_PL5
	;---------
	LD	A,DUOTUNNEL_EXE_PG
	CALL	PAGER
	LD	HL,DUOTUNNEL_EXE
	LD	DE,#8000
	CALL	DEPACK_PL5

	LD	IY,$+5
	RET
	
	DB	T_FX_INI
	DB	T_FX_NOP
	DW	3536
	
	DB	T_BLINK_ON
	DB	T_BLINK_ON
	DB	T_BLINK_OFF
	
	DB	T_FX_RUN
	DW	4368 - 26	;4329



//-----------------------------------------------------------------------------
// FX_TWISTER
//-----------------------------------------------------------------------------
	DB	2 ;COMM_ASM
	
	CALL	CLEAR_RGB
	;---------
	LD	A,TWISTER_PG0_PG
	CALL	PAGER
	LD	HL,TWISTER_PG0
	LD	DE,#8000
	LD	BC,TWISTER_PG0_END - TWISTER_PG0
	LDIR
	LD	A,#10
	CALL	PAGER
	LD	HL,#8000
	LD	DE,#C000
	CALL	DEPACK_PL5
	;---------
	LD	A,TWISTER_EXE_PG
	CALL	PAGER
	LD	HL,TWISTER_EXE
	LD	DE,#8000
	CALL	DEPACK_PL5

	LD	IY,$+5
	RET
	
	DB	T_FX_INI
	DB	T_FX_NOP
	DW	4368

	DB	T_BLINK_ON
	DB	T_BLINK_ON
	DB	T_BLINK_OFF

	DB	T_FX_RUN
	DW	5200 - 26
//-----------------------------------------------------------------------------
// FX_TWISTER SUPER NOISE MIX (SELFCODED BY AI)
//-----------------------------------------------------------------------------
	DB	2 ;COMM_ASM
	
	CALL	CLEAR_RGB
	;---------
	LD	A,DUOTUNNEL_PG0_PG
	CALL	PAGER
	LD	HL,DUOTUNNEL_PG0
	LD	DE,#8000
	LD	BC,DUOTUNNEL_PG0_END - DUOTUNNEL_PG0
	LDIR
	LD	A,#10
	CALL	PAGER
	LD	HL,#8000
	LD	DE,#C000
	CALL	DEPACK_PL5
	;---------
	LD	A,TWISTER_EXE_PG
	CALL	PAGER
	LD	HL,TWISTER_EXE
	LD	DE,#8000
	CALL	DEPACK_PL5

	LD	IY,$+5
	RET
	
	DB	T_FX_INI
	DB	T_FX_NOP
	DW	5200-2

	DB	T_BLINK_ON
	DB	T_BLINK_ON
	DB	T_BLINK_OFF

	DB	T_FX_RUN
	DW	5408 - 26
	
	
//-----------------------------------------------------------------------------
// LANDSCAPE
//-----------------------------------------------------------------------------
	
	DB	2 ;COMM_ASM
	
	CALL	CLEAR_RGB
	;---------
	LD	A,LAND_PG0_PG
	CALL	PAGER
	LD	HL,LAND_PG0
	LD	DE,#8000
	LD	BC,LAND_PG0_END - LAND_PG0
	LDIR
	LD	A,#10
	CALL	PAGER
	LD	HL,#8000
	LD	DE,#C000
	CALL	DEPACK_PL5
	;---------
	LD	A,LAND_YYY_PG
	CALL	PAGER
	LD	HL,LAND_YYY
	LD	DE,#8000-#0b00
	CALL	DEPACK_PL5	
	;---------
	LD	A,LAND_EXE_PG
	CALL	PAGER
	LD	HL,LAND_EXE
	LD	DE,#8000
	CALL	DEPACK_PL5

	LD	IY,$+5
	RET
	
	DB	T_FX_INI
	DB	T_FX_NOP
	DW	5408 - 2

	DB	T_BLINK_ON
	DB	T_BLINK_ON
	DB	T_BLINK_OFF

	DB	T_FX_RUN
	DW	5616 - 26
	
//-----------------------------------------------------------------------------
// LANDSCAPE 2
//-----------------------------------------------------------------------------
	DB	2 ;COMM_ASM
	
	CALL	CLEAR_RGB
	;---------
	LD	A,LAND2_EXE_PG
	CALL	PAGER
	LD	HL,LAND2_EXE
	LD	DE,#8000
	CALL	DEPACK_PL5
	;CALL	#8006
	LD	IY,$+5
	RET
	
	DB	T_FX_INI
	DB	T_FX_NOP
	DW	5616 - 2

	DB	T_BLINK_ON
	DB	T_BLINK_ON
	DB	T_BLINK_OFF

	DB	T_FX_RUN
	DW	5694-2
	DB	T_BLINK_ON
	DB	T_BLINK_OFF

	DB	T_FX_RUN
	DW	5720-2
	DB	T_BLINK_ON
	DB	T_BLINK_OFF


	DB	T_FX_RUN
	DW	5824 - 26

//-----------------------------------------------------------------------------
// LANDSCAPE 3
//-----------------------------------------------------------------------------

	DB	2 ;COMM_ASM
	
	CALL	CLEAR_RGB
	;---------
	LD	A,LAND_EXE_PG
	CALL	PAGER
	LD	HL,LAND_EXE
	LD	DE,#8000
	CALL	DEPACK_PL5
	;CALL	#8006
	LD	IY,$+5
	RET
	
	DB	T_FX_INI
	DB	T_FX_NOP
	DW	5824 - 2

	DB	T_BLINK_ON
	DB	T_BLINK_ON
	DB	T_BLINK_OFF


	DB	T_FX_RUN
	DW	5902-2
	DB	T_BLINK_ON
	DB	T_BLINK_OFF

	DB	T_FX_RUN
	DW	6032 - 26

//-----------------------------------------------------------------------------
// LANDSCAPE 3
//-----------------------------------------------------------------------------

	DB	2 ;COMM_ASM
	
	CALL	CLEAR_RGB
	;---------
	LD	A,LAND3_EXE_PG
	CALL	PAGER
	LD	HL,LAND3_EXE
	LD	DE,#8000
	CALL	DEPACK_PL5
	;CALL	#8006
	LD	IY,$+5
	RET
	
	DB	T_FX_INI
	DB	T_FX_NOP
	DW	6032 - 2

	DB	T_BLINK_ON
	DB	T_BLINK_ON
	DB	T_BLINK_OFF

	DB	T_FX_RUN
	DW	6110-2
	DB	T_BLINK_ON
	DB	T_BLINK_OFF


	DB	T_FX_RUN
	DW	6136-2
	DB	T_BLINK_ON
	DB	T_BLINK_OFF


	DB	T_FX_RUN
	DW	6240 - 26

//-----------------------------------------------------------------------------
// LOAD IMAGE
//-----------------------------------------------------------------------------
	DB	2 ;COMM_ASM

	CALL	CLEAR_RGB
	;---------

	LD	A,LOAD_IMG_PG + #08
	CALL	PAGER
	LD	HL,LOAD_IMG
	LD	DE,#4000
	CALL	DEPACK_PL5
	LD	IY,$+5
	RET

	DB	T_FX_NOP
	DW	6240

	DB	2 ;COMM_ASM
	EI
	HALT
	LD	A,7
	OUT	(#FE),A
	LD	HL,#D800
	LD	DE,#D801
	LD	BC,767
	LD	(HL),7
	LDIR
	
	DUP	2
	EI
	HALT
	EDUP
	XOR A: OUT (#FE),A
	
	LD	A,#10
	CALL	PAGER
	LD	IY,$+5
	RET


	DB	T_FX_NOP
	DW	6344 - 2
	
	DB	T_FX_NOP
	DW	#FFFF

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------