//======================================================== FX_MEMORY_MAP
;
;
//======================================================== FX_HEADER
EFF_INI		JP	EFF_INI_
EFF_RUN		JP	EFF_RUN_
//======================================================== FX_CONST
STAR_QTY	EQU	18
BUFF_Y		EQU	44
BUFFSZ		EQU	32 * BUFF_Y	;1408
BUFF1A		EQU	#BE00 - BUFFSZ
BUFF1B		EQU	BUFF1A - BUFFSZ
BUFF2A		EQU	BUFF1B - BUFFSZ
BUFF2B		EQU	BUFF2A - BUFFSZ
;---
	IF MACHINE_TYPE = MT_PENTAGON
BUFF_Y_TOP	EQU	44
BUFF_Y_BOTT	EQU	0;//BUFF_Y - BUFF_Y_TOP
PG18	EQU 	#18
STARPG8	EQU	#1F17
	ELSE
BUFF_Y_TOP	EQU	32
BUFF_Y_BOTT	EQU	12;//BUFF_Y - BUFF_Y_TOP
PG18	EQU	#10
STARPG8	EQU	#171F
	ENDIF
;---
C0	EQU	0;
CZ	EQU	3;
C1	EQU	4;
C2	EQU	5;
C3	EQU	6;
C4	EQU	10;
C5	EQU	15;
;---
P7FFD	EQU #7FFD
XOR8	EQU #08
;---
ADDLN0	EQU 64-2
ADDLN1	EQU 64-2
ADDLN2	EQU 64-3
ADDLN3	EQU 64-3
ADDLN4	EQU 64-3
ADDLN5	EQU 64-1
;---
ADDLN0X	EQU 64-1
ADDLN1X	EQU 64-3
ADDLN2X	EQU 64-3
ADDLN3X	EQU 64-3
ADDLN4X	EQU 64-2
ADDLN5X	EQU 64-2
;---
STARS_LIST_QTY_MAX EQU 0
STEP_Z	EQU	1
Z_MAX	EQU	16

ORTBL	EQU	#FF00

MOVE_ADR	EQU	#DB00
MOVE_ADR_BOTT	EQU	MOVE_ADR + 2 + 16*4*BUFF_Y_TOP
//======================================================== FX_INIT
EFF_INI_
	LD	A,#17
	CALL	PAGER

	LD	HL,#4860
	CALL	LD32
	LD	HL,#CC40
	CALL	LD32

ORNUM	EQU	3
	LD	HL,ORTBL
	DUP	ORNUM
	LD	(HL),ORNUM
	INC	L
	EDUP
ORTBL1	LD	(HL),L
	INC	L
	JP	NZ,ORTBL1

	LD	HL,BUFF2B
	LD	DE,BUFF2B + 1
	LD	BC,BUFFSZ*4-1
	LD	(HL),0
	LDIR

	LD	HL,BUFF
	LD	DE,BUFF + 1
	LD	BC,64 * BUFF_Y - 1
	LD	(HL),0
	LDIR

	CALL	INIMOVE

	EI
	HALT
	CALL	SWAPBUFF
	CALL	SWP
	CALL	MOVE
	CALL	ROTATE
	CALL	ADDSTARS
	LD	A,#17
	CALL	PAGER
	CALL	OUTBG

	RET

;-----------------------
INIMOVE
	LD	HL,MOVE_ADR
	LD	DE,#5820
	LD	LX,BUFF_Y_TOP
	IF BUFF_Y_BOTT > 0
	  CALL	INIMV0
	  LD	LX,BUFF_Y_BOTT
	ENDIF
INIMV0	;---
	LD	BC,0-32
INIMV2	;---
	LD	A,16
INIMV1	;---
	LD	(HL),#E1	; pop hl
	INC	HL
	LD	(HL),#22	; ld (adr),hl
	INC	HL
	LD	(HL),E
	INC	HL
	LD	(HL),D
	INC	HL
	INC	E
	INC	DE
	DEC	A
	JP	NZ,INIMV1
	;---
	;#40 = 0100.0000
	;#c0 = 1100.0000

	LD	A,D
	XOR	#80
	LD	D,A
	AND	#80
	JP	Z,INIMV3
	;---
	EX	DE,HL
	ADD	HL,BC
	EX	DE,HL
INIMV3	;---
	DEC	LX
	JP	NZ,INIMV2
	;---
	LD	(HL),#EB	; ex de,hl
	INC	HL
	LD	(HL),#E9	; jp (hl)
	INC	HL
	;---
	RET
;---------------------------
LD32	LD	LX,4
LD32_3	PUSH	HL
	LD	B,4
LD32_1	LD	E,L
	LD	A,#F0
	DUP	31
	LD	(HL),A
	INC	L
	EDUP
	LD	(HL),A
	LD	L,E
	INC	H
	DJNZ	LD32_1
	;--
	POP	HL
	LD	A,L
	ADD	A,#20
	LD	L,A
	JP	NC,LD32_2
	LD	A,H
	ADD	A,8
	LD	H,A
LD32_2	DEC	LX
	JP	NZ,LD32_3
	RET
//======================================================== FX_MAINLOOP
EFF_RUN_
	EI
	HALT
	CALL	MOVE_TOP
	LD	LX,15
	CALL	OUTPUT
	CALL	SWP
	CALL	MOVE
	IF BUFF_Y_BOTT > 0
	  CALL	MOVE_BOTTOM
	ENDIF
	;-----
	EI
	HALT
	CALL	MOVE_TOP
	LD	LX,14
	CALL	OUTPUT
	CALL	SWP
	CALL	ROTATE
	IF BUFF_Y_BOTT > 0
	  CALL	MOVE_BOTTOM
	ENDIF
	;-----
	EI
	HALT
	CALL	MOVE_TOP
	LD	LX,15
	CALL	OUTPUT
	CALL	SWP
	IF BUFF_Y_BOTT > 0
	  CALL	MOVE_BOTTOM
	ENDIF
	;-----

	EI
	HALT
	CALL	MOVE_TOP
	CALL	ADDSTARS
	CALL	OUTBG
	CALL	SWAPBUFF
	CALL	SWP
	CALL	SYNC
	CALL	FILL32
	
	IF BUFF_Y_BOTT > 0
	  CALL	MOVE_BOTTOM
	ENDIF
	;-----
	RET
//======================================================== FX_PROCEDURES
SYNC	XOR	A
	LD	(BORDER),A
	;---
	LD	HL,SYNC_TBL
SYNC_ADR	EQU $-2
	LD	C,(HL)
	INC	HL
	LD	B,(HL)
	INC	HL
	EX	DE,HL
	;---
	LD	HL,(MUSPOS)
	AND	A
	SBC	HL,BC
	JP	C,SYNC1
	;---
	EX	DE,HL
	LD	C,(HL)
	INC	HL
	LD	B,(HL)
	INC	HL
	LD	(SYNC_ADR),HL
	LD	(SYNC1+1),BC
	;---
SYNC1	JP	SYNC_RET
SYNC_RET RET
	
SYNC_TBL

	DW	2272+8	;2276 need 2275
	DW	S_MV

	DW	2288 - 4
	DW	S_BL_MV
	DW	1
	DW	S_MV

	DW	2288 + 4*4
	DW	SYNC_RET
	
	
	
	;DW	2496 - 4*3
	;DW	S_MV
	;DW	2496 - 4
	;DW	S_BL_MV
	;DW	1
	;DW	S_MV
	;DW	2496 + 4*2
	;DW	SYNC_RET

	
	DW	#FFFF

;---
S_BL_MV	LD	A,7
	LD	(BORDER),A
S_MV	CALL	MOVE
	CALL	MOVE
	CALL	MOVE
	JP	MOVE
;---
;S_BL	LD	A,7
;	LD	(BORDER),A
;	RET


;------------------------------------
FILL32
	LD	A,(BORDER)
	OR	A
	RET	NZ
	;--
	LD	HL,#5800
LDIR32	;--
	LD	D,H
	LD	E,L
	INC	E
	LD	BC,31
	LD	(HL),0
	LDIR
	RET
;------------------------------------
MCX_SPEED1	EQU	3
MCY_SPEED1	EQU	2
MCX_SPEED2	EQU	4
MCY_SPEED2	EQU	2

MOVE	LD	DE,MCY_SPEED1 * 256 + MCX_SPEED1
MOVEA	LD	A,0
	XOR	#FF
	LD	(MOVEA+1),A
	JP	Z,MOVE_
	LD	DE,MCY_SPEED2 * 256 + MCX_SPEED2
MOVE_
MCY	LD	A,0
	ADD	A,D
	LD	(MCY+1),A
	LD	B,SINY / 256
	LD	C,A
	LD	A,(BC)
	LD	L,A
	LD	H,0
	ADD	HL,HL
	ADD	HL,HL
	ADD	HL,HL
	ADD	HL,HL
	ADD	HL,HL
	ADD	HL,HL

MCX	LD	A,64
	ADD	A,E
	LD	(MCX+1),A
	LD	B,COSX / 256
	LD	C,A
	LD	A,(BC)
	LD	D,0
	LD	E,A
	ADD	HL,DE
	LD	(MOVADR),HL
	RET

;-------------------------------
SWAPBUFF
	LD	HL,BUFF+2
	LD	(OUT_BUFF),HL
	;-
	LD	A,0
SWAPBUFFA EQU $-1
	XOR	#FF
	LD	(SWAPBUFFA),A
	JR	Z,SWAPBUFF1
	;---
	LD	HL,BUFF2A + BUFFSZ - 1
	LD	(OUT_BUFFA),HL
	LD	HL,BUFF2B + BUFFSZ
	LD	(OUT_BUFFB),HL
	LD	HL,BUFF1A
	LD	(SWP_BUFFA),HL
	LD	HL,BUFF1B
	LD	(SWP_BUFFB),HL
	RET
SWAPBUFF1 ;---
	LD	HL,BUFF1A + BUFFSZ - 1
	LD	(OUT_BUFFA),HL
	LD	HL,BUFF1B + BUFFSZ
	LD	(OUT_BUFFB),HL
	LD	HL,BUFF2A
	LD	(SWP_BUFFA),HL
	LD	HL,BUFF2B
	LD	(SWP_BUFFB),HL
	RET
;--------------------------
SWP	LD	A,0
SWP0	EQU	$-1
	XOR	#FF
	LD	(SWP0),A
	LD	HL,0
SWP_BUFFA EQU $-2
	JP	Z,SWP1
	LD	HL,0
SWP_BUFFB EQU $-2
SWP1	LD	(MOVE_TOP_SP),HL
	;---
	IF BUFF_Y_TOP > 0
	  LD	DE,BUFF_Y_TOP*32
	  ADD	HL,DE
	  LD	(MOVE_BOTT_SP),HL
	ENDIF
	;---
	RET
;--------------------------
FX_BLINK
	LD	HL,#5B00
	CALL	FX_BLINK0
	LD	HL,#DB00
FX_BLINK0	
	LD	(FX_BLINK_SP),SP
	LD	SP,HL
	LD	HL,#3F3F
	LD	B,6
FX_BLINK1
	DUP	64
	PUSH	HL
	EDUP
	DJNZ	FX_BLINK1
	LD	SP,#3131
FX_BLINK_SP EQU $-2
	RET
;--------------------------
MOVE_TOP
	LD	BC,#7FFD
	LD	A,#17
	OUT	(C),A
	;---
	LD	A,7
BORDER	EQU	$-1
	OUT	(#FE),A
	OR	A
	JR	NZ,FX_BLINK
	;---
	LD	(SOHRSP1),SP
	
	LD	HL,0	;10
	LD	SP,#DB00 ;10
	DUP	16
	PUSH	HL	;11*16=176
	EDUP
	LD	SP,#5B00 ;10
	DUP	16
	PUSH	HL	;11*16=176
	EDUP	

	LD	SP,0
MOVE_TOP_SP	EQU	$-2
	LD	DE,MOVE_TOP1
	JP	MOVE_ADR
MOVE_TOP1
	LD	SP,0
SOHRSP1	EQU	$-2
	RET
;----------------------
	IF BUFF_Y_BOTT > 0
MOVE_BOTTOM
	LD	A,(BORDER)
	OR	A
	RET	NZ
	;--
	LD	BC,#7FFD ;10
	LD	A,#17	;7
	OUT	(C),A	;12
	;---
	LD	(MOVEBOTTSP),SP
	LD	SP,0
MOVE_BOTT_SP	EQU	$-2
	LD	DE,MOVE_BOTT1
	JP	MOVE_ADR_BOTT
MOVE_BOTT1
	LD	SP,0
MOVEBOTTSP	EQU	$-2
	RET
	ENDIF
;----------------------
OUTPUT	;--
	IF MACHINE_TYPE = MT_PENTAGON
	  ;w79
	  LD	A,5
	  DEC	A
	  JP	NZ,$-1
	ELSE
	  ;w44
	  ADD HL,HL:ADD HL,HL:ADD HL,HL:ADD HL,HL
	ENDIF
	LD	(SOHRSP_DEC),SP
	LD	H,PALETTE / 256
	LD	DE,0
OUT_BUFFA EQU $-2
	LD	SP,0
OUT_BUFFB EQU $-2
	EXX
	LD	HL,BUFF
OUT_BUFF EQU $-2
	LD	D,TBL_SUB / 256
	LD	BC,P7FFD
	LD	A,PG18
	OUT	(C),A
	;-
OUTLP	EX	AF,AF
	;--------
	DUP	2
	;--------
	DUP	6
	;--------
	LD	E,(HL)	;7
	LD	A,(DE)	;7
	LD	(HL),A	;7
	INC	L	;4 /25
	;-
	EXX		;4
	LD	L,A	;4
	LD	A,(HL)	;7
	LD	(DE),A	;7
	DEC	E	;4
	INC	H	;4
	LD	B,(HL)	;7
	EXX		;4 /41 //66
	;-----
	LD	E,(HL)	;7
	LD	A,(DE)	;7
	LD	(HL),A	;7
	INC	L	;4 /25
	;-
	EXX		;4
	LD	L,A	;4
	LD	C,(HL)	;7
	PUSH	BC	;11
	DEC	H	;4
	LD	A,(HL)	;7
	LD	(DE),A	;7
	DEC	E	;4
	EXX		;4 /52 //77 /=>143
	;--------
	EDUP
	;-------- 143*6=858
	;- wait 11
	XOR A:RET NZ
	
	IF MACHINE_TYPE = MT_ZX128 OR MACHINE_TYPE = MT_ZX2A
	  NOP:NOP:NOP:NOP
	ENDIF
	
	;--- swap scr
	EX	AF,AF	;4
	XOR	XOR8	;7
	OUT	(C),A	;12
	EX	AF,AF	;4 /27
	;--------
	EDUP
	;-------- 24 chars completed
	DUP	3
	;--------
	LD	E,(HL)	;7
	LD	A,(DE)	;7
	LD	(HL),A	;7
	INC	L	;4 /25
	;-
	EXX		;4
	LD	L,A	;4
	LD	A,(HL)	;7
	LD	(DE),A	;7
	DEC	E	;4
	INC	H	;4
	LD	B,(HL)	;7
	EXX		;4 /41 //66
	;-----
	LD	E,(HL)	;7
	LD	A,(DE)	;7
	LD	(HL),A	;7
	INC	L	;4 /25
	;-
	EXX		;4
	LD	L,A	;4
	LD	C,(HL)	;7
	PUSH	BC	;11
	DEC	H	;4
	LD	A,(HL)	;7
	LD	(DE),A	;7
	DEC	E	;4
	EXX		;4 /52 //77 /=>143
	;--------
	EDUP
	;-------- 		/143*3=429
	LD	E,(HL)	;7
	LD	A,(DE)	;7
	LD	(HL),A	;7
	INC	L	;4 /25
	;-
	EXX		;4
	LD	L,A	;4
	LD	A,(HL)	;7
	LD	(DE),A	;7
	DEC	E	;4
	INC	H	;4
	LD	B,(HL)	;7
	EXX		;4 /41 //66
	;-----
	LD	E,(HL)	;7
	LD	A,(DE)	;7
	LD	(HL),A	;7 /21
	;-
	EXX		;4
	LD	L,A	;4
	LD	C,(HL)	;7
	PUSH	BC	;11
	DEC	H	;4
	LD	A,(HL)	;7
	LD	(DE),A	;7
	DEC	DE	;6
	EXX		;4 /54 //75 /=>141
	;- wait
	IF MACHINE_TYPE = MT_PENTAGON
	  LD	A,17
	  DEC	A
	  JP	NZ,$-1
	  RET	NZ
	  NOP
	ELSE
	  LD	A,18
	  DEC	A
	  JP	NZ,$-1
	  RET	NZ
	  NOP
	  NOP
	ENDIF
	
	;-- next line
	LD	BC,33	;10
	ADD	HL,BC	;15
	LD	BC,P7FFD ;10
	;--- swap scr
	EX	AF,AF	;4
	XOR	XOR8	;7
	OUT	(C),A	;12 /23
	;--
	DEC	LX	;8
	JP	NZ,OUTLP ;10 /18
	;---
	LD	(OUT_BUFF),HL
	EXX
	LD	(OUT_BUFFA),DE
	LD	HL,0 - BUFFSZ + 1
	ADD	HL,DE
	LD	(OUT_BUFFB),HL
	;---
	LD	SP,0
SOHRSP_DEC EQU $-2
	RET
;------------------------------
ADDSTARS
	IF MACHINE_TYPE = MT_ZX128 OR MACHINE_TYPE = MT_ZX2A
	  LD	A,10
	  DEC	A
	  JP	NZ,$-1
	ENDIF

	LD	BC,#7FFD	;10
	LD	DE,STARPG8	;10
	OUT	(C),D
	EXX			;4
	LD	D,TBL_ADD_HI / 256 ;7
	LD	H,TBL_ADD / 256	;7
	;--
	LD	(SOHRSP2),SP
	LD	SP,ADDSTARS_TBL
	;-
	RET
ADDSTARS_RET
	EXX		;4
	LD	D,7	;7
ADDSR1	;--
	LD	A,60
	DEC	A
	JP	NZ,$-1
	NOP:NOP
	;--
	LD	A,E	;4
	OUT	(C),A	;12
	XOR	#08	;7
	LD	E,A	;4
	DEC	D	;4
	JP	NZ,ADDSR1 ;10 /41
ADDSR2	;---
	LD	SP,0
SOHRSP2	EQU $-2
	RET
;-------------------------
ADDSTARS_TBL
	DUP	STAR_QTY
	DW	ADDSTAR
	DW	BUFF + 10
	EDUP
	DW	ADDSTARS_RET
;--------------------------------------
; Начальные координаты точек хранятся в формате 
; X=X+COR_Z 
; Y=Y+COR_Z 
; Z=Z+COR_Z 
; (т.е. с прибавленным смещением до начала таблиц)
;---------------------------------------- 
; Диапазон изменения угла вращения 0..127 
; Поворот осуществляется вокруг осей Ox,Oy 
; по адресу Ay - угол вращения вокруг Oy 
; по адресу Ax - угол вращения вокруг Ox
;---------------------------------------- 
; Таблица произведений: 
;        #C000          +128	   +212	
;        +--------------+----------+----------+ 
;   Coord| Coord*cos(A) | projectY | projectX | Z
;        +--------------+----------+----------+ 
;        Alpha          
;---------------------------------------- 
; Формулы вращения 
;-Ox: 
; y` = y*cos(Ax) - z*sin(Ax) 
; z` = y*sin(Ax) + z*cos(Ax) 
;-Oy: 
; x` = x*cos(Ay) + z*sin(Ay) 
; z` = z*cos(Ay) - x*sin(Ay)

XYZMAX	EQU	21	; максимальная длина по осям (в одну сторону) 
COR_TBL	EQU	#C0
COR_Z	EQU	COR_TBL + XYZMAX 
PROJ_PY EQU	128	;#80
PROJ_PX EQU	212	;#D4

CSDIV	EQU	COR_TBL + XYZMAX*2

COS_AX	EQU	0
SIN_AX	EQU	COS_AX + 32
COS_AY	EQU	0
SIN_AY	EQU	COS_AY + 32


ANGLE_AX_STEP	EQU  700;700;796;896
ANGLE_AY_STEP	EQU  300;300;341;384


ROTATE	;------------------------
	LD	A,#18
	CALL	PAGER
	;-----------------------
	LD	HL,#4000
ANGLE_AX EQU $-2
	LD	BC,ANGLE_AX_STEP
	ADD	HL,BC
	LD	(ANGLE_AX),HL
	LD	A,H
	AND	127
	LD	(CAX1 + 1),A
	LD	(CAX2 + 1),A
	ADD	A,32
	AND	127
	LD	(SAX1 + 1),A
	LD	(SAX2 + 1),A
	;-----------------------
	LD	HL,0
ANGLE_AY EQU $-2
	LD	BC,ANGLE_AY_STEP
	ADD	HL,BC
	LD	(ANGLE_AY),HL
	LD	A,H
	AND	127
	LD	(CAY1 + 1),A
	LD	(CAY2 + 1),A
	ADD	A,32
	AND	127
	LD	(SAY1 + 1),A
	LD	(SAY2 + 1),A
	;-----------------------
	LD	(ROT_SOHR_SP),SP
	LD	SP,POINTS
	LD	BC,ADDSTARS_TBL
	EXX
	LD	LX,STAR_QTY
ROT1	;------
	POP	BC	;10	координаты C=z B=y
	;---------------------- Ox: y` = y*cos(Ax) - z*sin(Ax) 
CAX1	LD	L,COS_AX	;7
	LD	H,B		;4
	LD	A,(HL)		;7 a=(hl)=y*cos(Ax)
SAX1	LD	L,SIN_AX	;7
	LD	H,C		;4 (hl)=z*sin(Ax)
	SUB	(HL)		;7 a=y`
	;---
	ADD	A,XYZMAX*4
	RRA
	RRA
	AND	%00111111
	ADD	A,A
	ADD	A,PROJ_PY	;A = таблица проекции Y
	EXX
	LD	L,A
	EXX
	;---------------------- Ox: z` = y*sin(Ax) + z*cos(Ax) 
SAX2	LD	L,SIN_AX	;7
	LD	H,B		;4
	LD	A,(HL)		;7 a=(hl)=y*sin(Ax)
CAX2	LD	L,COS_AX	;7
	LD	H,C		;4 (hl)=z*sin(Ax)
	ADD	A,(HL)		;7 a=z`
	;---
	ADD	A,XYZMAX*4
	RRA
	RRA
	AND	%00111111
	ADD	A,COR_TBL
	;----------------------
	POP	BC
	DEC	SP
	LD	B,A		; координаты C=x B=z
	;---------------------- Oy: x` = x*cos(Ay) + z*sin(Ay)
SAY1	LD	L,SIN_AY	;7
	LD	H,B		;4
	LD	A,(HL)		;7 a=(hl)=z*sin(Ay)
CAY1	LD	L,COS_AY	;7
	LD	H,C		;4 (hl)=x*cos(Ay)
	ADD	A,(HL)		;7 a=x`
	;--
	ADD	A,XYZMAX*4
	RRA
	RRA
	AND	%00111111
	ADD	A,PROJ_PX ; a = projectX
	EX	AF,AF
	;---------------------- Oy: z` = z*cos(Ay) - x*sin(Ay)
CAY2	LD	L,COS_AY	;7
	LD	H,B		;4
	LD	A,(HL)		;7 a=(hl)=z*cos(Ay)
SAY2	LD	L,SIN_AY	;7
	LD	H,C		;4 (hl)=x*sin(Ay)
	SUB	(HL)		;7 a=z`
	;--
	ADD	A,XYZMAX*4
	RRA
	RRA
	AND	%00111111
	LD	L,A		;4
	;----------------------- get buff adr
	EXX
	ADD	A,COR_TBL
	LD	H,A		;H = z
	LD	E,(HL)
	INC	L
	LD	D,(HL)		;DE = BUFF ADR by Py
	EX	AF,AF
	LD	L,A
	LD	A,(HL)		;L = Px
	EX	AF,AF
	LD	A,(HL)		;L = Px
	RRA
	AND	%01111111
	LD	L,A
	LD	H,0
	ADD	HL,DE
	LD	DE,0 - 16	;0 - 8 + 64*8
	ADD	HL,DE
	LD	DE,0
MOVADR	EQU	$-2
	ADD	HL,DE

	LD	DE,ADDSTAR
	EX	AF,AF
	AND	1
	JP	Z,ROTSZ
	LD	DE,ADDSTARX
ROTSZ
	LD	A,E
	LD	(BC),A
	INC	BC
	LD	A,D
	LD	(BC),A
	INC	BC

	LD	A,L
	LD	(BC),A
	INC	BC
	LD	A,H
	LD	(BC),A
	INC	BC

	EXX
	;------------------------ get spr size
	DEC	LX
	JP	NZ,ROT1
	;---
	LD	SP,0
ROT_SOHR_SP EQU $-2
	RET
//======================================================== FX_INCLUDE_DATA
ADDSTAR
	INCLUDE "bin/addstar.asm"
ADDSTARX
	INCLUDE "bin/addstarx.asm"
//======================================================== FX_TABLES
	ALIGN	256
PALETTE
	INCBIN "bin/3d_addlight_palette.bin"
;----------------------
TBL_SUB
	INCBIN "bin/tbl_sub.bin"
;----------------------
TBL_ADD
	DB 0,1,2,3, 4,5,6,7, 8,9,10,11, 12,13,14,15
	DS 256-16, 15
;----------------------
TBL_ADD_HI
	INCBIN "bin/tbl_add_hi.bin"
	
	ALIGN	256
COSX	INCLUDE "bin/cos_x.asm"
SINY	INCLUDE "bin/sin_y.asm"
;----------------------
POINTS	;z y x
	DB	0+COR_Z,-7+COR_Z,-18+COR_Z
	DB	0+COR_Z,-18+COR_Z,7+COR_Z
	DB	-19+COR_Z,0+COR_Z,0+COR_Z
	DB	0+COR_Z,-5+COR_Z,-12+COR_Z
	DB	0+COR_Z,-12+COR_Z,5+COR_Z
	DB	-13+COR_Z,0+COR_Z,0+COR_Z
	DB	0+COR_Z,-2+COR_Z,-6+COR_Z
	DB	0+COR_Z,-6+COR_Z,2+COR_Z
	DB	-6+COR_Z,0+COR_Z,0+COR_Z
	DB	0+COR_Z,2+COR_Z,6+COR_Z
	DB	0+COR_Z,6+COR_Z,-2+COR_Z
	DB	7+COR_Z,0+COR_Z,0+COR_Z
	DB	0+COR_Z,5+COR_Z,12+COR_Z
	DB	0+COR_Z,12+COR_Z,-5+COR_Z
	DB	13+COR_Z,0+COR_Z,0+COR_Z
	DB	0+COR_Z,7+COR_Z,18+COR_Z
	DB	0+COR_Z,18+COR_Z,-7+COR_Z
	DB	20+COR_Z,0+COR_Z,0+COR_Z
;----------------------
	ALIGN 64
BUFF	EQU	$ + 64*16


	DISPLAY "-------------------------------- FX VARS:"
	DISPLAY "MOVE_ADR ", /A, MOVE_ADR
	DISPLAY "MOVE_ADR_BOTT ", /A, MOVE_ADR_BOTT
	DISPLAY "MOVE_ADR SIZE", /A, 32*BUFF_Y*4
	DISPLAY "MOVE_ADR_END ", /A, MOVE_ADR + 32*BUFF_Y*4 + 4

	DISPLAY "BUFF END: ", /A, BUFF + 64*40 + 64*8

	DISPLAY "BUFFSZ: ", /A, BUFFSZ
	DISPLAY "BUFF1A: ", /A, BUFF1A
	DISPLAY "BUFF1B: ", /A, BUFF1B
	DISPLAY "BUFF2A: ", /A, BUFF2A
	DISPLAY "BUFF2B: ", /A, BUFF2B

