//======================================================== FX_MEMORY_MAP
;
;
//======================================================== FX_HEADER
EFF_INI		JP	EFF_INI_
EFF_RUN		JP	EFF_RUN_
//======================================================== FX_CONST
STAR_QTY	EQU	26
BUFF_Y		EQU	44
BUFFSZ		EQU	32 * BUFF_Y	;1408
;---
BUFF1A		EQU	#BE00 - BUFFSZ
BUFF1B		EQU	BUFF1A - BUFFSZ
BUFF2A		EQU	BUFF1B - BUFFSZ
BUFF2B		EQU	BUFF2A - BUFFSZ
;---
	IF MACHINE_TYPE = MT_PENTAGON
BUFF_Y_TOP	EQU	44
BUFF_Y_BOTT	EQU	0;//BUFF_Y - BUFF_Y_TOP
	ELSE
BUFF_Y_TOP	EQU	32
BUFF_Y_BOTT	EQU	12;//BUFF_Y - BUFF_Y_TOP
	ENDIF
;---
C0	EQU	0;
CZ	EQU	1;
C1	EQU	2;
C2	EQU	3;
C3	EQU	6;
C4	EQU	10;
C5	EQU	15;
;---
P7FFD	EQU #7FFD
XOR8	EQU #08
PG18	EQU #10
;---
ADDLN0	EQU 64-2
ADDLN1	EQU 64-2
ADDLN2	EQU 64-3
ADDLN3	EQU 64-3
ADDLN4	EQU 64-3
ADDLN5	EQU 64-1
;---
ADDLN0X	EQU 64-1
ADDLN1X	EQU 64-3
ADDLN2X	EQU 64-3
ADDLN3X	EQU 64-3
ADDLN4X	EQU 64-2
ADDLN5X	EQU 64-2
;---
STARS_LIST_QTY_MAX EQU 0
STEP_Z	EQU	1
Z_MAX	EQU	16
;---
MOVE_ADR	EQU	#DB00
MOVE_ADR_BOTT	EQU	MOVE_ADR + 2 + 16*4*BUFF_Y_TOP
//======================================================== FX_INIT
EFF_INI_
	EI
	HALT

	LD	A,#17
	CALL	PAGER

	LD	HL,#C000
	LD	DE,#4000
	LD	BC,6912
	LDIR

	LD	HL,BUFF2B
	LD	DE,BUFF2B + 1
	LD	BC,BUFFSZ*4-1
	LD	(HL),0
	LDIR

	LD	HL,BUFF
	LD	DE,BUFF + 1
	LD	BC,64 * BUFF_Y - 1
	LD	(HL),0
	LDIR

	CALL	MOVESTARS
	CALL	SWAPBUFF
	CALL	SWP
;-----------------------
INIMOVE
	LD	HL,MOVE_ADR
	LD	DE,#5820
	LD	LX,BUFF_Y_TOP
	IF BUFF_Y_BOTT > 0
	  CALL	INIMV0
	  LD	LX,BUFF_Y_BOTT
	ENDIF
INIMV0	;---
	LD	BC,0-32
INIMV2	;---
	LD	A,16
INIMV1	;---
	LD	(HL),#E1	; pop hl
	INC	HL
	LD	(HL),#22	; ld (adr),hl
	INC	HL
	LD	(HL),E
	INC	HL
	LD	(HL),D
	INC	HL
	INC	E
	INC	DE
	DEC	A
	JP	NZ,INIMV1
	;---
	;#40 = 0100.0000
	;#c0 = 1100.0000

	LD	A,D
	XOR	#80
	LD	D,A
	AND	#80
	JP	Z,INIMV3
	;---
	EX	DE,HL
	ADD	HL,BC
	EX	DE,HL
INIMV3	;---
	DEC	LX
	JP	NZ,INIMV2
	;---
	LD	(HL),#EB	; ex de,hl
	INC	HL
	LD	(HL),#E9	; jp (hl)
	INC	HL
	;---
	RET
//======================================================== FX_MAINLOOP
EFF_RUN_
	EI
	HALT
	CALL	MOVE_TOP
	LD	LX,14
	CALL	OUTPUT
	CALL	MOVESTARS
	CALL	SWP
	IF BUFF_Y_BOTT > 0
	  CALL	MOVE_BOTTOM
	ENDIF
	;-----
	EI
	HALT
	CALL	MOVE_TOP
	LD	LX,15
	CALL	OUTPUT
	CALL	SWP
	IF BUFF_Y_BOTT > 0
	  CALL	MOVE_BOTTOM
	ENDIF
	;-----
	EI
	HALT
	CALL	MOVE_TOP
	LD	LX,15
	CALL	OUTPUT
	CALL	SWP
	CALL	ATTRFILL1
	CALL	ATTRFILL2
	CALL	ATTRFILL3
	IF BUFF_Y_BOTT > 0
	  CALL	MOVE_BOTTOM
	ENDIF
	;-----
	EI
	HALT
	CALL	MOVE_TOP
	CALL	ADDSTARS
	CALL	SWAPBUFF
	CALL	SWP
	IF BUFF_Y_BOTT > 0
	  CALL	MOVE_BOTTOM
	ENDIF
	;-----
	
	LD	(SOHRSPFILL),SP
	LD	HL,0	;10
	LD	SP,#5820 ;10
	DUP	16
	PUSH	HL	;11*16=176
	EDUP
	LD	SP,#3131
SOHRSPFILL EQU $-2
	
	XOR A:LD (BORDER),A
	RET
//======================================================== FX_PROCEDURES
SWAPBUFF
	LD	HL,BUFF+2
	LD	(OUT_BUFF),HL
	;-
	LD	A,0
SWAPBUFFA EQU $-1
	XOR	#FF
	LD	(SWAPBUFFA),A
	JR	Z,SWAPBUFF1
	;---
	LD	HL,BUFF2A + BUFFSZ - 1
	LD	(OUT_BUFFA),HL
	LD	HL,BUFF2B + BUFFSZ
	LD	(OUT_BUFFB),HL
	LD	HL,BUFF1A
	LD	(SWP_BUFFA),HL
	LD	HL,BUFF1B
	LD	(SWP_BUFFB),HL
	LD	HL,BUFF2A
	LD	(BUFF_ADR_A),HL
	LD	HL,BUFF2B
	LD	(BUFF_ADR_B),HL

	RET
SWAPBUFF1 ;---
	LD	HL,BUFF1A + BUFFSZ - 1
	LD	(OUT_BUFFA),HL
	LD	HL,BUFF1B + BUFFSZ
	LD	(OUT_BUFFB),HL
	LD	HL,BUFF2A
	LD	(SWP_BUFFA),HL
	LD	HL,BUFF2B
	LD	(SWP_BUFFB),HL
	LD	HL,BUFF1A
	LD	(BUFF_ADR_A),HL
	LD	HL,BUFF1B
	LD	(BUFF_ADR_B),HL
	RET
;--------------------------
SWP	LD	A,0
SWP0	EQU	$-1
	XOR	#FF
	LD	(SWP0),A
	LD	HL,0
SWP_BUFFA EQU $-2
	JP	Z,SWP1
	LD	HL,0
SWP_BUFFB EQU $-2
SWP1	LD	(MOVE_TOP_SP),HL

	IF BUFF_Y_TOP > 0
	  LD	BC,BUFF_Y_TOP*32
	  ADD	HL,BC
	  LD	(MOVE_BOTT_SP),HL
	ENDIF

	RET
;--------------------------
FX_BLINK
	LD	HL,#5B00
	CALL	FX_BLINK0
	LD	HL,#DB00
FX_BLINK0	
	LD	(FX_BLINK_SP),SP
	LD	SP,HL
	LD	HL,#3F3F
	LD	B,6
FX_BLINK1
	DUP	64
	PUSH	HL
	EDUP
	DJNZ	FX_BLINK1
	LD	SP,#3131
FX_BLINK_SP EQU $-2
	RET
;--------------------------
MOVE_TOP
	LD	BC,#7FFD ;10
	LD	A,#17	;7
	OUT	(C),A	;12
	;---
	LD	A,7
BORDER	EQU	$-1
	OUT	(#FE),A
	OR	A
	JR	NZ,FX_BLINK
	;---
	LD	(SOHRSP1),SP

	LD	HL,0	;10
	LD	SP,#DB00 ;10
	DUP	16
	PUSH	HL	;11*16=176
	EDUP
	LD	SP,#5B00 ;10
	DUP	16
	PUSH	HL	;11*16=176
	EDUP

	LD	SP,0
MOVE_TOP_SP	EQU	$-2
	LD	DE,MOVE_TOP1
	JP	MOVE_ADR
MOVE_TOP1
	LD	SP,0
SOHRSP1	EQU	$-2
	RET
;----------------------
	IF BUFF_Y_BOTT > 0
MOVE_BOTTOM
	LD	A,(BORDER)
	CP	7
	RET	Z
	;--
	LD	BC,#7FFD ;10
	LD	A,#17	;7
	OUT	(C),A	;12
	;---
	LD	(MOVEBOTTSP),SP
	LD	SP,0
MOVE_BOTT_SP	EQU	$-2
	LD	DE,MOVE_BOTT1
	JP	MOVE_ADR_BOTT
MOVE_BOTT1
	LD	SP,0
MOVEBOTTSP	EQU	$-2
	RET
	ENDIF
;----------------------
OUTPUT	;--
	IF MACHINE_TYPE = MT_PENTAGON
	  ;w79
	  LD	A,5
	  DEC	A
	  JP	NZ,$-1
	ELSE
	  ADD HL,HL:ADD HL,HL
	ENDIF


	LD	(SOHRSP_DEC),SP
	LD	H,PALETTE / 256
	LD	DE,0
OUT_BUFFA EQU $-2
	LD	SP,0
OUT_BUFFB EQU $-2
	EXX
	LD	HL,BUFF
OUT_BUFF EQU $-2
	LD	D,TBL_SUB / 256
	LD	BC,P7FFD
	LD	A,PG18
	OUT	(C),A
	;-
OUTLP	EX	AF,AF
	;--------
	DUP	2
	;--------
	DUP	6
	;--------
	LD	E,(HL)	;7
	LD	A,(DE)	;7
	LD	(HL),A	;7
	INC	L	;4 /25
	;-
	EXX		;4
	LD	L,A	;4
	LD	A,(HL)	;7
	LD	(DE),A	;7
	DEC	E	;4
	INC	H	;4
	LD	B,(HL)	;7
	EXX		;4 /41 //66
	;-----
	LD	E,(HL)	;7
	LD	A,(DE)	;7
	LD	(HL),A	;7
	INC	L	;4 /25
	;-
	EXX		;4
	LD	L,A	;4
	LD	C,(HL)	;7
	PUSH	BC	;11
	DEC	H	;4
	LD	A,(HL)	;7
	LD	(DE),A	;7
	DEC	E	;4
	EXX		;4 /52 //77 /=>143
	;--------
	EDUP
	;-------- 143*6=858
	;- wait 11
	XOR A:RET NZ

	IF MACHINE_TYPE = MT_ZX128 OR MACHINE_TYPE = MT_ZX2A
	  NOP:NOP:NOP:NOP
	ENDIF
	
	;--- swap scr
	EX	AF,AF	;4
	XOR	XOR8	;7
	OUT	(C),A	;12
	EX	AF,AF	;4 /27
	;--------
	EDUP
	;-------- 24 chars completed
	DUP	3
	;--------
	LD	E,(HL)	;7
	LD	A,(DE)	;7
	LD	(HL),A	;7
	INC	L	;4 /25
	;-
	EXX		;4
	LD	L,A	;4
	LD	A,(HL)	;7
	LD	(DE),A	;7
	DEC	E	;4
	INC	H	;4
	LD	B,(HL)	;7
	EXX		;4 /41 //66
	;-----
	LD	E,(HL)	;7
	LD	A,(DE)	;7
	LD	(HL),A	;7
	INC	L	;4 /25
	;-
	EXX		;4
	LD	L,A	;4
	LD	C,(HL)	;7
	PUSH	BC	;11
	DEC	H	;4
	LD	A,(HL)	;7
	LD	(DE),A	;7
	DEC	E	;4
	EXX		;4 /52 //77 /=>143
	;--------
	EDUP
	;-------- 		/143*3=429
	LD	E,(HL)	;7
	LD	A,(DE)	;7
	LD	(HL),A	;7
	INC	L	;4 /25
	;-
	EXX		;4
	LD	L,A	;4
	LD	A,(HL)	;7
	LD	(DE),A	;7
	DEC	E	;4
	INC	H	;4
	LD	B,(HL)	;7
	EXX		;4 /41 //66
	;-----
	LD	E,(HL)	;7
	LD	A,(DE)	;7
	LD	(HL),A	;7 /21
	;-
	EXX		;4
	LD	L,A	;4
	LD	C,(HL)	;7
	PUSH	BC	;11
	DEC	H	;4
	LD	A,(HL)	;7
	LD	(DE),A	;7
	DEC	DE	;6
	EXX		;4 /54 //75 /=>141
	;- wait
	IF MACHINE_TYPE = MT_PENTAGON
	  LD	A,17
	  DEC	A
	  JP	NZ,$-1
	  RET	NZ
	  NOP
	ELSE
	  LD	A,18
	  DEC	A
	  JP	NZ,$-1
	  RET	NZ
	  NOP
	  NOP
	ENDIF
	
	;-- next line
	LD	BC,33	;10
	ADD	HL,BC	;15
	LD	BC,P7FFD ;10
	;--- swap scr
	EX	AF,AF	;4
	XOR	XOR8	;7
	OUT	(C),A	;12 /23
	;--
	DEC	LX	;8
	JP	NZ,OUTLP ;10 /18
	;---
	LD	(OUT_BUFF),HL
	EXX
	LD	(OUT_BUFFA),DE
	LD	HL,0 - BUFFSZ + 1
	ADD	HL,DE
	LD	(OUT_BUFFB),HL
	;---
	LD	SP,0
SOHRSP_DEC EQU $-2
	RET
;------------------------------
ADDSTARS
	LD	A,10
	DEC	A
	JP	NZ,$-1
	;--
	LD	BC,#7FFD	;10
	LD	DE,#1018	;10
	OUT	(C),D
	
	EXX			;4
	LD	D,TBL_ADD_HI / 256 ;7
	LD	H,TBL_ADD / 256	;7
	;--
	LD	(SOHRSP2),SP
	LD	SP,ADDSTARS_TBL
	;-
	RET
ADDSTARS_RET
	LD	SP,0
SOHRSP2	EQU $-2
	RET
;-------------------------
ADDSTARS_TBL
	DUP	STAR_QTY
	DW	0
	DW	0
	EDUP
	DW	ADDSTARS_RET
;------------------------
MOVESTARS
	LD	HL,POINTS
	LD	(SOHRSP3),SP
	LD	SP,ADDSTARS_TBL + STAR_QTY * 4
	LD	LX,STAR_QTY
POI2	LD	A,(HL)
	ADD	A,STEP_Z
	CP	Z_MAX
	JP	C,POI1
	;-- get next rand star
	SUB	Z_MAX
	LD	B,A
	LD	DE,STARS_LIST
STARS_LIST_ADR EQU $-2
	LD	A,STARS_LIST_QTY_MAX
STARS_LIST_IDX EQU $-1
	DEC	A
	JP	NZ,POI3
	LD	DE,STARS_LIST
	LD	A,STARS_LIST_QTY_MAX
POI3	LD	(STARS_LIST_IDX),A
	;-
	PUSH	HL
	EX	DE,HL
	INC DE:LDI:LDI:LDI:LDI
	LD	(STARS_LIST_ADR),HL
	POP	HL
	LD	A,B
POI1	;-
	LD	(HL),A
	INC	HL
	LD	B,A	;4 B = z 0..31
	EX	AF,AF	;4
	;-
	LD	A,(HL)	;7
	ADD	A,B	;4
	LD	E,A	;4
	INC	L	;4
	LD	D,(HL)	;7
	INC	L	;4 de = tbl proj x adr
	;---
	LD	A,(DE)	;7
	LD	HX,LOW STARS_SPR_TBL
	BIT 	0,A
	JR	Z,POI4
	LD	HX,LOW STARS_SPR_TBLX
POI4	;--
	RRA
	LD	C,A	;4
	;---
	LD	A,(HL)	;7
	ADD	A,B	;4
	ADD	A,B	;4
	LD	E,A	;4
	INC	L	;4
	LD	D,(HL)	;7
	INC	L	;4 de = tbl proj y adr
	;---
	LD	A,(DE)	;7
	INC	DE	;4
	OR	C	;4
	LD	C,A	;4
	LD	A,(DE)	;7
	LD	B,A	;4 bc = buff adr
	;---
	PUSH	BC
	EX	AF,AF
	LD	D,HIGH STARS_SPR_TBL
	RRA
	AND	%00000110
	ADD	A,HX
	LD	E,A
	LD	A,(DE)
	LD	C,A
	INC	E
	LD	A,(DE)
	LD	B,A
	PUSH	BC
	;--
	DEC	LX
	JP	NZ,POI2
	;--
	LD	SP,0
SOHRSP3	EQU $-2
	RET
//======================================================== FX_INCLUDE_DATA

	INCLUDE "bin/attr_fill.asm"
//======================================================== FX_TABLES
	ALIGN	256
PALETTE
	INCBIN "bin/starfield_palette.bin"
;----------------------
TBL_SUB
	INCBIN "bin/tbl_sub.bin"
;----------------------
TBL_ADD
	DB 0,1,2,3, 4,5,6,7, 8,9,10,11, 12,13,14,15
	DS 256-16, 15
;----------------------
TBL_ADD_HI
	INCBIN "bin/tbl_add_hi.bin"
;----------------------
TBL_MUL16
	DB	#00,#10,#20,#30
	DB	#40,#50,#60,#70
	DB	#80,#90,#A0,#B0
	DB	#C0,#D0,#E0,#F0
;----------------------
POINTS	INCLUDE "bin/tbl_stars.asm"
POINTS_END
;----------------------
STARS_SPR_TBL
	DW	ADDSTAR0
	DW	ADDSTAR1
	DW	ADDSTAR2
	DW	ADDSTAR3
	
STARS_SPR_TBLX
	DW	ADDSTAR0X
	DW	ADDSTAR1X
	DW	ADDSTAR2X
	DW	ADDSTAR3X

;----------------------
;----------------------
	ALIGN 256
TBL_PROJ_Y	INCLUDE "bin/tbl_proj_y.asm"
TBL_PROJ_X	INCLUDE "bin/tbl_proj_x.asm"
TBL_PROJ_X_END
;----------------------
	ALIGN 256
BUFF	EQU	$ + 64*8

	DISPLAY "-------------------------------- FX VARS:"
	DISPLAY "MOVE_ADR ", /A, MOVE_ADR
	DISPLAY "MOVE_ADR_BOTT ", /A, MOVE_ADR_BOTT
	
	DISPLAY "MOVE_ADR SIZE", /A, 32*BUFF_Y*4
	DISPLAY "MOVE_ADR_END ", /A, MOVE_ADR + 32*BUFF_Y*4

	DISPLAY "BUFF1A: ", /A, BUFF1A
	DISPLAY "BUFF1B: ", /A, BUFF1B
	DISPLAY "BUFF2A: ", /A, BUFF2A
	DISPLAY "BUFF2B: ", /A, BUFF2B

	DISPLAY "TBL_PROJ_Y SIZE: ", /A, TBL_PROJ_X - TBL_PROJ_Y
	DISPLAY "STARS_SPR_TBL: ", /A, $

	DISPLAY "ADDSTAR SIZE: ", /A, ADDSTAR0 - ADDSTAR1

	DISPLAY "POINTS SIZE: ", /A, POINTS_END - POINTS
	DISPLAY "STARS_LIST SIZE: ", /A, STARS_LIST_END - STARS_LIST


