//======================================================== FX_HEADER
EFF_INI		JP	EFF_INI_
EFF_RUN		JP	EFF_RUN_
//======================================================== FX_CONST
BUFF_Y		EQU	48
;---
BUFFSZ		EQU	32 * BUFF_Y	;1280
BUFF2B		EQU	#BE00 - BUFFSZ
BUFF2A		EQU	BUFF2B - BUFFSZ
BUFF1B		EQU	BUFF2A - BUFFSZ
BUFF1A		EQU	BUFF1B - BUFFSZ
;---
MOVET_ADR	EQU	#DB00
MOVET_ATTR	EQU	#5800
MOVET_SZ	EQU	4*16*BUFF_Y+2
MOV_TOP_SZ	EQU	36
MOV_BOTT_SZ	EQU	BUFF_Y - MOV_TOP_SZ

MPG	EQU	#10+#08
P08	EQU	#08
P7F	EQU	#7F
PFD	EQU	#FD

MTBSTP1	EQU	128;128*6
MTBSTP2 EQU	128;-128*4

MDXSTEP	EQU	1
MDYSTEP EQU	-2


MAPG1	EQU	#10
MAPG2	EQU	#18
MAP7FFD	EQU	#7FFD

//======================================================== FX_INIT
EFF_INI_
	EI
	HALT
	
	LD	A,#17
	CALL	PAGER
	
	LD	HL,#4000
	LD	DE,#4001
	LD	(HL),#F0
	LD	BC,6143
	LDIR

	LD	HL,#4000
	LD	DE,#C000
	LD	BC,6912
	LDIR
;-----------
	CALL	INIMOVE
;-----------
	CALL	SWAPBUFF
	JP	SWP
;-----------
INIMOVE
	LD	HL,MOVET_ADR
	LD	DE,MOVET_ATTR
	LD	LX,MOV_BOTT_SZ
	CALL	INIMV0
	LD	LX,MOV_TOP_SZ
INIMV0	;---
	LD	BC,0-32
INIMV2	;---
	LD	A,16
INIMV1	;---
	LD	(HL),#E1	; pop hl
	INC	HL
	LD	(HL),#22	; ld (adr),hl
	INC	HL
	LD	(HL),E
	INC	HL
	LD	(HL),D
	INC	HL
	INC	E
	INC	DE
	DEC	A
	JP	NZ,INIMV1
	;---
	;#40 = 0100.0000
	;#c0 = 1100.0000
	LD	A,D
	XOR	#80
	LD	D,A
	AND	#80
	JP	Z,INIMV3
	;---
	EX	DE,HL
	ADD	HL,BC
	EX	DE,HL
INIMV3	;---
	DEC	LX
	JP	NZ,INIMV2
	;---
	LD	(HL),#EB	; ex de,hl
	INC	HL
	LD	(HL),#E9	; jp (hl)
	INC	HL
	;---
	RET
//======================================================== FX_MAINLOOP
EFF_RUN_

;378+378+378=1134
;1536-1134=402

	EI
	HALT

	CALL	MOVE_TOP
	LD	LX,6
	CALL	MAPPING
	CALL	SWP
	CALL	MOVE_BOTTOM

	EI
	HALT
	CALL	MOVE_TOP
	LD	LX,6
	CALL	MAPPING
	CALL	SWP
	CALL	MOVE_BOTTOM

	EI
	HALT
	CALL	MOVE_TOP
	LD	LX,6
	CALL	MAPPING
	CALL	SWP
	CALL	MOVE_BOTTOM
	
	EI
	HALT
	CALL	MOVE_TOP
	LD	LX,6
	CALL	MAPPING
	CALL	SYNC
	CALL	SWAPBUFF
	CALL	SWP
	CALL	MOVE_BOTTOM
	RET
//======================================================== FX_PROCEDURES
SWP	LD	A,0
SWP0	EQU	$-1
	XOR	#FF
	LD	(SWP0),A
	LD	HL,0
SWP_BUFFA EQU $-2
	LD	DE,0
SWP_BUFFA_BOTT EQU $-2
	JP	Z,SWP1
	LD	HL,0
SWP_BUFFB EQU $-2
	LD	DE,0
SWP_BUFFB_BOTT EQU $-2
SWP1	LD	(MOVE_TOP_SP),HL
	LD	(MOVE_BOTTOM_SP),DE
	RET
;--------------------------
SWAPBUFF
	LD	A,(MDX)
MDXA	ADD	A,MDXSTEP
	AND	63
	LD	(MDX),A
	;---------------
	LD	A,(MDY)
MDYA	ADD	A,MDYSTEP
	AND	31
	LD	(MDY),A
	;---------------
	LD	HL,MAPLNTBL
	LD	(MAP_MAPTBL),HL
	LD	A,0
SWAPBUFFA EQU $-1
	XOR	#FF
	LD	(SWAPBUFFA),A
	JR	Z,SWAPBUFF1
	;---
	LD	HL,BUFF2A + BUFFSZ - 1
	LD	(MAP_BUFFA),HL
	LD	HL,BUFF2B + BUFFSZ - 1
	LD	(MAP_BUFFB),HL
	;-
	LD	HL,BUFF1A + 32*(BUFF_Y - 38)
	LD	(SWP_BUFFA),HL
	LD	HL,BUFF1B + 32*(BUFF_Y - 38)
	LD	(SWP_BUFFB),HL
	LD	HL,BUFF1A
	LD	(SWP_BUFFA_BOTT),HL
	LD	HL,BUFF1B
	LD	(SWP_BUFFB_BOTT),HL
	RET
SWAPBUFF1 ;---
	LD	HL,BUFF1A + BUFFSZ - 1
	LD	(MAP_BUFFA),HL
	LD	HL,BUFF1B + BUFFSZ - 1
	LD	(MAP_BUFFB),HL
	;-
	LD	HL,BUFF2A + 32*(BUFF_Y - 38)
	LD	(SWP_BUFFA),HL
	LD	HL,BUFF2B + 32*(BUFF_Y - 38)
	LD	(SWP_BUFFB),HL
	LD	HL,BUFF2A
	LD	(SWP_BUFFA_BOTT),HL
	LD	HL,BUFF2B
	LD	(SWP_BUFFB_BOTT),HL
	RET
;--------------------------
MOVE_TOP
	LD	A,0
BORDER	EQU	$-1
	OUT	(#FE),A
	;---
	LD	BC,#7FFD
	LD	A,#17
	OUT	(C),A
	;---
	LD	(SOHRSP1),SP
	LD	SP,0
MOVE_TOP_SP	EQU $-2
	LD	DE,MOVE_TOP1
	JP	MOVET_ADR + MOV_BOTT_SZ * 16*4  + 2
	DISPLAY	"MVTOP ", /A, MOVET_ADR + (BUFF_Y - 38) * 16 * 4 + 2
MOVE_TOP1
	LD	SP,0
SOHRSP1	EQU	$-2
	RET
;--------------------------
MOVE_BOTTOM
	LD	BC,#7FFD
	LD	A,#17+#08
	OUT	(C),A
	;---
	LD	(SOHRSP2),SP
	LD	SP,0
MOVE_BOTTOM_SP	EQU $-2
	LD	DE,MOVE_BOTTOM1
	JP	MOVET_ADR
MOVE_BOTTOM1
	LD	SP,0
SOHRSP2	EQU	$-2
	LD	A,3:OUT (#FE),A

	RET
;----------------------------------------
MAPPING	
	LD	A,13
	DEC	A
	JP	NZ,$-1
	;---
	LD	DE,BUFF1A + BUFFSZ - 1
MAP_BUFFA EQU $-2
	LD	BC,BUFF1B + BUFFSZ - 1
MAP_BUFFB EQU $-2
	LD	H,PALETTE / 256
PALADR	EQU $-1
	EXX
	;-----
	LD	(SOHRSP_MAP),SP
	LD	BC,MAP7FFD
	LD	A,MAPG2
	OUT	(C),A
	LD	IY,MAPLNTBL
MAP_MAPTBL EQU $-2
	LD	SP,IY
	POP	HL
	LD	SP,HL
	LD	LX,12
	LD	DE,0	;mapping scroll, rotate
MDX	EQU	$-2
MDY	EQU	$-1
MAPLP	;------------------
	DUP	8
	;---
	POP	HL	;10
	ADD	HL,DE	;11
	LD	A,(HL)	;7
	POP	HL	;10
	ADD	HL,DE	;11
	OR	(HL)	;7 /56
	;-
	EXX		;4
	LD	L,A	;4
	LD	A,(HL)	;7
	LD	(BC),A	;7
	INC	H	;4
	LDD		;16
	DEC	H	;4
	EXX		;4 /50 /=> 106*8=848
	;---
	EDUP
	;---w14
	NOP:NOP:DEC HL
	;---
	LD	A,MAPG1	;7
	OUT	(C),A	;12 /19 //867 =>29free
	;------------------
	DUP	8
	;---
	POP	HL	;10
	ADD	HL,DE	;11
	LD	A,(HL)	;7
	POP	HL	;10
	ADD	HL,DE	;11
	OR	(HL)	;7 /56
	;-
	EXX		;4
	LD	L,A	;4
	LD	A,(HL)	;7
	LD	(BC),A	;7
	INC	H	;4
	LDD		;16
	DEC	H	;4
	EXX		;4 /50 /=> 106*8=848
	;---
	EDUP
	;---
	INC IY:INC IY
	LD A,R	;w9
	;---
	LD	A,MAPG2	;7
	OUT	(C),A	;12 /19 //867 =>29free
	;------------------
	DUP	8
	;---
	POP	HL	;10
	ADD	HL,DE	;11
	LD	A,(HL)	;7
	POP	HL	;10
	ADD	HL,DE	;11
	OR	(HL)	;7 /56
	;-
	EXX		;4
	LD	L,A	;4
	LD	A,(HL)	;7
	LD	(BC),A	;7
	INC	H	;4
	LDD		;16
	DEC	H	;4
	EXX		;4 /50 /=> 106*8=848
	;---
	EDUP
	;---w29
	ADD HL,HL:ADD HL,HL:LD A,0
	;---
	LD	A,MAPG1	;7
	OUT	(C),A	;12 /19 //867 =>29free
	;------------------
	DUP	8
	;---
	POP	HL	;10
	ADD	HL,DE	;11
	LD	A,(HL)	;7
	POP	HL	;10
	ADD	HL,DE	;11
	OR	(HL)	;7 /56
	;-
	EXX		;4
	LD	L,A	;4
	LD	A,(HL)	;7
	LD	(BC),A	;7
	INC	H	;4
	LDD		;16
	DEC	H	;4
	EXX		;4 /50 /=> 106*8=848
	;---
	EDUP
	;---
	LD	A,MAPG2	;7
	OUT	(C),A	;12 /19
	;---
		LD	SP,IY	;10
		POP	HL	;10
		LD	SP,HL	;6 /26t -15
	;---
	DEC	LX	;8
	JP	NZ,MAPLP ;10 /18 //881 11ree
	;--------------------
	EXX
	LD	(MAP_BUFFA),DE
	LD	(MAP_BUFFB),BC
	LD	(MAP_MAPTBL),IY
	;--------------------
	LD	SP,0
SOHRSP_MAP	EQU	$-2
	LD	A,2: OUT (#FE),A
	RET
//======================================================== FX_INCLUDE_DATA
SYNC
	RET



	
//======================================================== FX_TABLES
	DUP	64*4
	DW	#C000
	EDUP
MAPTBL	INCLUDE "bin/map_intor.asm"
MAPTBL_END
	DUP	64*4
	DW	#C000
	EDUP
;------------------------------------         48*2 = 96
MAPLNTBL
TMP1=MAPTBL
	DUP	48
	DW	TMP1
TMP1=TMP1+128
	EDUP
;------------------------------------ 
	ALIGN	256
PALETTE	INCBIN "bin/palette_intor.bin"

	DISPLAY "MOVE_ADR: ", /A, MOVET_ADR
	DISPLAY "MOVE_SZ: ", /A, MOVET_SZ
	DISPLAY "MOVE_END: ", /A, MOVET_ADR + MOVET_SZ
	DISPLAY "MAPTBL: ", /A, MAPTBL
	DISPLAY "MAPTBL_SZ: ", /A, MAPTBL_END - MAPTBL
	DISPLAY "MAPTBL_END: ", /A, MAPTBL_END

	DISPLAY "-"
	DISPLAY	"BUFF1A ", /A, BUFF1A
	DISPLAY	"BUFF1B ", /A, BUFF1B
	DISPLAY	"BUFF2A ", /A, BUFF2A
	DISPLAY	"BUFF2B ", /A, BUFF2B
