<?
$images = array();
for ($y = 0; $y < 8; $y++) {
    for ($x = 0; $x < 8; $x++) {
        $img = imagecreatefrompng('png-zx/squad-' . $x . $y . '.mgs.png');
        ob_start();
        imagepng($img);
        $imgData = ob_get_clean();
        $images[$y][$x] = 'data:image/gif;base64,' . base64_encode($imgData);
    }
}
?>



<!DOCTYPE html>
<html>
    <head>
        <script>
            var canvas;
            var ctx;
            var framesRender = 2;
            var jsInterval = 20 * framesRender;

            var loadedQty = 0;
            var texture = [];
            <? for ($y = 0; $y < 8; $y++) {?>
                texture[<?= $y ?>] = [];
                <?for ($x = 0; $x < 8; $x++) {?>
                    texture[<?= $y ?>][<?= $x ?>] = new Image();
                    texture[<?= $y ?>][<?= $x ?>].src = '<?= $images[$y][$x] ?>';
                    texture[<?= $y ?>][<?= $x ?>].onload = function() {
                        loadedQty++;
                        if (loadedQty == 64) {
                            setTimeout(function() {
                                canvas = document.getElementById('canvas');
                                ctx = canvas.getContext('2d');
                                setInterval(function(){
                                    renderFrame();
                                }, jsInterval)
                            }, 500);
                        }
                    }
                <?}
            }?>

            var ax = 0;
            var ay = 0;
            var axStep = 0.03;
            var ayStep = 0.04;
            var axMax = 32;
            var ayMax = 24;
            var tx = 0;
            var ty = 0;

            var fn = 0;
            var fnMax = 7;            
            var timer = 0;
            var timerMax = 4096;

            var process = [];
            process[0] = function() {
                tx += 0.02;
                ty = 0;
                return [tx,ty];
            }
            process[1] = function() {
                tx -= 0.02;
                ty = 0;
                return [tx,ty];
            }
            process[2] = function() {
                tx = 0;
                ty += 0.02;
                return [tx,ty];
            }
            process[3] = function() {
                tx = 0;
                ty -= 0.02;
                return [tx,ty];
            }
            process[4] = function() {
                ax += axStep;
                if (ax >= 256) { ax -= 256; }
                ay += ayStep;
                if (ay >= 256) { ay -= 256; }
                tx = Math.abs( axMax + Math.round(axMax * Math.cos(Math.PI * ax / 128)) );
                ty = Math.abs( ayMax + Math.round(ayMax * Math.sin(Math.PI * ay / 128)) );
                return [tx,ty];
            }
            process[5] = process[4];
            process[6] = process[4];
            process[7] = process[4];
            
            
            function renderFrame() {
                timer++;
                if (timer > timerMax) {
                    timer = 0;
                    fn++;
                    if (fn == 4) {
                        ax = 0; ay = 0;
                    }
                    if (fn > fnMax) {
                        fn = 0;
                    }
                    
                }
                
                
                var coord = process[fn]();
                var ttx = coord[0] & 7;
                var tty = coord[1] & 7;
                var img = texture[tty][ttx];
                ctx.drawImage(
                    img,
                    0, 0, 256, 192,
                    0, 0, 256, 192
                );
            }
        </script>
    </head>
    <body style="background-color:#000;">
        <canvas style="position:absolute;top:50%;left:50%;margin-left:-128px;margin-top:-96px;background-color:black;" id="canvas" width="256px" height="192px"></canvas>
    </body>
</html>