<?php

$eol = "\r\n";

$canvasSizeX = 32;
$canvasSizeY = 48;

/* make calc tables in zx page */
$zxPage = array();
for ($y = 0; $y < 64; $y++) {
	$zxPage[$y] = array();
	for ($x = 0; $x < 256; $x++) {
		$zxPage[$y][$x] = 0;
	}
}

$tY = 64 * 0.25;
$tX = 64 * 1.25;

$minU = 9999999999;
$maxU = 0;
$minV = 9999999999;
$maxV = 0;

$addU = 48+15;
$addV = -87-29;
$mult = 4;

for ($y = 0; $y < $canvasSizeY * 2; $y++) {
	$yy = $y - $canvasSizeY;
	for ($x = 0; $x < $canvasSizeX * 2; $x++) {
		$xx = $x - $canvasSizeX;
		//--- texture Y
		$calcU = $addU + round($mult * ($tY * atan2($yy, $xx) / pi()));
		$minU = min($minU, $calcU);
		$maxU = max($maxU, $calcU);
		
		//--- texture X
		$sqrt = sqrt(pow($xx, 2) + pow($yy, 2));
		if ($sqrt == 0) {
			$sqrt = 1;
		}
		$calcV = $addV + round($mult * $tX / pow($sqrt, 0.25));
		$minV = min($minV, $calcV);
		$maxV = max($maxV, $calcV);
		
		$zxPage[$x][$y+96] = $calcV;
		$zxPage[$x][$y] = $calcU;
	}
}
echo 'V: ' . $minV . ' - ' . $maxV . $eol;
echo 'U: ' . $minU . ' - ' . $maxU . $eol;



$f = fopen(__DIR__ . '/duo_tunnel_tbl.bin', 'wb');
for ($y = 0; $y < 64; $y++) {
	for ($x = 0; $x < 256; $x++) {
		fwrite($f, chr($zxPage[$y][$x]));
	}
}
fclose($f);

//-----------------------
/* make texture in zx page */
$img = imagecreatefrompng(__DIR__ . '/texture2.png');

$zxColorList = array(
	0x000000 => 0x00,
	0x0000CB => 0x01 + 1*8,
	0x0000FF => 0x41 + 1*8,
	0xCB0000 => 0x02 + 2*8,
	0xFF0000 => 0x42 + 2*8,
	0xCB00CB => 0x03 + 3*8,
	0xFF00FF => 0x43 + 3*8,
	0x00CB00 => 0x04 + 4*8,
	0x00FF00 => 0x44 + 4*8,
	0x00CBCB => 0x05 + 5*8,
	0x00FFFF => 0x45 + 5*8,
	0xCBCB00 => 0x06 + 6*8,
	0xFFFF00 => 0x46 + 6*8,
	0xCBCBCB => 0x07 + 7*8,
	0xFFFFFF => 0x47 + 7*8,
);

$zxPage2 = array();
for ($y = 0; $y < 32; $y++) {
	$zxPage2[$y] = array();
	for ($x = 0; $x < 256; $x++) {
		$zxPage2[$y][$x] = 0;
	}
}
for ($y = 0; $y < 32; $y++) {
	for ($x = 0; $x < 256; $x++) {
		$color = imagecolorat($img, $x, $y);
		
		if (!isset($zxColorList[$color])) {
			die($x . ',' . $y . ' = ' . dechex($color));
		}
		$zxColor = $zxColorList[$color];
		
		$zxPage2[$y][$x] = $zxColor;
	}
}

$f = fopen(__DIR__ . '/duo_tunnel_texture.bin', 'wb');
for ($y = 0; $y < 32; $y++) {
	for ($x = 0; $x < 256; $x++) {
		fwrite($f, chr($zxPage2[$y][$x]));
	}
}
fclose($f);

//-----------------------


echo 'cos table' . $eol;
$rX = 12;
$rY = 20;
$fx = fopen(__DIR__ . '/duo_tunnel_cos_x.bin', 'wb');
$fy = fopen(__DIR__ . '/duo_tunnel_sin_y.bin', 'wb');
for ($i = 0; $i < 256; $i++) {
	$x = floor($canvasSizeX/2 + $rX * cos($i * pi() / 128));
	fwrite($fx, chr($x));
	$y = floor($canvasSizeY/2 + $rY * sin($i * pi() / 128));
	fwrite($fy, chr($y));
}

		
fclose($fy);
fclose($fx);