//======================================================== FX_HEADER
EFF_INI		JP	EFF_INI_
EFF_RUN		JP	EFF_RUN_
//======================================================== FX_CONST
SIZE_Y		EQU	48
CIRC_QTY	EQU	10
OUTCIRC_BC	EQU	64-12

TBL_NOISE	EQU	#7D00
TBL_BUFF	EQU	#7E00
TBL_ATTR	EQU	#7F00
//======================================================== FX_INIT
EFF_INI_
	EI
	HALT

	LD	A,#17
	CALL	PAGER
	
	LD	HL,#4000
	LD	DE,#4001
	LD	BC,6144
	LD	(HL),#F0
	LDIR
	LD	(HL),4*8+5
	LD	BC,767
	LDIR

	LD	HL,#4000
	LD	DE,#C000
	LD	BC,6912
	LDIR

;---------------------------- make tbl attr
INI_ATTR	
	LD	DE,#5800
	LD	BC,32
	LD	HL,TBL_ATTR
	LD	A,24
INI_ATTR_1
	LD	(HL),E
	INC	L
	LD	(HL),D
	INC	L
	SET	7,D
	LD	(HL),E
	INC	L
	LD	(HL),D
	INC	L
	RES	7,D
	EX	DE,HL
	ADD	HL,BC
	EX	DE,HL
	DEC	A
	JP	NZ,INI_ATTR_1
;---------------------------- make tbl buff
	LD	DE,BUFF + 16
	LD	BC,64
	LD	HL,TBL_BUFF
	LD	A,48
INI_BUFF_1
	LD	(HL),E
	INC	L
	LD	(HL),D
	INC	L
	EX	DE,HL
	ADD	HL,BC
	EX	DE,HL
	DEC	A
	JP	NZ,INI_BUFF_1
;---------------------------- make tbl noise	
	LD	HL,TBL_NOISE
INI_NOISE_1
	CALL	GET_RANDOM
	LD	C,0
	CP	48
	JP	NC,INI_NOISE_2
	LD	C,#01
INI_NOISE_2
	CALL	GET_RANDOM
	CP	200
	LD	A,#00
	JP	C,INI_NOISE_3
	LD	A,#10
INI_NOISE_3
	OR	C
	LD	(HL),A

	INC	L
	JP	NZ,INI_NOISE_1

	RET
	
//======================================================== FX_MAINLOOP
EFF_RUN_

	EI
	HALT
	CALL	NOISE
	LD A,1: OUT (#FE),A
	CALL	ROTATE
	LD A,0: OUT (#FE),A

	EI
	HALT
	LD	HL,CIRC_TBL
	CALL	OUTCIRC

	EI
	HALT
	LD	HL,CIRC_TBL + 5*4
	CALL	OUTCIRC

	EI
	HALT
	CALL	OUTBUFF

	RET
//======================================================== FX_PROCEDURES
GET_RANDOM
	LD  A,137
SEED	EQU	$-1
	LD	B,A
	ADD	A,A
	XOR	B
	LD	B,A
	SRL	A
	XOR	B
	LD	B,A
	ADD	A,A
	ADD	A,A
	XOR	B
	LD	(SEED),A
	RET
;---------------------------
NOISE_ADD EQU 34
NOISE_ADD2 EQU 63
NOISE
	LD	BC,74*6+4
W2	DEC	BC
	LD	A,B
	OR	C
	JP	NZ,W2 ;24
	
	LD	A,#17
	CALL	PAGER
	
	;-------------------------
	LD	(NOISE_SOHR_SP),SP
	;--
	CALL	GET_RANDOM
	AND	#1F
	LD	H,A
	CALL	GET_RANDOM
	LD	L,A
	LD	SP,HL
	;--
	LD	D,TBL_NOISE / 256
	;------------------------- fill right char
	LD	HL,BUFF + 16 + 31
	LD	LX,48
NOISE2	;---
	POP	BC	;10
	LD	E,C	;4
	LD	A,(DE)	;7
	LD	(HL),A	;7
	INC	L	;4
	LD	E,B	;4
	LD	A,(DE)	;7
	LD	(HL),A	;7 /50
	LD	BC,NOISE_ADD2
	ADD	HL,BC
	DEC	LX
	JP	NZ,NOISE2
	;-------------------------
	LD	HL,BUFF + 16
	EXX
	LD	BC,#7FFD
	LD	DE,#1F17
	LD	L,24
NOISE1	EXX			; /=>869
	;----
	DUP	15
	;----
	POP	BC	;10
	LD	E,C	;4
	LD	A,(DE)	;7
	LD	(HL),A	;7
	INC	L	;4
	LD	E,B	;4
	LD	A,(DE)	;7
	LD	(HL),A	;7
	INC	L	;4 /54 * 15 = 810
	;----
	EDUP
	;----
	POP	BC	;10
	LD	E,C	;4
	LD	A,(DE)	;7
	LD	(HL),A	;7 /28
	;----
	NOP
	
	LD	BC,NOISE_ADD	;10
	ADD	HL,BC	;15 /25 /=>835
	;----
	EXX		;4
	OUT	(C),E	;12
	EXX		;4 /20 /=>855
	;----------------
	DUP	15
	;----
	POP	BC	;10
	LD	E,C	;4
	LD	A,(DE)	;7
	LD	(HL),A	;7
	INC	L	;4
	LD	E,B	;4
	LD	A,(DE)	;7
	LD	(HL),A	;7
	INC	L	;4 /54 * 15 = 810
	;----
	EDUP
	;----
	POP	BC	;10
	LD	E,C	;4
	LD	A,(DE)	;7
	LD	(HL),A	;7 /28

	NOP:NOP:NOP:NOP
	;----
	LD	BC,NOISE_ADD	;10
	ADD	HL,BC	;15 /25 /=>835
	;----
	EXX		;4
	OUT	(C),D	;12 /16 /=>851
	;----
	DEC	L	  ;4
	JP	NZ,NOISE1 ;10 /14 /=>865
	;----
	LD	SP,0
NOISE_SOHR_SP EQU $-2
	RET

;-869 27free
;-855 41free



;------------------------------------------------
OUTCIRC_END
	LD	SP,0
OUTCIRC_SOHR_SP EQU $-2
	RET
OUTCIRC	;------------------------
	NOP
	;--
	LD	(OUTCIRC_SOHR_SP),SP
	LD	SP,HL
CIRC_TBL_ADR EQU $-2
	LD	BC,OUTCIRC_BC
	EXX
	LD	BC,#7FFD
	LD	A,#17
	OUT	(C),A
	EX	AF,AF
	
	LD	DE,#0806
	LD	HL,#0D0D
OUTCIRCNEXT
	DEC	E		;4
	JR	Z,OUTCIRC_END	;7
	LD	L,H	;4
	EXX		;4
	POP	HL	;10
	POP	DE	;10
	LD	LX,13	;11 /50 ////=> 896
OUTCIRCLP ;------------------------
	DUP	2
	;---
	DUP	6
	;---
	LD	A,(DE)	;7
	OR	(HL)	;7
	LD	(HL),A	;7
	INC	E	;4
	INC	L	;4 /29
	;-
	LD	A,(DE)	;7
	OR	(HL)	;7
	LD	(HL),A	;7
	INC	DE	;6
	INC	L	;4 /31 //60 /=> 360
	;---
	EDUP
	;---
	LD	A,(DE)	;7
	OR	(HL)	;7
	LD	(HL),A	;7
	INC	E	;4
	INC	DE	;6 /31
	;----
	ADD	HL,BC	;15 next line /=> 402
	;---
	EDUP
	;--- //=>804
	EXX		;4
	EX	AF,AF	;4
	XOR	D	;4
	OUT	(C),A	;12
	EX	AF,AF	;4 /28 /=>832
	;--
	DEC	L		;4
	JP	Z,OUTCIRCNEXT	;10 /14 /=>846
	;------------------------
	;w36
	LD A,R:LD A,R:LD A,R:LD A,R
	;--
	EXX			;4
	JP	OUTCIRCLP	;10 /14 /=>860





;----------------------------------------
OUTBUFF	
	LD	BC,74*2
W1	DEC	BC
	LD	A,B
	OR	C
	JP	NZ,W1 ;24

	LD	A,#17
	CALL	PAGER

	;-----------------------
	LD	(OUTBUFF_SOHR_SP),SP
	;----------------------- out right char column
	LD	HL,BUFF + 31 + 16
	LD	DE,#581F
	LD	LX,24
OUTBUFF4	
	LD	B,PAL / 256
	LD	A,(HL)
	LD	C,A
	LD	A,(BC)
	LD	(DE),A
	LD	BC,64
	ADD	HL,BC
	SET	7,D
	;-
	LD	B,PAL / 256
	LD	A,(HL)
	LD	C,A
	LD	A,(BC)
	LD	(DE),A
	LD	BC,64
	ADD	HL,BC
	RES	7,D
	EX	HL,DE
	LD	BC,32
	ADD	HL,BC
	EX	HL,DE
	DEC	LX
	JP	NZ,OUTBUFF4
	;----------------------- make ATTR ADR
	LD	HL,BUFF + 32 + 16
	LD	DE,TBL_ATTR + 2
	LD	BC,63
	LD	LX,SIZE_Y
OUTBUFF2 ;---
	LD	A,(DE)
	LD	(HL),A
	INC	E
	INC	L
	LD	A,(DE)
	LD	(HL),A
	INC	E
	ADD	HL,BC
	DEC	LX
	JP	NZ,OUTBUFF2
	;----------------------- make BUFF ADR
	LD	HL,BUFF + 34 + 16
	LD	DE,TBL_BUFF + 2
	LD	BC,63
	LD	LX,SIZE_Y
OUTBUFF3 ;---
	LD	A,(DE)
	LD	(HL),A
	INC	E
	INC	L
	LD	A,(DE)
	LD	(HL),A
	INC	E
	ADD	HL,BC
	DEC	LX
	JP	NZ,OUTBUFF3
OUTBUFF_MAIN	;-----------------------
	LD	BC,#7FFD	;7FFD
	LD	DE,#171F	;171F
	EXX
	LD	SP,BUFF + 16
	LD	DE,#5800
	LD	B,PAL / 256
	LD	LX,24
OUTBUFF1 ;-----
	DUP	15
	;-----
	POP	HL	;10
	LD	C,L	;4
	LD	A,(BC)	;7
	LD	(DE),A	;7
	INC	E	;4
	LD	C,H	;4
	LD	A,(BC)	;7
	LD	(DE),A	;7
	INC	E	;4 /54 * 15 = 810
	;-----
	EDUP
	;-----
	POP	HL	;10
	LD	C,L	;4
	LD	A,(BC)	;7
	LD	(DE),A	;7 /28 /=>838
XXX	;-
	POP	DE	;10
	POP	HL	;10
	LD	SP,HL	;6 /26 /=> 864
	;-
	EXX		;4
	OUT	(C),E	;12
	  DEC HL	;wait6
	EXX		;4 /20 /=>884 ;12free
	;---------------------
	DUP	15
	;-----
	POP	HL	;10
	LD	C,L	;4
	LD	A,(BC)	;7
	LD	(DE),A	;7
	INC	E	;4
	LD	C,H	;4
	LD	A,(BC)	;7
	LD	(DE),A	;7
	INC	E	;4 /54 * 15 = 810
	;-----
	EDUP
	;-----
	POP	HL	;10
	LD	C,L	;4
	LD	A,(BC)	;7
	LD	(DE),A	;7 /28 /=>838
	;-
	POP	DE	;10
	POP	HL	;10
	LD	SP,HL	;6 /26 /=> 864
	;-
	EXX		;4
	OUT	(C),D	;12
	EXX		;4 /20 /=>884 ;12free
	;-
	DEC	LX	    ;8
	JP	NZ,OUTBUFF1 ;10 /18
	;-----
	LD	SP,0
OUTBUFF_SOHR_SP EQU $-2
	RET
;--------------------------------------
; Начальные координаты точек хранятся в формате 
; X=X+COR_Z 
; Y=Y+COR_Z 
; Z=Z+COR_Z 
; (т.е. с прибавленным смещением до начала таблиц)
;---------------------------------------- 
; Диапазон изменения угла вращения 0..127 
; Поворот осуществляется вокруг осей Ox,Oy 
; по адресу Ay - угол вращения вокруг Oy 
; по адресу Ax - угол вращения вокруг Ox
;---------------------------------------- 
; Таблица произведений: 
;        #C000          +128	   +212	
;        +--------------+----------+----------+ 
;   Coord| Coord*cos(A) | projectY | projectX | Z
;        +--------------+----------+----------+ 
;        Alpha          
;---------------------------------------- 
; Формулы вращения 
;-Ox: 
; y` = y*cos(Ax) - z*sin(Ax) 
; z` = y*sin(Ax) + z*cos(Ax) 
;-Oy: 
; x` = x*cos(Ay) + z*sin(Ay) 
; z` = z*cos(Ay) - x*sin(Ay)

XYZMAX	EQU	21	; максимальная длина по осям (в одну сторону) 
COR_TBL	EQU	#C0
COR_Z	EQU	COR_TBL + XYZMAX 
PROJ_PY EQU	128	;#80
PROJ_PX EQU	212	;#D4

COS_AX	EQU	0
SIN_AX	EQU	COS_AX + 32
COS_AY	EQU	0
SIN_AY	EQU	COS_AY + 32


ANGLE_AY_STEP	EQU 4
ANGLE_AX_STEP	EQU 3

ROTATE	;------------------------
	LD	A,#18
	CALL	PAGER
	;-----------------------
	LD	A,0
ANGLE_AX EQU $-1
	ADD	A,ANGLE_AX_STEP
	AND	127
	LD	(ANGLE_AX),A
	LD	(CAX1 + 1),A
	LD	(CAX2 + 1),A
	ADD	A,32
	AND	127
	LD	(SAX1 + 1),A
	;-----------------------
	LD	A,0
ANGLE_AY EQU $-1
	ADD	A,ANGLE_AY_STEP
	AND	127
	LD	(ANGLE_AY),A
	LD	(CAY1 + 1),A
	ADD	A,32
	AND	127
	LD	(SAY1 + 1),A
	LD	(SAY2 + 1),A
	;-----------------------
	LD	(ROT_SOHR_SP),SP
	LD	SP,POINTS
	LD	IY,CIRC_TBL
	LD	LX,10
	
ROT1	;------
	POP	BC	;10	координаты C=z B=y
	;---------------------- Ox: y` = y*cos(Ax) - z*sin(Ax) 
CAX1	LD	L,COS_AX	;7
	LD	H,B		;4
	LD	A,(HL)		;7 a=(hl)=y*cos(Ax)
SAX1	LD	L,SIN_AX	;7
	LD	H,C		;4 (hl)=z*sin(Ax)
	SUB	(HL)		;7 a=y`
	;---
	ADD	A,XYZMAX
	ADD	A,A
	ADD	A,PROJ_PY	;A = таблица проекции Y
	EXX
	LD	L,A
	EXX
	;---------------------- Ox: z` = y*sin(Ax) + z*cos(Ax) 
	;LD	L,SIN_AX	;7
	LD	H,B		;4
	LD	A,(HL)		;7 a=(hl)=y*sin(Ax)
CAX2	LD	L,COS_AX	;7
	LD	H,C		;4 (hl)=z*sin(Ax)
	ADD	A,(HL)		;7 a=z`
	ADD	A,COR_Z
	;----------------------
	POP	BC
	DEC	SP
	LD	B,A		; координаты C=x B=z
	;---------------------- Oy: x` = x*cos(Ay) + z*sin(Ay)
SAY1	LD	L,SIN_AY	;7
	LD	H,B		;4
	LD	A,(HL)		;7 a=(hl)=z*sin(Ay)
CAY1	LD	L,COS_AY	;7
	LD	H,C		;4 (hl)=x*cos(Ay)
	ADD	A,(HL)		;7 a=x`
	;--
	ADD	A,XYZMAX + PROJ_PX ; a = projectX
	EX	AF,AF
	;---------------------- Oy: z` = z*cos(Ay) - x*sin(Ay)
	;LD	L,COS_AY	;7
	LD	H,B		;4
	LD	A,(HL)		;7 a=(hl)=z*cos(Ay)
SAY2	LD	L,SIN_AY	;7
	LD	H,C		;4 (hl)=x*sin(Ay)
	SUB	(HL)		;7 a=z`
	;--
	ADD	A,XYZMAX	;7
	LD	L,A		;4
	;----------------------- get buff adr
	EXX
	ADD	A,COR_TBL
	LD	H,A		;H = z
	LD	E,(HL)
	INC	L
	LD	D,(HL)		;DE = BUFF ADR by Py
	EX	AF,AF
	LD	L,A
	LD	L,(HL)		;L = Px
	LD	H,0
	ADD	HL,DE
	EX	DE,HL
	LD	(IY),E
	INC	IY
	LD	(IY),D
	INC	IY
	EXX
	;------------------------ get spr size
	LD	A,L
	ADD	A,A
	LD	L,A
	LD	H,0
	LD	BC,SIZETBL
	ADD	HL,BC
	LD	C,(HL)
	INC	HL
	LD	B,(HL)
	LD	(IY),C
	INC	IY
	LD	(IY),B
	INC	IY
	;---------------
	DEC	LX
	JP	NZ,ROT1
	;---
	LD	SP,0
ROT_SOHR_SP EQU $-2
	RET
SIZETBL
	DUP	4
	DW	SPR0
	EDUP
	DUP	4
	DW	SPR1
	EDUP
	DUP	4
	DW	SPR2
	EDUP
	DUP	4
	DW	SPR3
	EDUP
	DUP	4
	DW	SPR4
	EDUP
	DUP	4
	DW	SPR5
	EDUP
	DUP	4
	DW	SPR6
	EDUP
	DUP	4
	DW	SPR7
	EDUP
	DUP	4
	DW	SPR8
	EDUP
	DUP	4
	DW	SPR9
	EDUP
	DUP	8
	DW	SPR10
	EDUP


//======================================================== FX_INCLUDE_DATA
//======================================================== FX_TABLES
POINTS	;z y x
	
	DB	COR_Z + 11, COR_Z + 11, COR_Z + 11
	DB	COR_Z + 11, COR_Z - 11, COR_Z + 11
	DB	COR_Z - 11, COR_Z - 11, COR_Z + 11
	DB	COR_Z - 11, COR_Z + 11, COR_Z + 11
	DB	COR_Z + 11, COR_Z + 11, COR_Z - 11
	DB	COR_Z + 11, COR_Z - 11, COR_Z - 11
	DB	COR_Z - 11, COR_Z - 11, COR_Z - 11
	DB	COR_Z - 11, COR_Z + 11, COR_Z - 11
	DB	COR_Z + 0, COR_Z + 0, COR_Z + 0
	DB	COR_Z + 0, COR_Z + 0, COR_Z + 0

CIRC_TBL
	DW	BUFF - 7*64 + 16
	DW	SPR2
	DW	BUFF + 6 - 7*64 + 16
	DW	SPR2
	DW	BUFF + 12 - 7*64 + 16
	DW	SPR2
	DW	BUFF + 18 - 7*64 + 16
	DW	SPR2
	DW	BUFF + 5*64 + 16
	DW	SPR2
	DW	BUFF + 6 + 5*64 + 16
	DW	SPR2
	DW	BUFF + 12 + 5*64 + 16
	DW	SPR2
	DW	BUFF + 18 + 5*64 + 16
	DW	SPR2
	DW	BUFF + 17*64 + 16
	DW	SPR2
	DW	BUFF + 6 + 17*64 + 16
	DW	SPR2
;--------------------
	ALIGN	2
	INCLUDE	"bin/circle_sprites.asm"
;--------------------	
	ALIGN	256
PAL	INCBIN "bin/3d_black_circles_palette.bin"
;--------------------
	ALIGN	256
	
BUFF	EQU	$ + 64*12
;--------------------

	DISPLAY "BUFF: ", /A, BUFF
	DISPLAY "BUFF END: ", /A, BUFF + 64*48 + 64*12

	DISPLAY "ROTATE: ", /A, ROTATE
	DISPLAY "CIRC_TBL: ", /A, CIRC_TBL
	

	DISPLAY "OUTBUFF_MAIN: ", /A, OUTBUFF_MAIN
	DISPLAY "OUTBUFF: ", /A, OUTBUFF
	DISPLAY "XXX: ", /A, XXX