<?php
$eol = "\r\n";

// make 3d rotate tables
$angleSize = 128;
$maxXYZ = 21;
$minusXYZ = 21;
$minusAlpha = 21;

$zRast = -60;

$projCx = 32 + 16 + 3;
$projCy = 24 - 16 + 3;

$zxPage = array();
for ($z = 0; $z < $maxXYZ * 2 + 1; $z++) {
	$zxPage[$z] = array();
	for ($x = 0; $x < 256; $x++) {
		$zxPage[$z][$x] = 0;
	}
}


$angleHalf = $angleSize / 2;
for ($z = 0; $z < $maxXYZ * 2; $z++) {
	$zz = ($z - $minusAlpha) * 0.995;
	for ($i = 0; $i < $angleSize; $i++) {
		$zxPage[$z][$i] = round(4 * $zz * cos($i * pi() / $angleHalf));
	}
}

for ($i = 0; $i < 256; $i++) {
	$x = $i < 128 ? $i : $i - 256;
	$zxPage[$maxXYZ * 2][$i] = round($x / 4);
}


$pxMin = 9999999999;
$pxMax = 0;

for ($z = 0; $z < $maxXYZ * 2; $z++) {
	$zz = $z - $minusXYZ;
	for ($x = 0; $x < $maxXYZ * 2; $x++) {
		$xx = $x - $minusXYZ;
		$px = round($projCx + $zRast * $xx / ($zz + $zRast));
		$py = round($projCy + $zRast * $xx / ($zz + $zRast));

		$yyy = '(BUFF ' . ($py > 0 ? '+ ' : '- ') . abs($py * 64) . ')';

		$zxPage[$z][$angleSize + 2 * $x] = 'low ' . $yyy;
		$zxPage[$z][$angleSize + 2 * $x + 1] = 'high ' . $yyy;

		$pxMin = min($pxMin, $px);
		$pxMax = max($pxMax, $px);
		$zxPage[$z][$angleSize + $maxXYZ * 2 * 2 + $x] = $px;
	}
}

$code = '';
for ($z = 0; $z < $maxXYZ * 2 + 1; $z++) {
	$code .= ";------- #" . dechex($z+0xC0) . '00' . $eol;
	for ($x = 0; $x < 256; $x++) {
		$code .= "\tDB\t" . $zxPage[$z][$x] . "\t\t;#" . dechex($x) . $eol;
	}
}
file_put_contents(__DIR__ . "/3d_page.asm", $code);

echo 'projX: ' . ($angleSize + $maxXYZ * 2 * 2) . $eol;
echo 'pX: ' . $pxMin . ' .. ' . $pxMax . $eol;





echo 'ax step' . round(256 * 7/2.5) . $eol;
echo 'ay step' . round(256 * 3/2.5) . $eol;

