//======================================================== FX_HEADER
EFF_INI		JP	EFF_INI_
EFF_RUN		JP	EFF_RUN_
//======================================================== FX_CONST
//======================================================== FX_INIT
EFF_INI_
	LD	A,#17
	CALL	PAGER
	LD	HL,0
	LD	DE,#4000
	LD	BC,6144
	LDIR
	LD	HL,0
	LD	DE,#C000
	LD	BC,6144
	LDIR	
	

	JP	NEXT_FRAME
//======================================================== FX_MAINLOOP
EFF_RUN_

	IF SHOW_FRAMES=1
		LD	A,(FRAMES_QTY)
		PUSH	AF
		XOR	A
		LD	(FRAMES_QTY),A
	ENDIF

	EI
	HALT
	
	IF SHOW_FRAMES=1
		POP AF:OUT (#FE),A
	ENDIF
	

FXDO	LD	A,#17
FXPAGE	EQU	$-1
	XOR	#08 + #02
	LD	(FXPAGE),A
	AND	%11111000
	CALL	PAGER
	
	LD	HL,FRM00
FRM_ADR	EQU	$-2
	LD	DE,BUFF
	CALL	DEPACK_PL5_CODE
	
	LD	A,(FXPAGE)
	CALL	PAGER
	
	
	CALL	OUTPUT
OUTPUT_ADR	EQU	$-2

	IF SHOW_FRAMES=1
		XOR A:OUT (#FE),A
	ENDIF

NEXT_FRAME
	LD	A,0
FRAME	EQU	$-1
	INC	A
	AND	63
	LD	(FRAME),A


	LD	B,SQUAD_COS/256
	;---
	LD	HL,0
FDY	EQU	$-2
	LD	DE,#0200
	ADD	HL,DE
	LD	(FDY),HL
	;---
	LD	C,H
	LD	A,(BC)
	AND	7
	LD	LX,A
	;---
	LD	HL,0
FDX	EQU	$-2
	LD	DE,#0300
	ADD	HL,DE
	LD	(FDX),HL
	;---
	LD	C,H
	LD	A,(BC)
	AND	7
	ADD	A,A
	ADD	A,A
	ADD	A,A
	ADD	A,LX
	





	LD	L,A
	LD	H,0
	ADD	HL,HL
	ADD	HL,HL
	LD	DE,FRM_TBL
	ADD	HL,DE
	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	INC	HL
	LD	(FRM_ADR),DE
	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	INC	HL
	LD	(OUTPUT_ADR),DE	

	RET


FRM_TBL	DW	FRM00, OUTPUT
	DW	FRM01, OUTPUT
	DW	FRM02, OUTPUT
	DW	FRM03, OUTPUT
	DW	FRM04, OUTPUT
	DW	FRM03, OUTPUT_INV_V
	DW	FRM02, OUTPUT_INV_V
	DW	FRM01, OUTPUT_INV_V

	DW	FRM10, OUTPUT
	DW	FRM11, OUTPUT
	DW	FRM12, OUTPUT
	DW	FRM13, OUTPUT
	DW	FRM14, OUTPUT
	DW	FRM13, OUTPUT_INV_V
	DW	FRM12, OUTPUT_INV_V
	DW	FRM11, OUTPUT_INV_V

	DW	FRM20, OUTPUT
	DW	FRM21, OUTPUT
	DW	FRM22, OUTPUT
	DW	FRM23, OUTPUT
	DW	FRM24, OUTPUT
	DW	FRM23, OUTPUT_INV_V
	DW	FRM22, OUTPUT_INV_V
	DW	FRM21, OUTPUT_INV_V
	
	DW	FRM30, OUTPUT
	DW	FRM31, OUTPUT
	DW	FRM32, OUTPUT
	DW	FRM33, OUTPUT
	DW	FRM34, OUTPUT
	DW	FRM33, OUTPUT_INV_V
	DW	FRM32, OUTPUT_INV_V
	DW	FRM31, OUTPUT_INV_V
	
	DW	FRM40, OUTPUT
	DW	FRM41, OUTPUT
	DW	FRM42, OUTPUT
	DW	FRM43, OUTPUT
	DW	FRM44, OUTPUT
	DW	FRM43, OUTPUT_INV_V
	DW	FRM42, OUTPUT_INV_V
	DW	FRM41, OUTPUT_INV_V
	
	DW	FRM30, OUTPUT_INV_H
	DW	FRM31, OUTPUT_INV_H
	DW	FRM32, OUTPUT_INV_H
	DW	FRM33, OUTPUT_INV_H
	DW	FRM34, OUTPUT_INV_H
	DW	FRM33, OUTPUT_INV_HV
	DW	FRM32, OUTPUT_INV_HV
	DW	FRM31, OUTPUT_INV_HV
	
	DW	FRM20, OUTPUT_INV_H
	DW	FRM21, OUTPUT_INV_H
	DW	FRM22, OUTPUT_INV_H
	DW	FRM23, OUTPUT_INV_H
	DW	FRM24, OUTPUT_INV_H
	DW	FRM23, OUTPUT_INV_HV
	DW	FRM22, OUTPUT_INV_HV
	DW	FRM21, OUTPUT_INV_HV
	
	DW	FRM10, OUTPUT_INV_H
	DW	FRM11, OUTPUT_INV_H
	DW	FRM12, OUTPUT_INV_H
	DW	FRM13, OUTPUT_INV_H
	DW	FRM14, OUTPUT_INV_H
	DW	FRM13, OUTPUT_INV_HV
	DW	FRM12, OUTPUT_INV_HV
	DW	FRM11, OUTPUT_INV_HV
	
//======================================================== FX_PROCEDURES
OUTPUT_INV_V
	LD	HL,BUFF + 768 - 32 + 64
	LD	BC,#C700
	LD	HX,3
VLP1	;-
	LD	DE,0-64
	ADD	HL,DE
	;---------
	DUP	32
	;---------
	LD	D,PIX_CHUNKS/256
	LD	A,(HL)
	INC	HL
	;-
	OR	A
	JR	Z,1F
	;-
	LD	E,A
	;---------
	DUP	7
	;---------
	LD	A,(DE)
	LD	(BC),A
	INC	D
	DEC	B
	;---------
	EDUP
	;---------
	LD	A,(DE)
	LD	(BC),A
	;-
	LD	A,B
	ADD	A,7
	LD	B,A
	;-
1	INC	C
	;---------
	EDUP
	;---------
	JP	NZ,VLP1
	;-
	LD	A,B
	ADD	A,8
	LD	B,A
	DEC	HX
	JP	NZ,VLP1
	;---------------------
	LD	HL,BUFF+768
	LD	DE,#DAE0
	LD	A,24
VLP2	;--
	DUP	32
	LDI
	EDUP
	;-
	EX	DE,HL
	LD	BC,0-64
	ADD	HL,BC
	EX	DE,HL
	;-
	DEC	A
	JP	NZ,VLP2
	;--
	RET
;------------------------------------------
OUTPUT_INV_H
	LD	HL,BUFF+31-64
	LD	BC,#C000
	LD	HX,3
LP1H	;---
	LD	DE,64
	ADD	HL,DE
	;---------
	DUP	32
	;---------
	LD	D,PIX_CHUNKS/256
	LD	A,(HL)
	DEC	HL
	OR	A
	JR	Z,1F
	;-
	ADD	A,128
	LD	E,A
	;---------
	DUP	7
	;---------
	LD	A,(DE)
	LD	(BC),A
	INC	D
	INC	B
	;---------
	EDUP
	;---------
	LD	A,(DE)
	LD	(BC),A
	;-
	LD	A,B
	SUB	7
	LD	B,A
	;-
1	INC	C
	;---------
	EDUP
	;---------
	JP	NZ,LP1H
	;-
	LD	A,B
	ADD	A,8
	LD	B,A
	;-
	DEC	HX
	JP	NZ,LP1H
	;----------------------
	LD	HL,BUFF+768+31
	LD	DE,#D800
	LD	LX,24
LP2H	;-	
	DUP	31
	LD	A,(HL)
	LD	(DE),A
	DEC	L
	INC	E
	EDUP
	;-
	LD	A,(HL)
	LD	(DE),A
	INC	DE
	;-
	LD	BC,63
	ADD	HL,BC
	;-
	DEC	LX
	JP	NZ,LP2H
	;--
	RET
;------------------------------------------
OUTPUT_INV_HV
	LD	HL,BUFF+767
	LD	BC,#C700
	LD	HX,3
LP1HV	;---
	;---------
	DUP	32
	;---------
	LD	D,PIX_CHUNKS/256
	LD	A,(HL)
	DEC	HL
	OR	A
	JR	Z,1F
	;-
	ADD	A,128
	LD	E,A
	;---------
	DUP	7
	;---------
	LD	A,(DE)
	LD	(BC),A
	INC	D
	DEC	B
	;---------
	EDUP
	;---------
	LD	A,(DE)
	LD	(BC),A
	;-
	LD	A,B
	ADD	A,7
	LD	B,A
	;-
1	INC	C
	;---------
	EDUP
	;---------
	JP	NZ,LP1HV
	;-
	LD	A,B
	ADD	A,8
	LD	B,A
	;-
	DEC	HX
	JP	NZ,LP1HV
	;------------------
	LD	HL,BUFF+768
	LD	DE,#DAFF
	LD	LX,24
LP2HV	;--
	DUP	31
	LD	A,(HL)
	LD	(DE),A
	INC	L
	DEC	E
	EDUP
	;-
	LD	A,(HL)
	LD	(DE),A
	INC	HL
	DEC	DE
	;-
	DEC	LX
	JP	NZ,LP2HV
	;--
	RET
;------------------------------------------
OUTPUT
	LD	HL,BUFF
	LD	BC,#C000
	LD	HX,3
LP1	;-
	LD	D,PIX_CHUNKS/256
	LD	A,(HL)
	INC	HL
	OR	A
	JR	Z,1F
	;-
	LD	E,A
	DUP	7
	LD	A,(DE)
	LD	(BC),A
	INC	D
	INC	B
	EDUP
	LD	A,(DE)
	LD	(BC),A
	;-
	LD	A,B
	SUB	7
	LD	B,A
	;-
1	INC	C
	JP	NZ,LP1
	;-
	LD	A,B
	ADD	A,8
	LD	B,A
	DEC	HX
	JP	NZ,LP1
	;------------------
	LD	HL,BUFF+768
	LD	DE,#D800
	LD	A,24
LP2	;-
	DUP	32
	LDI
	EDUP
	DEC	A
	JP	NZ,LP2

	RET
//======================================================== FX_INCLUDE_DATA
//======================================================== FX_TABLES
	ALIGN	256
SQUAD_COS
	INCBIN "bin/squad_cos_tbl.bin"
ATTR_CHUNKS
	INCBIN "bin/attr_chunks.bin"
PIX_CHUNKS
	INCBIN "bin/pix_chunks.bin"
BUFF
	DISPLAY "BUFF END ", /A, BUFF+1152+384

	