//======================================================== FX_HEADER
EFF_INI		JP	EFF_INI_
EFF_RUN		JP	EFF_RUN_
//======================================================== FX_CONST
STAR_QTY	EQU	24

BUFF_Y		EQU	40
BUFFSZ		EQU	32 * BUFF_Y	;1280
BUFF1A		EQU	#8000 - BUFFSZ
BUFF1B		EQU	BUFF1A - BUFFSZ
BUFF2A		EQU	BUFF1B - BUFFSZ
BUFF2B		EQU	BUFF2A - BUFFSZ
;---
C0	EQU	0;
CZ	EQU	1;
C1	EQU	2;
C2	EQU	3;
C3	EQU	5;
C4	EQU	8;
C5	EQU	15;
//======================================================== FX_INIT
EFF_INI_
	EI
	HALT

	LD	A,#17
	CALL	PAGER

	LD	HL,#C000
	LD	DE,#4000
	LD	BC,6912
	LDIR
	
	LD	HL,BUFF2B
	LD	DE,BUFF2B + 1
	LD	BC,BUFFSZ*4-1
	LD	(HL),0
	LDIR

	LD	HL,BUFF
	LD	DE,BUFF + 1
	LD	BC,64*40-1
	LD	(HL),0
	LDIR
	
	CALL	MOVESTARS
	CALL	SWAPBUFF
	CALL	SWP
	
;-----------------------
INIMOVE
	LD	HL,MOVE_ADR
	LD	DE,#5840
	LD	LX,BUFF_Y
INIMV0	;---
	LD	BC,0-32
INIMV2	;---
	LD	A,16
INIMV1	;---
	LD	(HL),#E1	; pop hl
	INC	HL
	LD	(HL),#22	; ld (adr),hl
	INC	HL
	LD	(HL),E
	INC	HL
	LD	(HL),D
	INC	HL
	INC	E
	INC	DE
	DEC	A
	JP	NZ,INIMV1
	;---
	;#40 = 0100.0000
	;#c0 = 1100.0000
	
	LD	A,D
	XOR	#80
	LD	D,A
	AND	#80
	JP	Z,INIMV3
	;---
	EX	DE,HL
	ADD	HL,BC
	EX	DE,HL
INIMV3	;---
	DEC	LX
	JP	NZ,INIMV2
	;---
	LD	(HL),#EB	; ex de,hl
	INC	HL
	LD	(HL),#E9	; jp (hl)
	INC	HL
	;---
	RET
//======================================================== FX_MAINLOOP
EFF_RUN_
	EI
	HALT
	CALL	MOVE_TOP
	CALL	OUTPUT
	CALL	SWP

	EI
	HALT
	CALL	MOVE_TOP
	CALL	OUTPUT
	CALL	SWP
	CALL	ATTRFILL1

	
	EI
	HALT
	CALL	MOVE_TOP
	CALL	OUTPUT
	CALL	SWP
	CALL	ATTRFILL2
	
	EI
	HALT
	CALL	MOVE_TOP
	CALL	OUTPUT
	CALL	SWP
	CALL	ATTRFILL3

	EI
	HALT
	CALL	MOVE_TOP
	CALL	ADDSTARS
	CALL	MOVESTARS
	CALL	SWAPBUFF
	
	CALL	SWP

	RET
//======================================================== FX_PROCEDURES
SWAPBUFF
	LD	HL,BUFF2A
	LD	DE,BUFF2B	
	EXX
	LD	HL,BUFF1A
	LD	DE,BUFF1B
	;--
	LD	A,0
SWAPBUFF0 EQU	$-1
	XOR	#FF
	LD	(SWAPBUFF0),A
	JR	Z,SWAPBUFF1
	EXX
SWAPBUFF1 ;--
	LD	(OUT_BUFFA),HL
	LD	(OUT_BUFFB),DE
	LD	(BUFF_ADR_A),HL
	LD	(BUFF_ADR_B),DE
	LD	HL,BUFF
	LD	(OUT_BUFF),HL
	EXX
	LD	(BUFF_ADR_A_1),HL
	LD	(BUFF_ADR_B_1),DE
	RET
;--------------------------
SWP	LD	HL,BUFF1A
BUFF_ADR_A_1 EQU $-2
	LD	A,0
SWP0	EQU	$-1
	XOR	#FF
	LD	(SWP0),A
	JP	Z,SWP1
	LD	HL,BUFF1B
BUFF_ADR_B_1 EQU $-2
SWP1	LD	(MOVE_TOP_SP),HL
	RET
;--------------------------
MOVE_TOP
	LD	(SOHRSP1),SP
	LD	SP,BUFF1A
MOVE_TOP_SP	EQU	$-2
	LD	DE,MOVE_TOP1
	JP	MOVE_ADR
MOVE_TOP1
	LD	SP,0
SOHRSP1	EQU	$-2
	RET
;----------------------
OUTPUT	;---
	LD	A,23
	DEC	A
	JP	NZ,$-1
	;---
	LD	H,PALETTE / 256
	LD	DE,BUFF1A
OUT_BUFFA EQU $-2
	LD	BC,BUFF1B
OUT_BUFFB EQU $-2
	EXX
	LD	HL,BUFF+4
OUT_BUFF EQU $-2
	LD	B,TBL_SUB / 256
	LD	D,TBL_MUL16 / 256
	LD	A,#17+8
	EX	AF,AF
	LD	LX,53
LP1	;------------
	DUP	3
	;------------
	LD	C,(HL)	;7
	LD	A,(BC)	;7
	LD	(HL),A	;7
	INC	L	;4 /25
	;-
	LD	E,A	;4 /4
	;-
	LD	C,(HL)	;7
	LD	A,(BC)	;7
	LD	(HL),A	;7
	INC	L	;4 /25
	;-
	EX	DE,HL	;4
	OR	(HL)	;7
	EX	DE,HL	;4 /15 /=69
	;--
	EXX		;4 /4
	;-
	LD	L,A	;4
	LD	A,(HL)	;7
	LD	(DE),A	;7
	INC	E	;4 /22
	;-
	INC	H	;4
	LD	A,(HL)	;7
	LD	(BC),A	;7
	INC	C	;4	
	DEC	H	;4 /26
	;-
	EXX		;4 /4 /=56 /=125
	;------
	LD	C,(HL)	;7
	LD	A,(BC)	;7
	LD	(HL),A	;7
	INC	L	;4 /25
	;-
	LD	E,A	;4 /4
	;-
	LD	C,(HL)	;7
	LD	A,(BC)	;7
	LD	(HL),A	;7
	INC	HL	;6 /27
	;-
	EX	DE,HL	;4
	OR	(HL)	;7
	EX	DE,HL	;4 /15
	;--
	EXX		;4 /4
	;-
	LD	L,A	;4
	LD	A,(HL)	;7
	LD	(DE),A	;7
	INC	DE	;6 /24
	;-
	INC	H	;4
	LD	A,(HL)	;7
	LD	(BC),A	;7
	INC	BC	;6
	DEC	H	;4 /28
	;-
	EXX		;4 /4	/=125+6=131
	;------------
	EDUP
	;------------ 768
	;w66
	LD	BC,0
	LD	A,3
	LD	A,3
	DEC	A
	JP	NZ,$-1
	;---
	LD	BC,#7FFD	;10	#00FE
	EX	AF,AF		;4
	XOR	#08		;7	#01
	OUT	(C),A		;12
	EX	AF,AF		;4
	LD	B,TBL_SUB / 256	;7 /44
	;--
	DEC	LX	;8
	JP	NZ,LP1	;10 /18
	;--
	LD	C,(HL)	;7
	LD	A,(BC)	;7
	LD	(HL),A	;7
	INC	L	;4 /25
	;-
	LD	E,A	;4 /4
	;-
	LD	C,(HL)	;7
	LD	A,(BC)	;7
	LD	(HL),A	;7
	INC	L	;4 /25
	;-
	EX	DE,HL	;4
	OR	(HL)	;7
	EX	DE,HL	;4 /15 /=69
	;--
	EXX		;4 /4
	;-
	LD	L,A	;4
	LD	A,(HL)	;7
	LD	(DE),A	;7
	INC	E	;4 /22
	;-
	INC	H	;4
	LD	A,(HL)	;7
	LD	(BC),A	;7
	INC	C	;4	
	DEC	H	;4 /26
	;-
	EXX		;4 /4 /=56 /=125
	;------
	LD	C,(HL)	;7
	LD	A,(BC)	;7
	LD	(HL),A	;7
	INC	L	;4 /25
	;-
	LD	E,A	;4 /4
	;-
	LD	C,(HL)	;7
	LD	A,(BC)	;7
	LD	(HL),A	;7
	INC	HL	;6 /27
	;-
	EX	DE,HL	;4
	OR	(HL)	;7
	EX	DE,HL	;4 /15
	;--
	EXX		;4 /4
	;-
	LD	L,A	;4
	LD	A,(HL)	;7
	LD	(DE),A	;7
	INC	DE	;6 /24
	;-
	INC	H	;4
	LD	A,(HL)	;7
	LD	(BC),A	;7
	INC	BC	;6
	DEC	H	;4 /28
	;-
	EXX		;4 /4	/=125+6=131
	;-----------------
	LD	(OUT_BUFF),HL
	EXX
	LD	(OUT_BUFFA),DE
	LD	(OUT_BUFFB),BC
	;--
	RET
;------------------------------
ADDSTARS
	LD	A,20
	DEC	A
	JP	NZ,$-1
	;--
	DS	6,0
	;--
	LD	BC,#7FFD	;10
	LD	DE,#1F17	;10
	EXX			;4
	LD	D,TBL_ADD / 256	;7
	;--
	LD	(SOHRSP2),SP
	LD	SP,ADDSTARS_TBL
	;-
	RET
ADDSTARS_RET
	LD	SP,0
SOHRSP2	EQU $-2
	RET
;-------------------------
ADDSTARS_TBL
	DUP	STAR_QTY
	DW	OUTSTAR3
	DW	BUFF + 2+16
	EDUP
	DW	ADDSTARS_RET
;-------------------
GET_RANDOM
	LD  A,137
SEED	EQU	$-1
	LD	B,A
	ADD	A,A
	XOR	B
	LD	B,A
	SRL	A
	XOR	B
	LD	B,A
	ADD	A,A
	ADD	A,A
	XOR	B
	LD	(SEED),A
	RET
;------------------------
MOVESTARS
	LD	HL,POINTS
	LD	(SOHRSP3),SP
	LD	SP,ADDSTARS_TBL + STAR_QTY * 4
	LD	LX,STAR_QTY
POI2	LD	A,(HL)
	ADD	A,2
	AND	31
	LD	(HL),A
	INC	HL
	JP	NZ,POI1
	;-- get next rand star
POI1	;-
	LD	B,A	;4 B = z 0..31
	EX	AF,AF
	;-
	LD	A,(HL)	;7
	ADD	A,B	;4
	LD	E,A	;4
	INC	L	;4
	LD	D,(HL)	;7
	INC	L	;4 de = tbl proj x adr
	;---
	LD	A,(DE)	;7
	LD	C,A	;4
	;---
	LD	A,(HL)	;7
	ADD	A,B	;4
	ADD	A,B	;4
	LD	E,A	;4
	INC	L	;4
	LD	D,(HL)	;7
	INC	L	;4 de = tbl proj y adr
	;---
	LD	A,(DE)	;7
	INC	DE	;4
	OR	C	;4
	LD	C,A	;4
	LD	A,(DE)	;7
	LD	B,A	;4 bc = buff adr
	
	;LD	A,(DE)	;7
	;ADD	A,A	;4
	;LD	E,A	;4
	;--
	;LD	D,TBLY	;0
	;LD	A,(DE)	;7
	;OR	B
	;LD	C,A	
	;INC	E
	;LD	A,(DE)
	;LD	B,A
	;--

	PUSH	BC
	EX	AF,AF
	LD	D,HIGH STARS_SPR_TBL
	RRA
	RRA
	AND	%00000110
	ADD	A,LOW STARS_SPR_TBL
	LD	E,A
	LD	A,(DE)
	LD	C,A
	INC	E
	LD	A,(DE)
	LD	B,A
	PUSH	BC
	;--
	DEC	LX
	JP	NZ,POI2
	;--
	LD	SP,0
SOHRSP3	EQU $-2
	RET


ATTRFILL3
	LD	HL,(BUFF_ADR_A)
	LD	BC,32*21 + 5
	ADD	HL,BC
	CALL	ATTR5
	LD	BC,10
	ADD	HL,BC
	LD	C,#43
	CALL	ATTR6
	LD	BC,8
	ADD	HL,BC
	CALL	ATTR7
	LD	BC,24
	ADD	HL,BC
	LD	A,(HL)
	AND	#47
	LD	(HL),A
	INC	L
	LD	A,(HL)
	AND	#40+7*8
	LD	(HL),A
	
	
	LD	HL,(BUFF_ADR_B)
	LD	BC,32*21 + 5
	ADD	HL,BC
	CALL	ATTR5
	LD	BC,10
	ADD	HL,BC
	LD	C,#45
	CALL	ATTR6
	LD	BC,8
	ADD	HL,BC
	CALL	ATTR7
	LD	BC,24
	ADD	HL,BC
	LD	A,(HL)
	AND	#47
	LD	(HL),A
	INC	L
	LD	A,(HL)
	AND	#40+7*8
	LD	(HL),A
	RET
ATTR5	LD	C,#05
	LD	A,(HL)
	AND	#47
	LD	(HL),A
	INC	L
	DUP	2
	LD	(HL),C
	INC	L
	EDUP
	LD	A,(HL)
	AND	#47
	LD	(HL),A
	INC	L
	LD	(HL),C
	INC	L
	LD	A,(HL)
	AND	#47
	LD	(HL),A
	INC	L
	DUP	8
	LD	(HL),C
	INC	L
	EDUP
	LD	A,(HL)
	AND	#40+7*8
	LD	(HL),A
	INC	L
	LD	A,(HL)
	AND	#47
	LD	(HL),A
	INC	L
	DUP	6
	LD	(HL),C
	INC	L
	LD	A,(HL)
	AND	#40+7*8
	LD	(HL),A
	EDUP
	RET

ATTR6
	LD	A,(HL)
	AND	#47
	LD	(HL),A
	INC	L
	LD	(HL),C
	INC	L
	LD	A,(HL)
	AND	#40+7*8
	LD	(HL),A
	INC	L
	LD	A,(HL)
	AND	#47
	LD	(HL),A
	INC	L
	LD	(HL),C
	INC	L
	LD	A,(HL)
	AND	#47
	LD	(HL),A
	INC	L
	DUP	8
	LD	(HL),C
	INC	L
	EDUP
	LD	A,(HL)
	AND	#40+7*8
	LD	(HL),A
	INC	L
	LD	A,(HL)
	AND	#47
	LD	(HL),A
	INC	L
	LD	(HL),C
	INC	L
	LD	(HL),C
	INC	L
	LD	A,(HL)
	AND	#47
	LD	(HL),A
	INC	L
	LD	(HL),C
	INC	L
	LD	(HL),C
	INC	L
	LD	(HL),C
	INC	L
	LD	A,(HL)
	AND	#40+7*8
	LD	(HL),A
	INC	L
	RET
ATTR7
	LD	C,#44
	LD	A,(HL)
	AND	#47
	LD	(HL),A
	INC	L
	DUP	2
	LD	(HL),C
	INC	L
	EDUP
	LD	A,(HL)
	AND	#40+7*8
	LD	(HL),A
	INC	L
	LD	A,(HL)
	AND	#47
	LD	(HL),A
	INC	L
	LD	(HL),C
	INC	L
	INC	L
	LD	A,(HL)
	AND	#47
	LD	(HL),A
	INC	L
	DUP	6
	LD	(HL),C
	INC	L
	EDUP
	LD	A,(HL)
	AND	#40+7*8
	LD	(HL),A
	INC	L
	INC	L
	INC	L
	LD	A,(HL)
	AND	#47
	LD	(HL),A
	INC	L
	LD	A,(HL)
	AND	#40+7*8
	LD	(HL),A
	INC	L
	LD	A,(HL)
	AND	#47
	LD	(HL),A
	INC	L
	LD	(HL),C
	INC	L
	LD	A,(HL)
	AND	#47
	LD	(HL),A
	INC	L
	LD	(HL),C
	INC	L
	LD	(HL),C
	INC	L
	LD	A,(HL)
	AND	#40+7*8
	LD	(HL),A
	INC	L
	RET
	
ATTRFILL2
	LD	HL,(BUFF_ADR_A)
	LD	BC,32*19 + 3
	ADD	HL,BC
	CALL	ATTR3
	LD	BC,10
	ADD	HL,BC
	CALL	ATTR4
	LD	HL,(BUFF_ADR_B)
	LD	BC,32*19 + 3
	ADD	HL,BC
	CALL	ATTR3
	LD	BC,10
	ADD	HL,BC
	CALL	ATTR4
	RET
ATTR3	LD	C,#46
	LD	A,(HL)
	AND	#47
	LD	(HL),A
	INC	L
	DUP	23
	LD	(HL),C
	INC	L
	EDUP
	LD	A,(HL)
	AND	#40+7*8
	LD	(HL),A
	INC	L
	RET
ATTR4	LD	C,#44
	LD	A,(HL)
	AND	#47
	LD	(HL),A
	INC	L
	DUP	5
	LD	(HL),C
	INC	L
	EDUP
	LD	A,(HL)
	AND	#47
	LD	(HL),A
	INC	L
	DUP	4
	LD	(HL),C
	INC	L
	EDUP
	LD	A,(HL)
	AND	#47
	LD	(HL),A
	INC	L
	DUP	8
	LD	(HL),C
	INC	L
	EDUP
	LD	A,(HL)
	AND	#40+7*8
	LD	(HL),A
	RET
	
ATTRFILL1 ;---------------
	LD	HL,BUFF1A
BUFF_ADR_A	EQU $-2
	LD	BC,32*17 + 2
	ADD	HL,BC
	CALL	ATTR1
	LD	BC,7
	ADD	HL,BC
	CALL	ATTR2
	LD	HL,BUFF1B
BUFF_ADR_B	EQU $-2
	LD	BC,32*17 + 2
	ADD	HL,BC
	CALL	ATTR1
	LD	BC,7
	ADD	HL,BC
ATTR2	;--
	LD	C,#47
	LD	A,(HL)
	AND	#47
	LD	(HL),A
	INC	L
	;-
	DUP	21
	LD	(HL),C
	INC	L
	EDUP
	;-
	LD	A,(HL)
	AND	#47
	LD	(HL),A
	INC	L
	;-
	LD	(HL),C
	INC	L
	;-
	LD	A,(HL)
	AND	#40+8*7
	LD	(HL),A
	INC	L
	RET
ATTR1	LD	C,#40
	LD	A,(HL)
	AND	#47
	LD	(HL),A
	INC	L
	;-
	DUP	22
	LD	(HL),C
	INC	L
	EDUP
	;-
	LD	A,(HL)
	AND	#47
	LD	(HL),A
	INC	L
	;-
	LD	(HL),C
	INC	L
	LD	(HL),C
	INC	L
	;-
	LD	A,(HL)
	AND	#40+7*8
	LD	(HL),A
	RET
//======================================================== FX_INCLUDE_DATA
OUTSTAR3	INCLUDE "bin/outstar3.asm"
OUTSTAR2	INCLUDE "bin/outstar2.asm"
OUTSTAR1	INCLUDE "bin/outstar1.asm"
OUTSTAR0	INCLUDE "bin/outstar0.asm"
//======================================================== FX_TABLES
	ALIGN	256
PALETTE
	INCBIN "bin/starfield_palette.bin"
	DS	512,0
TBL_SUB	;---
	DB 0,0,0,1, 2,3,4,5, 6,7,8,9, 10,11,12,13
	DS 256-16, 13
TBL_ADD	;---
	DB 0,1,2,3, 4,5,6,7, 8,9,10,11, 12,13,14,15
	DS 256-16, 15
TBL_MUL16
	;---
	DB	#00,#10,#20,#30
	DB	#40,#50,#60,#70
	DB	#80,#90,#A0,#B0
	DB	#C0,#D0,#E0,#F0

POINTS	INCLUDE "bin/tbl_stars.asm"
STARS_SPR_TBL
	DW	OUTSTAR0
	DW	OUTSTAR1
	DW	OUTSTAR2
	DW	OUTSTAR3

	ALIGN 256
TBL_PROJ_Y	INCLUDE "bin/tbl_proj_y.asm"
TBL_PROJ_X	INCLUDE "bin/tbl_proj_x.asm"
TBL_PROJ_X_END

	ALIGN 256
	DS	64*8,0
BUFF
MOVE_ADR EQU	#DB00

;MOVE_ADR
;BUFF EQU 0; //#DB00


	DISPLAY "-------------------------------- FX VARS:"
	DISPLAY "MOVE_ADR ", /A, MOVE_ADR
	DISPLAY "MOVE_ADR SIZE", /A, 32*BUFF_Y*4
	DISPLAY "MOVE_ADR_END ", /A, MOVE_ADR + 32*BUFF_Y*4
	
	DISPLAY "BUFF END: ", /A, BUFF + 64*8 + 64*40
	
	DISPLAY "BUFF2B: ", /A, BUFF2B
	
	DISPLAY "TBL_PROJ_Y SIZE: ", /A, TBL_PROJ_X - TBL_PROJ_Y
	DISPLAY "STARS_SPR_TBL: ", /A, $

	
	
	
	
	
	
	
	
	
	
	
	
	CALL	GET_RANDOM
	AND	31
	ADD	A,8
	PUSH	HL
	LD	L,A
	LD	H,0
	ADD	HL,HL
	ADD	HL,HL
	ADD	HL,HL
	ADD	HL,HL
	ADD	HL,HL
	ADD	HL,HL
	LD	BC,TBL_PROJ_X
	ADD	HL,BC
	EX	DE,HL
	POP	HL
	
	
	;LD	DE,TBL_PROJ_X + 64*20
	LD	(HL),E
	INC	L
	LD	(HL),D
	DEC	L