#version 330 core

// inputz
in vec2 UV;

uniform vec2 iResolution;
uniform float iTime;
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;


// outputz
out vec4 fragColor;

// linear white point
const float W = 1.5;
const float T2 = 8.15;

float filmic_reinhard_curve (float x) {
    float q = (T2*T2 + 1.0)*x*x;    
	return q / (q + x + T2*T2);
}

vec3 filmic_reinhard(vec3 x) {
    float w = filmic_reinhard_curve(W);
    return vec3(
        filmic_reinhard_curve(x.r),
        filmic_reinhard_curve(x.g),
        filmic_reinhard_curve(x.b)) / w;
}

void main()
{
    vec2 uv = UV;
    vec3 col = filmic_reinhard(1.0*texture(iChannel0, uv).xyz + 0.75*texture(iChannel1, uv).xyz);
	fragColor = vec4(
        			pow(col, vec3(1.0/1.2/2.2)),
        			1.0
                );
}
