#version 330 core

in vec2 UV;
out vec4 fragColor;

uniform vec2 iResolution;
uniform sampler2D textu;
uniform float iGlobalTime;
uniform vec3 letterbox;

bool aspect() {
	float yPix = (9.0 / 21.0) * iResolution.x;
	float dPix = 0.5 * (iResolution.y - yPix);
	float d = dPix / iResolution.y;
	return (UV.y < d) || (UV.y > 1.0 - d);
}

vec3 mod289(vec3 x) {
  return x - floor(x * (1.0 / 289.0)) * 289.0;
}

vec2 mod289(vec2 x) {
  return x - floor(x * (1.0 / 289.0)) * 289.0;
}

vec3 permute(vec3 x) {
  return mod289(((x*34.0)+1.0)*x);
}

float snoise(vec2 v)
  {
  const vec4 C = vec4(0.211324865405187,  // (3.0-sqrt(3.0))/6.0
                      0.366025403784439,  // 0.5*(sqrt(3.0)-1.0)
                     -0.577350269189626,  // -1.0 + 2.0 * C.x
                      0.024390243902439); // 1.0 / 41.0
  vec2 i  = floor(v + dot(v, C.yy) );
  vec2 x0 = v -   i + dot(i, C.xx);
  vec2 i1;
  i1 = (x0.x > x0.y) ? vec2(1.0, 0.0) : vec2(0.0, 1.0);
  vec4 x12 = x0.xyxy + C.xxzz;
  x12.xy -= i1;
  i = mod289(i);
  vec3 p = permute( permute( i.y + vec3(0.0, i1.y, 1.0 )) + i.x + vec3(0.0, i1.x, 1.0 ));
  vec3 m = max(0.5 - vec3(dot(x0,x0), dot(x12.xy,x12.xy), dot(x12.zw,x12.zw)), 0.0);
  m = m*m ;
  m = m*m ;
  vec3 x = 2.0 * fract(p * C.www) - 1.0;
  vec3 h = abs(x) - 0.5;
  vec3 ox = floor(x + 0.5);
  vec3 a0 = x - ox;
  m *= 1.79284291400159 - 0.85373472095314 * ( a0*a0 + h*h );
  vec3 g;
  g.x  = a0.x  * x0.x  + h.x  * x0.y;
  g.yz = a0.yz * x12.xz + h.yz * x12.yw;
  return 130.0 * dot(m, g);
}

float rand(vec2 co){
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}

vec2 co(vec2 uv)
{
  // return sampler-compatible uv coords
//    uv.y = -uv.y; // Remove this if image is upside down (tends to happen with video)
    return 0.5-uv*0.49;
}

const float kFunkyDistortionConst = 0.999;
vec4 spacepochdist(sampler2D tex) {
  const int N = 32;
  vec2 uv = 1.0 - 2.0 * UV;
  vec4 c = vec4(0); //vec4(0.0);

  float rf = 0.998;
  float gf = 1.0/0.998;
  
  float f = 1.0/float(N);
  for(int i = 0; i < N; ++i)
  {
    // sample texture
    c.x += f*texture(tex, co(gf*uv) ).x;
    c.y += f*texture(tex, co(uv) ).y;
    c.z += f*texture(tex, co(rf*uv) ).z;

    rf *= kFunkyDistortionConst;
    gf /= kFunkyDistortionConst;
  }

  // vignette and flicker
  float tv = 0.99+0.015*sin(2.0*3.141*25.0*iGlobalTime);
  return vec4( tv*c );
}

void main() {
	vec2 uv = UV * (1.0 - UV.yx);
    float vig = uv.x*uv.y * 10.0;
    vig = pow(vig, 1.0/2.0);

	vec4 op = smoothstep(vec4(-.029, -.016, -.01, -.01), vec4(1.12,1.15,1.13,1.1), spacepochdist(textu));
  //op = spacepochdist(textu);
	op += vec4( 0.01*vec3(rand(UV * vec2(iGlobalTime) )), 1.0 );
	op += vec4( 0.035*vec3(snoise(UV*333.3 + vec2(iGlobalTime*1000.0) )), 1.0 );
    op = aspect() ? vec4(letterbox, 1.0) : mix(1.0, vig,0.1) * op;
    fragColor = vec4(op.rgb, dot(op.rgb, vec3(0.2126, 0.7152, 0.0722)));
}
