function main()
{

document.body.style='width: 100%;height:100%;margin: 0;padding:0;overflow:hidden;cursor:none;background-color:black';
document.body.innerHTML+="<canvas id='canvas' width='1920' height='1080' style='position:absolute;width:100%;height:100%;top:0;left:0;'></canvas>";
document.body.addEventListener=("keypress", quit)
var CANVAS = document.getElementById("canvas");
var GL = CANVAS.getContext("webgl");

// Settings
const RESOLUTION = [1920,1080]; // [width, height]

// <<<<<<<<<<<<<<<<<<<<<<<<<<<<< Matrix functions
function translationMatrix(x, y, z){
	return [
		1,0,0,0,
		0,1,0,0,
		0,0,1,0,
		x,y,z,1
	];
}
function rotMatrix(x, y, z){
	cx = Math.cos(x); cy = Math.cos(y); cz = Math.cos(z);
	sx = Math.sin(x); sy = Math.sin(y); sz = Math.sin(z);
	return [
		cz*cy,sz*cx+cz*sy*sx,-sx*sz+cz*sy*cx,0,
		-sz*cy,cz*cx-sz*sy*sx,-cz*sx-sz*sy*cx,0,
		-sy,cy*sx,cy*cx,0,
		0,0,0,1
	];
}
function prod(m1, m2) {
	var matrix = [];
	for (i=0; i<4; i++){
		for (j=0; j<4; j++){
			ii = 4*i;
			matrix.push(
				m1[j]*m2[ii]+m1[j+4]*m2[ii+1]+m1[j+8]*m2[ii+2]+m1[j+12]*m2[ii+3]
			);
		}
	}
	return matrix;
}
// >>>>>>>>>>>>>>>>>>>>>>>>>>>>> Matrix functions

// <<<<<<<<<<<<<<<<<<<<<<<<<<<<< GL functions
function setGeometry(gl, shape) {
	gl.bufferData(
	    gl.ARRAY_BUFFER,
		new Float32Array(shape),
	    gl.STATIC_DRAW
    );
}

function createShader(gl, type, source){
	var shader = gl.createShader(type);
	gl.shaderSource(shader, source);
	gl.compileShader(shader);
	var success = gl.getShaderParameter(shader, gl.COMPILE_STATUS); //DEBUG
	if (success){ //DEBUG
		return shader;
	} //DEBUG
	console.log(gl.getShaderInfoLog(shader)); //DEBUG
	gl.deleteShader(shader); //DEBUG
}

function createProgram(gl, vertexShader, fragmentShader) {
	var program = gl.createProgram();
	gl.attachShader(program, vertexShader);
	gl.attachShader(program, fragmentShader);
	gl.linkProgram(program);
	var success = gl.getProgramParameter(program, gl.LINK_STATUS); //DEBUG
	if (success){ //DEBUG
		return program;
	} //DEBUG
	console.log(gl.getProgramInfoLog(program)); //DEBUG
	gl.deleteProgram(program); //DEBUG
}
// >>>>>>>>>>>>>>>>>>>>>>>>>>>>> GL functions

// <<<<<<<<<<<<<<<<<<<<<<<<<<<<< Initialization

// Create shaders
var VSrc = document.getElementById('vertex').innerHTML;
var FSrc = document.getElementById('fragment').innerHTML;
var VERTEXSHADER = createShader(GL, GL.VERTEX_SHADER, VSrc);
var FRAGMENTSHADER = createShader(GL, GL.FRAGMENT_SHADER, FSrc);

// Create programs
var program = createProgram(GL, VERTEXSHADER, FRAGMENTSHADER);

// Attribute and unifrom locations
posAttribLocation = GL.getAttribLocation(program, "position");
screensizeLocation = GL.getUniformLocation(program, "uScreensize");
timeLocation = GL.getUniformLocation(program, "uTime");
sunLoc = GL.getUniformLocation(program,"uSunPos");
noteLocation = GL.getUniformLocation(program, "uNote");
bassLocation = GL.getUniformLocation(program, "uBass");
phaseLocation = GL.getUniformLocation(program, "uPhase");
camLoc = GL.getUniformLocation(program,"uCamera");
planetLoc = GL.getUniformLocation(program,"uPlanetMatrix")

// Create and bind position buffer
var positionBuffer = GL.createBuffer();
GL.enableVertexAttribArray(posAttribLocation);
GL.bindBuffer(GL.ARRAY_BUFFER, positionBuffer); // bind the buffer
setGeometry(
    GL,
    [
        -1,-1,0,
		 1,-1,0,
		 1,1,0,
		 1,1,0,
		 -1,1,0,
		 -1,-1,0,
     ]
);

GL.vertexAttribPointer(
	posAttribLocation,
	3,					// 3 components per iteration
	GL.FLOAT,			// 32bit float
	false, 				// don't normalize
	0,					// stride
	0					// start at the beginning of the buffer
);

GL.useProgram(program);
GL.viewport(0, 0, GL.canvas.width, GL.canvas.height);

var PHASE = 0;
var START_TIME = 0;

// >>>>>>>>>>>>>>>>>>>>>>>>>>>>> Initialization

// <<<<<<<<<<<<<<<<<<<<<<<<<<<<< Draw functions

function drawScene(time, note, bass) {

	// Supply uniforms to shader
	GL.uniform2fv(screensizeLocation, new Float32Array(RESOLUTION));
	GL.uniform1f(timeLocation, time);
	GL.uniform1f(noteLocation, note);
	GL.uniform1f(bassLocation, bass);
	GL.uniform1i(phaseLocation, PHASE);

    GL.uniformMatrix4fv(
        camLoc,
        false,
        rotMatrix(
            0.,
            0.,
            0.
        )
    );
	GL.uniform3f(
        sunLoc,
        Math.sin(time/7)*3200,
        0.,
        Math.cos(time/7)*3200
    );

	GL.drawArrays(GL.TRIANGLES, 0, 6);

}

function refreshScreen(time){

    // Use time as seconds
    time -= START_TIME;
    time /= 1000;
    if (time > 44) {
        PHASE = 7;
    }

    note = 0;
    bass = 0;

	if (PHASE != 7){
        drawScene(time, note, bass);
		window.requestAnimationFrame(refreshScreen);
	} else {
        quit();
    }

}

function quit() {
    PHASE = 7;
    CANVAS.style.opacity=0.;
    document.getElementById('startBtn').innerHTML='Greetings to XKikkel7';
}

document.getElementById('audio').play();
START_TIME = performance.now()
window.requestAnimationFrame(refreshScreen);

// >>>>>>>>>>>>>>>>>>>>>>>>>>>>> Draw functions

}

// Start button for "browser needs user input before audio contexts are allowed"
// stupidery. Everyone has adblock anyway.
window.onload=function()
{
    var btn = document.createElement('BUTTON');
    btn.id = 'startBtn';
    btn.style.position = 'absolute';
    btn.style.width = '100%';
    btn.style.height = '100%';
    btn.style.fontSize = '200px';
    btn.style.top = 0;
    btn.style.left = 0;
    btn.onclick = main;
    btn.innerHTML = 'CLICK TO BEGIN';

    document.body.appendChild(btn);
}
