/*
 * This is a stripped down starter code for the
 * Assembly Summer 2019 Demo Coding Workshop
 * The original invitation code is very educational:
 * https://github.com/mrautio/graffathon19-demo-one-scene 
 */

// We suggest you use these libraries (and no others):
// Moonlander is a library for integrating Processing with GNU Rocket, https://github.com/anttihirvonen/moonlander
// GNURocket is a tool for synchronizing music and visuals in demoscene productions: https://github.com/rocket/rocket
import moonlander.library.*;
// Audio library for playing sound, http://code.compartmental.net/minim/
import ddf.minim.*;

// Some demo global variables 

// the time in seconds (will be taken from Moonlander / GNURocket every frame)
float now = 0.0;

// These control how big the opened window is.
// But you don't need not change these to develop in a smaller window!
// In fact, DON'T CHANGE THESE. They are optimal for Assembly 2019 Compo.
// ref. https://www.assembly.org/summer19/demoscene/rules
float CANVAS_WIDTH = 1920;
float CANVAS_HEIGHT = 1080;

//Initialise Moonlander
Moonlander moonlander;
// Define font 
PFont font;

String letters = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
/*
 * Initialize the window
 */
void settings() {
  boolean fullscreen = true;
  
  if (fullscreen) {
    //Set the window fullscreen in desktop's native resolution
    fullScreen(P3D);
  } else {
    //open in a smaller window
    //Put some 16:9 aspect ratio resolution
    //like 800x450... do not edit CANVAS_WIDTH or CANVAS_HEIGHT
    size((int)800,(int)450, P3D);
  }
}

/*
 * Set up, and load all assets in the demo.
 * Make sure you include everything in the "data/" directory 
 * with your entry, and that the license of each asset allows
 * you to use it in this compo!
 */
void setup() {
  // hide mouse cursor; you want to do this.
  noCursor();
  
  // load the defined font
  font = createFont("Amatic-Bold.ttf", 300);

  // Init & start moonlander
  int bpm = 120; // Tune's beats per minute. Set this according to your song.
  int rowsPerBeat = 4; // How many rows one beat consists of in the sync editor (GNURocket or so)
  moonlander = Moonlander.initWithSoundtrack(this, "Evgeny_Grinko_-_01_-_Winter_Sunshine.mp3", bpm, rowsPerBeat);
  moonlander.start();
  
  // Assembly has 60Hz maximum projector framerate, ref. https://www.assembly.org/summer19/demoscene/rules
  int fps = 60;
  frameRate(fps);  
}

// Title texts
void drawTitle(){
  fill(250,250,250);
  textFont(font);
  textSize(300);
  text("One scene combo", -800, 60);
  textSize(160);
  text("Assembly Summer 2019", -695, -180);
}

//Lissajous curves mathematical formula as a basis to make the the "randomness" 
// and different routes for the alphabets:
void drawAlphabet() {
  fill(255,255,0);
  textFont(font);
  textSize(300);
  int letter = 0;
  for (int i = 0; i < 52; i = i+1) {
    float t = 0.0001*millis()+0.11*i;
    float a = 1.7+0.99*i;
    float b = 0.68+0.69*i;
    float c = PI/2;
    float A = CANVAS_WIDTH/2-10;
    float B = CANVAS_HEIGHT/2-10;
    float x = A*sin(a*t+c);
    float y = B*sin(b*t);
  text(letters.charAt(i),x,y);
  }
}

// Thank you
void drawThanks(){
  fill(250,250,250);
  textFont(font);
  textSize(160);
  text("Thank you for all", -695, -180);
  text("the workshop organisers!", -695, -10);
}
 /*
 * The classic rotating cube from the begin
 */
/*void drawMyStuff() {
  pushMatrix();
  rotateY(now);
  fill(239,0,191,78);
  float w = (float)moonlander.getValue("cube:width");
  float h = (float)moonlander.getValue("cube:height");
  float d = (float)moonlander.getValue("cube:depth");
  box(w,h,d);
  for(int i=0; i<10; i++){
    rotateY(.2-(float)moonlander.getValue("bg:r"));
    translate(w*2,0,0);
    box(w,h,d);
  } 
  popMatrix();
}*/

/*
 * This function is called every time a screen is drawn, ideally that would be 60 times per second
 */
 
 
void draw() {
  // update Rocket sync data  
  moonlander.update();


  now = (float)moonlander.getCurrentTime();
  float end = 14.0; //end production after 20 secs 
  if (now > end) {
    exit();
  }
  
  // Set the background color
  background(239,0,191,78);
  /*background((int)(moonlander.getValue("bg:r") * 255),
             (int)(moonlander.getValue("bg:g") * 255),
             (int)(moonlander.getValue("bg:b") * 255),
             (int)(moonlander.getValue("bg:a") * 255));
  */
  
  /*
   * Center coordinates to screen and make the window and canvas resolution independent
   * This is because actual window in full screen on a 4K monitor has more pixels than FullHD resolution
   * so scaling is needed to ensure that all objects (3D and 2D) are in correct places regardless of the desktop resolution
   */
  translate(width/2, height/2, 0);
  scale(width/CANVAS_WIDTH,height/CANVAS_HEIGHT,width/CANVAS_WIDTH);

  // Enable lights and depth testing to ensure that 3D meshes are drawn in correct order
  lights();
  hint(ENABLE_DEPTH_TEST);

//Phase/time management from Rocket over time
  double phase = moonlander.getValue("demo:phase");
  println(phase);
  
  if (phase <= 1) {
    drawTitle();
  } else if (phase == 2) {
    drawAlphabet();
  } else {
    drawAlphabet();
    drawThanks();
  }
  
  //drawTitle();
  //idrawAlphabet();

  //drawMyStuff();
}
