//--------------------------------------------------------------------------------------
// Constant Buffer Variables
//--------------------------------------------------------------------------------------
Texture2D texSource : register(t0);
Texture2D texImage1 : register(t1);
SamplerState sampLinearClamp : register(s0);
SamplerState sampNearestClamp : register(s1);
SamplerState sampLinearWrap : register(s2);
SamplerState sampNearestWrap : register(s3);

cbuffer GlobalRenderData: register(b0)
{
    float g_fTime;
	float g_fFloat1;	// threshold
	float g_fFloat2;	// noise strength
    float g_fFloat3;
    float g_fFloat4;
    float g_fFloat5;
    float g_fFloat6;
    float g_fSeed;
};


#define PALETTE_SIZE 16
static float3 avecPalette[PALETTE_SIZE] = {
	float3(0,0,0),
	float3(1,0,0),
	float3(0,1,0),
	float3(0,0,1),
	float3(1,1,0),
	float3(0,1,1),
	float3(1,0,1),
	float3(1,1,1),
	float3(0,0,0),
	float3(0.74,0,0),
	float3(0,0.74,0),
	float3(0,0,0.74),
	float3(0.74,0.74,0),
	float3(0,0.74,0.74),
	float3(0.74,0,0.74),
	float3(0.74,0.74,0.74),
};

//--------------------------------------------------------------------------------------
struct VS_INPUT
{
    float3 vecPosition : POSITION;
    float2 vecTexCoord0 : TEXCOORD0;
};

struct PS_INPUT
{
    float4 vecPosition : SV_POSITION;
    float2 vecTexCoord0 : TEXCOORD0;
};


//--------------------------------------------------------------------------------------
// Vertex Shader
//--------------------------------------------------------------------------------------
PS_INPUT VS(VS_INPUT input)
{
    PS_INPUT output;

    float2 vecTexCoord0 = input.vecTexCoord0.xy * float2(2, -2) + float2(-1, 1);
    output.vecPosition = float4(vecTexCoord0, 0, 1);
    output.vecTexCoord0 = input.vecTexCoord0;

    return output;
}


//--------------------------------------------------------------------------------------
// Pixel Shader
//--------------------------------------------------------------------------------------
float4 PS(PS_INPUT input) : SV_Target
{
//if (input.vecTexCoord0.x<0.5) return texSource.Sample(sampLinearWrap, input.vecTexCoord0)*5;

	const int2 vecPixCoords = floor(input.vecTexCoord0 * float2(342, 192));
	if (vecPixCoords.x < (342-256)/2 || vecPixCoords.x > 342 - (342 - 256) / 2)
	{
		// border
		return float4(0, 0, 0, 1);
	}
	else
	{
		const float2 vecAspectCorrect = float2(342.0 / 192.0, 1.0);
		const float2 vecAttrBlockOrigin = floor(vecPixCoords / 8) * 8;

		float aiColourCounts[PALETTE_SIZE] = {
			0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,
		};
		for (int x = 0; x < 8; x++) {
			for (int y = 0; y < 8; y++) {
				int iClosest = 0;
				const float3 vecAttrBlockColour = texSource.Sample(sampLinearWrap, (vecAttrBlockOrigin + float2(x, y)) / float2(342, 192)).rgb;
				for (int i = 1; i < PALETTE_SIZE; i++) {
					if (length(vecAttrBlockColour - avecPalette[i]) < length(vecAttrBlockColour - avecPalette[iClosest])) {
						iClosest = i;
					}
				}
				aiColourCounts[iClosest] = aiColourCounts[iClosest] + 1;
			}
		}

		if (aiColourCounts[0] > 10)  aiColourCounts[0] = 0;

		int iClosest = 0;
		for (int i = 1; i < PALETTE_SIZE; i++) {
			if (aiColourCounts[i] > aiColourCounts[iClosest]) {
				iClosest = i;
			}
		}
		if (iClosest == 0 || iClosest == 8) iClosest=9;

		const float3 vecChosenColour = avecPalette[iClosest];
		const float3 vecSourceColour = texSource.Sample(sampLinearWrap, input.vecTexCoord0).rgb;
		if (length(vecChosenColour - vecSourceColour) < length(vecSourceColour)*g_fFloat1) {
			return float4(vecChosenColour, 1);
		} else {
			return float4(0,0,0,1);
		}
	}
}
