//--------------------------------------------------------------------------------------
// Constant Buffer Variables
//--------------------------------------------------------------------------------------
Texture2D tex0 : register(t0);
SamplerState sampLinearClamp : register(s0);
SamplerState sampNearestClamp : register(s1);
SamplerState sampLinearWrap : register(s2);
SamplerState sampNearestWrap : register(s3);

cbuffer GlobalRenderData: register(b2)
{
    float g_fTime;
    float g_fFloat1;
    float g_fFloat2;
    float g_fFloat3;
    float g_fFloat4;
    float g_fFloat5;
    float g_fFloat6;
    float g_fSeed;
};


//--------------------------------------------------------------------------------------
struct VS_INPUT
{
    float3 vecPosition : POSITION;
    float2 vecTexCoord0 : TEXCOORD0;
};

struct PS_INPUT
{
    float4 vecPosition : SV_POSITION;
    float2 vecTexCoord0 : TEXCOORD0;
};


//--------------------------------------------------------------------------------------
// Vertex Shader
//--------------------------------------------------------------------------------------
PS_INPUT VS( VS_INPUT input )
{
    PS_INPUT output;
    float2 vecTexCoord0 = input.vecTexCoord0.xy * float2(2, -2) + float2(-1, 1);
    output.vecPosition = float4(vecTexCoord0/* * float2(1, 800.06f/600.0f)*/, 0, 1);
    output.vecTexCoord0 = input.vecTexCoord0.xy;
    return output;
}


//--------------------------------------------------------------------------------------
// Pixel Shader
//--------------------------------------------------------------------------------------
float4 PS(PS_INPUT input) : SV_Target
{
    if (input.vecTexCoord0.x>0.9) {
        return (((input.vecTexCoord0.x + input.vecTexCoord0.y) * 20) + g_fTime) % 1 > 0.5 ? g_fFloat1 : 0;
    } else {
        float2 vecTexCoord = input.vecTexCoord0;
        vecTexCoord.y = min(vecTexCoord.y, g_fFloat2);
        float4 vecColour = tex0.Sample(sampLinearClamp, vecTexCoord);
        return vecColour * g_fFloat1;
    }
}
