//--------------------------------------------------------------------------------------
// Constant Buffer Variables
//--------------------------------------------------------------------------------------
Texture2D tex0 : register(t0);
Texture2D tex1 : register(t1);
SamplerState sampLinearClamp : register(s0);
SamplerState sampNearestClamp : register(s1);
SamplerState sampLinearWrap : register(s2);
SamplerState sampNearestWrap : register(s3);


cbuffer GlobalRenderData: register(b0)
{
    float g_fTime;
    float g_fFloat1;    // Mosaic scale
    float g_fFloat2;    // Mix
    float g_fFloat3;
    float g_fFloat4;
    float g_fFloat5;
    float g_fFloat6;
    float g_fSeed;
};



//--------------------------------------------------------------------------------------
struct VS_INPUT
{
    float3 vecPosition : POSITION;
    float2 vecTexCoord0 : TEXCOORD0;
};

struct PS_INPUT
{
    float4 vecPosition : SV_POSITION;
    float2 vecTexCoord0 : TEXCOORD0;
};


//--------------------------------------------------------------------------------------
// Vertex Shader
//--------------------------------------------------------------------------------------
PS_INPUT VS( VS_INPUT input )
{
    PS_INPUT output;

	const float2 vecTexCoord0 = input.vecTexCoord0.xy * float2(2, -2) + float2(-1, 1);
    output.vecPosition = float4(vecTexCoord0, 0, 1);
    output.vecTexCoord0 = input.vecTexCoord0;

    return output;
}


//--------------------------------------------------------------------------------------
// Pixel Shader
//--------------------------------------------------------------------------------------
float4 PS(PS_INPUT input) : SV_Target
{
float fStr = g_fFloat1;

    float4 vecColour = 1;
    float fScale = lerp(0,0.03,fStr);
    float fXBase = -pow(input.vecTexCoord0.y,3) * fScale * 10;

    {
    float fY = floor(input.vecTexCoord0.y*40)/40;
    float fOct1 = tex1.Sample(sampNearestWrap, float2(input.vecTexCoord0.x*g_fTime, fY)).r;
    float fOct2 = tex1.Sample(sampNearestWrap, input.vecTexCoord0*0.1).r;
    float fXOffset = fXBase - fOct1*fScale - fOct2*fScale*2;
    vecColour.r = tex0.Sample(sampLinearClamp, input.vecTexCoord0 + float2(fXOffset, 0)).r;
    }
    {
    float fY = floor(input.vecTexCoord0.y*60)/60;
    float fOct1 = tex1.Sample(sampNearestWrap, float2(input.vecTexCoord0.x*g_fTime, fY)).g;
    float fOct2 = tex1.Sample(sampNearestWrap, input.vecTexCoord0*0.1).g;
    float fXOffset = fXBase - fOct1*fScale - fOct2*fScale*2;
    vecColour.g = tex0.Sample(sampLinearClamp, input.vecTexCoord0 + float2(fXOffset, 0)).g;
    }
    {
    float fY = floor(input.vecTexCoord0.y*20)/20;
    float fOct1 = tex1.Sample(sampNearestWrap, float2(input.vecTexCoord0.x*g_fTime, fY)).b;
    float fOct2 = tex1.Sample(sampNearestWrap, input.vecTexCoord0*0.1).b;
    float fXOffset = fXBase - fOct1*fScale - fOct2*fScale*2;
    vecColour.b = tex0.Sample(sampLinearClamp, input.vecTexCoord0 + float2(fXOffset, 0)).b;
    }

    float fGrey = input.vecTexCoord0.x - tex1.Sample(sampNearestWrap, float2(input.vecTexCoord0.y*4.2, g_fTime)).a;
    vecColour.rgb += fGrey * fStr * 0.5;

    return vecColour;
}
