//--------------------------------------------------------------------------------------
// Constant Buffer Variables
//--------------------------------------------------------------------------------------
Texture2D texSource : register(t0);
Texture2D texImage1 : register(t1);
SamplerState sampLinearClamp : register(s0);
SamplerState sampNearestClamp : register(s1);
SamplerState sampLinearWrap : register(s2);
SamplerState sampNearestWrap : register(s3);

cbuffer GlobalRenderData: register(b0)
{
    float g_fTime;
    float g_fFloat1;    // Strength
    float g_fFloat2;
    float g_fFloat3;
    float g_fFloat4;
    float g_fFloat5;
    float g_fFloat6;
    float g_fSeed;
};



//--------------------------------------------------------------------------------------
struct VS_INPUT
{
    float3 vecPosition : POSITION;
    float2 vecTexCoord0 : TEXCOORD0;
};

struct PS_INPUT
{
    float4 vecPosition : SV_POSITION;
    float2 vecTexCoord0 : TEXCOORD0;
};


//--------------------------------------------------------------------------------------
// Vertex Shader
//--------------------------------------------------------------------------------------
PS_INPUT VS(VS_INPUT input)
{
    PS_INPUT output;

    float2 vecTexCoord0 = input.vecTexCoord0.xy * float2(2, -2) + float2(-1, 1);
    output.vecPosition = float4(vecTexCoord0, 0, 1);
    output.vecTexCoord0 = input.vecTexCoord0;

    return output;
}


//--------------------------------------------------------------------------------------
// Pixel Shader
//--------------------------------------------------------------------------------------
float4 PS(PS_INPUT input) : SV_Target
{
	const float fMaxDistance = 0.005;

	const float fX = input.vecTexCoord0.x;
	const float fY = input.vecTexCoord0.y;
	if (fX < 0.5)
	{
		const float fTargetValue = 1.0 - fY;
		float fResult = 0;
		for (float fScan = 0; fScan < 1; fScan += 0.01)
		{
			const float4 vecSourceColour = texSource.Sample(sampLinearWrap, float2(fX * 2, fScan));
			const float fGreyscale = dot(vecSourceColour.rgb, float3(0.222, 0.707, 0.071));
			const float fValueDiff = abs(fGreyscale - fTargetValue);
			const float fScaledDiff = min(fValueDiff, fMaxDistance) / fMaxDistance;
			fResult += pow(1.0 - fScaledDiff, 2) * 0.5;
		}

		return float4(fResult, fResult, fResult, 1);
	}
	else
	{
		return texSource.Sample(sampLinearWrap, float2((fX - 0.5) * 2, fY));
	}
}
