//--------------------------------------------------------------------------------------
// Constant Buffer Variables
//--------------------------------------------------------------------------------------
Texture2D texSource : register(t0);
Texture2D texImage1 : register(t1);
SamplerState sampLinearClamp : register(s0);
SamplerState sampNearestClamp : register(s1);
SamplerState sampLinearWrap : register(s2);
SamplerState sampNearestWrap : register(s3);

cbuffer GlobalRenderData: register(b0)
{
    float g_fTime;
    float g_fFloat1;    // Random position (time)
    float g_fFloat2;    // Vertical scale
    float g_fFloat3;    // Horizontal offset size
    float g_fFloat4;
    float g_fFloat5;
    float g_fFloat6;
    float g_fSeed;      // Added to random position
};


//--------------------------------------------------------------------------------------
struct VS_INPUT
{
    float3 vecPosition : POSITION;
    float2 vecTexCoord0 : TEXCOORD0;
};

struct PS_INPUT
{
    float4 vecPosition : SV_POSITION;
    float2 vecTexCoord : TEXCOORD0;
    float2 vecTexNoise : TEXCOORD1;
};


//--------------------------------------------------------------------------------------
// Vertex Shader
//--------------------------------------------------------------------------------------
PS_INPUT VS( VS_INPUT input )
{
    PS_INPUT output;

    float2 vecTexCoord0 = input.vecTexCoord0.xy * float2(2, -2) + float2(-1, 1);
    output.vecPosition = float4(vecTexCoord0/* * float2(1, 800.06f/600.0f)*/, 0, 1);

    output.vecTexCoord = input.vecTexCoord0.xy;
    output.vecTexNoise = texImage1.SampleLevel(sampNearestWrap, float2(g_fSeed + g_fFloat1, 0) * 1, 0).rg + (input.vecTexCoord0 - 0.5) * 1 * float2(0,g_fFloat2);

    return output;
}


//--------------------------------------------------------------------------------------
// Pixel Shader
//--------------------------------------------------------------------------------------
float4 PS(PS_INPUT input) : SV_Target
{
    float2 vecDirection = float2(1, 0);
    float3 vecOffset = (texImage1.Sample(sampNearestWrap, input.vecTexNoise).rgb - 0.5) * g_fFloat3;
    float4 vecR = texSource.Sample(sampLinearWrap, input.vecTexCoord + vecDirection * vecOffset.r);
    float4 vecG = texSource.Sample(sampLinearWrap, input.vecTexCoord + vecDirection * vecOffset.g);
    float4 vecB = texSource.Sample(sampLinearWrap, input.vecTexCoord + vecDirection * vecOffset.b);
    return float4(vecR.r, vecG.g, vecB.b, 1);
}
