//--------------------------------------------------------------------------------------
// Constant Buffer Variables
//--------------------------------------------------------------------------------------
Texture2D texSource : register(t0);
Texture2D texImage1 : register(t1);
SamplerState sampLinearClamp : register(s0);
SamplerState sampNearestClamp : register(s1);
SamplerState sampLinearWrap : register(s2);
SamplerState sampNearestWrap : register(s3);

cbuffer GlobalRenderData: register(b0)
{
    float g_fTime;
    float g_fFloat1;    // Strength
    float g_fFloat2;
    float g_fFloat3;
    float g_fFloat4;
    float g_fFloat5;
    float g_fFloat6;
    float g_fSeed;
};



//--------------------------------------------------------------------------------------
struct VS_INPUT
{
    float3 vecPosition : POSITION;
    float2 vecTexCoord0 : TEXCOORD0;
};

struct PS_INPUT
{
    float4 vecPosition : SV_POSITION;
    float2 vecTexCoord0 : TEXCOORD0;
};


//--------------------------------------------------------------------------------------
// Vertex Shader
//--------------------------------------------------------------------------------------
PS_INPUT VS(VS_INPUT input)
{
    PS_INPUT output;

    float2 vecTexCoord0 = input.vecTexCoord0.xy * float2(2, -2) + float2(-1, 1);
    output.vecPosition = float4(vecTexCoord0, 0, 1);
    output.vecTexCoord0 = input.vecTexCoord0;

    return output;
}


//--------------------------------------------------------------------------------------
// Pixel Shader
//--------------------------------------------------------------------------------------
float4 PS(PS_INPUT input) : SV_Target
{
    float4 vecGreyscale = float4(0.30, 0.59, 0.11, 1);

    float2 g_vecPixelSize = float2(0.001, 0.001);

    float fS11 = dot(texSource.Sample(sampLinearClamp, input.vecTexCoord0 + float2(-1, -1) * g_vecPixelSize), vecGreyscale);
    float fS12 = dot(texSource.Sample(sampLinearClamp, input.vecTexCoord0 + float2(-1, 0) * g_vecPixelSize), vecGreyscale);
    float fS13 = dot(texSource.Sample(sampLinearClamp, input.vecTexCoord0 + float2(-1, +1) * g_vecPixelSize), vecGreyscale);
    float fS21 = dot(texSource.Sample(sampLinearClamp, input.vecTexCoord0 + float2(0, -1) * g_vecPixelSize), vecGreyscale);
    float fS23 = dot(texSource.Sample(sampLinearClamp, input.vecTexCoord0 + float2(0, +1) * g_vecPixelSize), vecGreyscale);
    float fS31 = dot(texSource.Sample(sampLinearClamp, input.vecTexCoord0 + float2(+1, -1) * g_vecPixelSize), vecGreyscale);
    float fS32 = dot(texSource.Sample(sampLinearClamp, input.vecTexCoord0 + float2(+1, 0) * g_vecPixelSize), vecGreyscale);
    float fS33 = dot(texSource.Sample(sampLinearClamp, input.vecTexCoord0 + float2(+1, +1) * g_vecPixelSize), vecGreyscale);

    float fT1 = fS13 + fS33 + (2 * fS23) - fS11 - (2 * fS21) - fS31;
    float fT2 = fS31 + (2 * fS32) + fS33 - fS11 - (2 * fS12) - fS13;

    float fFactor = sqrt(fT1*fT1 + fT2*fT2);

    float4 vecSrcColour = texSource.Sample(sampLinearClamp, input.vecTexCoord0);
    float4 vecEdgeColour = vecSrcColour * fFactor;
    return lerp(vecSrcColour, vecEdgeColour, g_fFloat1);
//    return lerp(vecSrcColour * float4(0.5, 0.7, 0.8, 1.0), vecEdgeColour * float4(0.7, 0.7, 0.94, 1.0), g_fFloat1);
}
