//--------------------------------------------------------------------------------------
// Constant Buffer Variables
//--------------------------------------------------------------------------------------
Texture2D texTexture : register(t0);
SamplerState sampLinearClamp : register(s0);
SamplerState sampNearestClamp : register(s1);
SamplerState sampLinearWrap : register(s2);
SamplerState sampNearestWrap : register(s3);

cbuffer GlobalRenderData : register(b3)
{
    matrix g_matWorld;
    matrix g_matView;
    matrix g_matProjection;
};

struct Billboard
{
    float4 m_vecPosition_size;
    float4 m_vecNormal_Brightness;
};
StructuredBuffer<Billboard> g_aBillboards : register(t5);


//--------------------------------------------------------------------------------------
struct VS_INPUT
{
    float3 vecPosition : POSITION;
    float2 vecTexCoord : TEXCOORD;
    uint iInstanceID : SV_InstanceID;
};

struct PS_INPUT
{
    float4 vecPosition : SV_POSITION;
    float2 vecTexCoord : TEXCOORD0;
    float fBrightness : TEXCOORD1;
};


//--------------------------------------------------------------------------------------
// Vertex Shader
//--------------------------------------------------------------------------------------
PS_INPUT VS_CameraFacing(VS_INPUT input)
{
    PS_INPUT output;

    Billboard billboard = g_aBillboards[input.iInstanceID];

    matrix matWorld = g_matWorld;
    matrix matWorldView = mul(matWorld, g_matView);
    matrix matWorldViewProjection = mul(matWorldView, g_matProjection);
    
    float3 vecRight = matWorldView._11_21_31;
    float3 vecUp = matWorldView._12_22_32;

    float fSize = billboard.m_vecPosition_size.w;
    float3 vecPosition = billboard.m_vecPosition_size.xyz +
                         input.vecPosition.x * fSize * vecRight +
                         input.vecPosition.y * fSize * vecUp;

    output.vecPosition = mul(float4(vecPosition.xyz, 1), matWorldViewProjection);
    output.vecTexCoord = input.vecTexCoord;

    float fDistance = length(mul(float4(vecPosition.xyz, 1), matWorldView));
    output.fBrightness = (1 - saturate(fDistance / 2000)) * billboard.m_vecNormal_Brightness.w;

    return output;
}


PS_INPUT VS_NormalFacing(VS_INPUT input)
{
    PS_INPUT output;

    Billboard billboard = g_aBillboards[input.iInstanceID];

    matrix matWorld = g_matWorld;
    matrix matWorldView = mul(matWorld, g_matView);
    matrix matWorldViewProjection = mul(matWorldView, g_matProjection);

    float3 vecNormal = normalize(billboard.m_vecNormal_Brightness.xyz);
    float3 vecWorldRight = float3(1, 0, 0);
    float3 vecWorldUp = float3(0, 1, 0);
    float3 vecWorldFwd = float3(0, 0, 1);
    float3 vecUp, vecRight;
    if (dot(vecNormal, vecWorldRight > 0.5))
    {
        vecRight = vecNormal;
        vecUp = normalize(cross(vecWorldFwd, vecRight));
        vecRight = cross(vecUp, vecNormal);
    }
    else
    {
        vecUp = normalize(cross(vecNormal, vecWorldRight));
        vecRight = cross(vecUp, vecNormal);
    }

    float fSize = billboard.m_vecPosition_size.w;
    float3 vecPosition = billboard.m_vecPosition_size.xyz +
                         input.vecPosition.x * fSize * vecRight +
                         input.vecPosition.y * fSize * vecUp;

    output.vecPosition = mul(float4(vecPosition.xyz, 1), matWorldViewProjection);
    output.vecTexCoord = input.vecTexCoord;

    float fDistance = length(mul(float4(vecPosition.xyz, 1), matWorldView));
    output.fBrightness = (1 - saturate(fDistance / 2000)) * billboard.m_vecNormal_Brightness.w;

    return output;
}


//--------------------------------------------------------------------------------------
// Pixel Shader
//--------------------------------------------------------------------------------------
float4 PS(PS_INPUT input) : SV_Target
{
    return texTexture.Sample(sampLinearClamp, input.vecTexCoord) * pow(input.fBrightness,0.7);
}
